/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.util.Assert;
import org.springframework.xml.JaxpVersion;
import org.springframework.xml.transform.StaxResult;
import org.springframework.xml.transform.StaxSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class TraxUtils {
    static /* synthetic */ Class class$javax$xml$transform$stax$StAXSource;
    static /* synthetic */ Class class$javax$xml$transform$stax$StAXResult;

    public static boolean isStaxSource(Source source) {
        if (source instanceof StaxSource) {
            return true;
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.isStaxSource(source);
        }
        return false;
    }

    public static boolean isStaxResult(Result result) {
        if (result instanceof StaxResult) {
            return true;
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.isStaxResult(result);
        }
        return false;
    }

    public static XMLStreamReader getXMLStreamReader(Source source) {
        if (source instanceof StaxSource) {
            return ((StaxSource)source).getXMLStreamReader();
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.getXMLStreamReader(source);
        }
        throw new IllegalArgumentException("Source '" + source + "' is neither StaxSource nor StAXSource");
    }

    public static XMLEventReader getXMLEventReader(Source source) {
        if (source instanceof StaxSource) {
            return ((StaxSource)source).getXMLEventReader();
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.getXMLEventReader(source);
        }
        throw new IllegalArgumentException("Source '" + source + "' is neither StaxSource nor StAXSource");
    }

    public static XMLStreamWriter getXMLStreamWriter(Result result) {
        if (result instanceof StaxResult) {
            return ((StaxResult)result).getXMLStreamWriter();
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.getXMLStreamWriter(result);
        }
        throw new IllegalArgumentException("Result '" + result + "' is neither StaxResult nor StAXResult");
    }

    public static XMLEventWriter getXMLEventWriter(Result result) {
        if (result instanceof StaxResult) {
            return ((StaxResult)result).getXMLEventWriter();
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.getXMLEventWriter(result);
        }
        throw new IllegalArgumentException("Result '" + result + "' is neither StaxResult nor StAXResult");
    }

    public static Source createStaxSource(XMLStreamReader streamReader) {
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.createStaxSource(streamReader);
        }
        return new StaxSource(streamReader);
    }

    public static Source createStaxSource(XMLEventReader eventReader) throws XMLStreamException {
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.createStaxSource(eventReader);
        }
        return new StaxSource(eventReader);
    }

    public static Document getDocument(DOMSource source) {
        Node node = source.getNode();
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node != null) {
            return node.getOwnerDocument();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doWithSource(Source source, SourceCallback callback) throws XMLStreamException, IOException, SAXException {
        if (source instanceof DOMSource) {
            callback.domSource(((DOMSource)source).getNode());
            return;
        } else if (TraxUtils.isStaxSource(source)) {
            XMLStreamReader streamReader = TraxUtils.getXMLStreamReader(source);
            if (streamReader != null) {
                callback.staxSource(streamReader);
                return;
            } else {
                XMLEventReader eventReader = TraxUtils.getXMLEventReader(source);
                if (eventReader == null) throw new IllegalArgumentException("StAX source contains neither XMLStreamReader nor XMLEventReader");
                callback.staxSource(eventReader);
            }
            return;
        } else if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            callback.saxSource(saxSource.getXMLReader(), saxSource.getInputSource());
            return;
        } else {
            if (!(source instanceof StreamSource)) throw new IllegalArgumentException("Unknown Source type: " + source.getClass());
            StreamSource streamSource = (StreamSource)source;
            if (streamSource.getInputStream() != null) {
                callback.streamSource(streamSource.getInputStream());
                return;
            } else {
                if (streamSource.getReader() == null) throw new IllegalArgumentException("StreamSource contains neither InputStream nor Reader");
                callback.streamSource(streamSource.getReader());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doWithResult(Result result, ResultCallback callback) throws XMLStreamException, IOException, SAXException {
        if (result instanceof DOMResult) {
            callback.domResult(((DOMResult)result).getNode());
            return;
        } else if (TraxUtils.isStaxResult(result)) {
            XMLStreamWriter streamWriter = TraxUtils.getXMLStreamWriter(result);
            if (streamWriter != null) {
                callback.staxResult(streamWriter);
                return;
            } else {
                XMLEventWriter eventWriter = TraxUtils.getXMLEventWriter(result);
                if (eventWriter == null) throw new IllegalArgumentException("StAX result contains neither XMLStreamWriter nor XMLEventWriter");
                callback.staxResult(eventWriter);
            }
            return;
        } else if (result instanceof SAXResult) {
            SAXResult saxSource = (SAXResult)result;
            callback.saxResult(saxSource.getHandler(), saxSource.getLexicalHandler());
            return;
        } else {
            if (!(result instanceof StreamResult)) throw new IllegalArgumentException("Unknown Result type: " + result.getClass());
            StreamResult streamSource = (StreamResult)result;
            if (streamSource.getOutputStream() != null) {
                callback.streamResult(streamSource.getOutputStream());
                return;
            } else {
                if (streamSource.getWriter() == null) throw new IllegalArgumentException("StreamResult contains neither OutputStream nor Writer");
                callback.streamResult(streamSource.getWriter());
            }
        }
    }

    private static class Jaxp14StaxHandler {
        private Jaxp14StaxHandler() {
        }

        private static Source createStaxSource(XMLStreamReader streamReader) {
            return new StAXSource(streamReader);
        }

        private static Source createStaxSource(XMLEventReader eventReader) throws XMLStreamException {
            return new StAXSource(eventReader);
        }

        private static boolean isStaxSource(Source source) {
            return source instanceof StAXSource;
        }

        private static boolean isStaxResult(Result result) {
            return result instanceof StAXResult;
        }

        private static XMLStreamReader getXMLStreamReader(Source source) {
            Assert.isInstanceOf((Class)(class$javax$xml$transform$stax$StAXSource == null ? (class$javax$xml$transform$stax$StAXSource = TraxUtils.class$("javax.xml.transform.stax.StAXSource")) : class$javax$xml$transform$stax$StAXSource), (Object)source);
            return ((StAXSource)source).getXMLStreamReader();
        }

        private static XMLEventReader getXMLEventReader(Source source) {
            Assert.isInstanceOf((Class)(class$javax$xml$transform$stax$StAXSource == null ? (class$javax$xml$transform$stax$StAXSource = TraxUtils.class$("javax.xml.transform.stax.StAXSource")) : class$javax$xml$transform$stax$StAXSource), (Object)source);
            return ((StAXSource)source).getXMLEventReader();
        }

        private static XMLStreamWriter getXMLStreamWriter(Result result) {
            Assert.isInstanceOf((Class)(class$javax$xml$transform$stax$StAXResult == null ? (class$javax$xml$transform$stax$StAXResult = TraxUtils.class$("javax.xml.transform.stax.StAXResult")) : class$javax$xml$transform$stax$StAXResult), (Object)result);
            return ((StAXResult)result).getXMLStreamWriter();
        }

        private static XMLEventWriter getXMLEventWriter(Result result) {
            Assert.isInstanceOf((Class)(class$javax$xml$transform$stax$StAXResult == null ? (class$javax$xml$transform$stax$StAXResult = TraxUtils.class$("javax.xml.transform.stax.StAXResult")) : class$javax$xml$transform$stax$StAXResult), (Object)result);
            return ((StAXResult)result).getXMLEventWriter();
        }
    }

    public static interface ResultCallback {
        public void domResult(Node var1);

        public void saxResult(ContentHandler var1, LexicalHandler var2) throws IOException, SAXException;

        public void staxResult(XMLEventWriter var1) throws XMLStreamException;

        public void staxResult(XMLStreamWriter var1) throws XMLStreamException;

        public void streamResult(OutputStream var1) throws IOException;

        public void streamResult(Writer var1) throws IOException;
    }

    public static interface SourceCallback {
        public void domSource(Node var1);

        public void saxSource(XMLReader var1, InputSource var2) throws IOException, SAXException;

        public void staxSource(XMLEventReader var1) throws XMLStreamException;

        public void staxSource(XMLStreamReader var1) throws XMLStreamException;

        public void streamSource(InputStream var1) throws IOException;

        public void streamSource(Reader var1) throws IOException;
    }
}

