package mx.com.amx.mx.dda.ws.bo;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import mx.com.amx.mx.dda.ws.dao.ContratoDAO;
import mx.com.amx.mx.dda.ws.dto.ContratoDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoEstatusDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoSAPDTO;
import mx.com.amx.mx.dda.ws.dto.DatosFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.FacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ItemAgregaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ItemEntradaMercanciaDTO;
import mx.com.amx.mx.dda.ws.dto.ItemEnviaFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ItemModificaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.MaterialDTO;
import mx.com.amx.mx.dda.ws.dto.ParamActualizaContratoDTO;
import mx.com.amx.mx.dda.ws.dto.ParamAdendumEnmiendaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamAgregaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ParamEntradaMercanciaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamEnviaFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamEnviaTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ParamInventarioTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ParamManejoTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ParamModificaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ParamNotificaFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamOrdenCompraDTO;
import mx.com.amx.mx.dda.ws.dto.QryMontosAnualesCntDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseAdendumEnmiendaDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseNotificarFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseNotificarInventarioTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseOrdenCompraDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoEnviaFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoEnviaMercanciaDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoEnviaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoEnviaTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoModificaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoOrdenCompraDTO;
import mx.com.amx.mx.dda.ws.dto.TitulosAsocContratoDTO;
import mx.com.amx.mx.dda.ws.utils.ArithmeticManager;
import mx.com.amx.mx.dda.ws.utils.DateManager;
import mx.com.amx.mx.dda.ws.utils.StringManager;
import org.apache.log4j.Logger;

/****** Cambios
 * ************************************************
 * @version 2.1
 * @author RFD
 * @since 2020
 * 
 * Se agrega funcionalidad para que en lugar 
 * de mandar la interfaz 23 ahora se envie la 
 * interfaz 8 con el fin de que se cree una 
 * nueva orden de compra
 * 
 * ************************************************
 */
 


public class ContratoBO 
{		
	/* --------------------------------------------------------------------------------- Fields */
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	ParamActualizaContratoDTO pActualiza = new ParamActualizaContratoDTO();
	ParamManejoTitulosDTO pTitulos = new ParamManejoTitulosDTO();
	DateManager dateManager = new DateManager();
	StringManager strManager = new StringManager();
	ArithmeticManager arithManager = new ArithmeticManager();

	private ContratoWSBO wsMgr;
	private ContratoDAO contratoDAO;
	
	private String AMBIENTE;
	private String CASO_VIGENTE;
	private String CASO_REG_SAP_SUSCRIPCION;
	private String CASO_REG_SAP_LICENSEFEE;
	private String CASO_REG_SAP_TRANSACCIONAL;
	private String CASO_REG_SAP_ENMIENDA_SUSCRIPCION;
	private String CASO_REG_SAP_ENMIENDA_LICENSEFEE;
	private String CASO_REG_SAP_ENMIENDA_TRANSACCIONAL;
	private String ESTATUS_NOTIFICACION_SAP;
	private String ESTATUS_VIGENTE;
	private String ESTATUS_AUTORIZADO;
	private String ERROR_PROCESO;
	private String ERROR_REGISTRO_SAP;
	private String ERROR_MODIFICACION_SAP;
	
	private String PRIMERA_POSICION;
	private String ID_MATERIAL_MINIMO;
	private String ID_MATERIAL_OVERAGE;
	private String ID_MATERIAL_LF;
	private String ID_MATERIAL_SUSC;
	private String IMPUTACION_NOAMORTIZABLE;
	private String IMPUTACION_AMORTIZABLE;
	private String CENTRO;
	private String CENTRO_COSTO;
	private String CANTIDAD_NOAMORTIZABLE;
	private String CANTIDAD_AMORTIZABLE;
	private String ACTIVIDAD;
	private String INDICADOR_MOVIMIENTO;
	private String MOVIMIENTO;
	private String SOCIEDAD;
	private String POS_FACTURA;
	private String INDICADOR_FACTURA;
	private String TIPODOC_FACTURA;
	
	private String HOY_DOTS_DMY;
	private String HOY_DASH_YMD;
	
	
	public ContratoDAO getContratoDAO() {
		return contratoDAO;
	}

	public void setContratoDAO(ContratoDAO contratoDAO) {
		this.contratoDAO = contratoDAO;
	}

	public ContratoWSBO getWsMgr() {
		return wsMgr;
	}

	public void setWsMgr(ContratoWSBO wsMgr) {
		this.wsMgr = wsMgr;
	}

	public ContratoBO()
	{
		super();
		try
		{
			//tipo.imputacion.transaccional
			
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			AMBIENTE = env.getProperty("ambiente");
			CASO_VIGENTE = "Vigente";
			CASO_REG_SAP_ENMIENDA_SUSCRIPCION = "Registrar SAP Enmienda Suscripcion";
			CASO_REG_SAP_ENMIENDA_LICENSEFEE = "Registrar SAP Enmienda License Fee";
			CASO_REG_SAP_SUSCRIPCION = "Registrar SAP Suscripcion";
			CASO_REG_SAP_LICENSEFEE = "Registro SAP License Fee";
			CASO_REG_SAP_TRANSACCIONAL = "Registro SAP Transaccional";
			ESTATUS_VIGENTE = env.getProperty("estatus.vigente");
			ESTATUS_NOTIFICACION_SAP = env.getProperty("estatus.notificacion.sap");
			ESTATUS_AUTORIZADO = env.getProperty("estatus.autorizado");
			ERROR_PROCESO = env.getProperty("error.proceso");
			ERROR_REGISTRO_SAP = env.getProperty("error.registro.sap");
			ERROR_MODIFICACION_SAP = env.getProperty("error.modificacion.sap");
			
			PRIMERA_POSICION = env.getProperty("contrato.primera.posicion");
			ID_MATERIAL_MINIMO = env.getProperty(AMBIENTE+".id.material.mg.transaccional");
			ID_MATERIAL_OVERAGE = env.getProperty(AMBIENTE+".id.material.overage.transaccional");
			ID_MATERIAL_LF = env.getProperty(AMBIENTE+".id.material.licensefee");
			ID_MATERIAL_SUSC = env.getProperty(AMBIENTE+".id.material.suscripcion");
			IMPUTACION_NOAMORTIZABLE = env.getProperty("tipo.imputacion.noamortizable");
			IMPUTACION_AMORTIZABLE = env.getProperty("tipo.imputacion.amortizable");
			CENTRO_COSTO = env.getProperty(AMBIENTE+".centro.costo");
			CENTRO = env.getProperty("centro");
			CANTIDAD_NOAMORTIZABLE = env.getProperty("cantidad.noamortizable");
			CANTIDAD_AMORTIZABLE = env.getProperty("cantidad.amortizable");
			ACTIVIDAD = env.getProperty("actividad");
			INDICADOR_MOVIMIENTO = env.getProperty("indicador.movimiento");
			MOVIMIENTO = env.getProperty("movimiento");
			SOCIEDAD = env.getProperty("sociedad");
			POS_FACTURA = env.getProperty("posicion.factura");
			INDICADOR_FACTURA = env.getProperty("indicador.factura");
			TIPODOC_FACTURA = env.getProperty("tipo.doc.factura");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	public ResponseOrdenCompraDTO registrarSAPSuscripcion(ParamOrdenCompraDTO dto) throws Exception
	{
		ResponseOrdenCompraDTO resultado = new ResponseOrdenCompraDTO();
		boolean lboEjecutaProcesoAdicional = false;
		
		LOG.info("<< :::::::::::::::: INI ["+this.getClass().getSimpleName()+"::registrarSAPSuscripcion] :::::::::::::::: >>");
		LOG.info("     -->  Parametros: " + dto.toString());
		
		try
		{
			
			//--Establece por default el estatus en NOTIFICACION_SAP
			LOG.info("    [INI]. Llamado a Acciones Actualiza Estatus Contrato.");
			pActualiza.setCaso(CASO_REG_SAP_SUSCRIPCION);
			pActualiza.setEstatus(ESTATUS_NOTIFICACION_SAP);
			pActualiza.setExpediente(dto.getExpediente());
			pActualiza.setIdContrato(dto.getIdContrato());
			this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
			LOG.info("    [FIN]. Llamado a Acciones Actualiza Estatus Contrato.");
			
			
			//---Verifica si el Contrato aun no cuenta con el ID de SAP (primera vez) o si ya lo tiene (segunda vez en adelante).
			LOG.info("    [INI]. Obtener ID SAP del Contrato con ID ["+dto.getIdContrato()+"].");
			String lstIDSAP_Contrato = contratoDAO.obtenerIDSAPContrato(dto.getIdContrato());
			LOG.info("    [FIN]. Obtener ID SAP del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstIDSAP_Contrato+"_");
			
			
			if(lstIDSAP_Contrato.equals("-1"))
			{
				//--Llamado al WS SAP para Ordenes de Compra
				LOG.info("    [INI]. Llamado a WS SAP. Interfaz 8.");
				ResultadoOrdenCompraDTO rWS_OC = wsMgr.crearOrdenCompraWS(dto);
				
				/*[INI]TEST Interfaz 8*/
				/*
				ResultadoOrdenCompraDTO rWS_OC = new ResultadoOrdenCompraDTO();
				RespSAPOrdenCompraDTO oc_tst = rWS_OC.getOrdenCompra();
				oc_tst.setDescripcion("OK");
				oc_tst.setIDMensaje("OK");
				oc_tst.setPONumber("9200000011");
				rWS_OC.setResultado(true);
				*/
				/*[FIN]TEST Interfaz 8*/
				
				LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 8. Resultado: _" + rWS_OC.getResultado() + "_");
				
				//Verifica si ocurrio una excepcion y el resultado es false
				if(rWS_OC.getTransFault() != null && !rWS_OC.getResultado())
				{
					//-- Tracking
					LOG.error("Error al llamar el WS Orden de Compra:: registrarSAPSuscripcion: " + rWS_OC.getTransFault().toString());
					
					//--Construccion de respuesta
					resultado.setResultado(false);
					resultado.setMensaje(rWS_OC.getTransFault().getInternalCode() + ": " + rWS_OC.getTransFault().getFaultDescription());
					LOG.info("Respuesta devuelta: " + resultado.toString());
					
				}
				else if(rWS_OC.getOrdenCompra() != null && rWS_OC.getResultado())
				{
					//-- Registro Orden de Compra?
					if(rWS_OC.getOrdenCompra().getIDMensaje() != null && rWS_OC.getOrdenCompra().getIDMensaje().equalsIgnoreCase("OK"))
					{
						//-- Actualiza el contrato con el ID devuelto por SAP
						LOG.info("    [INI]. Actualiza contrato con ID de SAP.");
						ContratoDTO cnt = new ContratoDTO();
						cnt.setID_SAP(rWS_OC.getOrdenCompra().getPONumber());
						cnt.setID_CONTRATO(dto.getIdContrato());
						boolean lboActualizaIdSap = contratoDAO.actualizaContratoFull(cnt);
						LOG.info("    [FIN]. Actualiza contrato con ID de SAP. Resultado: _" +lboActualizaIdSap+"_");
						
						if(lboActualizaIdSap)
						{
							//--Manejo de Titulos por Contrato
							LOG.info("    [INI]. Ejecutar acciones Manejo de Titulos por Contrato.");
							pTitulos.setExpediente(dto.getExpediente());
							pTitulos.setIdContrato(dto.getIdContrato());
							ResponseOrdenCompraDTO lobResultadoTitulos = this.ejecutarAccionesManejoTitulosPorContrato(pTitulos);
							LOG.info("    [FIN]. Ejecutar acciones Manejo de Titulos por Contrato.");
							
							//--Construye Respuesta
							resultado.setResultado(lobResultadoTitulos.getResultado());
							resultado.setMensaje(lobResultadoTitulos.getMensaje());
							LOG.info("Respuesta devuelta: " + resultado.toString());
							
							//--Habilita la ejecucion del proceso Adicional (Interfaz 45)
							if(lobResultadoTitulos.getResultado())
							{
								lboEjecutaProcesoAdicional = true;
							}
							
						}// Ends if(lboActualizaIdSap)
						else
						{
							//--Construye respuesta
							resultado.setResultado(false);
							resultado.setMensaje("DDA-RSS-001: " + ERROR_PROCESO);
							LOG.info("Respuesta devuelta: " + resultado.toString());
						}
					}// Ends Registro Orden Compra?
					else
					{
						//--Construye Respuesta
						resultado.setResultado(false);
						resultado.setMensaje("DDA-RSS-002: "+ ERROR_REGISTRO_SAP);
						LOG.info("Respuesta devuelta: " + resultado.toString());
						
					}
					
				}//-- Ends else if(rWS.getOrdenCompra() != null && rWS.getResultado())
			} //--Ends: if(lstIDSAP_Contrato.equals("-1"))
			else
			{
				//--Manejo de Titulos por Contrato
				LOG.info("    [INI]. Ejecutar acciones Manejo de Titulos por Contrato.");
				pTitulos.setExpediente(dto.getExpediente());
				pTitulos.setIdContrato(dto.getIdContrato());
				ResponseOrdenCompraDTO lobResultadoTitulos = this.ejecutarAccionesManejoTitulosPorContrato(pTitulos);
				LOG.info("    [FIN]. Ejecutar acciones Manejo de Titulos por Contrato.");
				
				
				//--Habilita la ejecucion del proceso Adicional (Interfaz 45)
				if(lobResultadoTitulos.getResultado())
				{
					lboEjecutaProcesoAdicional = true;
				}
				
				//--Construye Respuesta
				resultado.setResultado(lobResultadoTitulos.getResultado());
				resultado.setMensaje(lobResultadoTitulos.getMensaje());
				LOG.info("Respuesta devuelta: " + resultado.toString());
				
			}//Ends: if(lstIDSAP_Contrato.equals("-1"))
			
			
			if(lboEjecutaProcesoAdicional)
			{
				//-- Proceso adicional de Envio de Titulos DDA a SAP
				LOG.info("    [INI]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"].");
				List<TitulosAsocContratoDTO> lobTitulosAsociados = contratoDAO.obtenerTitulosAsociadosContrato(dto.getIdContrato());
				LOG.info("    [FIN]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"]. Titulos Asociados:_"+lobTitulosAsociados.size()+"_");
				
				if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				{
					ParamEnviaTituloDTO pEnvTitulo = new ParamEnviaTituloDTO();
					pEnvTitulo.setTitulos(lobTitulosAsociados);
					
					//-- Llamado de interfaz 45 Envio Titulos DDA a SAP
					LOG.info("    [INI]. Llamado a WS SAP. Interfaz 45.");
					ResultadoEnviaTituloDTO rWS_ET = wsMgr.enviarTitulosDDAWS(pEnvTitulo);
					LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 45.");
					
					//Verifica si ocurrio una excepcion y el resultado es false
					if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					{
						//-- Tracking
						LOG.error("Error al llamar el WS Enviar Titulos DDA a SAP :: registrarSAPSuscripcion: " + rWS_ET.getTransFault().toString());
					}//Ends if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					
				}//Ends if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				else
					LOG.info("    No se pudieron obtener los Titulos activos asociados al contrato["+dto.getIdContrato()+"].");
			}//Ends if(lboEjecutaProcesoAdicional)
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarSAPSuscripcion]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::registrarSAPSuscripcion] :::::::::::::::: >>");
		return resultado;
	}
	
	
	
	private boolean ejecutarAccionesActualizaEstatusContrato(ParamActualizaContratoDTO dto) throws Exception
	{
		
		String lstCaso = (dto.getCaso() != null && dto.getCaso().length() > 0) ? dto.getCaso(): "";
		String lstEstatus = (dto.getEstatus() != null && dto.getEstatus().length() > 0) ? dto.getEstatus(): "";
		String lstExpediente = (dto.getExpediente() != null && dto.getExpediente().length() > 0) ? dto.getExpediente(): "";
		String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().length() > 0) ? dto.getIdContrato(): "";
		boolean resultado = false;
		try
		{
			//-- Actualiza estatus a Notificacion con SAP
			LOG.info("        [INI]. Actualiza estatus Contrato["+lstIdContrato+"]. Caso: " + lstCaso);
			ContratoDTO contrato = new ContratoDTO();
			contrato.setID_CONTRATO(lstIdContrato);
			contrato.setID_ESTATUS(lstEstatus);
			boolean lboActContratoNotificacion = contratoDAO.actualizaContratoFull(contrato);
			LOG.info("        [FIN]. Actualiza estatus Contrato["+lstIdContrato+"]. Caso: "+lstCaso+". Resultado: _" + lboActContratoNotificacion+"_");
			
			//--Registrar en bitacora de estatus
			if(lboActContratoNotificacion)
			{
				LOG.info("        [INI]. Registra bitacora Estatus.");
				ContratoEstatusDTO cntEstatus = new ContratoEstatusDTO();
				cntEstatus.setID_CONTRATO(lstIdContrato);
				cntEstatus.setID_ESTATUS(lstEstatus);
				cntEstatus.setEXPEDIENTE(lstExpediente);
				boolean lboRegistraBitacoraEstatus = contratoDAO.registraBitacoraEstatus(cntEstatus);
				LOG.info("        [FIN]. Registra bitacora Estatus. Resultado: _" + lboRegistraBitacoraEstatus + "_");
				
				if(lboRegistraBitacoraEstatus)
					resultado = true;
			}
		}
		catch(Exception e)
		{
			LOG.error("        Exception["+this.getClass().getSimpleName()+"::ejecutarAccionesActualizaEstatusContrato]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	private ResponseOrdenCompraDTO ejecutarAccionesManejoTitulosPorContrato(ParamManejoTitulosDTO dto) throws Exception
	{
		ResponseOrdenCompraDTO resTitulos = new ResponseOrdenCompraDTO();
		
		String lstExpediente = (dto.getExpediente() != null && dto.getExpediente().length() > 0) ? dto.getExpediente(): "";
		String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().length() > 0) ? dto.getIdContrato(): "";
		
		try
		{

			//-- Actualiza estatus a vigente
			LOG.info("    [INI]. Actualizacion a estatus Vigente de Contrato: ["+lstIdContrato+"].");
			pActualiza.setCaso(CASO_VIGENTE);
			pActualiza.setEstatus(ESTATUS_VIGENTE);
			pActualiza.setExpediente(lstExpediente);
			pActualiza.setIdContrato(lstIdContrato);
			boolean lboActualizoCnt = this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
			LOG.info("    [FIN]. Actualizacion a estatus Vigente de Contrato: ["+lstIdContrato+"]. Resultado: _"+lboActualizoCnt+"_");
			
			if(lboActualizoCnt)
			{
				//--Construccion de respuesta
				resTitulos.setResultado(true);
				resTitulos.setMensaje("OK");
			}
			else
			{
				//--Construye Respuesta
				resTitulos.setResultado(false);
				resTitulos.setMensaje("DDA-MTPC-001: "+ ERROR_PROCESO);
			}
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarAccionesManejoTitulosPorContrato]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resTitulos;
	}
	
	
	public ResponseAdendumEnmiendaDTO registrarSAPEnmiendaSuscripcion(ParamAdendumEnmiendaDTO dto)  throws Exception
	{
		ResponseAdendumEnmiendaDTO resultado = new ResponseAdendumEnmiendaDTO();
		boolean lboPuedeActualizarFechaModifSAP = false;
		boolean lboPuedeEjecutarSP_Adendum = false;
		boolean lboActualizarContratos = false;
		boolean lboEjecutaProcesoAdicional = false;
		
		LOG.info("<< :::::::::::::::: INI ["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaSuscripcion] :::::::::::::::: >>");
		LOG.info("    -->  Parametros: " + dto.toString());
		
		try
		{
 
			//--Establece por default el estatus en NOTIFICACION_SAP
			LOG.info("    [INI]. Llamado a Acciones Actualiza Estatus Contrato.");
			pActualiza.setCaso(CASO_REG_SAP_ENMIENDA_SUSCRIPCION);
			pActualiza.setEstatus(ESTATUS_NOTIFICACION_SAP);
			pActualiza.setExpediente(dto.getExpediente());
			pActualiza.setIdContrato(dto.getIdContrato());
			this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
			LOG.info("    [FIN]. Llamado a Acciones Actualiza Estatus Contrato.");
			
			
			//--INI PROCESO NVO 2.0
			//--Verifica si ya tiene o no establecida la fecha de Modificacion en SAP
			LOG.info("    [INI]. Obtener Fecha de Modificacion SAP del Contrato con ID ["+dto.getIdContrato()+"].");
			String lstFechaModifSAP_Contrato = contratoDAO.obtenerFechaModifSAPContrato(dto.getIdContrato());
			LOG.info("    [FIN]. Obtener Fecha de Modificacion SAP del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstFechaModifSAP_Contrato+"_");

			if(lstFechaModifSAP_Contrato.equals("-1"))
			{
				
				//-- Obtener registros de monto de contrato por ao.
				LOG.info("    [INI]. Obtener Registros de Monto del Contrato con ID ["+dto.getIdContrato()+"].");
				List<QryMontosAnualesCntDTO> lobMontosAnualesCnt = contratoDAO.obtenerMontosAnualesPorContrato(dto.getIdContrato());
				LOG.info("    [FIN]. Obtener Monto del Contrato con ID ["+dto.getIdContrato()+"]. Montos encontrados:_"+lobMontosAnualesCnt.size()+"_");
				
				//--Verifica si hubo registros montos anuales
				if(lobMontosAnualesCnt != null && lobMontosAnualesCnt.size() > 0)
				{
					int lnuTotalMontosAnuales = lobMontosAnualesCnt.size();
					lboPuedeActualizarFechaModifSAP = true;
					
					LOG.info(" ");
					LOG.info("        [INI] Procesamiento de ["+lnuTotalMontosAnuales+"] Montos por Annio.");
					for(int xMontoA = 0; xMontoA < lnuTotalMontosAnuales; xMontoA++)
					{
						QryMontosAnualesCntDTO lobMontoAnual =  (QryMontosAnualesCntDTO)lobMontosAnualesCnt.get(xMontoA);
						String lstMontoAnual = (lobMontoAnual.getMONTO() != null && lobMontoAnual.getMONTO().trim().length() > 0) ? lobMontoAnual.getMONTO() : "";
						String lstAnnio = (lobMontoAnual.getANNIO() != null && lobMontoAnual.getANNIO().trim().length() > 0) ? lobMontoAnual.getANNIO() : "";
						
						//--Obtener la posicion y el monto reportado a SAP para  el ao en cuestion
						LOG.info("    [INI]. Obtener Posicion y Monto reportado a SAP para Contrato ["+dto.getIdContrato()+"] y Annio["+lstAnnio+"].");
						List<ContratoSAPDTO> lobMontoReportadoSAP = contratoDAO.obtenerMontoAnualReportadoSAP(dto.getIdContrato(), lstAnnio);
						LOG.info("    [FIN]. Obtener Posicion y Monto reportado a SAP para Contrato ["+dto.getIdContrato()+"] y Annio["+lstAnnio+"]. Registros:_"+lobMontoReportadoSAP.size()+"_");
						
						if(lobMontoReportadoSAP != null && lobMontoReportadoSAP.size() == 1)
						{
							String lstMontoReportadoSAP = (lobMontoReportadoSAP.get(0).getMONTO() != null && lobMontoReportadoSAP.get(0).getMONTO().trim().length() > 0) ? lobMontoReportadoSAP.get(0).getMONTO() : "";
							String lstPosicionReportadoSAP = (lobMontoReportadoSAP.get(0).getPOSICION() != null && lobMontoReportadoSAP.get(0).getPOSICION().trim().length() > 0) ? lobMontoReportadoSAP.get(0).getPOSICION() : "";
							
							//--Determina la diferencia de montos
							LOG.info("    [INI]. Obtener Diferencia de Monto Anual de Contrato["+lstMontoAnual+"] contra Monto reportado a SAP["+lstMontoReportadoSAP+"] del Contrato con ID ["+dto.getIdContrato()+"].");
							String lstDifMontoCntVSMontoSAP = arithManager.obtenerDiferencia(lstMontoAnual, lstMontoReportadoSAP, "0");
							LOG.info("    [FIN]. Obtener Diferencia de Monto Anual de Contrato["+lstMontoAnual+"] contra Monto reportado a SAP["+lstMontoReportadoSAP+"] del Contrato con ID ["+dto.getIdContrato()+"]. Resultado: _"+lstDifMontoCntVSMontoSAP+"_");
							
							//--Determina caso de la diferencia de montos
							int lstResComparacion_DifMontos = arithManager.comparaCantidades(lstDifMontoCntVSMontoSAP, "0");
							LOG.info("    [INI/FIN]. Diferencia de Montos: _"+lstResComparacion_DifMontos+"_.");
							
							if(lstResComparacion_DifMontos == 0)
							{
								LOG.info("    -- [Caso: No ocurrio cambio alguno] --");
							}
							else
							{
								//--Llamado de WS SAP para Modificar Posicion de Pedido. Interfaz 23
								LOG.info("    [INI]. Llamado a WS SAP para modificar posicion de pedido. Interfaz 23.");
								ParamModificaPosicionDTO paramModifPos = new ParamModificaPosicionDTO();
								paramModifPos.setDocumento(dto.getIdSAP());
								
								List<ItemModificaPosicionDTO> posicionesModificar = new ArrayList<ItemModificaPosicionDTO>();
								ItemModificaPosicionDTO posModif = new ItemModificaPosicionDTO();
								posModif.setCantidad(lstMontoAnual);
                                                                posModif.setNoPosicion(lstPosicionReportadoSAP);
								posicionesModificar.add(posModif);
								paramModifPos.setItems(posicionesModificar);
								
                                 
                                                                
								ResultadoModificaPosicionDTO rWS_Modifica = wsMgr.modificaPosicionPedidoWS(paramModifPos);
								
								//---*********  [INI] TEST -----
								/*
								ResultadoModificaPosicionDTO rWS_Modifica = new ResultadoModificaPosicionDTO();
								RespSAPPosicionDTO resp1 = new RespSAPPosicionDTO();
								resp1.setDocumento("");
								resp1.setIDMensaje("OK");
								resp1.setMensaje("OK");
								rWS_Modifica.setPosicion(resp1);
								rWS_Modifica.setResultado(true);
								*/
								//---*********  [FIN] TEST -----
								LOG.info("    [FIN]. Llamado a WS SAP para modificar posicion de pedido. Interfaz 23. Resultado: _" + rWS_Modifica.getResultado() + "_");
								
								if(rWS_Modifica.getPosicion() != null && rWS_Modifica.getResultado())
								{
									//--Verifica si se registro la modificacion correctamente
									if(rWS_Modifica.getPosicion().getIDMensaje() != null && rWS_Modifica.getPosicion().getIDMensaje().equalsIgnoreCase("OK"))
									{
										//--Actualiza registro posicion
										LOG.info("    [INI]. Actualiza registro posicion["+lstPosicionReportadoSAP+"] del Contrato con ID ["+dto.getIdContrato()+"].");
										ContratoSAPDTO cntSAP = new ContratoSAPDTO();
										cntSAP.setID_CONTRATO(dto.getIdContrato());
										cntSAP.setMONTO(lstMontoAnual);
										cntSAP.setPOSICION(lstPosicionReportadoSAP);
										boolean lboModifRegPosicion = contratoDAO.actualizaRegistroPosicion(cntSAP);
										LOG.info("    [FIN]. Actualiza registro posicion["+lstPosicionReportadoSAP+"] del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lboModifRegPosicion+"_");
										
										
										if(!lboModifRegPosicion)
										{
											lboPuedeActualizarFechaModifSAP = false;
											
											//--Construye Respuesta
											resultado.setResultado(false);
											resultado.setMensaje("DDA-RSES-002: "+ ERROR_PROCESO);
											LOG.info("Respuesta devuelta: " + resultado.toString());
											
											break;
										}//Ends if(lboModifRegPosicion)
										
									}
									else
									{
										lboPuedeActualizarFechaModifSAP = false;
										
										//--Construye Respuesta
										resultado.setResultado(false);
										resultado.setMensaje("DDA-RSES-001: "+ ERROR_MODIFICACION_SAP);
										LOG.info("Respuesta devuelta: " + resultado.toString());
										
										break;
									}
								}//Ends if(rWS_Modifica.getPosicion() != null && rWS_Modifica.getResultado())
								else if(rWS_Modifica.getTransFault() != null && !rWS_Modifica.getResultado())
								{
									lboPuedeActualizarFechaModifSAP = false;
									
									//-- Tracking
									LOG.error("Error al llamar el WS Modifica Posicion :: registrarSAPEnmiendaSuscripcion: " + rWS_Modifica.getTransFault().toString());
										
									//--Construccion de respuesta
									resultado.setResultado(false);
									resultado.setMensaje(rWS_Modifica.getTransFault().getInternalCode() + ": " + rWS_Modifica.getTransFault().getFaultDescription());
									LOG.info("Respuesta devuelta: " + resultado.toString());
									
									break;
								}
							}//Ends else if(lstResComparacion_DifMontos == 0)
							
						}//Ends if(lobMontoReportadoSAP != null && lobMontoReportadoSAP.size() == 1)
						else
						{
							//--Obtener siguiente posicion del Contrato para llamado a Interfaz 17.
							LOG.info("    [INI]. Obtener siguiente posicion de pago del Contrato con ID ["+dto.getIdContrato()+"].");
							String lstPosicion = contratoDAO.obtenerPosicionAumento(dto.getIdContrato());
							LOG.info("    [FIN]. Obtener siguiente posicion de pago del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstPosicion+"_");
							
							
							//--Llamado de WS SAP para Agregar Posicion. Interfaz 17
							LOG.info("    [INI]. Llamado a WS SAP para Agregar posicion. Interfaz 17.");
							ParamAgregaPosicionDTO paramAgregaPos = new ParamAgregaPosicionDTO();
							paramAgregaPos.setIdDocumento(dto.getIdSAP());
							
							List<ItemAgregaPosicionDTO> posicionesAgregar = new ArrayList<ItemAgregaPosicionDTO>();
							ItemAgregaPosicionDTO posicion = new ItemAgregaPosicionDTO();
							posicion.setCantidad(lstMontoAnual); //OK
							posicion.setCentro(CENTRO); //OK
							posicion.setCentroCosto("");//OK
							posicion.setDocumento(dto.getOrdenInterna()); //OK
							posicion.setIdMaterial(ID_MATERIAL_SUSC);//OK
							posicion.setIndicadorIVA(dto.getClaveIVA()); //OK
							posicion.setNoPosicion(lstPosicion); //OK
							posicion.setPosicionPO(lstPosicion); //OK
							posicion.setPrecio(CANTIDAD_AMORTIZABLE);
							posicion.setTipoImputacion(IMPUTACION_AMORTIZABLE);
							posicionesAgregar.add(posicion);
							paramAgregaPos.setItems(posicionesAgregar);
							
							ResultadoEnviaPosicionDTO rWS_AgregaPos = wsMgr.agregaPosicionWS(paramAgregaPos);
							
							LOG.info("    [FIN]. Llamado a WS SAP para agregar posicion. Interfaz 17. Resultado: _" + rWS_AgregaPos.getResultado() + "_");
							
							
							if(rWS_AgregaPos.getPosicion() != null && rWS_AgregaPos.getResultado())
							{
								//--Verifica si se agrego la posicion correctamente
								if(rWS_AgregaPos.getPosicion().getIDMensaje() != null && rWS_AgregaPos.getPosicion().getIDMensaje().equalsIgnoreCase("OK"))
								{
									//--Inserta registro posicion 
									LOG.info("    [INI]. Inserta registro nueva posicion["+lstPosicion+"] del Contrato ["+dto.getIdContrato()+"].");
									ContratoSAPDTO cntSAP = new ContratoSAPDTO();
									cntSAP.setID_CONTRATO(dto.getIdContrato());
									cntSAP.setMONTO(lstMontoAnual);
									cntSAP.setPOSICION(lstPosicion);
									cntSAP.setANNIO(lstAnnio);
									boolean lboInsPosCnt =  contratoDAO.insertarRegistroPosicionAnnio(cntSAP);
									LOG.info("    [FIN]. Inserta registro nueva posicion["+lstPosicion+"] del Contrato ["+dto.getIdContrato()+"]. Resultado:_"+lboInsPosCnt+"_");
									
									if(!lboInsPosCnt)
									{
										lboPuedeActualizarFechaModifSAP = false;
										
										//--Construye Respuesta
										resultado.setResultado(false);
										resultado.setMensaje("DDA-RSELF-001: "+ ERROR_PROCESO);
										LOG.info("Respuesta devuelta: " + resultado.toString());
										
										break;
									}
									
								}//Ends if(rWS_AgregaPos.getPosicion().getIDMensaje() != null && rWS_AgregaPos.getPosicion().getIDMensaje().equalsIgnoreCase("OK"))
								else
								{
									lboPuedeActualizarFechaModifSAP = false; 
									
									//--Construye Respuesta
									resultado.setResultado(false);
									resultado.setMensaje("DDA-RSELF-002: "+ ERROR_MODIFICACION_SAP);
									LOG.info("Respuesta devuelta: " + resultado.toString());
									
									break;
								}
							}//Ends if(rWS_AgregaPos.getPosicion() != null && rWS_AgregaPos.getResultado())
							else if(rWS_AgregaPos.getTransFault() != null && !rWS_AgregaPos.getResultado())
							{
								lboPuedeActualizarFechaModifSAP = false;
								
								//--Tracking
								LOG.error("Error al llamar el WS Agrega Posicion :: registrarSAPEnmiendaLicenseFee: " + rWS_AgregaPos.getTransFault().toString());
								
								//--Construccion de respuesta
								resultado.setResultado(false);
								resultado.setMensaje(rWS_AgregaPos.getTransFault().getInternalCode() + ": " + rWS_AgregaPos.getTransFault().getFaultDescription());
								LOG.info("Respuesta devuelta: " + resultado.toString());
								
								break;
							}
							
						}
						
					}//Termina for(int xMontoA = 0; xMontoA < lnuTotalMontosAnuales; xMontoA++)
					LOG.info("        [FIN] Procesamiento de ["+lnuTotalMontosAnuales+"] Montos por Annio.");
				}
				else
				{
					LOG.info("No se encontraron Registros de Montos por Annio para el contrato ["+dto.getIdContrato()+"].");
					lboPuedeActualizarFechaModifSAP = true;
				}
				
				
				if(lboPuedeActualizarFechaModifSAP)
				{
					//---Actualizacion al contrato de la FECHA_MODIFSAP
					LOG.info("    [INI]. Actualiza FECHA_MODIFSAP a Contrato ["+dto.getIdContrato()+"].");
					ContratoDTO cnt = new ContratoDTO();
					cnt.setFECHA_MODIFSAP(dateManager.getFechaActual("yyyy-mm-dd"));
					cnt.setID_CONTRATO(dto.getIdContrato());
					boolean lboActualizaFechaContrato = contratoDAO.actualizaContratoFull(cnt);
					LOG.info("    [FIN]. Actualiza FECHA_MODIFSAP a Contrato ["+dto.getIdContrato()+"]. Resultado:_"+lboActualizaFechaContrato+"_");
					
					if(lboActualizaFechaContrato)
						lboPuedeEjecutarSP_Adendum = true;
					else
					{
						//--Construye Respuesta
						resultado.setResultado(false);
						resultado.setMensaje("DDA-RSES-004: "+ ERROR_PROCESO);
						LOG.info("Respuesta devuelta: " + resultado.toString());
					}
					
				}//Ends if(lboPuedeActualizarFechaModifSAP)
				
				
			}//Ends if(lstFechaModifSAP_Contrato.equals("-1"))
			else
			{
				LOG.info("    El contrato ya fue modificado anteriormente. Ya tiene establecida la FECHA_MODIFSAP");
				lboPuedeEjecutarSP_Adendum = true;
			}
			//--FIN PROCESO NVO 2.0
			
			
			//---Ejecuta el Stored Procedure que se encarga de poblar la tabla CRN para los llamados a las distintas interfaces segun el caso detectado para Adendum/Enmienda
			//-- La respuesta devuelta indica un true/false para indicar si se debe o puede hacer la siguiente verificacion.
			if(lboPuedeEjecutarSP_Adendum)
			{
				LOG.info("    [INI]. Ejecutar analisis de datos para CRN Cliente SAP ["+dto.getIdContrato()+"].");
				boolean lboSPCrnCteSAP = contratoDAO.ejecutarSPDDA_CrnClienteSAP(dto.getIdContrato());
				LOG.info("    [FIN]. Ejecutar analisis de datos para CRN Cliente SAP ["+dto.getIdContrato()+"]. Resultado:_"+lboSPCrnCteSAP+"_");
				
				if(lboSPCrnCteSAP)
					lboActualizarContratos = true;
				else
				{
					//--Construye Respuesta
					resultado.setResultado(false);
					resultado.setMensaje("No se pudo ejecutar el analisis de datos para CRN Cliente SAP");
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
				
			}//Ends if(lboVerificaAjusteTrasladoTitulos)
			
			
			
			
			//--Verifica si puede realizar las actualizaciones de los contratos
			if(lboActualizarContratos)
			{
				LOG.info("    [INI]. Inicia Actualizacion de Contratos de Adendum/Enmienda.");
				pTitulos.setExpediente(dto.getExpediente());
				pTitulos.setIdContrato(dto.getIdContrato());
				ResponseAdendumEnmiendaDTO lobResultadoActContratosAdendum = this.actualizaContratosAdendumEnmienda(pTitulos);
				LOG.info("    [FIN]. Inicia Actualizacion de Contratos de Adendum/Enmienda. Respuesta: <Mensaje:["+lobResultadoActContratosAdendum.getMensaje()+"],Resultado:["+lobResultadoActContratosAdendum.getResultado()+"]>");
				
				if(lobResultadoActContratosAdendum.getResultado())
				{
					lboEjecutaProcesoAdicional = true;
					
					resultado.setResultado(true);
					resultado.setMensaje("OK");
					LOG.info("Respuesta devuelta: " + resultado.toString());
					
				}
				else
				{
					resultado.setResultado(lobResultadoActContratosAdendum.getResultado());
					resultado.setMensaje(lobResultadoActContratosAdendum.getMensaje());
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
			}//Ends if(lboActualizarContratos)
			
			
			if(lboEjecutaProcesoAdicional)
			{
				//-- Proceso adicional de Envio de Titulos DDA a SAP
				LOG.info("    [INI]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"].");
				List<TitulosAsocContratoDTO> lobTitulosAsociados = contratoDAO.obtenerTitulosAsociadosContrato(dto.getIdContrato());
				LOG.info("    [FIN]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"]. Titulos Asociados:_"+lobTitulosAsociados.size()+"_");
				
				if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				{
					ParamEnviaTituloDTO pEnvTitulo = new ParamEnviaTituloDTO();
					pEnvTitulo.setTitulos(lobTitulosAsociados);
					
					//-- Llamado de interfaz 45 Envio Titulos DDA a SAP
					LOG.info("    [INI]. Llamado a WS SAP. Interfaz 45.");
					ResultadoEnviaTituloDTO rWS_ET = wsMgr.enviarTitulosDDAWS(pEnvTitulo);
					LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 45.");
					
					//Verifica si ocurrio una excepcion y el resultado es false
					if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					{
						//-- Tracking
						LOG.error("Error al llamar el WS Enviar Titulos DDA a SAP :: registrarSAPEnmiendaSuscripcion: " + rWS_ET.getTransFault().toString());
					}//Ends if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					
				}//Ends if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				else
					LOG.info("    No se pudieron obtener los Titulos activos asociados al contrato["+dto.getIdContrato()+"].");
			}//Ends if(lboEjecutaProcesoAdicional)
			
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaSuscripcion]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaSuscripcion] :::::::::::::::: >>");
		return resultado;
	}
	
	
	public ResponseAdendumEnmiendaDTO actualizaContratosAdendumEnmienda(ParamManejoTitulosDTO dto)  throws Exception
	{
		ResponseAdendumEnmiendaDTO resUpdContratosAd = new ResponseAdendumEnmiendaDTO();
		
		String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().length() > 0) ? dto.getIdContrato(): "";
		
		try
		{
			//--Buscar ultimo contrato vigente con base en el contrato de Adendum/Enmienda enviado
			LOG.info("    [INI]. Buscar ultimo contrato vigente relacionado al contrato: ["+dto.getIdContrato()+"].");
			String lstIdContratoVigente = contratoDAO.obtenerUltimoCntVigenteRelacionado(dto.getIdContrato());
			LOG.info("    [FIN]. Buscar ultimo contrato vigente relacionado al contrato: ["+dto.getIdContrato()+"]. Resultado:_"+lstIdContratoVigente+"_");
			
			if(!lstIdContratoVigente.equals("-1"))
			{
				//---Actualizacion de estatus a Ultimo Contrato Vigente
				LOG.info("    [INI]. Actualizacion a Autorizado de Ultimo contrato vigente: ["+lstIdContratoVigente+"].");
				pActualiza.setCaso(CASO_REG_SAP_ENMIENDA_SUSCRIPCION);
				pActualiza.setEstatus(ESTATUS_AUTORIZADO);
				pActualiza.setExpediente(dto.getExpediente());
				pActualiza.setIdContrato(lstIdContratoVigente);
				boolean lboActualizaUltimoVigente = this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
				LOG.info("    [FIN]. Actualizacion a Autorizado de Ultimo contrato vigente: ["+lstIdContratoVigente+"]. Resultado:_"+lboActualizaUltimoVigente+"_");
				
				if(lboActualizaUltimoVigente)
				{
					//--Actualizacion de estatus a Contrato respectivo del Adendum/Enmienda
					LOG.info("    [INI]. Actualizacion a estatus Vigente al Contrato de Adendum/Enmienda: ["+dto.getIdContrato()+"].");
					pActualiza.setCaso(CASO_REG_SAP_ENMIENDA_SUSCRIPCION);
					pActualiza.setEstatus(ESTATUS_VIGENTE);
					pActualiza.setExpediente(dto.getExpediente());
					pActualiza.setIdContrato(dto.getIdContrato());
					boolean lboActualizaCntAdEnmienda = this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
					LOG.info("    [FIN]. Actualizacion a estatus Vigente al Contrato de Adendum/Enmienda: ["+dto.getIdContrato()+"]. Resultado:_"+lboActualizaCntAdEnmienda+"_");
					
					if(lboActualizaCntAdEnmienda)
					{
						//--Construye Respuesta
						LOG.info("Se actualizo correctamente el estatus del Contrato respectivo del Adendum/Enmienda");
						resUpdContratosAd.setResultado(true);
						resUpdContratosAd.setMensaje("OK");
						
					}
					else
					{
						//--Construye Respuesta
						LOG.error("No se pudo actualizar el estatus del contrato de Adendum/Enmienda.");
						resUpdContratosAd.setResultado(false);
						resUpdContratosAd.setMensaje("DDA-ADE-003: "+ ERROR_PROCESO);
					}
				}
				else
				{
					//--Construye Respuesta
					LOG.error("No se pudo actualizar el estatus del ultimo contrato vigente.");
					resUpdContratosAd.setResultado(false);
					resUpdContratosAd.setMensaje("DDA-ADE-002: "+ ERROR_PROCESO);
				}
				
			}//Ends if(lstIdContratoVigente.equals("-1"))
			else
			{
				//--Construye Respuesta
				LOG.error("No se pudo obtener el ultimo contrato vigente.");
				resUpdContratosAd.setResultado(false);
				resUpdContratosAd.setMensaje("DDA-ADE-001: "+ ERROR_PROCESO);
			}
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizaContratosAdendumEnmienda]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resUpdContratosAd;
	}
	
	
	public ResponseOrdenCompraDTO registrarSAPLicenseFee(ParamOrdenCompraDTO dto) throws Exception
	{
		ResponseOrdenCompraDTO resultado = new ResponseOrdenCompraDTO();
		HOY_DASH_YMD = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_DOTS_DMY = dateManager.getFechaActual("dd.mm.yyyy");
		
		LOG.info("<< :::::::::::::::: INI ["+this.getClass().getSimpleName()+"::registrarSAPLicenseFee] :::::::::::::::: >>");
		LOG.info("     -->  Parametros: " + dto.toString());
		try
		{
			
			//--Establece por default el estatus en Registrar SAP License Fee
			LOG.info("    [INI]. Llamado a Acciones Actualiza Estatus Contrato.");
			pActualiza.setCaso(CASO_REG_SAP_LICENSEFEE);
			pActualiza.setEstatus(ESTATUS_NOTIFICACION_SAP);
			pActualiza.setExpediente(dto.getExpediente());
			pActualiza.setIdContrato(dto.getIdContrato());
			this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
			LOG.info("    [FIN]. Llamado a Acciones Actualiza Estatus Contrato.");
			
			//---Verifica si el Contrato cuenta con el ID de SAP. 
			LOG.info("    [INI]. Obtener ID SAP del Contrato: ["+dto.getIdContrato()+"].");
			String lstIDSAP_Contrato = contratoDAO.obtenerIDSAPContrato(dto.getIdContrato());
			LOG.info("    [FIN]. Obtener ID SAP del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstIDSAP_Contrato+"_");
			
			if(lstIDSAP_Contrato.equals("-1"))
			{
				//--Llamado al WS SAP para Ordenes de Compra. Interfaz 8
				LOG.info("    [INI]. Llamado a WS SAP. Interfaz 8.");
				//dto.getItems().get(0)
				ResultadoOrdenCompraDTO rWS_OC = wsMgr.crearOrdenCompraWS(dto);
				LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 8. Resultado: _" + rWS_OC.getResultado() + "_");
				
				if(rWS_OC.getOrdenCompra() != null && rWS_OC.getResultado())
				{

					//-- Registro Orden de Compra?
					if(rWS_OC.getOrdenCompra().getIDMensaje() != null && rWS_OC.getOrdenCompra().getIDMensaje().equalsIgnoreCase("OK"))
					{
						
						//-- Actualiza el contrato con el ID devuelto por SAP
						LOG.info("    [INI]. Actualiza contrato ["+dto.getIdContrato()+"] con ID de SAP ["+rWS_OC.getOrdenCompra().getPONumber()+"].");
						ContratoDTO cnt = new ContratoDTO();
						cnt.setID_SAP(rWS_OC.getOrdenCompra().getPONumber());
						cnt.setID_CONTRATO(dto.getIdContrato());
						boolean lboActualizaIdSap = contratoDAO.actualizaContratoFull(cnt);
						LOG.info("    [FIN]. Actualiza contrato ["+dto.getIdContrato()+"] con ID de SAP ["+rWS_OC.getOrdenCompra().getPONumber()+"]. Resultado: _" +lboActualizaIdSap+"_");
						
						if(lboActualizaIdSap)
							lstIDSAP_Contrato = rWS_OC.getOrdenCompra().getPONumber();
						else
						{
							//--Construye respuesta
							resultado.setResultado(false);
							resultado.setMensaje("DDA-RSLF-002: " + ERROR_PROCESO);
							LOG.info("Respuesta devuelta: " + resultado.toString());
						}
					}// Ends Registro Orden Compra?
					else
					{
						//--Construye Respuesta
						resultado.setResultado(false);
						resultado.setMensaje("DDA-RSLF-001: "+ ERROR_REGISTRO_SAP);
						LOG.info("Respuesta devuelta: " + resultado.toString());
						
					}
				}
				else if(rWS_OC.getTransFault() != null && !rWS_OC.getResultado())
				{
					//-- Tracking
					LOG.error("Error al llamar el WS Orden de Compra :: registrarSAPLicenseFee: " + rWS_OC.getTransFault().toString());
					
					//--Construccion de respuesta
					resultado.setResultado(false);
					resultado.setMensaje(rWS_OC.getTransFault().getInternalCode() + ": " + rWS_OC.getTransFault().getFaultDescription());
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
				
			}// Ends if(lstIDSAP_Contrato.equals("-1"))
			
			
			if(!lstIDSAP_Contrato.equals("-1"))
			{
				
				//--Actualiza contrato a Estatus Vigente
				LOG.info("    [INI]. Actualizacion a estatus Vigente de Contrato: ["+dto.getIdContrato()+"].");
				pActualiza.setCaso(CASO_REG_SAP_LICENSEFEE);
				pActualiza.setEstatus(ESTATUS_VIGENTE);
				pActualiza.setExpediente(dto.getExpediente());
				pActualiza.setIdContrato(dto.getIdContrato());
				boolean lboActualizoVigente = this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
				LOG.info("    [FIN]. Actualizacion a estatus Vigente de Contrato: ["+dto.getIdContrato()+"]. Resultado: _"+lboActualizoVigente+"_");
				
				if(lboActualizoVigente)
				{
					
					//--Construye Respuesta
					resultado.setResultado(true);
					resultado.setMensaje("OK");
					LOG.info("Respuesta devuelta: " + resultado.toString());
					
					
					//-- Proceso adicional de Envio de Titulos DDA a SAP
					LOG.info("    [INI]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"].");
					List<TitulosAsocContratoDTO> lobTitulosAsociados = contratoDAO.obtenerTitulosAsociadosContrato(dto.getIdContrato());
					LOG.info("    [FIN]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"]. Titulos Asociados:_"+lobTitulosAsociados.size()+"_");
					
					if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
					{
						ParamEnviaTituloDTO pEnvTitulo = new ParamEnviaTituloDTO();
						pEnvTitulo.setTitulos(lobTitulosAsociados);
						
						//-- Llamado de interfaz 45 Envio Titulos DDA a SAP
						LOG.info("    [INI]. Llamado a WS SAP. Interfaz 45.");
						ResultadoEnviaTituloDTO rWS_ET = wsMgr.enviarTitulosDDAWS(pEnvTitulo);
						LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 45.");
						
						//Verifica si ocurrio una excepcion y el resultado es false
						if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
						{
							//-- Tracking
							LOG.error("Error al llamar el WS Enviar Titulos DDA a SAP :: registrarSAPLicenseFee: " + rWS_ET.getTransFault().toString());
						}//Ends if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
						
					}//Ends if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
					else
						LOG.info("    No se pudieron obtener los Titulos activos asociados al contrato["+dto.getIdContrato()+"].");
					
				}//Ends if(lboActualizoVigente)
				else
				{
					//--Construye Respuesta
					LOG.error("No se pudo actualizar el estatus del contrato No Amortizable.");
					resultado.setResultado(false);
					resultado.setMensaje("DDA-RSLF-004: "+ ERROR_PROCESO);
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
						
			}//Ends if(!lstIDSAP_Contrato.equals("-1"))
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarSAPLicenseFee]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::registrarSAPLicenseFee] :::::::::::::::: >>");
		return resultado;
	}
	
	
	public ResponseOrdenCompraDTO registrarSAPTransaccional(ParamOrdenCompraDTO dto) throws Exception
	{
		ResponseOrdenCompraDTO resultado = new ResponseOrdenCompraDTO();
		boolean lboEjecutaProcesoAdicional = false;
		
		LOG.info("<< :::::::::::::::: INI ["+this.getClass().getSimpleName()+"::registrarSAPTransaccional] :::::::::::::::: >>");
		LOG.info("     -->  Parametros: " + dto.toString());
		try
		{
			
			//--Establece por default el estatus en Registrar SAP License Fee
			LOG.info("    [INI]. Llamado a Acciones Actualiza Estatus Contrato.");
			pActualiza.setCaso(CASO_REG_SAP_TRANSACCIONAL);
			pActualiza.setEstatus(ESTATUS_NOTIFICACION_SAP);
			pActualiza.setExpediente(dto.getExpediente());
			pActualiza.setIdContrato(dto.getIdContrato());
			this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
			LOG.info("    [FIN]. Llamado a Acciones Actualiza Estatus Contrato.");
			
			//---Verifica si el Contrato cuenta con el ID de SAP. 
			LOG.info("    [INI]. Obtener ID SAP del Contrato: ["+dto.getIdContrato()+"].");
			String lstIDSAP_Contrato = contratoDAO.obtenerIDSAPContrato(dto.getIdContrato());
			LOG.info("    [FIN]. Obtener ID SAP del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstIDSAP_Contrato+"_");
			
			if(lstIDSAP_Contrato.equals("-1"))
			{
				//--Llamado al WS SAP para Ordenes de Compra. Interfaz 8
				LOG.info("    [INI]. Llamado a WS SAP. Interfaz 8.");
				//dto.getItems().get(0)
				ResultadoOrdenCompraDTO rWS_OC = wsMgr.crearOrdenCompraWS(dto);
				LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 8. Resultado: _" + rWS_OC.getResultado() + "_");
				
				if(rWS_OC.getOrdenCompra() != null && rWS_OC.getResultado())
				{

					//-- Registro Orden de Compra?
					if(rWS_OC.getOrdenCompra().getIDMensaje() != null && rWS_OC.getOrdenCompra().getIDMensaje().equalsIgnoreCase("OK"))
					{
						//-- Actualiza el contrato con el ID devuelto por SAP
						LOG.info("    [INI]. Actualiza contrato ["+dto.getIdContrato()+"] con ID de SAP.");
						ContratoDTO cnt = new ContratoDTO();
						cnt.setID_SAP(rWS_OC.getOrdenCompra().getPONumber());
						cnt.setID_CONTRATO(dto.getIdContrato());
						boolean lboActualizaIdSap = contratoDAO.actualizaContratoFull(cnt);
						LOG.info("    [FIN]. Actualiza contrato ["+dto.getIdContrato()+"] con ID de SAP. Resultado: _" +lboActualizaIdSap+"_");
						
						if(lboActualizaIdSap)
						{
							//--Actualiza contrato vigente
							LOG.info("    [INI]. Actualizacion a estatus Vigente de Contrato: ["+dto.getIdContrato()+"].");
							pActualiza.setCaso(CASO_REG_SAP_TRANSACCIONAL);
							pActualiza.setEstatus(ESTATUS_VIGENTE);
							pActualiza.setExpediente(dto.getExpediente());
							pActualiza.setIdContrato(dto.getIdContrato());
							boolean lboActualizaVigente = this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
							LOG.info("    [FIN]. Actualizacion a estatus Vigente de Contrato: ["+dto.getIdContrato()+"]. Resultado: _"+lboActualizaVigente+"_");
							
							if(lboActualizaVigente)
							{
								//--Construye Respuesta
								resultado.setResultado(true);
								resultado.setMensaje("OK");
								LOG.info("Respuesta devuelta: " + resultado.toString());
								
								//--Habilita llamado Interfaz 45
								lboEjecutaProcesoAdicional = true;
							}
							else
							{
								//--Construye Respuesta
								LOG.error("No se pudo actualizar el estatus del contrato (RST).");
								resultado.setResultado(false);
								resultado.setMensaje("DDA-RST-003: "+ ERROR_PROCESO);
								LOG.info("Respuesta devuelta: " + resultado.toString());
							}
							
						}// Ends if(lboActualizaIdSap)
						else
						{
							//--Construye respuesta
							resultado.setResultado(false);
							resultado.setMensaje("DDA-RST-002: " + ERROR_PROCESO);
							LOG.info("Respuesta devuelta: " + resultado.toString());
						}
					}// Ends Registro Orden Compra?
					else
					{
						//--Construye Respuesta
						resultado.setResultado(false);
						resultado.setMensaje("DDA-RST-001: "+ ERROR_REGISTRO_SAP);
						LOG.info("Respuesta devuelta: " + resultado.toString());
						
					}
				}
				else if(rWS_OC.getTransFault() != null && !rWS_OC.getResultado())
				{
					//-- Tracking
					LOG.error("Error al llamar el WS Orden de Compra :: registrarSAPTransaccional: " + rWS_OC.getTransFault().toString());
					
					//--Construccion de respuesta
					resultado.setResultado(false);
					resultado.setMensaje(rWS_OC.getTransFault().getInternalCode() + ": " + rWS_OC.getTransFault().getFaultDescription());
					LOG.info("Respuesta devuelta: " + resultado.toString());
					
				}
				
			}// Ends if(lstIDSAP_Contrato.equals("-1"))
			else
			{
				//--Actualiza contrato a Estatus Vigente
				LOG.info("    [INI]. Actualizacion a estatus Vigente de Contrato: ["+dto.getIdContrato()+"].");
				pActualiza.setCaso(CASO_REG_SAP_TRANSACCIONAL);
				pActualiza.setEstatus(ESTATUS_VIGENTE);
				pActualiza.setExpediente(dto.getExpediente());
				pActualiza.setIdContrato(dto.getIdContrato());
				boolean lboActualizoVigente = this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
				LOG.info("    [FIN]. Actualizacion a estatus Vigente de Contrato: ["+dto.getIdContrato()+"]. Resultado: _"+lboActualizoVigente+"_");
				
				if(lboActualizoVigente)
				{
					//--Construye Respuesta
					resultado.setResultado(true);
					resultado.setMensaje("OK");
					LOG.info("Respuesta devuelta: " + resultado.toString());
					
					//--Habilita llamado Interfaz 45
					lboEjecutaProcesoAdicional = true;
				}
				else
				{
					//--Construye Respuesta
					LOG.error("No se pudo actualizar el estatus del contrato (RST).");
					resultado.setResultado(false);
					resultado.setMensaje("DDA-RST-004: "+ ERROR_PROCESO);
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
			}
			
			if(lboEjecutaProcesoAdicional)
			{
				//-- Proceso adicional de Envio de Titulos DDA a SAP
				LOG.info("    [INI]. Consulta de los titulos transaccionales asociados al contrato["+dto.getIdContrato()+"].");
				List<TitulosAsocContratoDTO> lobTitulosAsociados = contratoDAO.obtenerTitulosTransaccionalesAsociadosContrato(dto.getIdContrato());
				LOG.info("    [FIN]. Consulta de los titulos transaccionales asociados al contrato["+dto.getIdContrato()+"]. Titulos Asociados:_"+lobTitulosAsociados.size()+"_");
				
				if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				{
					ParamEnviaTituloDTO pEnvTitulo = new ParamEnviaTituloDTO();
					pEnvTitulo.setTitulos(lobTitulosAsociados);
					
					//-- Llamado de interfaz 45 Envio Titulos DDA a SAP
					LOG.info("    [INI]. Llamado a WS SAP. Interfaz 45.");
					ResultadoEnviaTituloDTO rWS_ET = wsMgr.enviarTitulosDDAWS(pEnvTitulo);
					LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 45.");
					
					//Verifica si ocurrio una excepcion y el resultado es false
					if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					{
						//-- Tracking
						LOG.error("Error al llamar el WS Enviar Titulos DDA a SAP :: registrarSAPTransaccional: " + rWS_ET.getTransFault().toString());
					}//Ends if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					
				}//Ends if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				else
					LOG.info("    No se pudieron obtener los Titulos activos asociados al contrato["+dto.getIdContrato()+"].");
			}//Ends if(lboEjecutaProcesoAdicional) 
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarSAPTransaccional]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::registrarSAPTransaccional] :::::::::::::::: >>");
		return resultado;
	}
	
	
	public ResponseAdendumEnmiendaDTO registrarSAPEnmiendaLicenseFee(ParamAdendumEnmiendaDTO dto)  throws Exception
	{
		
		ResponseAdendumEnmiendaDTO resultado = new ResponseAdendumEnmiendaDTO();
		boolean lboEjecutarI32 = false;
		boolean lboActualizarFechaModifSAP = false;
		boolean lboActualizarContratos = false;
		boolean lboEjecutaI45 = false;
		
		HOY_DASH_YMD = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_DOTS_DMY = dateManager.getFechaActual("dd.mm.yyyy");
		
		LOG.info("<< :::::::::::::::: INI ["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaLicenseFee] :::::::::::::::: >>");
		LOG.info("    -->  Parametros: " + dto.toString());
		
		try
		{
			//--Establece por default el estatus en NOTIFICACION_SAP
			LOG.info("    [INI]. Llamado a Acciones Actualiza Estatus Contrato.");
			pActualiza.setCaso(CASO_REG_SAP_ENMIENDA_LICENSEFEE);
			pActualiza.setEstatus(ESTATUS_NOTIFICACION_SAP);
			pActualiza.setExpediente(dto.getExpediente());
			pActualiza.setIdContrato(dto.getIdContrato());
			this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
			LOG.info("    [FIN]. Llamado a Acciones Actualiza Estatus Contrato.");
			
			//--Verifica si ya tiene o no establecida la fecha de Modificacion en SAP
			LOG.info("    [INI]. Obtener Fecha de Modificacion SAP del Contrato con ID ["+dto.getIdContrato()+"].");
			String lstFechaModifSAP_Contrato = contratoDAO.obtenerFechaModifSAPContrato(dto.getIdContrato());
			LOG.info("    [FIN]. Obtener Fecha de Modificacion SAP del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstFechaModifSAP_Contrato+"_");
			
			if(lstFechaModifSAP_Contrato.equals("-1"))
			{
				//--Obtener indicador de IVA del Contrato
				LOG.info("    [INI]. Obtener Indicador de Iva del Contrato ["+dto.getIdContrato()+"].");
				String lstIndicadorIVA = contratoDAO.obtenerIndicadorIVACnt(dto.getIdContrato());
				LOG.info("    [FIN]. Obtener Indicador de Iva del Contrato ["+dto.getIdContrato()+"]. Resultado:_"+lstIndicadorIVA+"_");
				
				//--Obtener el monto del contrato
				LOG.info("    [INI]. Obtener Monto del Contrato con ID ["+dto.getIdContrato()+"].");
				String lstMontoContrato = contratoDAO.obtenerMontoContrato(dto.getIdContrato());
				LOG.info("    [FIN]. Obtener Monto del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstMontoContrato+"_");
				
				//--Obtener monto reportado a SAP
				LOG.info("    [INI]. Obtener Monto reportado a SAP del Contrato con ID ["+dto.getIdContrato()+"].");
				String lstMontoReportadoSAP = contratoDAO.obtenerMontoReportadoSAP(dto.getIdContrato(),"");
				LOG.info("    [FIN]. Obtener Monto reportado a SAP del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstMontoReportadoSAP+"_");
				
				//--Obtener siguiente posicion del Contrato
				LOG.info("    [INI]. Obtener siguiente posicion de pago del Contrato con ID ["+dto.getIdContrato()+"].");
				String lstPosicion = contratoDAO.obtenerPosicionAumento(dto.getIdContrato());
				LOG.info("    [FIN]. Obtener siguiente posicion de pago del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstPosicion+"_");
				
				//--Determina la diferencia de montos
				LOG.info("    [INI]. Obtener Diferencia de Monto de Contrato["+lstMontoContrato+"] contra Monto reportado a SAP["+lstMontoReportadoSAP+"] del Contrato con ID ["+dto.getIdContrato()+"].");
				String lstDifMontoCntVSMontoSAP = arithManager.obtenerDiferencia(lstMontoContrato, lstMontoReportadoSAP, "0");
				LOG.info("    [FIN]. Obtener Diferencia de Monto de Contrato["+lstMontoContrato+"] contra Monto reportado a SAP["+lstMontoReportadoSAP+"] del Contrato con ID ["+dto.getIdContrato()+"]. Resultado: _"+lstDifMontoCntVSMontoSAP+"_");
				
				//--Determina caso de la diferencia de montos
				int lnuResComparacion_DifMontos = arithManager.comparaCantidades(lstDifMontoCntVSMontoSAP, "0");
				LOG.info("    [INI/FIN]. Diferencia de Montos: _"+lnuResComparacion_DifMontos+"_.");
				
				if(lnuResComparacion_DifMontos == 1 )
				{
					LOG.info("    -- [Caso: Diferencia mayor que cero] --"); 
					
					//--Llamado de WS SAP para Agregar posicion. Interfaz 17
					LOG.info("    [INI]. Llamado a WS SAP para agregar posicion. Interfaz 17.");
					ParamAgregaPosicionDTO paramAgregaPos = new ParamAgregaPosicionDTO();
					paramAgregaPos.setIdDocumento(dto.getIdSAP());
					
					List<ItemAgregaPosicionDTO> posicionesAgregar = new ArrayList<ItemAgregaPosicionDTO>();
					ItemAgregaPosicionDTO posicion = new ItemAgregaPosicionDTO();
					posicion.setCantidad(lstDifMontoCntVSMontoSAP);
					posicion.setCentro(CENTRO);
					posicion.setCentroCosto(CENTRO_COSTO);
					posicion.setDocumento("");
					posicion.setIdMaterial(ID_MATERIAL_LF);
					posicion.setIndicadorIVA(lstIndicadorIVA);
					posicion.setNoPosicion(lstPosicion);
					posicion.setPosicionPO(lstPosicion);
					posicion.setPrecio(CANTIDAD_NOAMORTIZABLE);
					posicion.setTipoImputacion(IMPUTACION_NOAMORTIZABLE);
					posicionesAgregar.add(posicion);
					paramAgregaPos.setItems(posicionesAgregar);
					
					ResultadoEnviaPosicionDTO rWS_AgregaPos = wsMgr.agregaPosicionWS(paramAgregaPos);
					
					LOG.info("    [FIN]. Llamado a WS SAP para agregar posicion. Interfaz 17. Resultado: _" + rWS_AgregaPos.getResultado() + "_");
					
					if(rWS_AgregaPos.getPosicion() != null && rWS_AgregaPos.getResultado())
					{
						//--Verifica si se agrego la posicion correctamente
						if(rWS_AgregaPos.getPosicion().getIDMensaje() != null && rWS_AgregaPos.getPosicion().getIDMensaje().equalsIgnoreCase("OK"))
						{
							//--Inserta registro posicion 
							LOG.info("    [INI]. Inserta registro nueva posicion["+lstPosicion+"] del Contrato ["+dto.getIdContrato()+"].");
							ContratoSAPDTO cntSAP = new ContratoSAPDTO();
							cntSAP.setID_CONTRATO(dto.getIdContrato());
							cntSAP.setMONTO(lstDifMontoCntVSMontoSAP);
							cntSAP.setPOSICION(lstPosicion);
							boolean lboInsPosCnt =  contratoDAO.insertarRegistroPosicion(cntSAP);
							LOG.info("    [FIN]. Inserta registro nueva posicion["+lstPosicion+"] del Contrato ["+dto.getIdContrato()+"]. Resultado:_"+lboInsPosCnt+"_");
							
							if(lboInsPosCnt)
								lboActualizarFechaModifSAP = true;
							else
							{
								//--Construye Respuesta
								resultado.setResultado(false);
								resultado.setMensaje("DDA-RSELF-001: "+ ERROR_PROCESO);
								LOG.info("Respuesta devuelta: " + resultado.toString());
							}
							
						}//Ends if(rWS_AgregaPos.getPosicion().getIDMensaje() != null && rWS_AgregaPos.getPosicion().getIDMensaje().equalsIgnoreCase("OK"))
						else
						{
							//--Construye Respuesta
							resultado.setResultado(false);
							resultado.setMensaje("DDA-RSELF-002: "+ ERROR_MODIFICACION_SAP);
							LOG.info("Respuesta devuelta: " + resultado.toString());
						}
					}//Ends if(rWS_AgregaPos.getPosicion() != null && rWS_AgregaPos.getResultado())
					else if(rWS_AgregaPos.getTransFault() != null && !rWS_AgregaPos.getResultado())
					{
						//--Tracking
						LOG.error("Error al llamar el WS Agrega Posicion :: registrarSAPEnmiendaLicenseFee: " + rWS_AgregaPos.getTransFault().toString());
						
						//--Construccion de respuesta
						resultado.setResultado(false);
						resultado.setMensaje(rWS_AgregaPos.getTransFault().getInternalCode() + ": " + rWS_AgregaPos.getTransFault().getFaultDescription());
						LOG.info("Respuesta devuelta: " + resultado.toString());
					}
				}//Ends if(lnuResComparacion_DifMontos == 1 )
				else
					lboActualizarFechaModifSAP = true;

				
				//--Verifica si puede actualizar Fecha Modificacion SAP
				if(lboActualizarFechaModifSAP)
				{
					//---Actualizacion al contrato de la FECHA_MODIFSAP
					LOG.info("    [INI]. Actualiza FECHA_MODIFSAP a Contrato ["+dto.getIdContrato()+"].");
					ContratoDTO cnt = new ContratoDTO();
					cnt.setFECHA_MODIFSAP(dateManager.getFechaActual("yyyy-mm-dd"));
					cnt.setID_CONTRATO(dto.getIdContrato());
					boolean lboActualizaFechaContrato = contratoDAO.actualizaContratoFull(cnt);
					LOG.info("    [FIN]. Actualiza FECHA_MODIFSAP a Contrato ["+dto.getIdContrato()+"]. Resultado:_"+lboActualizaFechaContrato+"_");
					
					if(lboActualizaFechaContrato)
						lboActualizarContratos = true;
					else
					{
						//--Construye Respuesta
						resultado.setResultado(false);
						resultado.setMensaje("DDA-RSELF-003: "+ ERROR_PROCESO);
						LOG.info("Respuesta devuelta: " + resultado.toString());
					}
					
				}//Ends if(lboActualizarFechaModifSAP)
				
			}//Ends if(lstFechaModifSAP_Contrato.equals("-1"))
			else
			{
				LOG.info("    El contrato ya fue modificado anteriormente. Ya tiene establecida la FECHA_MODIFSAP");
				lboActualizarContratos = true;
			}
			
			
			//--Verifica si puede realizar la actualizacion de los Contratos
			if(lboActualizarContratos)
			{
				LOG.info("    [INI]. Inicia Actualizacion de Contratos de Adendum/Enmienda License Fee.");
				pTitulos.setExpediente(dto.getExpediente());
				pTitulos.setIdContrato(dto.getIdContrato());
				ResponseAdendumEnmiendaDTO lobResultadoActContratosAdendum = this.actualizaContratosAdendumEnmienda(pTitulos);
				LOG.info("    [FIN]. Inicia Actualizacion de Contratos de Adendum/Enmienda License Fee. Respuesta: <Mensaje:["+lobResultadoActContratosAdendum.getMensaje()+"],Resultado:["+lobResultadoActContratosAdendum.getResultado()+"]>");
				
				if(lobResultadoActContratosAdendum.getResultado())
				{
					lboEjecutaI45 = true;
					
					resultado.setResultado(true);
					resultado.setMensaje("OK");
					LOG.info("Respuesta devuelta: " + resultado.toString());
					
				}
				else
				{
					resultado.setResultado(lobResultadoActContratosAdendum.getResultado());
					resultado.setMensaje(lobResultadoActContratosAdendum.getMensaje());
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
			}//Ends if(lboActualizarContratos)
			
			
			if(lboEjecutaI45)
			{
				//-- Proceso de Envio de Titulos DDA a SAP. Interfaz 45
				LOG.info("    [INI]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"].");
				List<TitulosAsocContratoDTO> lobTitulosAsociados = contratoDAO.obtenerTitulosAsociadosContrato(dto.getIdContrato());
				LOG.info("    [FIN]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"]. Titulos Asociados:_"+lobTitulosAsociados.size()+"_");
				
				if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				{
					ParamEnviaTituloDTO pEnvTitulo = new ParamEnviaTituloDTO();
					pEnvTitulo.setTitulos(lobTitulosAsociados);
					
					//-- Llamado de interfaz 45 Envio Titulos DDA a SAP
					LOG.info("    [INI]. Llamado a WS SAP. Interfaz 45.");
					ResultadoEnviaTituloDTO rWS_ET = wsMgr.enviarTitulosDDAWS(pEnvTitulo);
					LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 45.");
					
					//Verifica si ocurrio una excepcion y el resultado es false
					if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					{
						//-- Tracking
						LOG.error("Error al llamar el WS Enviar Titulos DDA a SAP :: registrarSAPEnmiendaLicenseFee: " + rWS_ET.getTransFault().toString());
					}//Ends if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					
				}//Ends if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				else
					LOG.info("    No se pudieron obtener los Titulos activos asociados al contrato["+dto.getIdContrato()+"].");
				
			}//Ends if(lboEjecutaI45)
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaLicenseFee]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaLicenseFee] :::::::::::::::: >>");
		
		return resultado;
		
	}
	

	public ResponseAdendumEnmiendaDTO registrarSAPEnmiendaTransaccional(ParamAdendumEnmiendaDTO dto)  throws Exception
	{
		
		ResponseAdendumEnmiendaDTO resultado = new ResponseAdendumEnmiendaDTO();
		boolean lboActualizarContratos = false;
		boolean lboEjecutaProcesoAdicional = false;
		
		LOG.info("<< :::::::::::::::: INI ["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaTransaccional] :::::::::::::::: >>");
		LOG.info("    -->  Parametros: " + dto.toString());
		
		try
		{
			//--Establece por default el estatus en NOTIFICACION_SAP
			LOG.info("    [INI]. Llamado a Acciones Actualiza Estatus Contrato.");
			pActualiza.setCaso(CASO_REG_SAP_ENMIENDA_TRANSACCIONAL);
			pActualiza.setEstatus(ESTATUS_NOTIFICACION_SAP);
			pActualiza.setExpediente(dto.getExpediente());
			pActualiza.setIdContrato(dto.getIdContrato());
			this.ejecutarAccionesActualizaEstatusContrato(pActualiza);
			LOG.info("    [FIN]. Llamado a Acciones Actualiza Estatus Contrato.");
			
			//--Verifica si ya tiene o no establecida la fecha de Modificacion en SAP
			LOG.info("    [INI]. Obtener Fecha de Modificacion SAP del Contrato con ID ["+dto.getIdContrato()+"].");
			String lstFechaModifSAP_Contrato = contratoDAO.obtenerFechaModifSAPContrato(dto.getIdContrato());
			LOG.info("    [FIN]. Obtener Fecha de Modificacion SAP del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstFechaModifSAP_Contrato+"_");
			
			if(lstFechaModifSAP_Contrato.equals("-1"))
			{
				//--Obtener el monto del contrato
				LOG.info("    [INI]. Obtener Monto del Contrato con ID ["+dto.getIdContrato()+"].");
				String lstMontoContrato = "1"; //contratoDAO.obtenerMontoContrato(dto.getIdContrato());
				LOG.info("    [FIN]. Obtener Monto del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstMontoContrato+"_");
				
				//--Obtener monto reportado a SAP
				LOG.info("    [INI]. Obtener Monto reportado a SAP del Contrato con ID ["+dto.getIdContrato()+"].");
				String lstMontoReportadoSAP = "0"; //contratoDAO.obtenerMontoReportadoSAP(dto.getIdContrato(),"");
				LOG.info("    [FIN]. Obtener Monto reportado a SAP del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lstMontoReportadoSAP+"_");
				
				//--Determina la diferencia de montos
				LOG.info("    [INI]. Obtener Diferencia de Monto de Contrato["+lstMontoContrato+"] contra Monto reportado a SAP["+lstMontoReportadoSAP+"] del Contrato con ID ["+dto.getIdContrato()+"].");
				String lstDifMontoCntVSMontoSAP = arithManager.obtenerDiferencia(lstMontoContrato, lstMontoReportadoSAP, "0");
				LOG.info("    [FIN]. Obtener Diferencia de Monto de Contrato["+lstMontoContrato+"] contra Monto reportado a SAP["+lstMontoReportadoSAP+"] del Contrato con ID ["+dto.getIdContrato()+"]. Resultado: _"+lstDifMontoCntVSMontoSAP+"_");
				
				//--Determina caso de la diferencia de montos
				int lstResComparacion_DifMontos = arithManager.comparaCantidades(lstDifMontoCntVSMontoSAP, "0");
				LOG.info("    [INI/FIN]. Diferencia de Montos: _"+lstResComparacion_DifMontos+"_.");
				
				if(lstResComparacion_DifMontos == 0)
				{
					LOG.info("    -- [Caso: No ocurrio cambio alguno] --");
					
					//---Actualizacion al contrato de la FECHA_MODIFSAP
					LOG.info("    [INI]. Actualiza FECHA_MODIFSAP a Contrato ["+dto.getIdContrato()+"].");
					ContratoDTO cnt = new ContratoDTO();
					cnt.setFECHA_MODIFSAP(dateManager.getFechaActual("yyyy-mm-dd"));
					cnt.setID_CONTRATO(dto.getIdContrato());
					boolean lboActualizaFechaContrato = contratoDAO.actualizaContratoFull(cnt);
					LOG.info("    [FIN]. Actualiza FECHA_MODIFSAP a Contrato ["+dto.getIdContrato()+"]. Resultado:_"+lboActualizaFechaContrato+"_");
					
					if(lboActualizaFechaContrato)
						lboActualizarContratos = true;
					else
					{
						//--Construye Respuesta
						resultado.setResultado(false);
						resultado.setMensaje("DDA-RSETR-004: "+ ERROR_PROCESO);
						LOG.info("Respuesta devuelta: " + resultado.toString());
					}
					
				}//Ends if(lstResComparacion_DifMontos == 0)
				else
				{
					LOG.info("    -- [Caso: Si ocurrio cambio] --");
					
					//--Llamado de WS SAP para Modificar Posicion de Pedido. Interfaz 23
					LOG.info("    [INI]. Llamado a WS SAP para modificar posicion de pedido. Interfaz 23.");
					ParamModificaPosicionDTO paramModifPos = new ParamModificaPosicionDTO();
					paramModifPos.setDocumento(dto.getIdSAP());
					
					List<ItemModificaPosicionDTO> posicionesModificar = new ArrayList<ItemModificaPosicionDTO>();
					ItemModificaPosicionDTO posModif = new ItemModificaPosicionDTO();
					posModif.setCantidad(lstMontoContrato);
					posModif.setNoPosicion(PRIMERA_POSICION);
					posicionesModificar.add(posModif);
					paramModifPos.setItems(posicionesModificar);
					
					ResultadoModificaPosicionDTO rWS_Modifica = wsMgr.modificaPosicionPedidoWS(paramModifPos);
					
					//---*********  [INI] TEST -----
					/*
					ResultadoModificaPosicionDTO rWS_Modifica = new ResultadoModificaPosicionDTO();
					RespSAPPosicionDTO resp1 = new RespSAPPosicionDTO();
					resp1.setDocumento("");
					resp1.setIDMensaje("OK");
					resp1.setMensaje("OK");
					rWS_Modifica.setPosicion(resp1);
					rWS_Modifica.setResultado(true);
					*/
					//---*********  [FIN] TEST -----
					LOG.info("    [FIN]. Llamado a WS SAP para modificar posicion de pedido. Interfaz 23. Resultado: _" + rWS_Modifica.getResultado() + "_");
					
					if(rWS_Modifica.getPosicion() != null && rWS_Modifica.getResultado())
					{
						//--Verifica si se registro la modificacion correctamente
						if(rWS_Modifica.getPosicion().getIDMensaje() != null && rWS_Modifica.getPosicion().getIDMensaje().equalsIgnoreCase("OK"))
						{
							//--Actualiza registro posicion
							LOG.info("    [INI]. Actualiza registro posicion["+PRIMERA_POSICION+"] del Contrato con ID ["+dto.getIdContrato()+"].");
							ContratoSAPDTO cntSAP = new ContratoSAPDTO();
							cntSAP.setID_CONTRATO(dto.getIdContrato());
							cntSAP.setMONTO(lstMontoContrato);
							cntSAP.setPOSICION(PRIMERA_POSICION);
							boolean lboModifRegPosicion = contratoDAO.actualizaRegistroPosicion(cntSAP);
							LOG.info("    [FIN]. Actualiza registro posicion["+PRIMERA_POSICION+"] del Contrato con ID ["+dto.getIdContrato()+"]. Resultado:_"+lboModifRegPosicion+"_");
							
							if(lboModifRegPosicion)
							{
								//---Actualizacion al contrato de la FECHA_MODIFSAP
								LOG.info("    [INI]. Actualiza FECHA_MODIFSAP a Contrato ["+dto.getIdContrato()+"].");
								ContratoDTO cnt = new ContratoDTO();
								cnt.setFECHA_MODIFSAP(dateManager.getFechaActual("yyyy-mm-dd"));
								cnt.setID_CONTRATO(dto.getIdContrato());
								boolean lboActualizaFechaContrato = contratoDAO.actualizaContratoFull(cnt);
								LOG.info("    [FIN]. Actualiza FECHA_MODIFSAP a Contrato ["+dto.getIdContrato()+"]. Resultado:_"+lboActualizaFechaContrato+"_");
									
								if(lboActualizaFechaContrato)
									lboActualizarContratos = true;
								else
								{
									//--Construye Respuesta
									resultado.setResultado(false);
									resultado.setMensaje("DDA-RSETR-003: "+ ERROR_PROCESO);
									LOG.info("Respuesta devuelta: " + resultado.toString());
								}
							}//Ends if(lboModifRegPosicion)
							else
							{
								//--Construye Respuesta
								resultado.setResultado(false);
								resultado.setMensaje("DDA-RSETR-002: "+ ERROR_PROCESO);
								LOG.info("Respuesta devuelta: " + resultado.toString());
							}
						}
						else
						{
							//--Construye Respuesta
							resultado.setResultado(false);
							resultado.setMensaje("DDA-RSETR-001: "+ ERROR_MODIFICACION_SAP);
							LOG.info("Respuesta devuelta: " + resultado.toString());
						}
					}//Ends if(rWS_Modifica.getPosicion() != null && rWS_Modifica.getResultado())
					else if(rWS_Modifica.getTransFault() != null && !rWS_Modifica.getResultado())
					{
						//-- Tracking
						LOG.error("Error al llamar el WS Modifica Posicion :: registrarSAPEnmiendaTransaccional: " + rWS_Modifica.getTransFault().toString());
							
						//--Construccion de respuesta
						resultado.setResultado(false);
						resultado.setMensaje(rWS_Modifica.getTransFault().getInternalCode() + ": " + rWS_Modifica.getTransFault().getFaultDescription());
						LOG.info("Respuesta devuelta: " + resultado.toString());
					}
					
				}//Ends else de if(lstResComparacion_DifMontos == 0)
				
			}//Ends if(lstFechaModifSAP_Contrato.equals("-1"))
			else
			{
				LOG.info("    El contrato ya fue modificado anteriormente. Ya tiene establecida la FECHA_MODIFSAP");
				lboActualizarContratos = true;
			}
			
			
			if(lboActualizarContratos)
			{
				LOG.info("    [INI]. Inicia Actualizacion de Contratos de Adendum/Enmienda Transaccional.");
				pTitulos.setExpediente(dto.getExpediente());
				pTitulos.setIdContrato(dto.getIdContrato());
				ResponseAdendumEnmiendaDTO lobResultadoActContratosAdendum = this.actualizaContratosAdendumEnmienda(pTitulos);
				LOG.info("    [FIN]. Inicia Actualizacion de Contratos de Adendum/Enmienda Transaccional. Respuesta: <Mensaje:["+lobResultadoActContratosAdendum.getMensaje()+"],Resultado:["+lobResultadoActContratosAdendum.getResultado()+"]>");
				
				if(lobResultadoActContratosAdendum.getResultado())
				{
					lboEjecutaProcesoAdicional = true;
					
					resultado.setResultado(true);
					resultado.setMensaje("OK");
					LOG.info("Respuesta devuelta: " + resultado.toString());
					
				}
				else
				{
					resultado.setResultado(lobResultadoActContratosAdendum.getResultado());
					resultado.setMensaje(lobResultadoActContratosAdendum.getMensaje());
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
			}//Termina if(lboActualizarContratos)
			
			
			if(lboEjecutaProcesoAdicional)
			{
				//-- Proceso adicional de Envio de Titulos DDA a SAP
				LOG.info("    [INI]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"].");
				List<TitulosAsocContratoDTO> lobTitulosAsociados = contratoDAO.obtenerTitulosTransaccionalesAsociadosContrato(dto.getIdContrato());
				LOG.info("    [FIN]. Consulta de los titulos activos asociados al contrato["+dto.getIdContrato()+"]. Titulos Asociados:_"+lobTitulosAsociados.size()+"_");
				
				if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				{
					ParamEnviaTituloDTO pEnvTitulo = new ParamEnviaTituloDTO();
					pEnvTitulo.setTitulos(lobTitulosAsociados);
					
					//-- Llamado de interfaz 45 Envio Titulos DDA a SAP
					LOG.info("    [INI]. Llamado a WS SAP. Interfaz 45.");
					ResultadoEnviaTituloDTO rWS_ET = wsMgr.enviarTitulosDDAWS(pEnvTitulo);
					LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 45.");
					
					//Verifica si ocurrio una excepcion y el resultado es false
					if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					{
						//-- Tracking
						LOG.error("Error al llamar el WS Enviar Titulos DDA a SAP :: registrarSAPEnmiendaTransaccional: " + rWS_ET.getTransFault().toString());
					}//Ends if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
					
				}//Ends if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
				else
					LOG.info("    No se pudieron obtener los Titulos activos asociados al contrato["+dto.getIdContrato()+"].");
			}//Termina if(lboEjecutaProcesoAdicional)
			
			
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaTransaccional]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::registrarSAPEnmiendaTransaccional] :::::::::::::::: >>");
		
		return resultado;
		
	}

	
	public ResponseNotificarInventarioTitulosDTO notificarInventarioTitulos(ParamInventarioTitulosDTO dto) throws Exception
	{
		ResponseNotificarInventarioTitulosDTO resultado = new ResponseNotificarInventarioTitulosDTO();
		
		LOG.info("<< :::::::::::::::: INI ["+this.getClass().getSimpleName()+"::notificarInventarioTitulos] :::::::::::::::: >>");
		LOG.info("     -->  Parametros: " + dto.toString());
		
		try
		{
			
			//-- Consulta de los titulos transaccionales asociados al contrato proporcionado.
			LOG.info("    [INI]. Consulta de los titulos transaccionales asociados al contrato["+dto.getIdContrato()+"].");
			List<TitulosAsocContratoDTO> lobTitulosAsociados = contratoDAO.obtenerTitulosTransaccionalesAsociadosContrato(dto.getIdContrato());
			LOG.info("    [FIN]. Consulta de los titulos transaccionales asociados al contrato["+dto.getIdContrato()+"]. Titulos Asociados:_"+lobTitulosAsociados.size()+"_");
			
			if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
			{
				ParamEnviaTituloDTO pEnvTitulo = new ParamEnviaTituloDTO();
				pEnvTitulo.setTitulos(lobTitulosAsociados);
				
				//-- Llamado de interfaz 45 Envio Titulos DDA a SAP
				LOG.info("    [INI]. Llamado a WS SAP. Interfaz 45.");
				ResultadoEnviaTituloDTO rWS_ET = wsMgr.enviarTitulosDDAWS(pEnvTitulo);
				LOG.info("    [FIN]. Llamado a WS SAP. Interfaz 45.");
				
				//Verifica si ocurrio una excepcion y el resultado es false
				if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
				{
					LOG.error("Error al llamar el WS Enviar Titulos DDA a SAP :: notificarInventarioTitulos: " + rWS_ET.getTransFault().toString());
					
					//-- Construccion de respuesta
					resultado.setMensaje("NO_OK");
					resultado.setResultado(false);
					LOG.info("Respuesta devuelta: " + resultado.toString());
					
				}//Ends if(rWS_ET.getTransFault() != null && !rWS_ET.getResultado())
				else
				{
					//--Construccion de respuesta
					resultado.setMensaje("OK");
					resultado.setResultado(true);
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
			}//Ends if(lobTitulosAsociados != null && lobTitulosAsociados.size() > 0)
			else
			{
				LOG.info("    No se pudieron obtener los Titulos activos asociados al contrato["+dto.getIdContrato()+"].");
				
				//-- Construccion de respuesta
				resultado.setMensaje("NO_OK");
				resultado.setResultado(false);
				LOG.info("Respuesta devuelta: " + resultado.toString());
			}
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::notificarInventarioTitulos]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::notificarInventarioTitulos] :::::::::::::::: >>");
		return resultado;
	}
	
	
	public ResponseNotificarFacturaDTO notificarFactura(ParamNotificaFacturaDTO dto) throws Exception
	{
		ResponseNotificarFacturaDTO resultado = new ResponseNotificarFacturaDTO();
		boolean lboVerificaI32 = false;
		boolean lboObtenerCveISO = false;
		
		HOY_DASH_YMD = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_DOTS_DMY = dateManager.getFechaActual("dd.mm.yyyy");
		
		LOG.info("<< :::::::::::::::: INI ["+this.getClass().getSimpleName()+"::notificarFactura] :::::::::::::::: >>");
		LOG.info("     -->  Parametros: " + dto.toString());
		
		try
		{
			//--Consultar datos importantes de la factura
			LOG.info("    [INI]. Consulta de los datos principales de la factura["+dto.getIdFactura()+"].");
			List<DatosFacturaDTO> lobDatosFactura = contratoDAO.obtenerDatosFactura(dto.getIdFactura());
			LOG.info("    [FIN]. Consulta de los datos principales de la factura["+dto.getIdFactura()+"]. Registros obtenidos:_"+lobDatosFactura.size()+"_");
			
			if(lobDatosFactura != null && lobDatosFactura.size() > 0)
			{
				int lnuTotalRegDatosFactura = lobDatosFactura.size();
				
				//--Verifica el numero de registros obtenidos.
				//--Por reglas de negocio, solo debera regresar un registro, esto porque a cada factura le corresponde un mes y monto de pago, no podrian
				//--configurar mas meses de pago por factura.
				if(lnuTotalRegDatosFactura == 1)
				{
					//--Recuperacion de datos de factura.
					DatosFacturaDTO lobFactura = (DatosFacturaDTO)lobDatosFactura.get(0);
					
					String lstComentario = (lobFactura.getCOMENTARIO() != null && lobFactura.getCOMENTARIO().trim().length() > 0) ? lobFactura.getCOMENTARIO() : "";
					String lstFechaFactura = (lobFactura.getFECHA_FACTURA() != null && lobFactura.getFECHA_FACTURA().trim().length() > 0) ? lobFactura.getFECHA_FACTURA() : "";
					String lstFechaSapI14 = (lobFactura.getFECHA_SAP_I14() != null && lobFactura.getFECHA_SAP_I14().trim().length() > 0) ? lobFactura.getFECHA_SAP_I14() : "";
					String lstFechaSapI17 = (lobFactura.getFECHA_SAP_I17() != null && lobFactura.getFECHA_SAP_I17().trim().length() > 0) ? lobFactura.getFECHA_SAP_I17() : "";
					String lstFechaSapI32 = (lobFactura.getFECHA_SAP_I32() != null && lobFactura.getFECHA_SAP_I32().trim().length() > 0) ? lobFactura.getFECHA_SAP_I32() : "";
					String lstIdCntOriginal = (lobFactura.getID_CONTRATO_ORIGINAL() != null && lobFactura.getID_CONTRATO_ORIGINAL().trim().length() > 0) ? lobFactura.getID_CONTRATO_ORIGINAL() : "";
					String lstIdSapCnt = (lobFactura.getID_SAP_CONTRATO() != null && lobFactura.getID_SAP_CONTRATO().trim().length() > 0) ? lobFactura.getID_SAP_CONTRATO() : "";
					String lstIndicadorIVA = (lobFactura.getIVA() != null && lobFactura.getIVA().trim().length() > 0) ? lobFactura.getIVA() : ""; 
					String lstMoneda = (lobFactura.getMONEDA() != null && lobFactura.getMONEDA().trim().length() > 0) ? lobFactura.getMONEDA() : "";
					String lstMontoPagar = (lobFactura.getMONTO_PAGAR() != null && lobFactura.getMONTO_PAGAR().trim().length() > 0) ? lobFactura.getMONTO_PAGAR() : "";
					String lstNoFactura = (lobFactura.getNO_FACTURA() != null && lobFactura.getNO_FACTURA().trim().length() > 0) ? lobFactura.getNO_FACTURA() : "";
					String lstPosicionPO = (lobFactura.getPOSICION_ENVIAR() != null && lobFactura.getPOSICION_ENVIAR().trim().length() > 0) ? lobFactura.getPOSICION_ENVIAR() : "";
					String lstTipoPago = (lobFactura.getTIPO_PAGO() != null && lobFactura.getTIPO_PAGO().trim().length() > 0) ? lobFactura.getTIPO_PAGO() : "";
					String lstIdFactura = (lobFactura.getID_FACTURA() != null && lobFactura.getID_FACTURA().trim().length() > 0) ? lobFactura.getID_FACTURA() : "";
					String lstIdMaterial = "";
					
					if(lstTipoPago.equalsIgnoreCase("MINIMO"))
						lstIdMaterial = ID_MATERIAL_MINIMO;
					else if(lstTipoPago.equalsIgnoreCase("OVERAGE"))
						lstIdMaterial = ID_MATERIAL_OVERAGE;
					
					
					LOG.info("   ");
					LOG.info("    <IdFactura:["+lstIdFactura+"],NoFactura:["+lstNoFactura+"],Posicion:["+lstPosicionPO+"],TipoPago:["+lstTipoPago+"],MontoPagar:["+lstMontoPagar+"],Moneda:["+lstMoneda+"],IndicadorIVA:["+lstIndicadorIVA+"],IdSapCnt:["+lstIdSapCnt+"],IdCntOriginal:["+lstIdCntOriginal+"],FechaFactura:["+lstFechaFactura+"],FechaI17["+lstFechaSapI17+"],FechaI32["+lstFechaSapI32+"],FechaI14["+lstFechaSapI14+"],Comentario:["+lstComentario+"]>");
					LOG.info("    <Ejecutar17 :: IdMaterial:["+lstIdMaterial+"],Centro:["+CENTRO+"],TipoImputacion:["+IMPUTACION_NOAMORTIZABLE+"],CentroCosto:["+CENTRO_COSTO+"]>");
					
					//--Verifica fecha SAP i17
					if(lstFechaSapI17.equals(""))
					{
						//--Llamado de WS SAP para Agregar posicion. Interfaz 17
						LOG.info("    [INI]. Llamado a WS SAP para agregar posicion. Interfaz 17.");
						ParamAgregaPosicionDTO paramAgregaPos = new ParamAgregaPosicionDTO();
						paramAgregaPos.setIdDocumento(lstIdSapCnt);
						
						List<ItemAgregaPosicionDTO> posicionesAgregar = new ArrayList<ItemAgregaPosicionDTO>();
						ItemAgregaPosicionDTO posicion = new ItemAgregaPosicionDTO();
						posicion.setCantidad(CANTIDAD_NOAMORTIZABLE);
						posicion.setCentro(CENTRO);
						posicion.setCentroCosto(CENTRO_COSTO);
						posicion.setDocumento("");
						posicion.setIdMaterial(lstIdMaterial);
						posicion.setIndicadorIVA(lstIndicadorIVA);
						posicion.setNoPosicion(lstPosicionPO);
						posicion.setPosicionPO(lstPosicionPO);
						posicion.setPrecio(lstMontoPagar);
						posicion.setTipoImputacion(IMPUTACION_NOAMORTIZABLE);
						posicionesAgregar.add(posicion);
						paramAgregaPos.setItems(posicionesAgregar);
						
						ResultadoEnviaPosicionDTO rWS_AgregaPos = wsMgr.agregaPosicionWS(paramAgregaPos);
						
						LOG.info("    [FIN]. Llamado a WS SAP para agregar posicion. Interfaz 17. Resultado: _" + rWS_AgregaPos.getResultado() + "_");
						
						if(rWS_AgregaPos.getPosicion() != null && rWS_AgregaPos.getResultado())
						{
							//--Verifica si se agrego la posicion correctamente
							if(rWS_AgregaPos.getPosicion().getIDMensaje() != null && rWS_AgregaPos.getPosicion().getIDMensaje().equalsIgnoreCase("OK"))
							{
								//--Actualiza registro de Factura
								LOG.info("    [INI]. Actualiza factura ["+lstIdFactura+"].");
								FacturaDTO facUpdI17 = new FacturaDTO();
								facUpdI17.setFECHA_SAP_I17(HOY_DASH_YMD);
								facUpdI17.setPOSICION(lstPosicionPO);
								facUpdI17.setID_FACTURA(lstIdFactura);
								boolean lboActualizaI17 =  contratoDAO.actualizaFacturaFull(facUpdI17);
								LOG.info("    [FIN]. Actualiza factura ["+lstIdFactura+"]. Resultado: _" +lboActualizaI17+"_");
								
								if(lboActualizaI17)
									lboVerificaI32 = true;
								else
								{
									//--Construye Respuesta
									resultado.setResultado(false);
									resultado.setMensaje("DDA-NF-002: "+ ERROR_PROCESO);
									LOG.info("Respuesta devuelta: " + resultado.toString());
								}
								
							}//Ends if(rWS_AgregaPos.getPosicion().getIDMensaje() != null && rWS_AgregaPos.getPosicion().getIDMensaje().equalsIgnoreCase("OK"))
							else
							{
								//--Construye Respuesta
								resultado.setResultado(false);
								resultado.setMensaje("DDA-NF-001: "+ ERROR_MODIFICACION_SAP);
								LOG.info("Respuesta devuelta: " + resultado.toString());
							}
						}//Ends if(rWS_AgregaPos.getPosicion() != null && rWS_AgregaPos.getResultado())
						else if(rWS_AgregaPos.getTransFault() != null && !rWS_AgregaPos.getResultado())
						{
							//--Tracking
							LOG.error("Error al llamar el WS Agrega Posicion :: notificarFactura: " + rWS_AgregaPos.getTransFault().toString());
							
							//--Construccion de respuesta
							resultado.setResultado(false);
							resultado.setMensaje(rWS_AgregaPos.getTransFault().getInternalCode() + ": " + rWS_AgregaPos.getTransFault().getFaultDescription());
							LOG.info("Respuesta devuelta: " + resultado.toString());
						}
					}//Ends if(lstFechaSapI17.equals(""))
					else
						lboVerificaI32 = true;
					
					
					if(lboVerificaI32)
					{
						//--Verifica fecha SAP I32
						if(lstFechaSapI32.equals(""))
						{
							//--LLamado de WS SAP para Notificar Entrada Mercancia. Interfaz 32
							LOG.info("    [INI]. Llamado a WS SAP para Notificar Entrada de Mercancia. Interfaz 32.");
							ParamEntradaMercanciaDTO paramEntMercancia = new ParamEntradaMercanciaDTO();
							paramEntMercancia.setActividad(ACTIVIDAD);
							paramEntMercancia.setFechaContabilidad(HOY_DOTS_DMY);
							paramEntMercancia.setFechaDocto(HOY_DOTS_DMY);
							paramEntMercancia.setNumeroPO(lstIdSapCnt);
							paramEntMercancia.setTexto("");
							
							List<ItemEntradaMercanciaDTO> registrosEntrada = new ArrayList<ItemEntradaMercanciaDTO>();
							ItemEntradaMercanciaDTO registro = new ItemEntradaMercanciaDTO();
							registro.setCantidad(CANTIDAD_NOAMORTIZABLE);
							registro.setCentro(CENTRO);
							registro.setIndicadorMto(INDICADOR_MOVIMIENTO);
							registro.setMovimiento(MOVIMIENTO);
							registro.setNumeroPO(lstIdSapCnt);
							registro.setPosicionRef(lstPosicionPO);
							registrosEntrada.add(registro);
							paramEntMercancia.setItems(registrosEntrada);
							
							ResultadoEnviaMercanciaDTO rWS_EntMercancia = wsMgr.enviaMercanciaWS(paramEntMercancia);
							
							LOG.info("    [FIN]. Llamado a WS SAP para Notificar Entrada de Mercancia. Interfaz 32. Resultado: _" + rWS_EntMercancia.getResultado() + "_");
							
							if(rWS_EntMercancia.getEnvioMerc() != null && rWS_EntMercancia.getResultado())
							{
								//--Verifica si se registro el envio de entrada de mercancia correctamente
								if(rWS_EntMercancia.getEnvioMerc().getDocMaterial() != null && !rWS_EntMercancia.getEnvioMerc().getDocMaterial().equalsIgnoreCase(""))
								{
									//--Actualiza registro de Factura
									LOG.info("    [INI]. Actualiza factura ["+lstIdFactura+"].");
									FacturaDTO facUpdI32 = new FacturaDTO();
									facUpdI32.setFECHA_SAP_I32(HOY_DASH_YMD);
									facUpdI32.setDOC_MATERIAL(rWS_EntMercancia.getEnvioMerc().getDocMaterial());
									facUpdI32.setID_FACTURA(lstIdFactura);
									boolean lboActualizaI32 =  contratoDAO.actualizaFacturaFull(facUpdI32);
									LOG.info("    [FIN]. Actualiza factura ["+lstIdFactura+"]. Resultado: _" +lboActualizaI32+"_");
									
									if(lboActualizaI32)
										lboObtenerCveISO = true;
									else
									{
										//--Construye Respuesta
										resultado.setResultado(false);
										resultado.setMensaje("DDA-NF-004: "+ ERROR_PROCESO);
										LOG.info("Respuesta devuelta: " + resultado.toString());
									}
									
								}//Ends if(rWS_EntMercancia.getEnvioMerc().getDocMaterial() != null && rWS_EntMercancia.getEnvioMerc().getDocMaterial().equalsIgnoreCase(""))
								else
								{
									//--Construye Respuesta
									resultado.setResultado(false);
									resultado.setMensaje("DDA-NF-003: "+ ERROR_MODIFICACION_SAP);
									LOG.info("Respuesta devuelta: " + resultado.toString());
								}
							}//Ends if(rWS_EntMercancia.getEnvioMerc() != null && rWS_EntMercancia.getResultado())
							else if(rWS_EntMercancia.getTransFault() != null && !rWS_EntMercancia.getResultado())
							{
								//-- Tracking
								LOG.error("Error al llamar el WS Entrega Mercancia :: notificarFactura: " + rWS_EntMercancia.getTransFault().toString());
									
								//--Construccion de respuesta
								resultado.setResultado(false);
								resultado.setMensaje(rWS_EntMercancia.getTransFault().getInternalCode() + ": " + rWS_EntMercancia.getTransFault().getFaultDescription());
								LOG.info("Respuesta devuelta: " + resultado.toString());
							}
						}//Ends if(lstFechaSapI32.equals(""))
						else
							lboObtenerCveISO = true;
						
					}//Ends if(lboVerificaI32)
					
					if(lboObtenerCveISO)
					{
						//--Obtener clave ISO del material a usar
						LOG.info("    [INI]. Consulta codigo ISO Medida para el Id Material["+lstIdMaterial+"].");
						List<MaterialDTO> lobMaterial = contratoDAO.obtenerCodigoISOMedida(lstIdMaterial);
						LOG.info("    [FIN]. Consulta codigo ISO Medida para el Id Material["+lstIdMaterial+"]. Registros obtenidos:_"+lobMaterial.size()+"_");
						
						if(lobMaterial != null && lobMaterial.size() > 0)
						{
							int lnuTotalCodigoISO = lobMaterial.size();
							
							if(lnuTotalCodigoISO == 1)
							{
								String lstCodigoISOMedida = (lobMaterial.get(0).getCODIGO_ISO_MEDIDA() != null && lobMaterial.get(0).getCODIGO_ISO_MEDIDA().trim().length() > 0) ? lobMaterial.get(0).getCODIGO_ISO_MEDIDA() : "";
								
								if(!lstCodigoISOMedida.equals(""))
								{
									//--Verifica fecha SAP I14
									if(lstFechaSapI14.equals(""))
									{
										//--LLamado de WS SAP para Enviar Factura. Interfaz 14
										LOG.info("    [INI]. Llamado a WS SAP para Enviar Factura. Interfaz 14.");
										ParamEnviaFacturaDTO paramEnvFactura = new ParamEnviaFacturaDTO();
										paramEnvFactura.setFechaContabilizacion(HOY_DOTS_DMY);
										paramEnvFactura.setFechaFactura(lstFechaFactura);
										paramEnvFactura.setIndicador(INDICADOR_FACTURA);
										paramEnvFactura.setMoneda(lstMoneda);
										paramEnvFactura.setMonto(lstMontoPagar);
										paramEnvFactura.setReferencia(lstNoFactura);
										paramEnvFactura.setSociedad(SOCIEDAD);
										paramEnvFactura.setTexto(lstComentario);
										paramEnvFactura.setTipoDoc(TIPODOC_FACTURA);
										
										List<ItemEnviaFacturaDTO> itemsFactura = new ArrayList<ItemEnviaFacturaDTO>();
										ItemEnviaFacturaDTO itmFactura = new ItemEnviaFacturaDTO();
										itmFactura.setCantidad(CANTIDAD_NOAMORTIZABLE);
										itmFactura.setImporte(lstMontoPagar);
										itmFactura.setImpuesto(lstIndicadorIVA);
										itmFactura.setIsoMedida(lstCodigoISOMedida);
										itmFactura.setPedido(lstIdSapCnt);
										itmFactura.setPosicion(POS_FACTURA);
										itmFactura.setPosicionPO(lstPosicionPO);
										itemsFactura.add(itmFactura);
										paramEnvFactura.setItems(itemsFactura);
										ResultadoEnviaFacturaDTO  rWS_EnviaFactura = wsMgr.enviarFacturaWS(paramEnvFactura);
										LOG.info("    [FIN]. Llamado a WS SAP para Enviar Factura. Interfaz 14. Resultado: _" + rWS_EnviaFactura.getResultado() + "_");
										
										if(rWS_EnviaFactura.getEnvioFactura() != null && rWS_EnviaFactura.getResultado())
										{
											//--Verifica si se envio la factura correctamente
											if(rWS_EnviaFactura.getEnvioFactura().getFactura() != null && rWS_EnviaFactura.getEnvioFactura().getFactura().trim().length() > 0)
											{
												//-- Actualiza registro de factura
												LOG.info("    [INI]. Actualiza factura ["+lstIdFactura+"].");
												FacturaDTO facUpdI14 = new FacturaDTO();
												facUpdI14.setFECHA_SAP_I14(HOY_DASH_YMD);
												facUpdI14.setFACTURA_I14(rWS_EnviaFactura.getEnvioFactura().getFactura());
												facUpdI14.setID_FACTURA(lstIdFactura);
												boolean lboActualizaI14 =  contratoDAO.actualizaFacturaFull(facUpdI14);
												LOG.info("    [FIN]. Actualiza factura ["+lstIdFactura+"]. Resultado: _" +lboActualizaI14+"_");
												
												if(lboActualizaI14)
												{
													//--Construye respuesta
													resultado.setMensaje("OK");
													resultado.setResultado(true);
													LOG.info("Respuesta devuelta: " + resultado.toString());
												}//Ends if(lboActualizaI14)
												else
												{
													//--Construye Respuesta
													resultado.setResultado(false);
													resultado.setMensaje("DDA-NF-006: "+ ERROR_PROCESO);
													LOG.info("Respuesta devuelta: " + resultado.toString());
												}
												
											}//Ends if(rWS_EnviaFactura.getEnvioFactura().getFactura() != null && rWS_EnviaFactura.getEnvioFactura().getFactura().trim().length() > 0)
											else
											{
												//--Construye Respuesta
												resultado.setResultado(false);
												resultado.setMensaje("DDA-NF-005: "+ ERROR_MODIFICACION_SAP);
												LOG.info("Respuesta devuelta: " + resultado.toString());
											}
										}//Ends if(rWS_EnviaFactura.getEnvioFactura() != null && rWS_EnviaFactura.getResultado())
										else if(rWS_EnviaFactura.getTransFault() != null && !rWS_EnviaFactura.getResultado())
										{
											//--Tracking
											LOG.error("Error al llamar el WS Enviar Factura :: notificarFactura: " + rWS_EnviaFactura.getTransFault().toString());
											
											//--Construccion de respuesta
											resultado.setResultado(false);
											resultado.setMensaje(rWS_EnviaFactura.getTransFault().getInternalCode() + ": " + rWS_EnviaFactura.getTransFault().getFaultDescription());
											LOG.info("Respuesta devuelta: " + resultado.toString());
										}
											
									}//Ends if(lstFechaSapI14.equals(""))
									else
									{
										//--Construye respuesta
										resultado.setMensaje("OK");
										resultado.setResultado(true);
										LOG.info("Respuesta devuelta: " + resultado.toString());
										
									}
								}//Ends if(!lstCodigoISOMedida.equals(""))
								else
								{
									LOG.info("    Codigo ISO obtenido para Id Material["+lstIdMaterial+"] es nulo o vacio.");
									
									//-- Construccion de respuesta
									resultado.setMensaje("NO_OK");
									resultado.setResultado(false);
									LOG.info("Respuesta devuelta: " + resultado.toString());
								}
							}//Ends if(lnuTotalCodigoISO == 1)
							else
							{
								LOG.info("    Multiples registros de codigo ISO para Id Material["+lstIdMaterial+"].");
								
								//-- Construccion de respuesta
								resultado.setMensaje("NO_OK");
								resultado.setResultado(false);
								LOG.info("Respuesta devuelta: " + resultado.toString());
							}
						}//Ends if(lobMaterial != null && lobMaterial.size() > 0)
						else
						{
							LOG.info("    No se pudo obtener el codigo ISO Medida para el Id Material ["+lstIdMaterial+"].");
							
							//-- Construccion de respuesta
							resultado.setMensaje("NO_OK");
							resultado.setResultado(false);
							LOG.info("Respuesta devuelta: " + resultado.toString());
						}
												
					}//Ends if(lboObtenerCveISO)
					
				}//Ends if(lnuTotalRegDatosFactura == 1)
				else
				{
					LOG.info("    Multiples registros de factura ["+dto.getIdFactura()+"].");
					
					//-- Construccion de respuesta
					resultado.setMensaje("NO_OK");
					resultado.setResultado(false);
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
				
			}//Ends if(lobDatosFactura != null && lobDatosFactura.size() > 0)
			else
			{
				LOG.info("    No se pudieron obtener los datos de la factura ["+dto.getIdFactura()+"].");
				
				//-- Construccion de respuesta
				resultado.setMensaje("NO_OK");
				resultado.setResultado(false);
				LOG.info("Respuesta devuelta: " + resultado.toString());
			}
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::notificarFactura]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::notificarFactura] :::::::::::::::: >>");
		return resultado;
	}
	
	
	
	
	public String obtenerDiferenciaMontoContratoVSSAP(String pstMontoContrato, String pstMontoSAP) throws Exception 
	{
		LOG.debug("    - [" + this.getClass().getSimpleName() + "::obtenerDiferenciaMontoContratoVSSAP]");
		LOG.debug("    - Parametros: ");
		LOG.debug("           MontoContrato: " + pstMontoContrato);
		LOG.debug("           MontoReportadoSAP: " + pstMontoSAP);

		String resultado = "0";
		BigDecimal bdResultado = new BigDecimal("0.0");
		String lstMontoContrato = (pstMontoContrato != null && pstMontoContrato.trim().length() > 0) ? pstMontoContrato : "0.0";
		String lstMontoSAP = (pstMontoSAP != null && pstMontoSAP.trim().length() > 0) ? pstMontoSAP : "0.0";

		try 
		{
			BigDecimal lnuMontoContrato = new BigDecimal(lstMontoContrato);
			BigDecimal lnuMontoSAP = new BigDecimal(lstMontoSAP);

			bdResultado = lnuMontoContrato.subtract(lnuMontoSAP);
			bdResultado = bdResultado.setScale(4, BigDecimal.ROUND_HALF_UP);
			resultado = bdResultado.toString();
		} 
		catch (NumberFormatException nf) 
		{
			LOG.info("Ocurrio un error al parsear las cantidades CostoMensual[" + lstMontoContrato + "] y CostoPrevio["+ lstMontoSAP + "]");
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerDiferenciaMontoContratoVSSAP]: "+ nf.getMessage());
			throw new Exception(nf.getMessage());
		} 
		catch (Exception e) 
		{
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerDiferenciaMontoContratoVSSAP]: "+ e.getMessage());
			throw new Exception(e.getMessage());
		}
		return resultado;
	}
	
	/*
	private static java.sql.Date getCurrentDate() 
	{
	    Date hoy = new Date();
	    return hoy.getTime()
	    
		java.util.Date today = new java.util.Date();
	    return new java.sql.Date(today.getTime());
	}
	*/
	
}

