package mx.com.amx.mx.dda.ws.bo;

import java.util.Properties;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.ws.WebServiceException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;

import com.americamovil.dda._1.enviaentradamercancia.DTEntradaMercancia;
import com.americamovil.dda._1.enviaentradamercancia.DTEntradaMercanciaRes;
import com.americamovil.dda._1.enviaposicionpo.DTCreaPosicionPOReq;
import com.americamovil.dda._1.enviaposicionpo.DTModificaPosicionPO;
import com.americamovil.dda._1.enviaposicionpo.DTPosicionPORes;
import com.americamovil.dda._1.enviaposicionpo.DTPosicionPORes.Respuesta;
import com.americamovil.dda._1.f.enviafactura.DTFactura;
import com.americamovil.dda._1.f.enviafactura.DTFacturasRes;
import com.americamovil.dda._1.m.enviatitulo.DTTitulo;
import com.americamovil.dda._1.m.enviapedidocompra.DTPedidoCompra;
import com.americamovil.dda._1.m.enviapedidocompra.DTPedidoCompraRes;
import com.americamovil.dda._1.m.enviapedidocompra.DTPedidoCompraRes.Resultado;

import mx.com.amx.mx.dda.ws.dto.ParamAgregaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ParamEntradaMercanciaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamEnviaFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamEnviaTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ParamModificaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ParamOrdenCompraDTO;
import mx.com.amx.mx.dda.ws.dto.RespSAPEnvFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.RespSAPEnvMercDTO;
import mx.com.amx.mx.dda.ws.dto.RespSAPOrdenCompraDTO;
import mx.com.amx.mx.dda.ws.dto.RespSAPPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoEnviaFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoEnviaMercanciaDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoEnviaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoEnviaTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoModificaPosicionDTO;
import mx.com.amx.mx.dda.ws.dto.ResultadoOrdenCompraDTO;
import mx.com.amx.mx.dda.ws.dto.TransactionFaultDTO;
import mx.com.amx.mx.dda.ws.utils.StringManager;

public class ContratoWSBO 
{		

	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	StringManager strManager = new StringManager();
	
	
	@Autowired
	@Qualifier("wsContratosSAP")
	private WebServiceTemplate wsContratosSAP;
	
	
	private String COMPONENTE;
	private String AMBIENTE;
	private String SERVIDOR;
	private String PUERTO;
	
	private String ERROR_COMUNICACION_SAP;
	private String ERROR_INTERNO_SAP;
	private String ERROR_PROCESO;
	
	
	public WebServiceTemplate getWsContratosSAP() {
		return wsContratosSAP;
	}


	public void setWsContratosSAP(WebServiceTemplate wsContratosSAP) {
		this.wsContratosSAP = wsContratosSAP;
	}


	public ContratoWSBO()
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			AMBIENTE = env.getProperty("ambiente");
			SERVIDOR = env.getProperty(AMBIENTE+".servidor.sap.ws");
			PUERTO = env.getProperty(AMBIENTE+".puerto.sap.ws");
			COMPONENTE = "DDA_WSB_ClienteSAP::" + this.getClass().getSimpleName();
			
			ERROR_COMUNICACION_SAP = env.getProperty("error.comunicacion.sap");
			ERROR_INTERNO_SAP = env.getProperty("error.interno.sap");
			ERROR_PROCESO = env.getProperty("error.proceso");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	
	public ResultadoOrdenCompraDTO crearOrdenCompraWS(ParamOrdenCompraDTO dto) 
	{
		ResultadoOrdenCompraDTO resultado = new ResultadoOrdenCompraDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		RespSAPOrdenCompraDTO oc = resultado.getOrdenCompra();
	
		try
		{
			
			DTPedidoCompra params = new DTPedidoCompra();
			
			//--Encabezado
			DTPedidoCompra.PedidoCompra encabezado = new DTPedidoCompra.PedidoCompra();
			encabezado.setHClaseDoc(dto.getClaseDoc());
			encabezado.setHFechaDoc(dto.getFechaDoc());
			encabezado.setHGrupoCompras(dto.getGrupoCompras());
			encabezado.setHIDProveedor(dto.getIdProveedor());
			encabezado.setHOrgCompras(dto.getOrgCompras());
			encabezado.setHReferencia(dto.getReferencia());
			encabezado.setHSociedad(dto.getSociedad());
			params.setPedidoCompra(encabezado);
			
			//--Detalle
			int lnuTotalItems = dto.getItems().size();
			for(int xItem = 0; xItem < lnuTotalItems; xItem++)
			{
				 DTPedidoCompra.PedidoCompra.Item item = new DTPedidoCompra.PedidoCompra.Item();
				 
				 item.setICantidad(dto.getItems().get(xItem).getCantidad());
				 item.setICentro(dto.getItems().get(xItem).getCentro());
				 item.setICentroCoste(dto.getItems().get(xItem).getCentroCostos());
				 item.setIIDMaterial(dto.getItems().get(xItem).getIdMaterial());
				 item.setIIDOrden(dto.getItems().get(xItem).getIdOrden());
				 item.setIIDPosicion(dto.getItems().get(xItem).getIdPosicion());
				 item.setIIDPosicionAcc(dto.getItems().get(xItem).getIdPosicionAcc());
				 item.setIIndicadorIVA(dto.getItems().get(xItem).getIndicadorIVA());
				 item.setIPrecio(dto.getItems().get(xItem).getPrecio());
				 item.setITipoImputacion(dto.getItems().get(xItem).getTipoImputacion());
				 params.getPedidoCompra().getItem().add(item);
			}

			
			//--Llamado a WS SAP. Interfaz 8,
			DTPedidoCompraRes responseOrdenCompra = new DTPedidoCompraRes();
			LOG.debug ( "    Url Srv. Orden Compra: " + this.getUrlServicio("8") );
			
			//--REAL CODE
			responseOrdenCompra = (DTPedidoCompraRes) wsContratosSAP.marshalSendAndReceive( this.getUrlServicio("8") ,  params );
			
			//--TEST
			//1. 
			//responseOrdenCompra = null;
			
			//2.
			/*
			DTPedidoCompraRes.Resultado resTest = new DTPedidoCompraRes.Resultado();
			resTest.setDescripcion("Orden de compra creada con xito");
			resTest.setIDMensaje("OK");
			resTest.setPONumber("9200000010");
			responseOrdenCompra.setResultado(resTest);
			*/
			
			if( responseOrdenCompra != null && responseOrdenCompra.getResultado() != null)
			{
				DTPedidoCompraRes.Resultado rSAP = responseOrdenCompra.getResultado();
				
				LOG.info(" ");
				LOG.info("    [INI] Detalle respuesta devuelta por SAP [Orden Compra]:");
				LOG.info("        <PONumber:["+rSAP.getPONumber()+"], IDMensaje:["+rSAP.getIDMensaje()+"], Descripcion:["+rSAP.getDescripcion()+"]>");
				LOG.info("    [FIN] Detalle respuesta devuelta por SAP [Orden Compra]:");
				LOG.info(" ");
					
				oc.setPONumber((rSAP.getPONumber() != null && rSAP.getPONumber().length() > 0) ? rSAP.getPONumber() : "");
				oc.setIDMensaje((rSAP.getIDMensaje() != null && rSAP.getIDMensaje().length() > 0) ? rSAP.getIDMensaje() : "");
				oc.setDescripcion((rSAP.getDescripcion() != null && rSAP.getDescripcion().length() > 0) ? rSAP.getDescripcion() : "");
				resultado.setResultado(true);
			}
			else
			{
				tf.setInternalCode("DDA-COC-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("crearOrdenCompraWS");
				resultado.setResultado(false);
			}
			
			return resultado;
			
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-COC-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("crearOrdenCompraWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-COC-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("crearOrdenCompraWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-COC-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("crearOrdenCompraWS");
			resultado.setResultado(false);
			return resultado;
		}
	}
	
	
	public ResultadoEnviaTituloDTO enviarTitulosDDAWS(ParamEnviaTituloDTO dto) 
	{
		ResultadoEnviaTituloDTO resultado = new ResultadoEnviaTituloDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		
		try
		{
			DTTitulo params = new DTTitulo();
			
			//--Recorrido de titulos enviados
			int lnuTotalTitulosEnviar = dto.getTitulos().size();
			
			String lstIdTitulo = "";
			String lstDescripcion = "";
			String lstProveedor = "";
			String lstProgramaID = "";
			String lstFechaInicioExposicion = "";
			
			
			
			for(int xTitulo = 0; xTitulo < lnuTotalTitulosEnviar; xTitulo++)
			{
				lstIdTitulo = (dto.getTitulos().get(xTitulo).getID_TITULO_CNTORIG() != null && dto.getTitulos().get(xTitulo).getID_TITULO_CNTORIG().length() > 0) ? dto.getTitulos().get(xTitulo).getID_TITULO_CNTORIG(): "";
				lstDescripcion = (dto.getTitulos().get(xTitulo).getDESC_TITULO() != null && dto.getTitulos().get(xTitulo).getDESC_TITULO().length() > 0) ? dto.getTitulos().get(xTitulo).getDESC_TITULO(): "";
				lstProveedor = (dto.getTitulos().get(xTitulo).getID_SAP_ESTUDIO() != null && dto.getTitulos().get(xTitulo).getID_SAP_ESTUDIO().length() > 0) ? dto.getTitulos().get(xTitulo).getID_SAP_ESTUDIO(): "";
				lstProgramaID = (dto.getTitulos().get(xTitulo).getID_BV() != null && dto.getTitulos().get(xTitulo).getID_BV().length() > 0) ? dto.getTitulos().get(xTitulo).getID_BV(): "";
				lstFechaInicioExposicion = (dto.getTitulos().get(xTitulo).getFECHA_INICIO() != null && dto.getTitulos().get(xTitulo).getFECHA_INICIO().length() > 0) ? dto.getTitulos().get(xTitulo).getFECHA_INICIO(): "";
				
				
				DTTitulo.Registro titulo = new DTTitulo.Registro();
				titulo.setIDTitulo(lstIdTitulo);
				titulo.setDescripcion(strManager.extraerPrimerosCaracteres(lstDescripcion,75));
				titulo.setProveedor(strManager.extraerPrimerosCaracteres(lstProveedor,10));
				titulo.setProgramaID(strManager.extraerPrimerosCaracteres(lstProgramaID,9));
				titulo.setFechaInicioExposicion(lstFechaInicioExposicion);
				params.getRegistro().add(titulo);
			}//Ends for(int xTitulo = 0; xTitulo < lnuTotalTitulosEnviar; xTitulo++)
			
			//--Llamado al WS de SAP. Interfaz 45
			LOG.debug ( "        Url Srv. Envia Titulo DDA a SAP: " + this.getUrlServicio("45") );

			wsContratosSAP.marshalSendAndReceive( this.getUrlServicio("45") ,  params );
			
			resultado.setResultado(true);
			return resultado;
			
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-ETDDA-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("enviarTitulosDDAWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-ETDDA-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("enviarTitulosDDAWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-ETDDA-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("enviarTitulosDDAWS");
			resultado.setResultado(false);
			return resultado;
		}
	}
	
	
	public ResultadoModificaPosicionDTO modificaPosicionPedidoWS(ParamModificaPosicionDTO dto)
	{
		ResultadoModificaPosicionDTO resultado = new ResultadoModificaPosicionDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		RespSAPPosicionDTO pos = resultado.getPosicion();
		
		try
		{
			LOG.debug("Parametros recibidos: ");
			LOG.debug("		Documento: _" +dto.getDocumento()+"_");
			LOG.debug("		Item: _" +dto.getItems().size()+"_");
			LOG.debug("		Detalle: ");
			LOG.debug("				Cantidad: _"+dto.getItems().get(0).getCantidad()+"_");
			LOG.debug("				Posicion: _"+dto.getItems().get(0).getNoPosicion()+"_");
			
			DTModificaPosicionPO params = new DTModificaPosicionPO();
			
			//--Encabezado
			DTModificaPosicionPO.Registro registro = new DTModificaPosicionPO.Registro();
			registro.setDocumento(dto.getDocumento());
			params.setRegistro(registro);
			
			//--Detalle
			int lnuTotalPosiciones = dto.getItems().size();
			for(int xPosicion = 0; xPosicion < lnuTotalPosiciones; xPosicion++)
			{
				DTModificaPosicionPO.Registro.Posicion posicion = new DTModificaPosicionPO.Registro.Posicion();
				posicion.setCantidad(dto.getItems().get(xPosicion).getCantidad());
				posicion.setNoPosicion(dto.getItems().get(xPosicion).getNoPosicion());
				params.getRegistro().getPosicion().add(posicion);
			}
			
			//--Llamado a WS SAP. Interfaz 23.
			DTPosicionPORes responseModificaPosicion = new DTPosicionPORes();
			LOG.debug ( "    Url Srv. Interfaz 23: " + this.getUrlServicio("23") );
			responseModificaPosicion = (DTPosicionPORes) wsContratosSAP.marshalSendAndReceive(this.getUrlServicio("23"), params);
			
			if(responseModificaPosicion != null && responseModificaPosicion.getRespuesta() != null)
			{
				DTPosicionPORes.Respuesta rSAP = responseModificaPosicion.getRespuesta();
				
				LOG.info(" ");
				LOG.info("    [INI] Detalle respuesta devuelta por SAP [Modifica Posicion]:");
				LOG.info("        <Documento:["+rSAP.getDocumento()+"], IDMensaje:["+rSAP.getIDMensaje()+"], Mensaje:["+rSAP.getMensaje()+"]>");
				LOG.info("    [FIN] Detalle respuesta devuelta por SAP [Modifica Posicion]:");
				LOG.info(" ");
				
				pos.setDocumento((rSAP.getDocumento() != null && rSAP.getDocumento().length() > 0) ? rSAP.getDocumento() : "");
				pos.setIDMensaje((rSAP.getIDMensaje() != null && rSAP.getIDMensaje().length() > 0) ? rSAP.getIDMensaje() : "");
				pos.setMensaje((rSAP.getMensaje() != null && rSAP.getMensaje().length() > 0) ? rSAP.getMensaje() : "");
				resultado.setResultado(true);
			}
			else
			{
				tf.setInternalCode("DDA-MPOS-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("modificaPosicionPedidoWS");
				resultado.setResultado(false);
			}
			
			return resultado;
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-MPOS-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("modificaPosicionPedidoWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-MPOS-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("modificaPosicionPedidoWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-MPOS-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("modificaPosicionPedidoWS");
			resultado.setResultado(false);
			return resultado;
		}
	}
	
	
	public ResultadoEnviaPosicionDTO agregaPosicionWS(ParamAgregaPosicionDTO dto)
	{
		ResultadoEnviaPosicionDTO resultado = new ResultadoEnviaPosicionDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		RespSAPPosicionDTO pos = resultado.getPosicion();
		
		try
		{
			LOG.debug("Parametros recibidos: ");
			LOG.debug("		IdDocumento: _" +dto.getIdDocumento()+"_");
			LOG.debug("		Item: _" +dto.getItems().size()+"_");
			
			DTCreaPosicionPOReq params = new DTCreaPosicionPOReq();
			
			//--Encabezado
			DTCreaPosicionPOReq.PedidoCompra pedidoCompra = new DTCreaPosicionPOReq.PedidoCompra();
			pedidoCompra.setIDDocumento(dto.getIdDocumento());
			params.setPedidoCompra(pedidoCompra);
			
			//--Detalle
			int lnuTotalPosiciones = dto.getItems().size();
			for(int xPosicion = 0; xPosicion < lnuTotalPosiciones; xPosicion++)
			{
				DTCreaPosicionPOReq.PedidoCompra.Item posicion = new DTCreaPosicionPOReq.PedidoCompra.Item();
				posicion.setCantidad(dto.getItems().get(xPosicion).getCantidad());
				posicion.setCentro(dto.getItems().get(xPosicion).getCentro());
				posicion.setCentroCosto(dto.getItems().get(xPosicion).getCentroCosto());
				posicion.setDocumento(dto.getItems().get(xPosicion).getDocumento());
				posicion.setIDMaterial(dto.getItems().get(xPosicion).getIdMaterial());
				posicion.setIndicadorIVA(dto.getItems().get(xPosicion).getIndicadorIVA());
				posicion.setNoPosicionPO(dto.getItems().get(xPosicion).getNoPosicion());
				posicion.setPosicionPO(dto.getItems().get(xPosicion).getPosicionPO());
				posicion.setPrecio(dto.getItems().get(xPosicion).getPrecio());
				posicion.setTipoImputacion(dto.getItems().get(xPosicion).getTipoImputacion());
				params.getPedidoCompra().getItem().add(posicion);
			}
			

			//--Llamado a WS SAP. Interfaz 17.
			DTPosicionPORes responseCreaPosicion = new DTPosicionPORes();
			LOG.debug ( "    Url Srv. Interfaz 17: " + this.getUrlServicio("17") );
			responseCreaPosicion = (DTPosicionPORes) wsContratosSAP.marshalSendAndReceive(this.getUrlServicio("17"), params);
			
			if(responseCreaPosicion != null && responseCreaPosicion.getRespuesta() != null)
			{
				DTPosicionPORes.Respuesta rSAP = responseCreaPosicion.getRespuesta();
				
				LOG.info(" ");
				LOG.info("    [INI] Detalle respuesta devuelta por SAP [Crea Posicion]:");
				LOG.info("        <Documento:["+rSAP.getDocumento()+"], IDMensaje:["+rSAP.getIDMensaje()+"], Mensaje:["+rSAP.getMensaje()+"]>");
				LOG.info("    [FIN] Detalle respuesta devuelta por SAP [Crea Posicion]:");
				LOG.info(" ");
				
				pos.setDocumento((rSAP.getDocumento() != null && rSAP.getDocumento().length() > 0) ? rSAP.getDocumento() : "");
				pos.setIDMensaje((rSAP.getIDMensaje() != null && rSAP.getIDMensaje().length() > 0) ? rSAP.getIDMensaje() : "");
				pos.setMensaje((rSAP.getMensaje() != null && rSAP.getMensaje().length() > 0) ? rSAP.getMensaje() : "");
				resultado.setResultado(true);
			}
			else
			{
				tf.setInternalCode("DDA-APOS-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("agregaPosicionWS");
				resultado.setResultado(false);
			}
			
			return resultado;
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-APOS-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("agregaPosicionWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-APOS-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("agregaPosicionWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-APOS-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("agregaPosicionWS");
			resultado.setResultado(false);
			return resultado;
		}
	}
	
	public ResultadoEnviaMercanciaDTO enviaMercanciaWS(ParamEntradaMercanciaDTO dto)
	{
		ResultadoEnviaMercanciaDTO resultado = new ResultadoEnviaMercanciaDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		RespSAPEnvMercDTO envio = resultado.getEnvioMerc();
		
		try
		{
			LOG.debug("Parametros recibidos: ");
			LOG.debug("		fechaContabilidad: _" +dto.getFechaContabilidad()+"_");
			LOG.debug("		fechaDocto: _" +dto.getFechaDocto()+"_");
			LOG.debug("		numeroPO: _" +dto.getNumeroPO()+"_");
			LOG.debug("		texto: _" +dto.getTexto()+"_");
			LOG.debug("		actividad: _" +dto.getActividad()+"_");
			LOG.debug("		Item: _" +dto.getItems().size()+"_");
			
			DTEntradaMercancia params = new DTEntradaMercancia();
			
			//--Encabezado
			params.setActividad(dto.getActividad());
			params.setFechaContab(dto.getFechaContabilidad());
			params.setFechaDoc(dto.getFechaDocto());
			params.setNumeroPO(dto.getNumeroPO());
			params.setTextoCab(dto.getTexto());
			
			//--Detalle
			int lnuTotalItems = dto.getItems().size();
			for(int xItem=0; xItem < lnuTotalItems; xItem++)
			{
				DTEntradaMercancia.Item item = new DTEntradaMercancia.Item();
				item.setCantidad(dto.getItems().get(xItem).getCantidad());
				item.setCentro(dto.getItems().get(xItem).getCentro());
				item.setClaseMov(dto.getItems().get(xItem).getMovimiento());
				item.setIndicadorMvto(dto.getItems().get(xItem).getIndicadorMto());
				item.setNumeroPO(dto.getItems().get(xItem).getNumeroPO());
				item.setPosicionRefPO(dto.getItems().get(xItem).getPosicionRef());
				params.getItem().add(item);
			}
			
			//--Llamado a WS SAP. Interfaz 32
			DTEntradaMercanciaRes responseEnviaMercancia = new DTEntradaMercanciaRes();
			LOG.debug ( "    Url Srv. Interfaz 32: " + this.getUrlServicio("32") );
			responseEnviaMercancia = (DTEntradaMercanciaRes) wsContratosSAP.marshalSendAndReceive(this.getUrlServicio("32"), params);
			
			if(responseEnviaMercancia != null && responseEnviaMercancia.getRespuesta() != null)
			{
				DTEntradaMercanciaRes.Respuesta rSAP = responseEnviaMercancia.getRespuesta();
				
				LOG.info(" ");
				LOG.info("    [INI] Detalle respuesta devuelta por SAP [Envia Mercancia]:");
				LOG.info("        <DocMaterial:["+rSAP.getDocMaterial()+"], EjerDoc:["+rSAP.getEjercDoc()+"], Mensaje:["+rSAP.getMensaje()+"]>");
				LOG.info("    [FIN] Detalle respuesta devuelta por SAP [Envia Mercancia]:");
				LOG.info(" ");
				
				envio.setDocMaterial((rSAP.getDocMaterial() != null && rSAP.getDocMaterial().length() > 0) ? rSAP.getDocMaterial() : "");
				envio.setEjercDoc((rSAP.getEjercDoc() != null && rSAP.getEjercDoc().length() > 0) ? rSAP.getEjercDoc() : "");
				envio.setMensaje((rSAP.getMensaje() != null && rSAP.getMensaje().length() > 0) ? rSAP.getMensaje() : "");
				resultado.setResultado(true);
			}
			else
			{
				tf.setInternalCode("DDA-EM-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("enviaMercanciaWS");
				resultado.setResultado(false);
			}
			
			return resultado;
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-EM-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("enviaMercanciaWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-EM-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("enviaMercanciaWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-EM-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("enviaMercanciaWS");
			resultado.setResultado(false);
			return resultado;
		}
	}
	
	
	public ResultadoEnviaFacturaDTO enviarFacturaWS(ParamEnviaFacturaDTO dto)
	{
		ResultadoEnviaFacturaDTO resultado = new ResultadoEnviaFacturaDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		RespSAPEnvFacturaDTO envio = resultado.getEnvioFactura();
		
		try
		{
			LOG.debug("Parametros recibidos: ");
			LOG.debug("		sociedad: _" +dto.getSociedad()+"_");
			LOG.debug("		referencia: _" +dto.getReferencia()+"_");
			LOG.debug("		indicador: _" +dto.getIndicador()+"_");
			LOG.debug("		tipoDoc: _" +dto.getTipoDoc()+"_");
			LOG.debug("		fechaContabilizacion: _" +dto.getFechaContabilizacion()+"_");
			LOG.debug("		fechaFactura: _" +dto.getFechaFactura()+"_");
			LOG.debug("		moneda: _" +dto.getMoneda()+"_");
			LOG.debug("		texto: _" +dto.getTexto()+"_");
			LOG.debug("		monto: _" +dto.getMonto()+"_");
			LOG.debug("		Item: _" +dto.getItems().size()+"_");
			
			DTFactura params = new DTFactura();
			
			//--Encabezado
			DTFactura.Factura factura = new DTFactura.Factura();
			factura.setFechaContabilizacion(dto.getFechaContabilizacion());
			factura.setFechaFactura(dto.getFechaFactura());
			factura.setIndicador(dto.getIndicador());
			factura.setMoneda(dto.getMoneda());
			factura.setMonto(dto.getMonto());
			factura.setReferencia(dto.getReferencia());
			factura.setSociedad(dto.getSociedad());
			factura.setTexto(dto.getTexto());
			factura.setTipoDoc(dto.getTipoDoc());
			params.setFactura(factura);
			
			//--Detalle
			int lnuTotalItems = dto.getItems().size();
			for(int xItem=0; xItem < lnuTotalItems; xItem++)
			{
				DTFactura.Factura.Posicion item = new DTFactura.Factura.Posicion();
				item.setCantidad(dto.getItems().get(xItem).getCantidad());
				item.setImporte(dto.getItems().get(xItem).getImporte());
				item.setIndImpuesto(dto.getItems().get(xItem).getImpuesto());
				item.setPedido(dto.getItems().get(xItem).getPedido());
				item.setPosicion(dto.getItems().get(xItem).getPosicion());
				item.setPosicionPO(dto.getItems().get(xItem).getPosicionPO());
				item.setUnMedidaISO(dto.getItems().get(xItem).getIsoMedida());
				params.getFactura().getPosicion().add(item);
			}
			
			//-- Llamado a WS SAP. Interfaz 14
			DTFacturasRes responseEnviaFactura = new DTFacturasRes();
			LOG.debug ( "    Url Interfaz 14: " + this.getUrlServicio("14") );
			responseEnviaFactura = (DTFacturasRes) wsContratosSAP.marshalSendAndReceive(this.getUrlServicio("14"), params);
			
			if(responseEnviaFactura != null && responseEnviaFactura.getRespuesta() != null)
			{
				DTFacturasRes.Respuesta rSAP = responseEnviaFactura.getRespuesta();
				
				LOG.info(" ");
				LOG.info("    [INI] Detalle respuesta devuelta por SAP [Envia Factura]:");
				LOG.info("        <Factura:["+rSAP.getFactura()+"], Status:["+rSAP.getStatus()+"], Mensaje:["+rSAP.getMensaje()+"]>");
				LOG.info("    [FIN] Detalle respuesta devuelta por SAP [Envia Factura]:");
				LOG.info(" ");
				
				envio.setFactura((rSAP.getFactura() != null && rSAP.getFactura().length() > 0) ? rSAP.getFactura() : "");
				envio.setStatus((rSAP.getStatus() != null && rSAP.getStatus().length() > 0) ? rSAP.getStatus() : "");
				envio.setMensaje((rSAP.getMensaje() != null && rSAP.getMensaje().length() > 0) ? rSAP.getMensaje() : "");
				resultado.setResultado(true);
				
			}//Ends if(responseEnviaFactura != null && responseEnviaFactura.getRespuesta() != null)
			else
			{
				tf.setInternalCode("DDA-EF-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("enviarFacturaWS");
				resultado.setResultado(false);
			}
			
			return resultado;
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-EF-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("enviarFacturaWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-EF-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("enviarFacturaWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-EF-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("enviarFacturaWS");
			resultado.setResultado(false);
			return resultado;
		}	
	}
	
	private String getUrlServicio(String pNumInterfaz)
	{
		String urlServicio = env.getProperty(AMBIENTE+".clientws.interface.i"+pNumInterfaz).replaceAll("%servidor%", SERVIDOR).replaceAll("%puerto%", PUERTO);
	    return urlServicio;
	}
}

