package mx.com.amx.mx.dda.ws.dao;

import java.util.List;


import mx.com.amx.mx.dda.ws.dto.ContratoDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoEstatusDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoSAPDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoSAPSubnumDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.ws.dto.DatosFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.FacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ItemActivoFijoDTO;
import mx.com.amx.mx.dda.ws.dto.MaterialDTO;
import mx.com.amx.mx.dda.ws.dto.QryMontosAnualesCntDTO;
import mx.com.amx.mx.dda.ws.dto.TitulosAsocContratoDTO;

public interface IContratoDAO 
{
	public boolean registraBitacoraEstatus(ContratoEstatusDTO dto) throws Exception;
	public int cuantosTitulosNoIDSAP(String pstIdContrato) throws Exception;
	public List<ItemActivoFijoDTO> obtenerTitulosContratoNoIDSAP(String pstIdContrato) throws Exception;
	public String obtenerIDSAPContrato(String pstIdContrato) throws Exception; 
	public boolean actualizaContratoTituloFull(ContratoTituloDTO dto) throws Exception;
	public boolean actualizaContratoFull(ContratoDTO dto) throws Exception;
	public String obtenerFechaModifSAPContrato(String pstIdContrato) throws Exception;
	public String obtenerUltimoCntVigenteRelacionado(String pstIdContratoAdendumEnmienda) throws Exception;
	public List<TitulosAsocContratoDTO> obtenerTitulosAsociadosContrato(String pstIdContrato) throws Exception;
	public String obtenerFechaAutorizacion(String pstIdContrato) throws Exception;
	public boolean actualizaCntSAPSubnumFull(ContratoSAPSubnumDTO dto, String pstIdSAP, String pstSubnum) throws Exception;
	public String obtenerMontoContrato(String pstIdContrato) throws Exception;
	public String obtenerMontoReportadoSAP(String pstIdContrato, String posicionExcluir) throws Exception;
	public String obtenerPosicionAumento(String pstIdContrato) throws Exception;
	public boolean insertarRegistroPosicion(ContratoSAPDTO dto) throws Exception;
	public boolean insertarRegistroPosicionAnnio(ContratoSAPDTO dto) throws Exception;
	public boolean actualizaRegistroPosicion(ContratoSAPDTO dto) throws Exception;
	public boolean ejecutarSPDDA_CrnClienteSAP(String pstIdContrato) throws Exception;
	public List<TitulosAsocContratoDTO> obtenerTitulosTransaccionalesAsociadosContrato(String pstIdContrato) throws Exception;
	public List<DatosFacturaDTO> obtenerDatosFactura(String pstIdFactura) throws Exception;
	public boolean actualizaFacturaFull(FacturaDTO dto) throws Exception;
	public List<MaterialDTO> obtenerCodigoISOMedida(String pstIdMaterial) throws Exception;
	public String obtenerIndicadorIVACnt(String pstIdContrato) throws Exception;
	public String obtenerUltimaPosicionRegSinDocMaterial(String pstIdContrato) throws Exception;
	public List<QryMontosAnualesCntDTO> obtenerMontosAnualesPorContrato(String pstIdContrato) throws Exception;
	public List<ContratoSAPDTO> obtenerMontoAnualReportadoSAP(String pstIdContrato, String pstAnnio)  throws Exception;
	
}
