package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlElement;

/**
 * Representa en el ambito de DDA la respuesta obtenida por SAP respecto del Envio de Factura a SAP
 * Los nombres estan tomados del Excel de inventario de Interfaces. 
 */
public class RespSAPEnvFacturaDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String Factura;
	private String Status;
	private String Mensaje;
	
	public String getFactura() {
		return Factura;
	}

	public void setFactura(String factura) {
		Factura = factura;
	}

	public String getStatus() {
		return Status;
	}

	public void setStatus(String status) {
		Status = status;
	}

	public String getMensaje() {
		return Mensaje;
	}

	public void setMensaje(String mensaje) {
		Mensaje = mensaje;
	}

	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" Factura: _" + this.getFactura() + "_" + NEW_LINE);
		result.append(" Status: _" + this.getStatus() + "_" + NEW_LINE);
		result.append(" Mensaje: _" + this.getMensaje() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
}
