package mx.com.amx.mx.dda.ws.service;

import java.io.PrintWriter; 
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import mx.com.amx.mx.dda.ws.bo.ContratoBO;
import mx.com.amx.mx.dda.ws.dto.ParamAdendumEnmiendaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamInventarioTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ParamNotificaFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamOrdenCompraDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseAdendumEnmiendaDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseNotificarFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseNotificarInventarioTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseOrdenCompraDTO;

@Controller
@RequestMapping("contrato")
public class ContratoService
{
	protected final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	private String ERROR_PROCESO;
	
	
	@Autowired
	private ContratoBO contratoBO;
	
	public ContratoService()
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			ERROR_PROCESO = env.getProperty("error.proceso");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	/* --------------------------------------------------------------------------------- Methods */
	@RequestMapping( value = "/registrarSAPSuscripcion" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseOrdenCompraDTO registrarSAPSuscripcion(@RequestHeader HttpHeaders headers, @RequestBody ParamOrdenCompraDTO dto)
	{
		ResponseOrdenCompraDTO resultado = new ResponseOrdenCompraDTO();
		try
		{
			resultado = contratoBO.registrarSAPSuscripcion(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso registrar SAP Suscripcion (crear orden de Compra): " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-RSS-003: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
	@RequestMapping( value = "/registrarSAPEnmiendaSuscripcion" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseAdendumEnmiendaDTO registrarSAPEnmiendaSuscripcion(@RequestHeader HttpHeaders headers, @RequestBody ParamAdendumEnmiendaDTO dto)
	{
		
		ResponseAdendumEnmiendaDTO resultado = new ResponseAdendumEnmiendaDTO();
		try
		{
			resultado = contratoBO.registrarSAPEnmiendaSuscripcion(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de registrar SAP Enmienda Suscripcion (crear Adendum/Enmienda): " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-RSES-005: "+ ERROR_PROCESO);
			return resultado;
		}
	}
	
	
	
	@RequestMapping( value = "/registrarSAPLicenseFee" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseOrdenCompraDTO registrarSAPLicenseFee(@RequestHeader HttpHeaders headers, @RequestBody ParamOrdenCompraDTO dto)
	{
		
		ResponseOrdenCompraDTO resultado = new ResponseOrdenCompraDTO();
		try
		{
			resultado = contratoBO.registrarSAPLicenseFee(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso registrar SAP License Fee(registro SAP No Amortizable): " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-RSLF-006: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
	@RequestMapping( value = "/registrarSAPEnmiendaLicenseFee" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseAdendumEnmiendaDTO registrarSAPEnmiendaLicenseFee(@RequestHeader HttpHeaders headers, @RequestBody ParamAdendumEnmiendaDTO dto)
	{
		
		ResponseAdendumEnmiendaDTO resultado = new ResponseAdendumEnmiendaDTO();
		try
		{
			resultado = contratoBO.registrarSAPEnmiendaLicenseFee(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso registrar SAP Enmienda License Fee (Adendum/Enmienda No Amortizable): " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-RSELF-005: "+ ERROR_PROCESO);
			return resultado;
		}
	}
	
	
	@RequestMapping( value = "/registrarSAPEnmiendaTransaccional" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseAdendumEnmiendaDTO registrarSAPEnmiendaTransaccional(@RequestHeader HttpHeaders headers, @RequestBody ParamAdendumEnmiendaDTO dto)
	{
		
		ResponseAdendumEnmiendaDTO resultado = new ResponseAdendumEnmiendaDTO();
		try
		{
			resultado = contratoBO.registrarSAPEnmiendaTransaccional(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso registrar SAP Enmienda Transaccional: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-RSETR-005: "+ ERROR_PROCESO);
			return resultado;
		}
	}
	
	
	@RequestMapping( value = "/notificarInventarioTitulos" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseNotificarInventarioTitulosDTO notificarInventarioTitulos(@RequestHeader HttpHeaders headers, @RequestBody ParamInventarioTitulosDTO dto)
	{
		
		ResponseNotificarInventarioTitulosDTO resultado = new ResponseNotificarInventarioTitulosDTO();
		try
		{
			resultado = contratoBO.notificarInventarioTitulos(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al hacer la notificacion de Inventario de Titulos: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-NIT-004: "+ ERROR_PROCESO);
			return resultado;
		}
	}
	
	@RequestMapping( value = "/registrarSAPTransaccional" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseOrdenCompraDTO registrarSAPTransaccional(@RequestHeader HttpHeaders headers, @RequestBody ParamOrdenCompraDTO dto)
	{
		
		ResponseOrdenCompraDTO resultado = new ResponseOrdenCompraDTO();
		try
		{
			resultado = contratoBO.registrarSAPTransaccional(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso registrar SAP Transaccional: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-RST-005: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
	@RequestMapping( value = "/notificarFactura" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseNotificarFacturaDTO notificarFactura(@RequestHeader HttpHeaders headers, @RequestBody ParamNotificaFacturaDTO dto)
	{
		
		ResponseNotificarFacturaDTO resultado = new ResponseNotificarFacturaDTO();
		try
		{
			resultado = contratoBO.notificarFactura(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de notificar Factura: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-NF-007: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
}
