package mx.com.amx.mx.dda.crn.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Representa el manejo interno de este cliente WS que se le dara al llamado del WS a SAP para Baja-[Con/Sin]Perdida del Activo Fijo (Titulo)
 * considerando los posibles escenarios de exito y error.
 * Si el objeto TransactionFaultDTO tiene valores, entonces ocurrio alguna excepcion en el llamado.
 * Si el objeto Status tiene valores entonces todo ocurrio correctamente.
 * En resumen, ambos objetos deben ser mutuamente excluyentes, indicando el exito o el error segun haya sucedido. 
 */
public class ResultadoBajaPerdidaAFijoDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private List<RespSAPBajaPerdidaAFijoDTO> activosFijos = new ArrayList<RespSAPBajaPerdidaAFijoDTO>();
	private TransactionFaultDTO transFault = new TransactionFaultDTO();
	private boolean resultado;
	
	public TransactionFaultDTO getTransFault() {
		return transFault;
	}
	public void setTransFault(TransactionFaultDTO transFault) {
		this.transFault = transFault;
	}
	public boolean getResultado() {
		return resultado;
	}
	public void setResultado(boolean resultado) {
		this.resultado = resultado;
	}
	public List<RespSAPBajaPerdidaAFijoDTO> getActivosFijos() {
		return activosFijos;
	}
	public void setActivosFijos(List<RespSAPBajaPerdidaAFijoDTO> activosFijos) {
		this.activosFijos = activosFijos;
	}
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" tFault: _" + this.getTransFault().toString() + "_" + NEW_LINE);
		result.append(" resultado: _" + this.getResultado() + "_" + NEW_LINE);
		result.append(" activosFijos: _" + this.getActivosFijos().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
}
