package mx.com.amx.mx.dda.crn;

import java.util.List;
import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import mx.com.amx.mx.dda.crn.bo.DDAClienteSAPBO;
import mx.com.amx.mx.dda.crn.dto.ResponseEjecucionDTO;

import org.apache.log4j.Logger;


public class DDAClienteSAP implements ApplicationContextAware
{
	private ApplicationContext context;
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	Properties env 	= 	new Properties();
	private DDAClienteSAPBO bo;
	
	public DDAClienteSAPBO getBo() {
		return bo;
	}

	public void setBo(DDAClienteSAPBO bo) {
		this.bo = bo;
	}
	
	public DDAClienteSAP()
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	public void ejecutaProceso()
	{
		
		LOG.info("  ");
		LOG.info("<< :::::::::::::::: Inicia CRN Cliente SAP :::::::::::::::: >>");
		try
		{
			
			//-- 1. Verifica que no se este ejecutando ya un proceso de Notificacion
			LOG.info("    [INI]. Paso 1.- Verifica bandera de ejecucion de proceso CRN Cliente SAP.");
			boolean boEjecutandoseProceso = bo.existeProcesoNotificacionEjecutandose();
			LOG.info("    [INI]. Paso 1.- Verifica bandera de ejecucion de proceso CRN Cliente SAP. Esta ejecutando?: _" + boEjecutandoseProceso+"_");
			if(!boEjecutandoseProceso)
			{
				//-- 2. Verificar si se puede iniciar el proceso
				LOG.info("    [INI]. Paso 2.- Verifica si se puede iniciar el proceso CRN Cliente SAP.");
				boolean boIniciar = bo.verificaPuedeIniciar();
				LOG.info("    [FIN]. Paso 2.- Verifica si se puede iniciar el proceso CRN Cliente SAP. Resultado: _" + boIniciar+"_");
				
				if(boIniciar)
				{
					//-- 3. Actualiza bandera indicando que inicia el proceso general de Notificacion
					LOG.info("    [INI]. Paso 3.- Prendiendo Bandera Inicio Proceso CRN Cliente SAP.");
					boolean boActualizarBanderaIniciaProceso = bo.actualizarEjecutandoProcesoNotificacion("1"); 
					LOG.info("    [FIN]. Paso 3.- Prendiendo Bandera Inicio Proceso CRN Cliente SAP. Resultado: _"+boActualizarBanderaIniciaProceso+"_");
					
					if(boActualizarBanderaIniciaProceso)
					{
                                                /*
						//--4. Llamado a Interfaz 27. Baja Titulos (Activos Fijos). Cambio Titulo A por Titulo B, pero con diferente costo.
						//--   I27: Da de baja el titulo A.
						LOG.info("    [INI]. Paso 4.- Ejecutando Traslado de Titulo con diferente valor (I27).");
						ResponseEjecucionDTO lobResTraslado_DV = bo.ejecutarCambiaTituloDiferenteValor();
						LOG.info("    [FIN]. Paso 4.- Ejecutando Traslado de Titulo con diferente valor (I27). Respuesta: <Mensaje:["+lobResTraslado_DV.getMensaje()+"],Resultado:["+lobResTraslado_DV.getResultado()+"]>");
						
						//--5. Llamado a Interfaz 25, opcionalmente 29. Traslado de Titulos. Se cambia titulo A por Titulo B pero tiene el mismo costo.
						//--(Para este caso, ya se haba notificado a SAP que el titulo haba comenzado a exhibirse)
						LOG.info("    [INI]. Paso 5.- Ejecutando Traslado de Titulo con mismo valor (I25).");
						ResponseEjecucionDTO lobResultadoTraslado_MV = bo.ejecutarCambiaTituloMismoValor();
						LOG.info("    [FIN]. Paso 5.- Ejecutando Traslado de Titulo con mismo valor (I25).Respuesta: <Mensaje:["+lobResultadoTraslado_MV.getMensaje()+"],Resultado:["+lobResultadoTraslado_MV.getResultado()+"]>");
						
						//--6. Llamado a Interfaz 31. Baja de Titulos SIN perdida. Lo ya pagado por el titulo(en caso de haberlo hecho, se toma como credito a favor por parte del estudio)
						LOG.info("    [INI]. Paso 6.- Ejecutando Baja de Titulo SIN perdida (I31).");
						ResponseEjecucionDTO lobResultadoBajaTitulos_SP = bo.ejecutarBajaTitulosSinPerdida();
						LOG.info("    [FIN]. Paso 6.- Ejecutando Baja de Titulo SIN perdida (I31). Respuesta: <Mensaje:["+lobResultadoBajaTitulos_SP.getMensaje()+"],Resultado:["+lobResultadoBajaTitulos_SP.getResultado()+"]>");
						
						//--7. Llamado a Interfaz 30. Baja de Titulos CON perdida. 
						LOG.info("    [INI]. Paso 7.- Ejecutando Baja de Titulo CON perdida (I30).");
						ResponseEjecucionDTO lobResultadoBajaTitulos_CP = bo.ejecutarBajaTitulosConPerdida();
						LOG.info("    [FIN]. Paso 7.- Ejecutando Baja de Titulo CON perdida (I30). Respuesta: <Mensaje:["+lobResultadoBajaTitulos_CP.getMensaje()+"],Resultado:["+lobResultadoBajaTitulos_CP.getResultado()+"]>");
						
						//--8. Llamado a Interfaz 19, opcionalmente 29.  Aumento de precio (Postcapitalizacion de activo fijo)
						LOG.info("    [INI]. Paso 8.- Ejecutando Aumento de Precio (Postcapitalizacion) (I19).");
						ResponseEjecucionDTO lobResultadoAumentoPrecio = bo.ejecutarAumentoPrecio();
						LOG.info("    [FIN]. Paso 8.- Ejecutando Aumento de Precio (Postcapitalizacion) (I19). Respuesta: <Mensaje:["+lobResultadoAumentoPrecio.getMensaje()+"],Resultado:["+lobResultadoAumentoPrecio.getResultado()+"]>");
						*/
						//--9. Llamado a Interfaz 51. Disminucion de valor de Activo Fijo
						LOG.info("    [INI]. Paso 9.- Ejecutando Disminucion de valor Activo Fijo (I51).");
						ResponseEjecucionDTO lobResultadoDisminucionPrecio = bo.ejecutarDisminucionPrecio();
						LOG.info("    [FIN]. Paso 9.- Ejecutando Disminucion de valor Activo Fijo (I51). Respuesta: <Mensaje:["+lobResultadoDisminucionPrecio.getMensaje()+"],Resultado:["+lobResultadoDisminucionPrecio.getResultado()+"]>");
						/*
						//--10. Llamado a Interfaz 20. Actualizar datos generales de Activo Fijo (Titulo)
						LOG.info("    [INI]. Paso 10.- Ejecutando Actualizacion de datos generales Activo Fijo (I20).");
						ResponseEjecucionDTO lobResultadoModificaAF = bo.ejecutarModificarTitulo();
						LOG.info("    [FIN]. Paso 10.- Ejecutando Actualizacion de datos generales Activo Fijo (I20). Respuesta: <Mensaje:["+lobResultadoModificaAF.getMensaje()+"],Resultado:["+lobResultadoModificaAF.getResultado()+"]>");
						
						//--11. Llamado a Interfaz 29. Ajuste de Vida Util.
						LOG.info("    [INI]. Paso 11.- Ejecutando Ajuste de vida util (I29).");
						ResponseEjecucionDTO lobResultadoAjusteVU = bo.ejecutarAjusteVidaUtil();
						LOG.info("    [FIN]. Paso 11.- Ejecutando Ajuste de vida util (I29). Respuesta: <Mensaje:["+lobResultadoAjusteVU.getMensaje()+"],Resultado:["+lobResultadoAjusteVU.getResultado()+"]>");
						
						//-- 12. Sos 22Ago17 Generacin de la amortizacin real de los titulos
						LOG.info("    [INI]. Paso 9.- Llamado a SP Amortizacion  Real.");
						boolean lboResultadoSP = bo.ejecutarSPAmortizacionAjustada();
						LOG.info("    [FIN]. Paso 9.- Llamado a SP Amortizacion  Real. Resultado:_"+lboResultadoSP+"_");*/
						//--Apagar bandera de 
						bo.actualizarEjecutandoProcesoNotificacion("0");
						LOG.info("Apaga bandera de proceso CRN Cliente SAP.[Caso Ejecucion total de pasos.]");
					}//Ends if(boActualizarBanderaIniciaProceso)
					else
					{
						LOG.error("DDA-CRNSAP-003: No se pudo actualizar la bandera de inicio de proceso.");
						
						bo.actualizarEjecutandoProcesoNotificacion("0");
						LOG.info("Apaga bandera de proceso CRN Cliente SAP.[Else_boActualizarBanderaIniciaProceso]");
						
					}
				}//Ends if(boIniciar)
				else
				{
					LOG.error("DDA-CRNSAP-002: No se han otorgado los permisos para poder iniciar el proceso.");
				}
			}//Ends if(!boEjecutandoseProceso)
			else
			{
				LOG.error("DDA-CRNSAP-001: Es probable que se haya iniciado este proceso previamente.");
			}

		}
		catch (Exception e)
		{
			LOG.error("Ocurrio un error en ejecutaProceso[DDAClienteSAP]: " + e.getMessage());
		}
		
		LOG.info("<< :::::::::::::::: Finaliza CRN Cliente SAP :::::::::::::::: >>");
		LOG.info("  ");
	}
	
	
	
	@Override
	public void setApplicationContext(ApplicationContext arg0) 	throws BeansException 
	{
		LOG.info("Entering to the application Context...");
		this.context = context;
	}

	
	

}


