package mx.com.amx.mx.dda.crn.bo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;



import org.apache.log4j.Logger;

import mx.com.amx.mx.dda.crn.dao.DDAClienteSAPDAO;
import mx.com.amx.mx.dda.crn.dto.ContratoSAPSubnumDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.crn.dto.CrnClienteSAPDTO;
import mx.com.amx.mx.dda.crn.dto.ItemAumentoCostoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemBajaActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemCambioNombreActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemDisminucionCostoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemTrasladoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemVidaUtilAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamAumentoCostoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamBajaActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamCambiaNombreAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamCambiaVUAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamDisminucionCostoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamTrasladoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParametroDTO;
import mx.com.amx.mx.dda.crn.dto.ResponseEjecucionDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoBajaPerdidaAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaCostoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaNombreAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaVUAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoEnviaTituloPorValorDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoTrasladoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.TerminosComercialesDTO;
import mx.com.amx.mx.dda.crn.dto.VidaUtilDTO;
import mx.com.amx.mx.dda.crn.utils.DateManager;



public class DDAClienteSAPBO 
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	DateManager dateManager = new DateManager();
	private DDAClienteSAPDAO dao;
	private DDACteSAPWSBO wsMgr;
	
	private String AMBIENTE;
	private String HOY;
	private String SUBNUMERO;
	private String HOY_FMTSAP;
	private String HOY_DIAG_DMY;
	
	public DDAClienteSAPDAO getDao() {
		return dao;
	}

	public void setDao(DDAClienteSAPDAO dao) {
		this.dao = dao;
	}
	
	public DDACteSAPWSBO getWsMgr() {
		return wsMgr;
	}

	public void setWsMgr(DDACteSAPWSBO wsMgr) {
		this.wsMgr = wsMgr;
	}

	public DDAClienteSAPBO() 
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			AMBIENTE = env.getProperty("ambiente");
			SUBNUMERO = env.getProperty("subnumero");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	public boolean existeProcesoNotificacionEjecutandose() throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::existeProcesoNotificacionEjecutandose]");
		boolean resultado = false;
		try
		{
			resultado = dao.verificaEjecutandoseProcesoNotificacion();
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::existeProcesoNotificacionEjecutandose]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public boolean verificaPuedeIniciar() throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::verificaPuedeIniciar]");
		
		boolean resultado = false;
		try
		{
			resultado = dao.puedeIniciarProcesoNotificacion();
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::verificaPuedeIniciar]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public boolean actualizarEjecutandoProcesoNotificacion(String pstValor) throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::actualizarEjecutandoProcesoNotificacion]");
		LOG.debug("    - Parametros: _" + pstValor+"_");
		
		boolean resultado = false;
		try
		{
			resultado = dao.updateEjecutandoseProcesoNotificacion(pstValor);
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizarEjecutandoProcesoNotificacion]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public ResponseEjecucionDTO ejecutarCambiaTituloDiferenteValor() throws Exception
	{
		ResponseEjecucionDTO resultado = new ResponseEjecucionDTO();
		int lnuErrores = 0;
		
		HOY = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_FMTSAP = dateManager.getFechaActual("yyyymmdd");
		HOY_DIAG_DMY = dateManager.getFechaActual("dd/mm/yyyy");
		
		try
		{
			//--Consulta de los registros marcados para Traslado de Titulos con cambio de Valor.
			//--candidatos a enviar a la interfaz 27.
			List<CrnClienteSAPDTO> lobTitulosAjusteTitulo = dao.obtenerRegistrosCandidatos("27");
			LOG.info("        [INI/FIN] Obtener registros candidatos I27. Encontrados:_"+lobTitulosAjusteTitulo.size()+"_");
			
			
			if(lobTitulosAjusteTitulo != null && lobTitulosAjusteTitulo.size() > 0)
			{
				int lnuTotalTitulosAjusteTitulo = lobTitulosAjusteTitulo.size();
				
				LOG.info(" ");
				LOG.info("        [INI] Procesamiento de ["+lnuTotalTitulosAjusteTitulo+"] Titulos marcados como candidatos para Traslado con cambio de valor.");
				for(int xTraslado=0; xTraslado < lnuTotalTitulosAjusteTitulo; xTraslado++)
				{
					CrnClienteSAPDTO crnCteSAP = new CrnClienteSAPDTO();
					CrnClienteSAPDTO lobTituloAjuste = (CrnClienteSAPDTO)lobTitulosAjusteTitulo.get(xTraslado);
					
					//-- Por cuestiones de logica de negocio, se envia SIEMPRE la fecha actual como la fecha de contabilizacion. Cualquier cambio de ubicacion de proceso, o de orden o condiciones
					//-- de ejecucion, tendrn que derivar en un analisis a fin de determinar nuevamente el valor correcto a enviar en la fecha de contabilizacion
					String lstIdCrn = (lobTituloAjuste.getID_CRN() != null && lobTituloAjuste.getID_CRN().trim().length() > 0) ? lobTituloAjuste.getID_CRN() : "";
					String lstIdTituloCntOrig = (lobTituloAjuste.getID_TITULO_CNTORIG() != null && lobTituloAjuste.getID_TITULO_CNTORIG().trim().length() > 0) ? lobTituloAjuste.getID_TITULO_CNTORIG() : ""; 
					String lstCodigoSAPAnt = (lobTituloAjuste.getCODIGO_SAPANT() != null && lobTituloAjuste.getCODIGO_SAPANT().trim().length() > 0) ? lobTituloAjuste.getCODIGO_SAPANT() : "";
					String lstFechaContabilizacionBD = (lobTituloAjuste.getFECHA_CONTABILIZACION() != null && lobTituloAjuste.getFECHA_CONTABILIZACION().trim().length() > 0) ? lobTituloAjuste.getFECHA_CONTABILIZACION() : "";
					String lstFechaContabilizacion =  HOY_FMTSAP;
					LOG.info("   ");
					LOG.info("            <Registro: ["+xTraslado+"], IdCrn:["+lstIdCrn+"], IdTitCntOriginal:["+lstIdTituloCntOrig+"], CodSAPAnt:["+lstCodigoSAPAnt+"], FechaContabilizacion:["+lstFechaContabilizacion+"], FechaContabilizacionBD:["+lstFechaContabilizacionBD+"]>");
					
					//--Cambia Titulo por Valor. (Elimina Titulo anterior)
					LOG.info("                [INI]. Llamado a WS SAP para Envio de Titulo por Valor. Interfaz 27.");
					ParamBajaActivoFijoDTO paramsBaja = new ParamBajaActivoFijoDTO();
					List<ItemBajaActivoFijoDTO> itemsBaja = new ArrayList<ItemBajaActivoFijoDTO>();
					
					ItemBajaActivoFijoDTO lobItmBaja = new ItemBajaActivoFijoDTO();
					lobItmBaja.setCodigoSAPAnterior(lstCodigoSAPAnt);
					lobItmBaja.setFechaContabilizacion(lstFechaContabilizacion);
					lobItmBaja.setFechaInicio(lstFechaContabilizacion);
					
					itemsBaja.add(lobItmBaja);
					paramsBaja.setTitulos(itemsBaja);
					ResultadoEnviaTituloPorValorDTO  rWS_TitPorValor = wsMgr.enviaTituloPorValorWS(paramsBaja);
					LOG.info("                [FIN]. Llamado a WS SAP para Envio de Titulo por Valor. Interfaz 27. Ejecuto?: _" + rWS_TitPorValor.getResultado() + "_");
					
					//--Verifica resultado real proporcionado por SAP
					if(rWS_TitPorValor.getActivosFijos() != null && rWS_TitPorValor.getActivosFijos().size() > 0 && rWS_TitPorValor.getResultado())
					{
						
						if(rWS_TitPorValor.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						{
							//--Actualizar en tabla CRN
							LOG.info("                [INI]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente .");
							crnCteSAP.setR_STATUS(rWS_TitPorValor.getActivosFijos().get(0).getStatus());
							crnCteSAP.setR_CODIGO_SAP(rWS_TitPorValor.getActivosFijos().get(0).getCodigoSAP());
							crnCteSAP.setFECHA_ENVIO_OK(HOY);
							crnCteSAP.setID_CRN(lstIdCrn);
							boolean lboActualizoCrnCteSAP = dao.actualizaCrnClienteSAP(crnCteSAP);
							LOG.info("                [FIN]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente. Resultado:_"+lboActualizoCrnCteSAP+"_");
							
							if(lboActualizoCrnCteSAP)
							{
								
								//--Actualiza Titulo.
								LOG.info("            [INI]. Actualiza datos varios de Titulo ["+lstIdTituloCntOrig+"].");
								ContratoTituloDTO cntTitulo = new ContratoTituloDTO();
								cntTitulo.setID_SAP("null");
								cntTitulo.setFECHA_NOTIFSAP("null");
								cntTitulo.setFECHA_AJUSTOTITULO(HOY);
								cntTitulo.setFECHA_AJUSTOVALOR(HOY);
								cntTitulo.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
								boolean lboActTitulo = dao.actualizaContratoTituloFull(cntTitulo);
								LOG.info("             [FIN]. Actualiza datos varios de Titulo ["+lstIdTituloCntOrig+"]. Resultado:_"+lboActTitulo+"_");
								
								if(!lboActTitulo)
									lnuErrores++;
								 
							}//Ends if(lboActualizoCrnCteSAP)
							else
								lnuErrores++;
							 
						}//Ends if(rWS_TitPorValor.getStatus().equalsIgnoreCase("OK"))
						else
						{
							LOG.error("            No se proceso correctamente el Envio de Titulo por Valor en SAP, del registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
						}
						
					}// Ends if(rWS_TitPorValor.getStatus() != null && rWS_TitPorValor.getStatus().trim().length() > 0 && rWS_TitPorValor.getResultado())
					else if(rWS_TitPorValor.getTransFault() != null && !rWS_TitPorValor.getResultado())
					{
						//-- Tracking
						LOG.error("                Error al llamar el WS Envio de Titulo por Valor :: ejecutarCambiaTituloDiferenteValor: " + rWS_TitPorValor.getTransFault().toString());
						lnuErrores++;
						
						//--Actualizar en tabla CRN
						crnCteSAP.setID_CRN(lstIdCrn);
						dao.actualizaCrnClienteSAP(crnCteSAP);
						
					}
					
				}//Ends for(int xTraslado=0; xTraslado < lnuTotalTitulosAjusteTitulo; xTraslado++)
				LOG.info("        [FIN] Procesamiento de ["+lnuTotalTitulosAjusteTitulo+"] Titulos marcados como candidatos para Traslado con cambio de valor");
				
				
			}//Ends if(lobTitulosAjusteTitulo != null && lobTitulosAjusteTitulo.size() > 0)
			else
			{
				//--No hay nada que procesar o notificar a SAP
				LOG.info("No se encontraron Titulos marcados como candidatos para Traslado con cambio de valor.");
			}
			
			//--Determina resultado final de proceso total de registros Traslado con cambio de Valor.
			if(lnuErrores == 0)
			{
				resultado.setMensaje("OK");
				resultado.setResultado(true);
			}
			else
			{
				resultado.setMensaje("Ocurrio error con algun(os) de los titulos enviados");
				resultado.setResultado(false);
			}
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarCambiaTituloCambioValor]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public ResponseEjecucionDTO ejecutarCambiaTituloMismoValor() throws Exception
	{
		ResponseEjecucionDTO resultado = new ResponseEjecucionDTO();
		int lnuErrores = 0;
		
		HOY = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_FMTSAP = dateManager.getFechaActual("yyyymmdd");
		HOY_DIAG_DMY = dateManager.getFechaActual("dd/mm/yyyy");
		
		try
		{
			//--Consulta de los registros marcados para Traslado de Titulos con mismo valor.
			//--candidatos a enviar a la interfaz 25.
			List<CrnClienteSAPDTO> lobTitulosTraslado = dao.obtenerRegistrosCandidatos("25");
			LOG.info("        [INI/FIN] Obtener registros candidatos I25. Encontrados:_"+lobTitulosTraslado.size()+"_");
			
			if(lobTitulosTraslado != null && lobTitulosTraslado.size() > 0)
			{
				int xTraslado = 1;
				
				LOG.info(" ");
				LOG.info("        [INI] Procesamiento de ["+lobTitulosTraslado.size()+"] Titulos marcados como candidatos para Traslado con mismo valor.");
				for(CrnClienteSAPDTO lobTituloTraslado : lobTitulosTraslado)
				{
					CrnClienteSAPDTO crnCteSAP = new CrnClienteSAPDTO();
					//CrnClienteSAPDTO lobTituloTraslado = (CrnClienteSAPDTO)lobTitulosTraslado.get(xTraslado);
					
					String lstIdCrn = (lobTituloTraslado.getID_CRN() != null && lobTituloTraslado.getID_CRN().trim().length() > 0) ? lobTituloTraslado.getID_CRN() : "";
					String lstIdTituloCntOrig = (lobTituloTraslado.getID_TITULO_CNTORIG() != null && lobTituloTraslado.getID_TITULO_CNTORIG().trim().length() > 0) ? lobTituloTraslado.getID_TITULO_CNTORIG() : ""; 
					String lstCodigoSAPAnt = (lobTituloTraslado.getCODIGO_SAPANT() != null && lobTituloTraslado.getCODIGO_SAPANT().trim().length() > 0) ? lobTituloTraslado.getCODIGO_SAPANT() : "";
					String lstDescActNuevo = (lobTituloTraslado.getDESC_NUEVO() != null && lobTituloTraslado.getDESC_NUEVO().trim().length() > 0) ? lobTituloTraslado.getDESC_NUEVO() : "";
					String lstCodDDANuevo = (lobTituloTraslado.getCODIGO_DDA() != null && lobTituloTraslado.getCODIGO_DDA().trim().length() > 0) ? lobTituloTraslado.getCODIGO_DDA() : "";
					String lstProgramId = (lobTituloTraslado.getPROGRAM_ID() != null && lobTituloTraslado.getPROGRAM_ID().trim().length() > 0) ? lobTituloTraslado.getPROGRAM_ID() : "";
					String lstFechaContabilizacionBD = (lobTituloTraslado.getFECHA_CONTABILIZACION() != null && lobTituloTraslado.getFECHA_CONTABILIZACION().trim().length() > 0) ? lobTituloTraslado.getFECHA_CONTABILIZACION() : "";
					String lstFechaContabilizacion =  HOY_FMTSAP;
					
					LOG.debug("lstFechaContabilizacion: " + lstFechaContabilizacion + " HOY_FMTSAP: " + HOY_FMTSAP);
					
					String lstFlgEjecutar29 = (lobTituloTraslado.getEJECUTA29() != null && lobTituloTraslado.getEJECUTA29().trim().length() > 0) ? lobTituloTraslado.getEJECUTA29() : "0";
					String lstIdCntOriginal = (lobTituloTraslado.getID_CONTRATO_ORIGINAL() != null && lobTituloTraslado.getID_CONTRATO_ORIGINAL().trim().length() > 0) ? lobTituloTraslado.getID_CONTRATO_ORIGINAL() : "";
					String lstIdCnt = (lobTituloTraslado.getID_CONTRATO() != null && lobTituloTraslado.getID_CONTRATO().trim().length() > 0) ? lobTituloTraslado.getID_CONTRATO() : "";
					String lstIdTituloCnt = (lobTituloTraslado.getID_TITULO_CNT() != null && lobTituloTraslado.getID_TITULO_CNT().trim().length() > 0) ? lobTituloTraslado.getID_TITULO_CNT() : ""; 
					String lstFechaInicioBD = (lobTituloTraslado.getFECHA_INICIO() != null && lobTituloTraslado.getFECHA_INICIO().trim().length() > 0) ? lobTituloTraslado.getFECHA_INICIO() : "";
					String lstFechaFinBD = (lobTituloTraslado.getFECHA_FIN() != null && lobTituloTraslado.getFECHA_FIN().trim().length() > 0) ? lobTituloTraslado.getFECHA_FIN() : "";
					
					LOG.info("   ");
					LOG.info("            <Registro: ["+xTraslado+"], IdCrn:["+lstIdCrn+"], IdTitCntOriginal:["+lstIdTituloCntOrig+"], CodSAPAnt:["+lstCodigoSAPAnt+"], DescActNuevo:["+lstDescActNuevo+"], CodDDANuevo:["+lstCodDDANuevo+"], ProgramID:["+lstProgramId+"],  FechaContabilizacion:["+lstFechaContabilizacion+"], FechaContabilizacionBD:["+lstFechaContabilizacionBD+"]>");
					LOG.info("            <Ejecutar29: ["+lstFlgEjecutar29+"], IdCntOriginal:["+lstIdCntOriginal+"], IdCnt:["+lstIdCnt+"], IdTituloCnt:["+lstIdTituloCnt+"], FechaInicioBD:["+lstFechaInicioBD+"], FechaFinBD:["+lstFechaFinBD+"]>");
					
					//--Cambia Titulo por Valor.
					
					LOG.info("                [INI]. Llamado a WS SAP para Traslado de Titulo por otro con mismo valor. Interfaz 25.");
					ParamTrasladoAFijoDTO pTrasladoAF = new ParamTrasladoAFijoDTO(); 
					
					List<ItemTrasladoActivoFijoDTO> itmsTraslado = new ArrayList<ItemTrasladoActivoFijoDTO>();
					ItemTrasladoActivoFijoDTO itmTraslado = new ItemTrasladoActivoFijoDTO();
					
					itmTraslado.setCodigoDDANuevo(lstCodDDANuevo);
					itmTraslado.setCodigoSAPAnt(lstCodigoSAPAnt);
					itmTraslado.setDescActNuevo(lstDescActNuevo);
					itmTraslado.setFechaContabilizacion(lstFechaContabilizacion);
					itmTraslado.setFechaInicio(lstFechaContabilizacion);
					itmTraslado.setProgramID(lstProgramId);
					itmsTraslado.add(itmTraslado);
					pTrasladoAF.setTitulos(itmsTraslado);
					ResultadoTrasladoAFijoDTO rWS_Traslado = wsMgr.trasladarActivoFijoWS(pTrasladoAF); 
					LOG.info("                [FIN]. Llamado a WS SAP para Traslado de Titulo por otro con mismo valor. Interfaz 25 Ejecuto?: _" + rWS_Traslado.getResultado() + "_");
					
					//--Verifica resultado real proporcionado por SAP
					if(rWS_Traslado.getActivosFijos() != null && rWS_Traslado.getActivosFijos().size() > 0 && rWS_Traslado.getResultado())
					{
						if(rWS_Traslado.getActivosFijos().get(0).getExcepcion().equalsIgnoreCase("OK"))
						{
							
							if(rWS_Traslado.getActivosFijos().get(0).getID_SAP() != null && rWS_Traslado.getActivosFijos().get(0).getID_SAP().trim().length() > 0)
							{
								//--Actualizar tabla CRN por ejecucion unicamente de I25
								LOG.info("                [INI]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente [Traslado] .");
								crnCteSAP.setR_STATUS(rWS_Traslado.getActivosFijos().get(0).getExcepcion());
								crnCteSAP.setR_CODIGO_SAP(rWS_Traslado.getActivosFijos().get(0).getID_SAP());
								crnCteSAP.setR_IDDDA(rWS_Traslado.getActivosFijos().get(0).getID_DDA());
								crnCteSAP.setFECHA_ENVIO_OK(HOY);
								crnCteSAP.setID_CRN(lstIdCrn);
								boolean lboActualizoCrnCteSAP = dao.actualizaCrnClienteSAP(crnCteSAP);
								LOG.info("                [FIN]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente [Traslado]. Resultado:_"+lboActualizoCrnCteSAP+"_");
								
								if(lboActualizoCrnCteSAP)
								{
									//--Actualiza Titulo
									LOG.info("            [INI]. Actualiza datos varios de Titulo ["+lstIdTituloCntOrig+"].");
									ContratoTituloDTO cntTitulo = new ContratoTituloDTO();
									cntTitulo.setID_SAP(rWS_Traslado.getActivosFijos().get(0).getID_SAP());
									cntTitulo.setFECHA_AJUSTOTITULO(HOY);
									cntTitulo.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
									boolean lboActTitulo = dao.actualizaContratoTituloFull(cntTitulo);
									LOG.info("            [FIN]. Actualiza datos varios de Titulo ["+lstIdTituloCntOrig+"]. Resultado:_"+lboActTitulo+"_");
									
									if(!lboActTitulo)
										lnuErrores++;
									
								}//Ends if(lboActualizoCrnCteSAP)
								else
									lnuErrores++;
								
								//--Verifica si se debe ejecutar la interfaz 29, debido a un cambio de fechas.
								if(lstFlgEjecutar29.equals("1"))
								{
									//--Calculo de la VU
									LOG.info("            [INI]. Calculo de la vida util, FI:["+lstFechaInicioBD+"], FF:["+lstFechaFinBD+"].");
									VidaUtilDTO vuDTO = dao.calcularVidaUtil(lstFechaInicioBD, lstFechaFinBD);
									LOG.info("            [FIN].Calculo de la vida util, FI:["+lstFechaInicioBD+"], FF:["+lstFechaFinBD+"]. Resultado:_"+vuDTO.toString()+"_");
									
									
									if(vuDTO != null && (vuDTO.getVUAA() != null && vuDTO.getVUAA().trim().length() > 0) && (vuDTO.getVUMM() != null && vuDTO.getVUMM().trim().length() > 0))
									{
										//--Insercion de registro en CRN para programar una futura ejecucion proxima de la I29 para este registro recien ejecutado de la I25.
										LOG.info("        [INI]. Inserta registro CRN para ejecucion de I29. Id CRN relacionado ["+lstIdCrn+"] y Id SAP["+rWS_Traslado.getActivosFijos().get(0).getID_SAP()+"].");
										CrnClienteSAPDTO dto = new CrnClienteSAPDTO();
										
										dto.setID_CONTRATO_ORIGINAL(lstIdCntOriginal);
										dto.setID_CONTRATO(lstIdCnt);
										dto.setINTERFAZ("29");
										dto.setCODIGO_SAP(rWS_Traslado.getActivosFijos().get(0).getID_SAP());
										dto.setSUBNUMERO(SUBNUMERO);
										dto.setFECHA_CONTABILIZACION(HOY);
										dto.setID_TITULO_CNT(lstIdTituloCnt);
										dto.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
										dto.setFECHA_INICIO(dateManager.cambiarFormato(lstFechaInicioBD, "yyyy-MM-dd")); 
										dto.setVUAA(vuDTO.getVUAA());
										dto.setVUMM(vuDTO.getVUMM());
										boolean lboResInsRegCrn29 = dao.insertaRegistroCRNClienteSAP(dto);
										LOG.info("        [INI]. Inserta registro CRN para ejecucion de I29. Id CRN relacionado ["+lstIdCrn+"] y subnumero["+rWS_Traslado.getActivosFijos().get(0).getID_SAP()+"]. Resultado: _"+lboResInsRegCrn29+"_");
										
										if(!lboResInsRegCrn29)
										{
											LOG.error("            *** No pudo ser insertado el registro CRN para ejecucion I29. Id CRN Relacionado: [" + lstIdCrn + "] ***");
											lnuErrores++;
										}
									}//Ends if(vuDTO != null && (vuDTO.getVUAA() != null && vuDTO.getVUAA().trim().length() > 0) && (vuDTO.getVUMM() != null && vuDTO.getVUMM().trim().length() > 0))
									else
									{
										//--No se pudo ejecutar I29
										LOG.error("No se pudo obtener la vida util :: ejecutarCambiaTituloMismoValor.");
										lnuErrores++;
									}
									
									
								}
								else
								{
									//--No ejecutar I29
									LOG.info("No ocurrio cambio de vida util, por lo tanto no se ejecuto llamado a I29 :: ejecutarCambiaTituloMismoValor.");
								}
							}//Ends if(rWS_Traslado.getActivosFijos().get(0).getID_SAP() != null && rWS_Traslado.getActivosFijos().get(0).getID_SAP().trim().length() > 0)
							else
							{
								LOG.error("            El Id SAP devuelto no es un dato valido, registro CRN [" + lstIdCrn + "]");
								lnuErrores++;
								
								//--Actualizar en tabla CRN
								crnCteSAP.setID_CRN(lstIdCrn);
								dao.actualizaCrnClienteSAP(crnCteSAP);
							}
							
						}//Ends if(rWS_Traslado.getActivosFijos().get(0).getExcepcion().equalsIgnoreCase("OK"))
						else
						{
							LOG.error("            No se proceso correctamente el Traslado de Titulo mismo valor en SAP, del registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
						}
						
					}//Ends if(rWS_Traslado.getActivosFijos() != null && rWS_Traslado.getActivosFijos().size() > 0 && rWS_Traslado.getResultado())
					else
					{
						//-- Tracking
						LOG.error("                Error al llamar el WS Traslado de Titulo mismo valor :: ejecutarCambiaTituloMismoValor: " + rWS_Traslado.getTransFault().toString());
						lnuErrores++;
						
						//--Actualiza tabla CRN
						crnCteSAP.setID_CRN(lstIdCrn);
						dao.actualizaCrnClienteSAP(crnCteSAP);
						
					}
					
					xTraslado++;
				}//Ends for(int xTraslado=0; xTraslado < lnuTotalTitulosTraslado; xTraslado++)
				LOG.info("        [INI] Procesamiento de ["+lobTitulosTraslado.size()+"] Titulos marcados como candidatos para Traslado con mismo valor.");
				
			}//Ends if(lobTitulosTraslado != null && lobTitulosTraslado.size() > 0)
			else
			{
				//--No hay nada que procesar o notificar a SAP
				LOG.info("No se encontraron Titulos marcados como candidatos para Traslado con mismo valor.");
			}
			
			//--Determina resultado final de proceso total de registros Traslado con mismo valor.
			if(lnuErrores == 0)
			{
				resultado.setMensaje("OK");
				resultado.setResultado(true);
			}
			else
			{
				resultado.setMensaje("Ocurrio error con algun(os) de los titulos enviados");
				resultado.setResultado(false);
			}
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarCambiaTituloMismoValor]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	
	public ResponseEjecucionDTO ejecutarBajaTitulosSinPerdida() throws Exception
	{
		ResponseEjecucionDTO resultado = new ResponseEjecucionDTO();
		int lnuErrores = 0;
		
		HOY = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_FMTSAP = dateManager.getFechaActual("yyyymmdd");
		HOY_DIAG_DMY = dateManager.getFechaActual("dd/mm/yyyy");
		
		try
		{
			//--Consulta de los registros marcados para Baja de Titulos SIN perdida.
			//--candidatos a enviar a la interfaz 31.
			List<CrnClienteSAPDTO> lobTitulosBajaSinPerdida = dao.obtenerRegistrosCandidatos("31");
                        LOG.info("        [INI/FIN] Obtener registros candidatos I31. Encontrados:_"+lobTitulosBajaSinPerdida.size()+"_");
                        List<TerminosComercialesDTO> lobTerminosComerciales = dao.obtenerContratosCandidatos("31");
			LOG.info("        [INI/FIN] Obtener contratos candidatos I31. Encontrados:_"+lobTerminosComerciales.size()+"_");
			wsMgr.terminosComerciales(lobTerminosComerciales, "31");
			if(lobTitulosBajaSinPerdida != null && lobTitulosBajaSinPerdida.size() > 0)
			{
				int lnuTotalTitulosBajaSP = lobTitulosBajaSinPerdida.size();
				
				LOG.info(" ");
				LOG.info("        [INI] Procesamiento de ["+lnuTotalTitulosBajaSP+"] Titulos marcados como candidatos para Baja sin Perdida.");
				for(int xBaja=0; xBaja < lnuTotalTitulosBajaSP; xBaja++)
				{
					CrnClienteSAPDTO crnCteSAP = new CrnClienteSAPDTO();
					CrnClienteSAPDTO lobTituloBaja = (CrnClienteSAPDTO)lobTitulosBajaSinPerdida.get(xBaja);
					//-- Por cuestiones de logica de negocio, se envia SIEMPRE la fecha actual como la fecha de contabilizacion. Cualquier cambio de ubicacion de proceso, o de orden o condiciones
					//-- de ejecucion, tendrn que derivar en un analisis a fin de determinar nuevamente el valor correcto a enviar en la fecha de contabilizacion
					String lstIdCrn = (lobTituloBaja.getID_CRN() != null && lobTituloBaja.getID_CRN().trim().length() > 0) ? lobTituloBaja.getID_CRN() : "";
					String lstIdTituloCnt = (lobTituloBaja.getID_TITULO_CNT() != null && lobTituloBaja.getID_TITULO_CNT().trim().length() > 0) ? lobTituloBaja.getID_TITULO_CNT() : ""; 
					String lstCodigoSAP = (lobTituloBaja.getCODIGO_SAP() != null && lobTituloBaja.getCODIGO_SAP().trim().length() > 0) ? lobTituloBaja.getCODIGO_SAP() : "";
					String lstFechaContabilizacionBD = (lobTituloBaja.getFECHA_CONTABILIZACION() != null && lobTituloBaja.getFECHA_CONTABILIZACION().trim().length() > 0) ? lobTituloBaja.getFECHA_CONTABILIZACION() : "";
					String lstFechaContabilizacion =  HOY_FMTSAP;
                                        String lstSubnumero = (lobTituloBaja.getSUBNUMERO()!= null && lobTituloBaja.getSUBNUMERO().trim().length() > 0) ? lobTituloBaja.getSUBNUMERO() : "";
					LOG.info("   ");
					LOG.info("            <Registro: ["+xBaja+"], IdCrn:["+lstIdCrn+"], IdTituloCnt:["+lstIdTituloCnt+"], CodigoSAP:["+lstCodigoSAP+"], FechaContabilizacion:["+lstFechaContabilizacion+"], FechaContabilizacionBD:["+lstFechaContabilizacionBD+"]>");
					
					//--Baja de Titulo sin perdida.
					LOG.info("                [INI]. Llamado a WS SAP para Baja Sin Perdida. Interfaz 31.");
					ParamBajaActivoFijoDTO pBajaSinPerdida = new ParamBajaActivoFijoDTO();
					List<ItemBajaActivoFijoDTO> itmsBajaSinPerdida = new ArrayList<ItemBajaActivoFijoDTO>();
					
					//--NOTA: Se reutilizo el objeto de Baja ya que usa los mismos campos.
					//--      La unica diferencia es que el objeto tiene un campo llamado CodigoSAPAnterior
					//--      y esta interfaz solo se llama CodigoSAP, pero una vez realizada esta aclaracion solo de 
					//--      nombre no hay mayor problema.
					
					ItemBajaActivoFijoDTO itmBajaSinPerdida = new ItemBajaActivoFijoDTO();
					itmBajaSinPerdida.setCodigoSAPAnterior(lstCodigoSAP);
					itmBajaSinPerdida.setFechaContabilizacion(lstFechaContabilizacion);
					itmBajaSinPerdida.setFechaInicio(lstFechaContabilizacion);
                                        itmBajaSinPerdida.setSubnumero(lstSubnumero);
					
					itmsBajaSinPerdida.add(itmBajaSinPerdida);
					pBajaSinPerdida.setTitulos(itmsBajaSinPerdida);
					
					ResultadoBajaPerdidaAFijoDTO rWS_BSP = wsMgr.bajaSinPerdidaWS(pBajaSinPerdida);
					LOG.info("                [FIN]. Llamado a WS SAP para Baja Sin Perdida. Interfaz 31. Ejecuto?: _" + rWS_BSP.getResultado() + "_");
					
					//--Verifica resultado real proporcionado por SAP
					if(rWS_BSP.getActivosFijos() != null && rWS_BSP.getActivosFijos().size() > 0 && rWS_BSP.getResultado())
					{
						if(rWS_BSP.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						{
							//--Actualizar en tabla CRN
							LOG.info("                [INI]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente .");
							crnCteSAP.setR_STATUS(rWS_BSP.getActivosFijos().get(0).getStatus());
							crnCteSAP.setR_CODIGO_SAP(rWS_BSP.getActivosFijos().get(0).getCodigoSAP());
							crnCteSAP.setFECHA_ENVIO_OK(HOY);
							crnCteSAP.setID_CRN(lstIdCrn);
							boolean lboActualizoCrnCteSAP = dao.actualizaCrnClienteSAP(crnCteSAP);
							LOG.info("                [FIN]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente. Resultado:_"+lboActualizoCrnCteSAP+"_");
							
							if(lboActualizoCrnCteSAP)
							{
								//--Actualiza titulo
								LOG.info("            [INI]. Actualiza datos varios de Titulo ["+lstIdTituloCnt+"].");
								ContratoTituloDTO cntTitulo = new ContratoTituloDTO();
								cntTitulo.setFECHA_BAJA(HOY);
								cntTitulo.setID_TITULO_CNT(lstIdTituloCnt);
								boolean lboActTitulo = dao.actualizaContratoTituloFull(cntTitulo);
								LOG.info("             [FIN]. Actualiza datos varios de Titulo ["+lstIdTituloCnt+"]. Resultado:_"+lboActTitulo+"_");
								
								if(!lboActTitulo)
									lnuErrores++;
								
							}//Ends if(lboActualizoCrnCteSAP)
							else
								lnuErrores++;
							
						}//Ends if(rWS_TitPorValor.getStatus().equalsIgnoreCase("OK"))
						else
						{
							LOG.error("            No se proceso correctamente la Baja sin perdida en SAP, del registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
						}
						
					}// Ends if(rWS_BSP.getStatus() != null && rWS_BSP.getStatus().trim().length() > 0 && rWS_BSP.getResultado())
					else if(rWS_BSP.getTransFault() != null && !rWS_BSP.getResultado())
					{
						//-- Tracking
						LOG.error("                Error al llamar el WS SAP para Baja sin perdida :: ejecutarBajaTitulosSinPerdida: " + rWS_BSP.getTransFault().toString());
						lnuErrores++;
						
						//--Actualizar en tabla CRN
						crnCteSAP.setID_CRN(lstIdCrn);
						dao.actualizaCrnClienteSAP(crnCteSAP);
						
					}

				}//Ends for(int xBaja=0; xBaja < lnuTotalTitulosBajaSP; xBaja++)
				LOG.info("        [FIN] Procesamiento de ["+lnuTotalTitulosBajaSP+"] Titulos marcados como candidatos para Baja sin Perdida");
				
			}//Ends if(lobTitulosBajaSinPerdida != null && lobTitulosBajaSinPerdida.size() > 0)
			else
			{
				//--No hay nada que procesar o notificar a SAP
				LOG.info("No se encontraron Titulos marcados como candidatos para Baja sin Perdida.");
			}
			
			
			//--Determina resultado final de proceso total de registros Baja sin perdida
			if(lnuErrores == 0)
			{
				resultado.setMensaje("OK");
				resultado.setResultado(true);
			}
			else
			{
				resultado.setMensaje("Ocurrio error con algun(os) de los titulos enviados");
				resultado.setResultado(false);
			}
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarBajaTitulosSinPerdida]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public ResponseEjecucionDTO ejecutarBajaTitulosConPerdida() throws Exception
	{
		ResponseEjecucionDTO resultado = new ResponseEjecucionDTO();
		int lnuErrores = 0;
		
		HOY = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_FMTSAP = dateManager.getFechaActual("yyyymmdd");
		HOY_DIAG_DMY = dateManager.getFechaActual("dd/mm/yyyy");
		
		try
		{
			//--Consulta de los registros marcados para Baja de Titulos CON perdida.
			//--candidatos a enviar a la interfaz 30.
			List<CrnClienteSAPDTO> lobTitulosBajaConPerdida = dao.obtenerRegistrosCandidatos("30");
			LOG.info("        [INI/FIN] Obtener registros candidatos I30. Encontrados:_"+lobTitulosBajaConPerdida.size()+"_");
                        List<TerminosComercialesDTO> lobTerminosComerciales = dao.obtenerContratosCandidatos("30");
			LOG.info("        [INI/FIN] Obtener contratos candidatos I30. Encontrados:_"+lobTerminosComerciales.size()+"_");
			wsMgr.terminosComerciales(lobTerminosComerciales, "30");
			
			if(lobTitulosBajaConPerdida != null && lobTitulosBajaConPerdida.size() > 0)
			{
				int lnuTotalTitulosBajaCP = lobTitulosBajaConPerdida.size();
				
				LOG.info(" ");
				LOG.info("        [INI] Procesamiento de ["+lnuTotalTitulosBajaCP+"] Titulos marcados como candidatos para Baja con Perdida.");
				for(int xBaja=0; xBaja < lnuTotalTitulosBajaCP; xBaja++)
				{
					CrnClienteSAPDTO crnCteSAP = new CrnClienteSAPDTO();
					CrnClienteSAPDTO lobTituloBaja = (CrnClienteSAPDTO)lobTitulosBajaConPerdida.get(xBaja);
					//-- Por cuestiones de logica de negocio, se envia SIEMPRE la fecha actual como la fecha de contabilizacion. Cualquier cambio de ubicacion de proceso, o de orden o condiciones
					//-- de ejecucion, tendrn que derivar en un analisis a fin de determinar nuevamente el valor correcto a enviar en la fecha de contabilizacion
					String lstIdCrn = (lobTituloBaja.getID_CRN() != null && lobTituloBaja.getID_CRN().trim().length() > 0) ? lobTituloBaja.getID_CRN() : "";
					String lstIdTituloCnt = (lobTituloBaja.getID_TITULO_CNT() != null && lobTituloBaja.getID_TITULO_CNT().trim().length() > 0) ? lobTituloBaja.getID_TITULO_CNT() : ""; 
					String lstCodigoSAP = (lobTituloBaja.getCODIGO_SAP() != null && lobTituloBaja.getCODIGO_SAP().trim().length() > 0) ? lobTituloBaja.getCODIGO_SAP() : "";
					String lstFechaContabilizacionBD = (lobTituloBaja.getFECHA_CONTABILIZACION() != null && lobTituloBaja.getFECHA_CONTABILIZACION().trim().length() > 0) ? lobTituloBaja.getFECHA_CONTABILIZACION() : "";
					String lstFechaContabilizacion =  HOY_FMTSAP;
                                        String lstSubnumero = (lobTituloBaja.getSUBNUMERO()!= null && lobTituloBaja.getSUBNUMERO().trim().length() > 0) ? lobTituloBaja.getSUBNUMERO() : "";
					LOG.info("   ");
					LOG.info("            <Registro: ["+xBaja+"], IdCrn:["+lstIdCrn+"], IdTituloCnt:["+lstIdTituloCnt+"], CodigoSAP:["+lstCodigoSAP+"], FechaContabilizacion:["+lstFechaContabilizacion+"], FechaContabilizacionBD:["+lstFechaContabilizacionBD+"]>");
					
					//--Baja de Titulo con perdida.
					LOG.info("                [INI]. Llamado a WS SAP para Baja Con Perdida. Interfaz 30.");
					ParamBajaActivoFijoDTO pBajaConPerdida = new ParamBajaActivoFijoDTO();
					List<ItemBajaActivoFijoDTO> itmsBajaConPerdida = new ArrayList<ItemBajaActivoFijoDTO>();
					
					//--NOTA: Se reutilizo el objeto de Baja ya que usa los mismos campos.
					//--      La unica diferencia es que el objeto tiene un campo llamado CodigoSAPAnterior
					//--      y esta interfaz solo se llama CodigoSAP, pero una vez realizada esta aclaracion solo de 
					//--      nombre no hay mayor problema.
					
					ItemBajaActivoFijoDTO itmBajaConPerdida = new ItemBajaActivoFijoDTO();
					itmBajaConPerdida.setCodigoSAPAnterior(lstCodigoSAP);
					itmBajaConPerdida.setFechaContabilizacion(lstFechaContabilizacion);
					itmBajaConPerdida.setFechaInicio(lstFechaContabilizacion);
                                        itmBajaConPerdida.setSubnumero(lstSubnumero);
					
					itmsBajaConPerdida.add(itmBajaConPerdida);
					pBajaConPerdida.setTitulos(itmsBajaConPerdida);
					
					
					ResultadoBajaPerdidaAFijoDTO rWS_BCP = wsMgr.bajaConPerdidaWS(pBajaConPerdida);
					LOG.info("                [FIN]. Llamado a WS SAP para Baja Con Perdida. Interfaz 30. Ejecuto?: _" + rWS_BCP.getResultado() + "_");
					
					//--Verifica resultado real proporcionado por SAP
					if(rWS_BCP.getActivosFijos() != null && rWS_BCP.getActivosFijos().size() > 0 && rWS_BCP.getResultado())
					{
						if(rWS_BCP.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						{
							//--Actualizar en tabla CRN
							LOG.info("                [INI]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente .");
							crnCteSAP.setR_STATUS(rWS_BCP.getActivosFijos().get(0).getStatus());
							crnCteSAP.setR_CODIGO_SAP(rWS_BCP.getActivosFijos().get(0).getCodigoSAP());
							crnCteSAP.setFECHA_ENVIO_OK(HOY);
							crnCteSAP.setID_CRN(lstIdCrn);
							boolean lboActualizoCrnCteSAP = dao.actualizaCrnClienteSAP(crnCteSAP);
							LOG.info("                [FIN]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente. Resultado:_"+lboActualizoCrnCteSAP+"_");
							
							if(lboActualizoCrnCteSAP)
							{
								//--Actualiza titulo
								LOG.info("            [INI]. Actualiza datos varios de Titulo ["+lstIdTituloCnt+"].");
								ContratoTituloDTO cntTitulo = new ContratoTituloDTO();
								cntTitulo.setFECHA_BAJA(HOY);
								cntTitulo.setID_TITULO_CNT(lstIdTituloCnt);
								boolean lboActTitulo = dao.actualizaContratoTituloFull(cntTitulo);
								LOG.info("             [FIN]. Actualiza datos varios de Titulo ["+lstIdTituloCnt+"]. Resultado:_"+lboActTitulo+"_");
								
								if(!lboActTitulo)
									lnuErrores++;
							}
							else
								lnuErrores++;
							
						}//Ends if(rWS_BCP.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						else
						{
							LOG.error("            No se proceso correctamente la Baja con perdida en SAP, del registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
						}
					}//Ends if(rWS_BCP.getActivosFijos() != null && rWS_BCP.getActivosFijos().size() > 0 && rWS_BCP.getResultado())
					else if(rWS_BCP.getTransFault() != null && !rWS_BCP.getResultado())
					{
						//-- Tracking
						LOG.error("                Error al llamar el WS SAP para Baja con perdida :: ejecutarBajaTitulosConPerdida: " + rWS_BCP.getTransFault().toString());
						lnuErrores++;
						
						//--Actualizar en tabla CRN
						crnCteSAP.setID_CRN(lstIdCrn);
						dao.actualizaCrnClienteSAP(crnCteSAP);
						
					}//Ends else if(rWS_BCP.getTransFault() != null && !rWS_BCP.getResultado())
					
				}//Ends for(int xBaja=0; xBaja < lnuTotalTitulosBajaCP; xBaja++)
				LOG.info("        [FIN] Procesamiento de ["+lnuTotalTitulosBajaCP+"] Titulos marcados como candidatos para Baja con Perdida");
				
			}//Ends if(lobTitulosBajaConPerdida != null && lobTitulosBajaConPerdida.size() > 0)
			else
			{
				//--No hay nada que procesar o notificar a SAP
				LOG.info("No se encontraron Titulos marcados como candidatos para Baja con Perdida.");
			}
			
			
			//--Determina resultado final de proceso total de registros Baja con perdida
			if(lnuErrores == 0)
			{
				resultado.setMensaje("OK");
				resultado.setResultado(true);
			}
			else
			{
				resultado.setMensaje("Ocurrio error con algun(os) de los titulos enviados");
				resultado.setResultado(false);
			}
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarBajaTitulosConPerdida]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public ResponseEjecucionDTO ejecutarAjusteVidaUtil() throws Exception
	{
		ResponseEjecucionDTO resultado = new ResponseEjecucionDTO();
		int lnuErrores = 0;
		
		HOY = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_FMTSAP = dateManager.getFechaActual("yyyymmdd");
		HOY_DIAG_DMY = dateManager.getFechaActual("dd/mm/yyyy");
		
		try
		{
			//-- Consulta de los registros marcados para Ajuste de Vida Util.
			//-- Candidatos a enviar a la interfaz 29.
			List<CrnClienteSAPDTO> lobTitulosAjusteVU = dao.obtenerRegistrosCandidatos("29");
			LOG.info("        [INI/FIN] Obtener registros candidatos I29. Encontrados:_"+lobTitulosAjusteVU.size()+"_");
			
			if(lobTitulosAjusteVU != null && lobTitulosAjusteVU.size() > 0)
			{
				int lnuTotalTitulosVU = lobTitulosAjusteVU.size();
				
				LOG.info(" ");
				LOG.info("        [INI] Procesamiento de ["+lnuTotalTitulosVU+"] Titulos marcados como candidatos para Ajuste Vida Util.");
				for(int xVU=0; xVU < lnuTotalTitulosVU; xVU++)
				{
					CrnClienteSAPDTO crnCteSAP = new CrnClienteSAPDTO();
					CrnClienteSAPDTO lobTituloVU = (CrnClienteSAPDTO)lobTitulosAjusteVU.get(xVU);
					//-- Por cuestiones de logica de negocio, se envia SIEMPRE la fecha actual como la fecha de contabilizacion. Cualquier cambio de ubicacion de proceso, o de orden o condiciones
					//-- de ejecucion, tendrn que derivar en un analisis a fin de determinar nuevamente el valor correcto a enviar en la fecha de contabilizacion
					String lstIdCrn = (lobTituloVU.getID_CRN() != null && lobTituloVU.getID_CRN().trim().length() > 0) ? lobTituloVU.getID_CRN() : "";
					String lstIdTituloCnt = (lobTituloVU.getID_TITULO_CNT() != null && lobTituloVU.getID_TITULO_CNT().trim().length() > 0) ? lobTituloVU.getID_TITULO_CNT() : "";
					String lstCodigoSAP = (lobTituloVU.getCODIGO_SAP() != null && lobTituloVU.getCODIGO_SAP().trim().length() > 0) ? lobTituloVU.getCODIGO_SAP() : "";
					String lstSubnumero = (lobTituloVU.getSUBNUMERO() != null && lobTituloVU.getSUBNUMERO().trim().length() > 0) ? lobTituloVU.getSUBNUMERO() : "";
					String lstFechaInicioBD = (lobTituloVU.getFECHA_INICIO() != null && lobTituloVU.getFECHA_INICIO().trim().length() > 0) ? lobTituloVU.getFECHA_INICIO() : "";
					String lstFechaFinBD = (lobTituloVU.getFECHA_FIN() != null && lobTituloVU.getFECHA_FIN().trim().length() > 0) ? lobTituloVU.getFECHA_FIN() : "";
					String lstVU_AA = (lobTituloVU.getVUAA() != null && lobTituloVU.getVUAA().trim().length() > 0) ? lobTituloVU.getVUAA() : "";
					String lstVU_MM = (lobTituloVU.getVUMM() != null && lobTituloVU.getVUMM().trim().length() > 0) ? lobTituloVU.getVUMM() : "";
					String lstFechaInicio = "";
					
					//--Verificar subnumero leido para determinar recalculo de V.U.
					if(!lstSubnumero.equals(SUBNUMERO))
					{
						//--- Ejecucion posterior a I19 de un registro de aumento de costo (Subnumero != 0000).
						lstFechaInicio = HOY_FMTSAP;
						
						//--Calculo actualizado de Vida Util con referencia a la fecha de Contabilizacion (hoy) y la fecha final establecida.
						LOG.info("            [INI]. Calculo de la vida util, FI:["+HOY_DIAG_DMY+"], FF:["+lstFechaFinBD+"].");
						VidaUtilDTO vuDTO = dao.calcularVidaUtil(HOY_DIAG_DMY, lstFechaFinBD);
						LOG.info("            [FIN]. Calculo de la vida util, FI:["+HOY_DIAG_DMY+"], FF:["+lstFechaFinBD+"]. Resultado:_"+vuDTO.toString()+"_");
						
						if(vuDTO != null && (vuDTO.getVUAA() != null && vuDTO.getVUAA().trim().length() > 0) && (vuDTO.getVUMM() != null && vuDTO.getVUMM().trim().length() > 0))
						{
							lstVU_AA = vuDTO.getVUAA();
							lstVU_MM = vuDTO.getVUMM();
						}//Ends if(vuDTO != null && vuDTO.getVUAA()!= null  && vuDTO.getVUMM()!= null)
						else
						{
							LOG.error("            No se pudo recalcular la vida util para registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
							
							//--Se "salta" la ejecucion de la interfaz y pasa al siguiente registro candidato
							break;
						}
						
					}//Ends if(!lstSubnumero.equals(SUBNUMERO))
					else
					{
						//--Cuando se ejecuta "sola". Ejecucion normal de un registro 0000
						lstFechaInicio = dateManager.cambiarFormato(lstFechaInicioBD, "yyyyMMdd");
						
					}
					
					LOG.info("   ");
					LOG.info("            <Registro: ["+xVU+"], IdCrn:["+lstIdCrn+"], IdTituloCnt:["+lstIdTituloCnt+"], CodigoSAP:["+lstCodigoSAP+"], Subnumero:["+lstSubnumero+"], FechaInicioBD:["+lstFechaInicioBD+"], FechaFinBD:["+lstFechaFinBD+"],VU_AA:["+lstVU_AA+"],VU_MM:["+lstVU_MM+"],FechaInicio:["+lstFechaInicio+"]>");
					
					
					//--Ajuste de Vida Util
					LOG.info("                [INI]. Llamado a WS SAP para Ajuste Vida Util. Interfaz 29.");
					List<ItemVidaUtilAFijoDTO> itmsVidaUtil = new ArrayList<ItemVidaUtilAFijoDTO>();
					ParamCambiaVUAFijoDTO pAjusteVU = new ParamCambiaVUAFijoDTO();
					
					ItemVidaUtilAFijoDTO itmVidaUtil = new ItemVidaUtilAFijoDTO();
					itmVidaUtil.setCodigoSAP(lstCodigoSAP);
					itmVidaUtil.setFechaInicio(lstFechaInicio);
					itmVidaUtil.setSubNumero(lstSubnumero);
					itmVidaUtil.setVuAA(lstVU_AA);
					itmVidaUtil.setVuMM(lstVU_MM);
					itmsVidaUtil.add(itmVidaUtil);
					pAjusteVU.setTitulos(itmsVidaUtil);
					
					ResultadoCambiaVUAFijoDTO rWS_VU = wsMgr.modificaVidaUtilAFijoWS(pAjusteVU);
					LOG.info("                [FIN]. Llamado a WS SAP para Ajuste Vida Util. Interfaz 29. Ejecuto?: _" + rWS_VU.getResultado() + "_");
					
					//--Verifica resultado real proporcionado por SAP
					if(rWS_VU.getActivosFijos() != null && rWS_VU.getActivosFijos().size() > 0 && rWS_VU.getResultado())
					{
						if(rWS_VU.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						{
							//--Actualizar en tabla CRN
							LOG.info("                [INI]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente .");
							crnCteSAP.setR_STATUS(rWS_VU.getActivosFijos().get(0).getStatus());
							crnCteSAP.setR_CODIGO_SAP(rWS_VU.getActivosFijos().get(0).getCodigoSAP());
							crnCteSAP.setFECHA_ENVIO_OK(HOY);
							crnCteSAP.setID_CRN(lstIdCrn);
							boolean lboActualizoCrnCteSAP = dao.actualizaCrnClienteSAP(crnCteSAP);
							LOG.info("                [FIN]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente. Resultado:_"+lboActualizoCrnCteSAP+"_");
							
							if(lboActualizoCrnCteSAP)
							{
								//--Actualizacion titulo
								LOG.info("            [INI]. Actualiza datos varios de Titulo ["+lstIdTituloCnt+"].");
								ContratoTituloDTO cntTitulo = new ContratoTituloDTO();
								cntTitulo.setFECHA_AJUSTOVU(HOY);
								cntTitulo.setID_TITULO_CNT(lstIdTituloCnt);
								boolean lboActTitulo = dao.actualizaContratoTituloFull(cntTitulo);
								LOG.info("             [FIN]. Actualiza datos varios de Titulo ["+lstIdTituloCnt+"]. Resultado:_"+lboActTitulo+"_");
								
								if(!lboActTitulo)
									lnuErrores++;
							}
							else
								lnuErrores++;
							
						}//Ends if(rWS_VU.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						else
						{
							LOG.error("            No se proceso correctamente el Ajuste VU en SAP, del registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
						}
					}//Ends if(rWS_VU.getActivosFijos() != null && rWS_VU.getActivosFijos().size() > 0 && rWS_VU.getResultado())
					else if(rWS_VU.getTransFault() != null && !rWS_VU.getResultado())
					{
						//-- Tracking
						LOG.error("                Error al llamar el WS SAP para Ajuste VU :: ejecutarAjusteVidaUtil: " + rWS_VU.getTransFault().toString());
						lnuErrores++;
						
						//--Actualizar en tabla CRN
						crnCteSAP.setID_CRN(lstIdCrn);
						dao.actualizaCrnClienteSAP(crnCteSAP);
						
					}//Ends else if(rWS_VU.getTransFault() != null && !rWS_VU.getResultado())
					
				}//Ends for(int xVU=0; xVU < lnuTotalTitulosVU; xVU++)
				LOG.info("        [FIN] Procesamiento de ["+lnuTotalTitulosVU+"] Titulos marcados como candidatos para Ajuste Vida Util");
				
			}//Ends if(lobTitulosAjusteVU != null && lobTitulosAjusteVU.size() > 0)
			else
			{
				//--No hay nada que procesar o notificar a SAP
				LOG.info("No se encontraron Titulos marcados como candidatos para Ajuste de Vida Util.");
			}
			
			
			//--Determina resultado final de proceso total de registros Ajuste Vida Util
			if(lnuErrores == 0)
			{
				resultado.setMensaje("OK");
				resultado.setResultado(true);
			}
			else
			{
				resultado.setMensaje("Ocurrio error con algun(os) de los titulos enviados");
				resultado.setResultado(false);
			}
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarAjusteVidaUtil]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public ResponseEjecucionDTO ejecutarAumentoPrecio() throws Exception
	{
		ResponseEjecucionDTO resultado = new ResponseEjecucionDTO();
		int lnuErrores = 0;
		
		HOY = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_FMTSAP = dateManager.getFechaActual("yyyymmdd");
		HOY_DIAG_DMY = dateManager.getFechaActual("dd/mm/yyyy");
		
		try
		{
			//-- Consulta de los registros marcados para Aumento de precio
			//-- Candidatos a enviar a la interfaz 19.
			List<CrnClienteSAPDTO> lobTitulosAumentoPrecio = dao.obtenerRegistrosCandidatos("19");
			LOG.info("        [INI/FIN] Obtener registros candidatos I19. Encontrados:_"+lobTitulosAumentoPrecio.size()+"_");
                        List<TerminosComercialesDTO> lobTerminosComerciales = dao.obtenerContratosCandidatos("19");
			LOG.info("        [INI/FIN] Obtener contratos candidatos Terminos comerciales I19. Encontrados:_"+lobTerminosComerciales.size()+"_");
			wsMgr.terminosComerciales(lobTerminosComerciales, "19");
			
			if(lobTitulosAumentoPrecio != null && lobTitulosAumentoPrecio.size() > 0)
			{
				int lnuTotalTitulosAumPrecio = lobTitulosAumentoPrecio.size();
				LOG.info(" ");
				LOG.info("        [INI] Procesamiento de ["+lnuTotalTitulosAumPrecio+"] Titulos marcados como candidatos para Aumento de Precio.(Postcapitalizacion)");
				for(int xAP=0; xAP < lnuTotalTitulosAumPrecio; xAP++)
				{
					CrnClienteSAPDTO crnCteSAP = new CrnClienteSAPDTO();
					CrnClienteSAPDTO lobTituloAP = (CrnClienteSAPDTO)lobTitulosAumentoPrecio.get(xAP);
					//-- Por cuestiones de logica de negocio, se envia SIEMPRE la fecha actual como la fecha de contabilizacion. Cualquier cambio de ubicacion de proceso, o de orden o condiciones
					//-- de ejecucion, tendrn que derivar en un analisis a fin de determinar nuevamente el valor correcto a enviar en la fecha de contabilizacion
					String lstIdCrn = (lobTituloAP.getID_CRN() != null && lobTituloAP.getID_CRN().trim().length() > 0) ? lobTituloAP.getID_CRN() : "";
					String lstIdRegSAP_Subnum = (lobTituloAP.getID_REGISTRO_SAP() != null && lobTituloAP.getID_REGISTRO_SAP().trim().length() > 0) ? lobTituloAP.getID_REGISTRO_SAP() : "";
					String lstCodigoSAP = (lobTituloAP.getCODIGO_SAP() != null && lobTituloAP.getCODIGO_SAP().trim().length() > 0) ? lobTituloAP.getCODIGO_SAP() : ""; 
					String lstAumento = (lobTituloAP.getAUMENTO() != null && lobTituloAP.getAUMENTO().trim().length() > 0) ? lobTituloAP.getAUMENTO() : "";
					String lstFechaInicioBD = (lobTituloAP.getFECHA_INICIO() != null && lobTituloAP.getFECHA_INICIO().trim().length() > 0) ? lobTituloAP.getFECHA_INICIO() : "";
					String lstFechaContabilizacionBD = (lobTituloAP.getFECHA_CONTABILIZACION() != null && lobTituloAP.getFECHA_CONTABILIZACION().trim().length() > 0) ? lobTituloAP.getFECHA_CONTABILIZACION() : "";
					String lstFlgEjecutar29 = (lobTituloAP.getEJECUTA29() != null && lobTituloAP.getEJECUTA29().trim().length() > 0) ? lobTituloAP.getEJECUTA29() : "0";
					String lstFechaFinBD = (lobTituloAP.getFECHA_FIN() != null && lobTituloAP.getFECHA_FIN().trim().length() > 0) ? lobTituloAP.getFECHA_FIN() : "";
					String lstFechaInicio = HOY_FMTSAP;
					String lstFechaContabilizacion = lstFechaInicio;
					
                                        String lstSubnumero = (lobTituloAP.getSUBNUMERO()!= null && lobTituloAP.getSUBNUMERO().trim().length() > 0) ? lobTituloAP.getSUBNUMERO() : "0000";
					String lstIdCntOriginal = (lobTituloAP.getID_CONTRATO_ORIGINAL() != null && lobTituloAP.getID_CONTRATO_ORIGINAL().trim().length() > 0) ? lobTituloAP.getID_CONTRATO_ORIGINAL() : "";
					String lstIdCnt = (lobTituloAP.getID_CONTRATO() != null && lobTituloAP.getID_CONTRATO().trim().length() > 0) ? lobTituloAP.getID_CONTRATO() : "";
					String lstIdTituloCnt = (lobTituloAP.getID_TITULO_CNT() != null && lobTituloAP.getID_TITULO_CNT().trim().length() > 0) ? lobTituloAP.getID_TITULO_CNT() : ""; 
					String lstIdTituloCntOriginal = (lobTituloAP.getID_TITULO_CNTORIG() != null && lobTituloAP.getID_TITULO_CNTORIG().trim().length() > 0) ? lobTituloAP.getID_TITULO_CNTORIG() : "";
					
					LOG.info("   ");
					LOG.info("            <Registro: ["+xAP+"], IdCrn:["+lstIdCrn+"], IdRegSubnum:["+lstIdRegSAP_Subnum+"], CodigoSAP:["+lstCodigoSAP + 
                                                "], Aumento:["+lstAumento+"], FechaInicioBD:["+lstFechaInicioBD+"], FechaContabilizacionBD:["+lstFechaContabilizacionBD+"],FechaInicio:["+lstFechaInicio + 
                                                "], FechaContabilizacion:["+lstFechaContabilizacion+"],Ejecuta29:["+lstFlgEjecutar29+"], FechaFinBD:["+lstFechaFinBD + "],Subnumero:[" + lstSubnumero +
                                                "]>");
					LOG.info("            <IdCntOriginal: ["+lstIdCntOriginal+"], IdCnt:["+lstIdCnt+"], IdTituloCnt:["+lstIdTituloCnt+"], IdTituloCntOriginal:["+lstIdTituloCntOriginal+"]>");
					
					//--Aumento de Precio (Postcapitalizacion)
					LOG.info("                [INI]. Llamado a WS SAP para Aumento de precio (Postcapitalizacion). Interfaz 19.");
					List<ItemAumentoCostoActivoFijoDTO> itmsAC = new ArrayList<ItemAumentoCostoActivoFijoDTO>();
					ParamAumentoCostoAFijoDTO pAumentoCosto = new ParamAumentoCostoAFijoDTO();
					
					ItemAumentoCostoActivoFijoDTO itmAC = new ItemAumentoCostoActivoFijoDTO();
					itmAC.setCodigoSAP(lstCodigoSAP);
					itmAC.setAumento(lstAumento);
					itmAC.setFechaInicio(lstFechaInicio);
					itmAC.setFechaContabilizacion(lstFechaContabilizacion);
                                        itmAC.setSubnumero(lstSubnumero);
					itmsAC.add(itmAC);
					pAumentoCosto.setTitulos(itmsAC);
					
					ResultadoCambiaCostoActivoFijoDTO rWS_AC = wsMgr.notificarAumentoCostoAFijoWS(pAumentoCosto);
					LOG.info("                [FIN]. Llamado a WS SAP para Aumento de precio (Postcapitalizacion). Interfaz 19. Ejecuto?: _" + rWS_AC.getResultado() + "_");
					
					//--Verifica resultado real proporcionado por SAP
					if(rWS_AC.getActivosFijos() != null && rWS_AC.getActivosFijos().size() > 0 && rWS_AC.getResultado())
					{
						if(rWS_AC.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						{
							if(rWS_AC.getActivosFijos().get(0).getSubNumero() != null && rWS_AC.getActivosFijos().get(0).getSubNumero().trim().length() > 0)
							{
								
								//--Actualizacion en tabla CRN por ejecucin unicamente I19.
								LOG.info("                [INI]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente .");
								crnCteSAP.setR_STATUS(rWS_AC.getActivosFijos().get(0).getStatus());
								crnCteSAP.setR_CODIGO_SAP(rWS_AC.getActivosFijos().get(0).getCodigoSAP());
								crnCteSAP.setR_SUBNUMERO(rWS_AC.getActivosFijos().get(0).getSubNumero());
								crnCteSAP.setFECHA_ENVIO_OK(HOY);
								crnCteSAP.setID_CRN(lstIdCrn);
								boolean lboActualizoCrnCteSAP = dao.actualizaCrnClienteSAP(crnCteSAP);
								LOG.info("                [FIN]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente. Resultado:_"+lboActualizoCrnCteSAP+"_");
								
								if(lboActualizoCrnCteSAP)
								{

									//-- Actualiza el registro de aumento con el Subnumero y Fecha Sap 
									LOG.info("        [INI]. Actualiza registro Subnumero con ID Subnum ["+lstIdRegSAP_Subnum+"].");
									ContratoSAPSubnumDTO titUpd = new ContratoSAPSubnumDTO();
									titUpd.setFECHA_SAP(HOY);
									titUpd.setSUBNUMERO(rWS_AC.getActivosFijos().get(0).getSubNumero());
									titUpd.setID_REGISTRO_SAP(lstIdRegSAP_Subnum);
									boolean lboActCntSAPSub = dao.actualizaCntSAPSubnumFull(titUpd);
									LOG.info("        [FIN]. Actualiza registro Subnumero con ID Subnum ["+lstIdRegSAP_Subnum+"]. Resultado: _" +lboActCntSAPSub+"_");
									
									if(!lboActCntSAPSub)
										lnuErrores++;
									
								}//Ends if(lboActualizoCrnCteSAP)
								else
									lnuErrores++;
								
								
								//--Verifica si se debe ejecutar la interfaz 29, debido a cambio de fechas.
								if(lstFlgEjecutar29.equals("1"))
								{
									//--Insercion de registro en CRN para programar una futura ejecucion proxima de la I29 para este registro recien ejecutado para la 19
									//--En la ejecucion de la 29, hay que implementar una validacion que cuando el subnumero leido sea distinto de 0000 entonces se debe recalcular
									//--la V.U. con la fecha de inicio = HOY y la fecha de Fin BD.
									
									LOG.info("        [INI]. Inserta registro CRN para ejecucion de I29. Id CRN relacionado ["+lstIdCrn+"] y subnumero["+rWS_AC.getActivosFijos().get(0).getSubNumero()+"].");
									CrnClienteSAPDTO dto = new CrnClienteSAPDTO();
									String lstFechaFin_Fmt = dateManager.cambiarFormato(lstFechaFinBD, "yyyy-MM-dd");
									
									dto.setID_CONTRATO_ORIGINAL(lstIdCntOriginal);
									dto.setID_CONTRATO(lstIdCnt);
									dto.setINTERFAZ("29");
									dto.setCODIGO_SAP(lstCodigoSAP);
									dto.setSUBNUMERO(rWS_AC.getActivosFijos().get(0).getSubNumero());
									dto.setFECHA_CONTABILIZACION(HOY);
									dto.setID_TITULO_CNT(lstIdTituloCnt);
									dto.setID_TITULO_CNTORIG(lstIdTituloCntOriginal);
									dto.setFECHA_FIN(lstFechaFin_Fmt);
									boolean lboResInsRegCrn29 = dao.insertaRegistroCRNClienteSAP(dto);
									LOG.info("        [INI]. Inserta registro CRN para ejecucion de I29. Id CRN relacionado ["+lstIdCrn+"] y subnumero["+rWS_AC.getActivosFijos().get(0).getSubNumero()+"]. Resultado: _"+lboResInsRegCrn29+"_");
									
									if(!lboResInsRegCrn29)
									{
										LOG.error("            *** No pudo ser insertado el registro CRN para ejecucion I29. Id CRN Relacionado: [" + lstIdCrn + "] ***");
										lnuErrores++;
									}
									
								}//Ends if(lstFlgEjecutar29.equals("1"))
								else
								{
									//--No ejecutar I29
									LOG.info("No ocurrio cambio de vida util, por lo tanto no se ejecuto llamado a I29 :: ejecutarAumentoPrecio .");
								}
							}//Ends if(rWS_AC.getActivosFijos().get(0).getSubNumero() != null && rWS_AC.getActivosFijos().get(0).getSubNumero().trim().length() > 0)
							else
							{
								LOG.error("            El subnumero devuelto no es un dato valido, registro CRN [" + lstIdCrn + "]");
								lnuErrores++;
								
								//--Actualizar en tabla CRN
								crnCteSAP.setID_CRN(lstIdCrn);
								dao.actualizaCrnClienteSAP(crnCteSAP);
							}
						}//Termina if(rWS_AC.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						else
						{
							LOG.error("            No se proceso correctamente el Aumento de Costo en SAP, del registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
						}
					}//Ends if(rWS_AC.getActivosFijos() != null && rWS_AC.getActivosFijos().size() > 0 && rWS_AC.getResultado())
					else if(rWS_AC.getTransFault() != null && !rWS_AC.getResultado())
					{
						//-- Tracking
						LOG.error("                Error al llamar el WS SAP para Aumento de Costo :: ejecutarAumentoPrecio: " + rWS_AC.getTransFault().toString());
						lnuErrores++;
						
						//--Actualizar en tabla CRN
						crnCteSAP.setID_CRN(lstIdCrn);
						dao.actualizaCrnClienteSAP(crnCteSAP);
						
					}//Ends else if(rWS_VU.getTransFault() != null && !rWS_VU.getResultado())
					
				}//Ends for(int xAP=0; xAP < lnuTotalTitulosAumPrecio; xAP++)
				LOG.info("        [FIN] Procesamiento de ["+lnuTotalTitulosAumPrecio+"] Titulos marcados como candidatos para Aumento de Precio. (Postcapitalizacion)");
				
			}//Ends if(lobTitulosAumentoPrecio != null && lobTitulosAumentoPrecio.size() > 0)
			else
			{
				//--No hay nada que procesar o notificar a SAP
				LOG.info("No se encontraron Titulos marcados como candidatos para Aumento de Precio. (Postcapitalizacion)");
			}
			
			
			//--Determina resultado final de proceso total de registros Aumento de Precio
			if(lnuErrores == 0)
			{
				resultado.setMensaje("OK");
				resultado.setResultado(true);
			}
			else
			{
				resultado.setMensaje("Ocurrio error con algun(os) de los titulos enviados");
				resultado.setResultado(false);
			}
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarAumentoPrecio]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public ResponseEjecucionDTO ejecutarDisminucionPrecio() throws Exception
	{
		ResponseEjecucionDTO resultado = new ResponseEjecucionDTO();
		int lnuErrores = 0;
		
		HOY = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_FMTSAP = dateManager.getFechaActual("yyyymmdd");
		HOY_DIAG_DMY = dateManager.getFechaActual("dd/mm/yyyy");
		
		try
		{
			//-- Consulta de los registros marcados para Disminucion de precio
			//-- Candidatos a enviar a la interfaz 51
			List<CrnClienteSAPDTO> lobTitulosDisminucionPrecio = dao.obtenerRegistrosCandidatos("51");
			LOG.info("        [INI/FIN] Obtener registros candidatos I51. Encontrados:_"+lobTitulosDisminucionPrecio.size()+"_");
			
                        /*
                        RFD, se integra funcionalidad de Interfaz terminos comerciales 
                        */
                        List<TerminosComercialesDTO> lobTerminosComerciales = dao.obtenerContratosCandidatos("51");
			LOG.info("        [INI/FIN] Obtener contratos candidatos I51. Encontrados:_"+lobTerminosComerciales.size()+"_");
			wsMgr.terminosComerciales(lobTerminosComerciales, "51");
                        /**********/
                                                
			if(lobTitulosDisminucionPrecio != null && lobTitulosDisminucionPrecio.size() > 0)
			{
				int lnuTotalTitulosDismPrecio = lobTitulosDisminucionPrecio.size();
				LOG.info(" ");
				LOG.info("        [INI] Procesamiento de ["+lnuTotalTitulosDismPrecio+"] Titulos marcados como candidatos para Disminucion de Precio.");
				for(int xDP=0; xDP < lnuTotalTitulosDismPrecio; xDP++)
				{
					CrnClienteSAPDTO crnCteSAP = new CrnClienteSAPDTO();
					CrnClienteSAPDTO lobTituloDP = (CrnClienteSAPDTO)lobTitulosDisminucionPrecio.get(xDP);
					
					//-- Por cuestiones de logica de negocio, se envia SIEMPRE la fecha actual como la fecha de contabilizacion. Cualquier cambio de ubicacion de proceso, o de orden o condiciones
					//-- de ejecucion, tendrn que derivar en un analisis a fin de determinar nuevamente el valor correcto a enviar en la fecha de contabilizacion
					String lstIdCrn = (lobTituloDP.getID_CRN() != null && lobTituloDP.getID_CRN().trim().length() > 0) ? lobTituloDP.getID_CRN() : "";
					String lstCodigoSAP = (lobTituloDP.getCODIGO_SAP() != null && lobTituloDP.getCODIGO_SAP().trim().length() > 0) ? lobTituloDP.getCODIGO_SAP() : "";
					String lstIdRegSAP_Subnum = (lobTituloDP.getID_REGISTRO_SAP() != null && lobTituloDP.getID_REGISTRO_SAP().trim().length() > 0) ? lobTituloDP.getID_REGISTRO_SAP() : "";
					String lstSubnumero = (lobTituloDP.getSUBNUMERO() != null && lobTituloDP.getSUBNUMERO().trim().length() > 0) ? lobTituloDP.getSUBNUMERO() : "";
					String lstImporte = (lobTituloDP.getDISMINUCION() != null && lobTituloDP.getDISMINUCION().trim().length() > 0) ? lobTituloDP.getDISMINUCION() : "";
					String lstFechaInicioBD = (lobTituloDP.getFECHA_INICIO() != null && lobTituloDP.getFECHA_INICIO().trim().length() > 0) ? lobTituloDP.getFECHA_INICIO() : "";
					String lstFechaContabilizacionBD = (lobTituloDP.getFECHA_CONTABILIZACION() != null && lobTituloDP.getFECHA_CONTABILIZACION().trim().length() > 0) ? lobTituloDP.getFECHA_CONTABILIZACION() : "";
					String lstFechaInicio = HOY_FMTSAP;
					String lstFechaContabilizacion = lstFechaInicio; 
					
					LOG.info("   ");
					LOG.info("            <Registro: ["+xDP+"], IdCrn:["+lstIdCrn+"], CodigoSAP:["+lstCodigoSAP+"], Subnumero:["+lstSubnumero+"], Importe:["+lstImporte+"], FechaInicio:["+lstFechaInicio+"],FechaContabilizacion:["+lstFechaContabilizacion+"], FechaInicioBD:["+lstFechaInicioBD+"],FechaContabilizacionBD:["+lstFechaContabilizacionBD+"]>");
					
					//--Disminucion de Precio
					LOG.info("                [INI]. Llamado a WS SAP para Disminucion de precio. Interfaz 51.");
					List<ItemDisminucionCostoActivoFijoDTO> itmsDC = new ArrayList<ItemDisminucionCostoActivoFijoDTO>();
					ParamDisminucionCostoAFijoDTO pDisminucionCosto = new ParamDisminucionCostoAFijoDTO();
					
					ItemDisminucionCostoActivoFijoDTO itmDC = new ItemDisminucionCostoActivoFijoDTO();
					itmDC.setCodigoSAP(lstCodigoSAP);
					itmDC.setDisminucion(lstImporte);
					itmDC.setFechaContabilizacion(lstFechaContabilizacion);
					itmDC.setFechaInicio(lstFechaInicio);
					itmDC.setSubNumero(lstSubnumero);
					itmsDC.add(itmDC);
					pDisminucionCosto.setTitulos(itmsDC);
					
					ResultadoCambiaCostoActivoFijoDTO rWS_DC = wsMgr.notificarDisminucionCostoAFijoWS(pDisminucionCosto);
					LOG.info("                [FIN]. Llamado a WS SAP para Disminucion de precio. Interfaz 51. Ejecuto?: _" + rWS_DC.getResultado() + "_");
					
					//--Verifica resultado real proporcionado por SAP
					if(rWS_DC.getActivosFijos() != null && rWS_DC.getActivosFijos().size() > 0 && rWS_DC.getResultado())
					{
						if(rWS_DC.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						{
							//--Actualizar en tabla CRN
							LOG.info("                [INI]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente .");
							crnCteSAP.setR_STATUS(rWS_DC.getActivosFijos().get(0).getStatus());
							crnCteSAP.setR_CODIGO_SAP(rWS_DC.getActivosFijos().get(0).getCodigoSAP());
							crnCteSAP.setR_SUBNUMERO(rWS_DC.getActivosFijos().get(0).getSubNumero());
							crnCteSAP.setFECHA_ENVIO_OK(HOY);
							crnCteSAP.setID_CRN(lstIdCrn);
							boolean lboActualizoCrnCteSAP = dao.actualizaCrnClienteSAP(crnCteSAP);
							LOG.info("                [FIN]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente. Resultado:_"+lboActualizoCrnCteSAP+"_");
							
							if(lboActualizoCrnCteSAP)
							{
								//-- Actualiza el registro de aumento con el Subnumero y Fecha Sap 
								LOG.info("        [INI]. Actualiza registro Subnumero con ID Subnum ["+lstIdRegSAP_Subnum+"].");
								ContratoSAPSubnumDTO titUpd = new ContratoSAPSubnumDTO();
								titUpd.setFECHA_SAP(HOY);
								titUpd.setID_REGISTRO_SAP(lstIdRegSAP_Subnum);
								boolean lboActCntSAPSub = dao.actualizaCntSAPSubnumFull(titUpd);
								LOG.info("        [FIN]. Actualiza registro Subnumero con ID Subnum ["+lstIdRegSAP_Subnum+"]. Resultado: _" +lboActCntSAPSub+"_");
								
								if(!lboActCntSAPSub)
									lnuErrores++;
							}
							else
								lnuErrores++;
							
						}//Ends if(rWS_DC.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						else
						{
							LOG.error("            No se proceso correctamente la Disminucion de Costo en SAP, del registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
						}
					}//Ends if(rWS_DC.getActivosFijos() != null && rWS_DC.getActivosFijos().size() > 0 && rWS_DC.getResultado())
					else if(rWS_DC.getTransFault() != null && !rWS_DC.getResultado())
					{
						//-- Tracking
						LOG.error("                Error al llamar el WS SAP para Disminucion de Costo :: ejecutarDisminucionPrecio: " + rWS_DC.getTransFault().toString());
						lnuErrores++;
						
						//--Actualizar en tabla CRN
						crnCteSAP.setID_CRN(lstIdCrn);
						dao.actualizaCrnClienteSAP(crnCteSAP);
						
					}//Ends else if(rWS_VU.getTransFault() != null && !rWS_VU.getResultado())
				}//Ends for(int xDP=0; xDP < lnuTotalTitulosDismPrecio; xDP++)
				LOG.info("        [FIN] Procesamiento de ["+lnuTotalTitulosDismPrecio+"] Titulos marcados como candidatos para Disminucion de Precio.");
			}//Ends if(lobTitulosDisminucionPrecio != null && lobTitulosDisminucionPrecio.size() > 0)
			else
			{
				//--No hay nada que procesar o notificar a SAP
				LOG.info("No se encontraron Titulos marcados como candidatos para Disminucion de Precio.");
			}
			
			
			//--Determina resultado final de proceso total de registros Disminucion de Precio
			if(lnuErrores == 0)
			{
				resultado.setMensaje("OK");
				resultado.setResultado(true);
			}
			else
			{
				resultado.setMensaje("Ocurrio error con algun(os) de los titulos enviados");
				resultado.setResultado(false);
			}
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarDisminucionPrecio]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public ResponseEjecucionDTO ejecutarModificarTitulo() throws Exception
	{
		ResponseEjecucionDTO resultado = new ResponseEjecucionDTO();
		int lnuErrores = 0;
		
		HOY = dateManager.getFechaActual("yyyy-mm-dd");
		HOY_FMTSAP = dateManager.getFechaActual("yyyymmdd");
		HOY_DIAG_DMY = dateManager.getFechaActual("dd/mm/yyyy");
		
		try
		{
			//--Consulta de los registros marcados para Modificar datos de Activos Fijos (Titulos)  candidatos a enviar a la interfaz 20.
			List<CrnClienteSAPDTO> lobTitulosModificar = dao.obtenerRegistrosCandidatos("20");
			LOG.info("        [INI/FIN] Obtener registros candidatos I20. Encontrados:_"+lobTitulosModificar.size()+"_");
			
			if(lobTitulosModificar != null && lobTitulosModificar.size() > 0)
			{
				int lnuTotalTitulosModificar = lobTitulosModificar.size();
				
				LOG.info(" ");
				LOG.info("        [INI] Procesamiento de ["+lnuTotalTitulosModificar+"] Titulos marcados como candidatos para Modificar.");
				for(int xMod=0; xMod < lnuTotalTitulosModificar; xMod++)
				{
					CrnClienteSAPDTO crnCteSAP = new CrnClienteSAPDTO();
					CrnClienteSAPDTO lobTituloMod = (CrnClienteSAPDTO)lobTitulosModificar.get(xMod);
					
					//-- Por cuestiones de logica de negocio, se envia SIEMPRE la fecha actual como la fecha de contabilizacion. Cualquier cambio de ubicacion de proceso, o de orden o condiciones
					//-- de ejecucion, tendrn que derivar en un analisis a fin de determinar nuevamente el valor correcto a enviar en la fecha de contabilizacion
					String lstIdCrn = (lobTituloMod.getID_CRN() != null && lobTituloMod.getID_CRN().trim().length() > 0) ? lobTituloMod.getID_CRN() : "";
					String lstCodigoSAP = (lobTituloMod.getCODIGO_SAP() != null && lobTituloMod.getCODIGO_SAP().trim().length() > 0) ? lobTituloMod.getCODIGO_SAP() : "";
					String lstNvoNombre = (lobTituloMod.getDESC_NUEVO() != null && lobTituloMod.getDESC_NUEVO().trim().length() > 0) ? lobTituloMod.getDESC_NUEVO() : "";
					String lstCodigoDDA = (lobTituloMod.getCODIGO_DDA() != null && lobTituloMod.getCODIGO_DDA().trim().length() > 0) ? lobTituloMod.getCODIGO_DDA() : "";
					String lstProgramID = (lobTituloMod.getPROGRAM_ID() != null && lobTituloMod.getPROGRAM_ID().trim().length() > 0) ? lobTituloMod.getPROGRAM_ID() : "";
					LOG.info("   ");
					LOG.info("            <Registro: ["+xMod+"], IdCrn:["+lstIdCrn+"], CodigoSAP:["+lstCodigoSAP+"], NuevoNombre:["+lstNvoNombre+"],CodigoDDA:["+lstCodigoDDA+"],ProgramID:["+lstProgramID+"]>");
					
					//--Modificacion de datos generales 
					LOG.info("                [INI]. Llamado a WS SAP para Modificacion de datos. Interfaz 20.");
					ParamCambiaNombreAFijoDTO pModifAF = new ParamCambiaNombreAFijoDTO();
					List<ItemCambioNombreActivoFijoDTO> itmsModifAF = new ArrayList<ItemCambioNombreActivoFijoDTO>();
					
					ItemCambioNombreActivoFijoDTO itmModifAF = new ItemCambioNombreActivoFijoDTO();
					itmModifAF.setCodigoDDA(lstCodigoDDA);
					itmModifAF.setIdActivoFijo(lstCodigoSAP);
					itmModifAF.setNuevoNombre(lstNvoNombre);
					itmModifAF.setProgramID(lstProgramID);
					
					itmsModifAF.add(itmModifAF);
					pModifAF.setTitulos(itmsModifAF);
					
					ResultadoCambiaNombreAFijoDTO rWS_MAF = wsMgr.cambiaNombreActivoFijoWS(pModifAF);
					LOG.info("                [FIN]. Llamado a WS SAP para Modificacion de datos. Interfaz 20. Ejecuto?: _" + rWS_MAF.getResultado() + "_");
					
					//--Verifica resultado real proporcionado por SAP
					if(rWS_MAF.getActivosFijos() != null && rWS_MAF.getActivosFijos().size() > 0 && rWS_MAF.getResultado())
					{
						if(rWS_MAF.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						{
							//--Actualizar en tabla CRN
							LOG.info("                [INI]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente .");
							crnCteSAP.setR_STATUS(rWS_MAF.getActivosFijos().get(0).getStatus());
							crnCteSAP.setR_CODIGO_SAP(rWS_MAF.getActivosFijos().get(0).getCodigoSAP());
							crnCteSAP.setFECHA_ENVIO_OK(HOY);
							crnCteSAP.setID_CRN(lstIdCrn);
							boolean lboActualizoCrnCteSAP = dao.actualizaCrnClienteSAP(crnCteSAP);
							LOG.info("                [FIN]. Actualiza datos registro IdCrn:["+lstIdCrn+"] en tabla CRN_Cliente. Resultado:_"+lboActualizoCrnCteSAP+"_");
							
							if(!lboActualizoCrnCteSAP)
								lnuErrores++;
						}//Ends if(rWS_BCP.getActivosFijos().get(0).getStatus().equalsIgnoreCase("OK"))
						else
						{
							LOG.error("            No se proceso correctamente la Modificacion de Titulo (Activo Fijo) en SAP, del registro CRN [" + lstIdCrn + "]");
							lnuErrores++;
							
							//--Actualizar en tabla CRN
							crnCteSAP.setID_CRN(lstIdCrn);
							dao.actualizaCrnClienteSAP(crnCteSAP);
						}
						
					}//Ends if(rWS_MAF.getActivosFijos() != null && rWS_MAF.getActivosFijos().size() > 0 && rWS_MAF.getResultado())
					else if(rWS_MAF.getTransFault() != null && !rWS_MAF.getResultado())
					{
						//-- Tracking
						LOG.error("                Error al llamar el WS SAP para Modificar Titulo (Activo Fijo) :: ejecutarModificarTitulo: " + rWS_MAF.getTransFault().toString());
						lnuErrores++;
						
						//--Actualizar en tabla CRN
						crnCteSAP.setID_CRN(lstIdCrn);
						dao.actualizaCrnClienteSAP(crnCteSAP);
						
					}//Ends else if(rWS_BCP.getTransFault() != null && !rWS_BCP.getResultado())
					
				}//Ends for(int xMod=0; xMod < lnuTotalTitulosModificar; xMod++)
				LOG.info("        [FIN] Procesamiento de ["+lnuTotalTitulosModificar+"] Titulos marcados como candidatos para Modificar");
				
			}//Ends if(lobTitulosModificar != null && lobTitulosModificar.size() > 0)
			else
			{
				//--No hay nada que procesar o notificar a SAP
				LOG.info("No se encontraron Titulos marcados como candidatos para Modificacion de datos de Activos Fijos(Titulos).");
			}
			
			//--Determina resultado final de proceso total de registros Modificacion de datos de Activos Fijos (Titulos)
			if(lnuErrores == 0)
			{
				resultado.setMensaje("OK");
				resultado.setResultado(true);
			}
			else
			{
				resultado.setMensaje("Ocurrio error con algun(os) de los titulos enviados");
				resultado.setResultado(false);
			}
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarModificarTitulo]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public boolean ejecutarSPAmortizacionAjustada() throws Exception {
		
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::ejecutarSPAmortizacionAjustada]");
		
		boolean resultado = false;
		try
		{
			resultado = dao.ejecutarSPAmortizacionAjustada(); 
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPAmortizacionAjustada]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		return resultado;		
	}
}
