package mx.com.amx.mx.dda.crn.bo;

import java.util.List;
import java.util.Properties;

import javax.xml.ws.WebServiceException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;

import com.americamovil.dda._1.f.enviaactivofijo.DTActivoFijoRes;
import com.americamovil.dda._1.f.enviaactivofijo.DTTituloMismoValor;
import com.americamovil.dda._1.f.enviadisminucionvalor.DTDisminucionValor;
import com.americamovil.dda._1.f.enviadisminucionvalor.DTDisminucionValorRes;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTBajaConPerdida;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTBajaSinPerdida;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTModificaAFRes;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTTituloPorValor;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTVidaUtil;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTVidaUtilRes;
import com.americamovil.dda._1.f.envianombreactivof.DTNombreActivoFReq;
import com.americamovil.dda._1.f.envianombreactivof.DTNombreActivoFRes;
import com.americamovil.dda._1.f.enviapostcapitalizacontenido.DTCapitalizaContenido;
import com.americamovil.dda._1.f.enviapostcapitalizacontenido.DTCapitalizaContenidoRes;
import com.americamovil.dda._1.f.enviaterminoscomerciales.DTTerminosComerciales;
import com.americamovil.dda._1.f.enviaterminoscomerciales.DTTerminosComerciales.Condicionescomerciales;
import com.americamovil.dda._1.f.enviaterminoscomerciales.DTTerminosComercialesRes;
import java.util.Objects;

import mx.com.amx.mx.dda.crn.dto.ParamAumentoCostoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamBajaActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamCambiaNombreAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamCambiaVUAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamDisminucionCostoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamTrasladoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPBajaActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPBajaPerdidaAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPCambiaNombreActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPCambiaVUAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPCambioCostoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoBajaPerdidaAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaCostoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaNombreAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaVUAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoEnviaTituloPorValorDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoTrasladoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.TerminosComercialesDTO;
import mx.com.amx.mx.dda.crn.dto.TransactionFaultDTO;
import mx.com.amx.mx.dda.crn.utils.StringManager;



public class DDACteSAPWSBO 
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	StringManager strManager = new StringManager();
		
	@Autowired
	@Qualifier("wsCRNClienteSAP")
	private WebServiceTemplate wsCRNClienteSAP;
	
	private String AMBIENTE;
	private String SERVIDOR;
	private String PUERTO;
	private String COMPONENTE;
	private String ERROR_COMUNICACION_SAP;
	private String ERROR_INTERNO_SAP;
	private String ERROR_PROCESO;
	private String ERROR_REGISTRO_SAP;
	private String ERROR_RESP_DISTINTA;
	private String FECHA_TEST;
	
	public DDACteSAPWSBO()
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			AMBIENTE = env.getProperty("ambiente");
			SERVIDOR = env.getProperty(AMBIENTE+".servidor.sap.ws");
			PUERTO = env.getProperty(AMBIENTE+".puerto.sap.ws");
			COMPONENTE = "DDA_CRN_ClienteSAP::" + this.getClass().getSimpleName();
			ERROR_COMUNICACION_SAP = env.getProperty("error.comunicacion.sap");
			ERROR_INTERNO_SAP = env.getProperty("error.interno.sap");
			ERROR_PROCESO = env.getProperty("error.proceso");
			ERROR_RESP_DISTINTA = env.getProperty("error.respuesta.distinta.esperada");
			FECHA_TEST = env.getProperty("fecha.test");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
		
	}
	
	public ResultadoEnviaTituloPorValorDTO enviaTituloPorValorWS(ParamBajaActivoFijoDTO dto)
	{
		/*
		 * Debido a que ahora los registros son llamados de multiples contratos ( y no de uno solo como antes) y que 
		 * al no regresar SAP algunos datos que requerimos como Id de Titulo Cnt Original, o Id's especificos para en
		 * nuestras tablas tener la informacion con integridad, se deber hacer uno por uno.
		 */
		ResultadoEnviaTituloPorValorDTO resultado = new ResultadoEnviaTituloPorValorDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPBajaActivoFijoDTO> afs = resultado.getActivosFijos();
		try
		{
			
			DTTituloPorValor params = new DTTituloPorValor();
			
			/*
			 * Codigo unitario
			DTTituloPorValor.Registro titulo = new DTTituloPorValor.Registro();
			titulo.setCodigoSAPAnt(dto.getTitulos().get(0).getCodigoSAPAnterior());
			titulo.setFechaContabilizacion(dto.getTitulos().get(0).getFechaContabilizacion());
			titulo.setFechaInicio(dto.getTitulos().get(0).getFechaInicio());
			
			params.getRegistro().add(titulo);
			*/
			
			int lnuTotalTitulos = dto.getTitulos().size();
			for(int xTitulos=0; xTitulos < lnuTotalTitulos; xTitulos++)
			{
				DTTituloPorValor.Registro titulo = new DTTituloPorValor.Registro();
				
				titulo.setCodigoSAPAnt(dto.getTitulos().get(xTitulos).getCodigoSAPAnterior());
				titulo.setFechaContabilizacion(dto.getTitulos().get(xTitulos).getFechaContabilizacion());
				titulo.setFechaInicio(dto.getTitulos().get(xTitulos).getFechaInicio());
				
				params.getRegistro().add(titulo);
			}
			
			
			//--Llamado a WS SAP. Interfaz 27.
			DTModificaAFRes responseTitPorValor = new DTModificaAFRes();
			LOG.info ("                      Url Srv. Titulo por valor: " + this.getUrlServicio("27") );
			
			//--REAL CODE
			responseTitPorValor = (DTModificaAFRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("27"), params);
			
			//TEST
			//1.
			//responseTitPorValor = null;
			
			//2.
			/*
			DTModificaAFRes.Registro resp1 = new DTModificaAFRes.Registro();
			resp1.setIDSAP("12345");
			resp1.setStatus("NO_OK");
			responseTitPorValor.getRegistro().add(resp1);
			*/
			
			//3.
			/*
			DTModificaAFRes.Registro resp1 = new DTModificaAFRes.Registro();
			resp1.setIDSAP("12345");
			resp1.setStatus("OK");
			responseTitPorValor.getRegistro().add(resp1);
			*/
			
			
			
			//--Version multiple
			if(responseTitPorValor != null && responseTitPorValor.getRegistro() != null && responseTitPorValor.getRegistro().size() > 0)
			{
				int lnuTitulosProcesados = responseTitPorValor.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Tit. x valor): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPBajaActivoFijoDTO respSAP = new RespSAPBajaActivoFijoDTO();
					respSAP.setCodigoSAP(responseTitPorValor.getRegistro().get(0).getIDSAP());
					respSAP.setStatus(responseTitPorValor.getRegistro().get(0).getStatus());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Titulo por valor]: <Status:["+respSAP.getStatus()+"], IdSAP:["+respSAP.getCodigoSAP()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
				}
				else
				{
					tf.setInternalCode("DDA-TAF-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("enviaTituloPorValorWS");
					resultado.setResultado(false);
				}
				
			}
			else
			{
				tf.setInternalCode("DDA-TPV-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("enviaTituloPorValorWS");
				resultado.setResultado(false);
			}
			
			return resultado;
			
			
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-TPV-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("enviaTituloPorValorWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-TPV-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("enviaTituloPorValorWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-TPV-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("enviaTituloPorValorWS");
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	
	public ResultadoTrasladoAFijoDTO trasladarActivoFijoWS(ParamTrasladoAFijoDTO dto)
	{
		/*
		 * Debido a que ahora los registros son llamados de multiples contratos ( y no de uno solo como antes) y que 
		 * al no regresar SAP algunos datos que requerimos como Id de Titulo Cnt Original, o Id's especificos para en
		 * nuestras tablas tener la informacion con integridad, se deber hacer uno por uno.
		 */
		ResultadoTrasladoAFijoDTO resultado = new ResultadoTrasladoAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPActivoFijoDTO> afs = resultado.getActivosFijos();
		
		try
		{
			
			String lstCodigoDDANuevo = "";
			String lstCodigoSAPAnterior = "";
			String lstDescActNuevo = "";
			String lstFechaContabilizacion = "";
			String lstFechaInicio = "";
			String lstProgramId = "";
			
			DTTituloMismoValor params = new DTTituloMismoValor();
			
			/*
			 * Codigo unitario
			DTTituloMismoValor.Registro titulo = new DTTituloMismoValor.Registro();
			titulo.setCodigoDDANuevo(lstCodigoDDANuevo);
			titulo.setCodigoSAPAnt(lstCodigoSAPAnterior);
			titulo.setDescActNuevo(strManager.extraerPrimerosCaracteres(lstDescActNuevo, 50));
			titulo.setFechaContabilizacion(lstFechaContabilizacion);
			titulo.setFechaInicio(lstFechaInicio);
			titulo.setProgramID(lstProgramId);
			
			params.getRegistro().add(titulo);
			*/
			
			//--Recorrido de titulos
			int lnuTotalTitulos = dto.getTitulos().size();
			for(int xTitulos=0; xTitulos < lnuTotalTitulos; xTitulos++)
			{
				DTTituloMismoValor.Registro titulo = new DTTituloMismoValor.Registro();
				
				lstCodigoDDANuevo = (dto.getTitulos().get(xTitulos).getCodigoDDANuevo() != null && dto.getTitulos().get(xTitulos).getCodigoDDANuevo().length() > 0) ? dto.getTitulos().get(xTitulos).getCodigoDDANuevo(): "";
				lstCodigoSAPAnterior = (dto.getTitulos().get(xTitulos).getCodigoSAPAnt() != null && dto.getTitulos().get(xTitulos).getCodigoSAPAnt().length() > 0) ? dto.getTitulos().get(xTitulos).getCodigoSAPAnt(): "";
				lstDescActNuevo = (dto.getTitulos().get(xTitulos).getDescActNuevo() != null && dto.getTitulos().get(xTitulos).getDescActNuevo().length() > 0) ? dto.getTitulos().get(xTitulos).getDescActNuevo(): "";
				lstFechaContabilizacion = (dto.getTitulos().get(xTitulos).getFechaContabilizacion() != null && dto.getTitulos().get(xTitulos).getFechaContabilizacion().length() > 0) ? dto.getTitulos().get(xTitulos).getFechaContabilizacion(): "";
				lstFechaInicio = (dto.getTitulos().get(xTitulos).getFechaInicio() != null && dto.getTitulos().get(xTitulos).getFechaInicio().length() > 0) ? dto.getTitulos().get(xTitulos).getFechaInicio(): "";
				lstProgramId = (dto.getTitulos().get(xTitulos).getProgramID() != null && dto.getTitulos().get(xTitulos).getProgramID().length() > 0) ? dto.getTitulos().get(xTitulos).getProgramID(): "";
				
				titulo.setCodigoDDANuevo(lstCodigoDDANuevo);
				titulo.setCodigoSAPAnt(lstCodigoSAPAnterior);
				titulo.setDescActNuevo(strManager.extraerPrimerosCaracteres(lstDescActNuevo, 50));
				titulo.setFechaContabilizacion(lstFechaContabilizacion);
				titulo.setFechaInicio(lstFechaInicio);
				titulo.setProgramID(lstProgramId);
				
				params.getRegistro().add(titulo);
			}
			
			//--Llamado a WS SAP. Interfaz 25
			DTActivoFijoRes responseTrasladaAFijo = new DTActivoFijoRes();
			LOG.debug ( "                Url Srv. Trasladar Activo Fijo: " + this.getUrlServicio("25") );
			
			//--REAL CODE
			responseTrasladaAFijo = (DTActivoFijoRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("25"), params);
			
			//--TEST
			// 1.
			//responseTrasladaAFijo = null;
			
			//2. 
			/*
			DTActivoFijoRes.Respuesta resp1 = new DTActivoFijoRes.Respuesta();
			resp1.setExcepcion("Posting with trans.type 320  not possible (No acquisition posted)");
			resp1.setIDDDA("3");
			resp1.setIDSAP("700000004449");
			responseTrasladaAFijo.getRespuesta().add(resp1);
			*/
						
			//3.
			/*
			DTActivoFijoRes.Respuesta resp1 = new DTActivoFijoRes.Respuesta();
			resp1.setExcepcion("OK");
			resp1.setIDDDA("408010");
			resp1.setIDSAP("700000092594");
			responseTrasladaAFijo.getRespuesta().add(resp1);
			*/
			
			if(responseTrasladaAFijo != null && responseTrasladaAFijo.getRespuesta() != null && responseTrasladaAFijo.getRespuesta().size() > 0)
			{
				int lnuTitulosProcesados = responseTrasladaAFijo.getRespuesta().size();
				LOG.info("                Total titulos procesados SAP(traslado): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPActivoFijoDTO respSAP = new RespSAPActivoFijoDTO();
					respSAP.setExcepcion(responseTrasladaAFijo.getRespuesta().get(0).getExcepcion());
					respSAP.setID_DDA(responseTrasladaAFijo.getRespuesta().get(0).getIDDDA());
					respSAP.setID_SAP(responseTrasladaAFijo.getRespuesta().get(0).getIDSAP());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Traslado Titulo mismo valor]: <IdDDA:["+respSAP.getID_DDA()+"], IdSAP:["+respSAP.getID_SAP()+"], Excepcion:["+respSAP.getExcepcion()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
					
				}
				else
				{
					tf.setInternalCode("DDA-TAF-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("trasladarActivoFijoWS");
					resultado.setResultado(false);
				}
				
			}
			else
			{
				tf.setInternalCode("DDA-TAF-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL.");
				tf.setMethod("trasladarActivoFijoWS");
				resultado.setResultado(false);
			}
			
			return resultado;
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-TAF-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("trasladarActivoFijoWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-TAF-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("trasladarActivoFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-TAF-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("trasladarActivoFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		
	} 
        
        public void terminosComerciales(List<TerminosComercialesDTO> terminosComerciales, String interfaz) throws Exception{
            try {
                for(TerminosComercialesDTO contrato : terminosComerciales){
                    DTTerminosComerciales params = new DTTerminosComerciales();
                    params.setContratoDDA(contrato.getNumeroContrato());
                    //params.setOrdenCompra("6200000007");
                    params.setOrdenCompra(contrato.getOrdenCompra());
                    params.setIdentificadorInt(env.getProperty("identificador.sap" + interfaz));
                    DTTerminosComerciales.Condicionescomerciales condicion = new DTTerminosComerciales.Condicionescomerciales();
                    condicion.setValorcondicion(contrato.getCosto());
                    condicion.setFechavencimiento(contrato.getFechaVencimiento());
                    params.getCondicionescomerciales().add(condicion);
                    DTTerminosComercialesRes response = (DTTerminosComercialesRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("99"), params);
                    if(!response.getESTPROC().equals("OK")){
                        LOG.debug("        Fallo el contrato " + contrato.getNumeroContrato() + " al enviarlo a " + this.getUrlServicio("99") 
                                + " mensaje del servicio: " + response.getEstatus());
                    }
                LOG.info("************************************** ESTPROC: " + response.getESTPROC());
                LOG.info("************************************** Estatus: " + response.getEstatus());
                LOG.info("************************************** Response: " + response.toString());
                }
            }catch(Exception e){
                LOG.error("Exception[" + this.getClass().getSimpleName() + "::ejeccuciondeTerminos comerciales]: " + e.getMessage());
                throw new Exception(e.getMessage());
            }
        }
	
	public ResultadoBajaPerdidaAFijoDTO bajaSinPerdidaWS(ParamBajaActivoFijoDTO dto)
	{
		/*
		 * Debido a que ahora los registros son llamados de multiples contratos ( y no de uno solo como antes) y que 
		 * al no regresar SAP algunos datos que requerimos como Id de Titulo Cnt Original, o Id's especificos para en
		 * nuestras tablas tener la informacion con integridad, se deber hacer uno por uno.
		 */
		ResultadoBajaPerdidaAFijoDTO resultado = new ResultadoBajaPerdidaAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPBajaPerdidaAFijoDTO> afs = resultado.getActivosFijos();
		
		
		try
		{

			DTBajaSinPerdida params = new DTBajaSinPerdida();
			
			/*
			 * Cod unitario
			DTBajaSinPerdida.Registro titulo = new DTBajaSinPerdida.Registro();
			titulo.setCodigoSAP(dto.getTitulos().get(0).getCodigoSAPAnterior());
			titulo.setFechaContab(dto.getTitulos().get(0).getFechaContabilizacion());
			titulo.setFechaInicio(dto.getTitulos().get(0).getFechaInicio());
			
			params.getRegistro().add(titulo);
			*/
			
			//--Recorrido de titulos
			int lnuTotalTitulos = dto.getTitulos().size();
			for(int xTitulos=0; xTitulos < lnuTotalTitulos; xTitulos++)
			{
				DTBajaSinPerdida.Registro titulo = new DTBajaSinPerdida.Registro();
				
				titulo.setCodigoSAP(dto.getTitulos().get(xTitulos).getCodigoSAPAnterior());
				titulo.setFechaContab(dto.getTitulos().get(xTitulos).getFechaContabilizacion());
				titulo.setFechaInicio(dto.getTitulos().get(xTitulos).getFechaInicio());
				titulo.setSubNumero(dto.getTitulos().get(xTitulos).getSubnumero());
				params.getRegistro().add(titulo);
			}
			
			//--Llamado a WS SAP. Interfaz 31
			DTModificaAFRes responseBajaSinPerdida = new DTModificaAFRes();
			LOG.debug ( "                Url Srv. Baja sin Perdida Activo Fijo: " + this.getUrlServicio("31") );
			
			//--REAL CODE
			responseBajaSinPerdida = (DTModificaAFRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("31"), params);
			
			//--TEST
			//1.
			//responseBajaSinPerdida = null;
			
			//2.
			/*
			DTModificaAFRes.Registro resp1 = new DTModificaAFRes.Registro();
			resp1.setIDSAP("1");
			resp1.setStatus("NO_OK");
			responseBajaSinPerdida.getRegistro().add(resp1);
			*/
			
			//3.
			/*
			DTModificaAFRes.Registro resp1 = new DTModificaAFRes.Registro();
			resp1.setIDSAP("1");
			resp1.setStatus("OK");
			responseBajaSinPerdida.getRegistro().add(resp1);
			*/
			
			if(responseBajaSinPerdida != null && responseBajaSinPerdida.getRegistro() != null && responseBajaSinPerdida.getRegistro().size() > 0)
			{
				int lnuTitulosProcesados = responseBajaSinPerdida.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Baja sin perdida): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPBajaPerdidaAFijoDTO respSAP = new RespSAPBajaPerdidaAFijoDTO();
					respSAP.setCodigoSAP(responseBajaSinPerdida.getRegistro().get(0).getIDSAP());
					respSAP.setStatus(responseBajaSinPerdida.getRegistro().get(0).getStatus());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Baja sin perdida]: <CodSAP:["+respSAP.getCodigoSAP()+"], Status:["+respSAP.getStatus()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
				}
				else
				{
					tf.setInternalCode("DDA-BSP-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("bajaSinPerdidaWS");
					resultado.setResultado(false);
				}
				
			}
			else
			{
				tf.setInternalCode("DDA-BSP-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("bajaSinPerdidaWS");
				resultado.setResultado(false);
			}
			
			return resultado;
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-BSP-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("bajaSinPerdidaWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-BSP-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("bajaSinPerdidaWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-BSP-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("bajaSinPerdidaWS");
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	
	public ResultadoBajaPerdidaAFijoDTO bajaConPerdidaWS(ParamBajaActivoFijoDTO dto)
	{
		/*
		 * Debido a que ahora los registros son llamados de multiples contratos ( y no de uno solo como antes) y que 
		 * al no regresar SAP algunos datos que requerimos como Id de Titulo Cnt Original, o Id's especificos para en
		 * nuestras tablas tener la informacion con integridad, se deber hacer uno por uno.
		 */
		ResultadoBajaPerdidaAFijoDTO resultado = new ResultadoBajaPerdidaAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPBajaPerdidaAFijoDTO> afs = resultado.getActivosFijos();
		
		
		try
		{
			
			DTBajaConPerdida params = new DTBajaConPerdida();
			
			/*
			 * Cod unitario
			DTBajaConPerdida.Registro titulo = new DTBajaConPerdida.Registro();
			titulo.setCodigoSAP(dto.getTitulos().get(0).getCodigoSAPAnterior());
			titulo.setFechaContab(dto.getTitulos().get(0).getFechaContabilizacion());
			titulo.setFechaInicio(dto.getTitulos().get(0).getFechaInicio());
			params.getRegistro().add(titulo);
			*/
			
			//--Recorrido de titulos
			int lnuTotalTitulos = dto.getTitulos().size();
			for(int xTitulos=0; xTitulos < lnuTotalTitulos; xTitulos++)
			{
				DTBajaConPerdida.Registro titulo = new DTBajaConPerdida.Registro();
				
				titulo.setCodigoSAP(dto.getTitulos().get(xTitulos).getCodigoSAPAnterior());
				titulo.setFechaContab(dto.getTitulos().get(xTitulos).getFechaContabilizacion());
				titulo.setFechaInicio(dto.getTitulos().get(xTitulos).getFechaInicio());
                                titulo.setSubNumero(dto.getTitulos().get(xTitulos).getSubnumero());
				params.getRegistro().add(titulo);
			}
			
			
			//--Llamado a WS SAP. Interfaz 30
			DTModificaAFRes responseBajaConPerdida = new DTModificaAFRes();
			LOG.debug ( "                Url Srv. Baja con Perdida Activo Fijo: " + this.getUrlServicio("30") );
			
			//--REAL CODE
			responseBajaConPerdida = (DTModificaAFRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("30"), params);
			
			//TEST
			//1.
			//responseBajaConPerdida = null;
			
			//2.
			/*
			DTModificaAFRes.Registro resp1 = new DTModificaAFRes.Registro();
			resp1.setIDSAP("1");
			resp1.setStatus("NO_OK");
			responseBajaConPerdida.getRegistro().add(resp1);
			*/
			
			//3.
			/*
			DTModificaAFRes.Registro resp1 = new DTModificaAFRes.Registro();
			resp1.setIDSAP("1");
			resp1.setStatus("OK");
			responseBajaConPerdida.getRegistro().add(resp1);
			*/
			
			
			if(responseBajaConPerdida != null && responseBajaConPerdida.getRegistro() != null && responseBajaConPerdida.getRegistro().size() > 0)
			{
				int lnuTitulosProcesados = responseBajaConPerdida.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Baja con perdida): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPBajaPerdidaAFijoDTO respSAP = new RespSAPBajaPerdidaAFijoDTO();
					respSAP.setCodigoSAP(responseBajaConPerdida.getRegistro().get(0).getIDSAP());
					respSAP.setStatus(responseBajaConPerdida.getRegistro().get(0).getStatus());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Baja con perdida]: <CodSAP:["+respSAP.getCodigoSAP()+"], Status:["+respSAP.getStatus()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
				}
				else
				{
					tf.setInternalCode("DDA-BCP-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("bajaConPerdidaWS");
					resultado.setResultado(false);
				}
				
			}
			else
			{
				tf.setInternalCode("DDA-BCP-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("bajaConPerdidaWS");
				resultado.setResultado(false);
			}
			
			return resultado;
			
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-BCP-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("bajaConPerdidaWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-BCP-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("bajaConPerdidaWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-BCP-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("bajaConPerdidaWS");
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	
	public ResultadoCambiaVUAFijoDTO modificaVidaUtilAFijoWS(ParamCambiaVUAFijoDTO dto)
	{
		ResultadoCambiaVUAFijoDTO resultado = new ResultadoCambiaVUAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPCambiaVUAFijoDTO> afs = resultado.getActivosFijos();

		try
		{
			DTVidaUtil params = new DTVidaUtil();
			
			//--Recorrido de titulos
			int lnuTotalTitulos = dto.getTitulos().size();
			for(int xTitulos=0; xTitulos < lnuTotalTitulos; xTitulos++)
			{
				DTVidaUtil.Registro titulo = new DTVidaUtil.Registro();
				
				titulo.setCodigoSAP(dto.getTitulos().get(xTitulos).getCodigoSAP());
				titulo.setFechaInicio(dto.getTitulos().get(xTitulos).getFechaInicio());
				titulo.setSubnumero(dto.getTitulos().get(xTitulos).getSubNumero());
				titulo.setVUAA(dto.getTitulos().get(xTitulos).getVuAA());
				titulo.setVUMM(dto.getTitulos().get(xTitulos).getVuMM());
				params.getRegistro().add(titulo);
			}//End for(int xTitulos=0; xTitulos < lnuTotalTitulos; xTitulos++)
			
			//--Llamado a WS SAP. Interfaz 29.
			DTVidaUtilRes responseAjusteVU = new DTVidaUtilRes();
			LOG.debug ( "                Url Srv. Ajuste VU Activo Fijo: " + this.getUrlServicio("29") );
			
			//--REAL CODE
			responseAjusteVU = (DTVidaUtilRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("29"), params);
			
			//TEST
			//1.
			//responseAjusteVU = null;
			
			//2.
			/*
			DTVidaUtilRes.Registro resp1 = new DTVidaUtilRes.Registro();
			resp1.setIDSAP("1");
			resp1.setStatus("NO_OK");
			resp1.setSubnumero("0001");
			responseAjusteVU.getRegistro().add(resp1);
			*/
			
			//3.
			/*
			DTVidaUtilRes.Registro resp1 = new DTVidaUtilRes.Registro();
			resp1.setIDSAP("1");
			resp1.setStatus("OK");
			resp1.setSubnumero("0001");
			responseAjusteVU.getRegistro().add(resp1);
			*/
			
			if(responseAjusteVU != null && responseAjusteVU.getRegistro() != null && responseAjusteVU.getRegistro().size() > 0)
			{
				/*
				 * Codigo multiple original OK, se comenta porque por ahora se ocupara el codigo estandar de los dems metodos donde se supone 
				 * que se entrega solo uno
				//-- Recorrer los resultados obtenidos
				int lnuTitulosActualizados = responseAjusteVU.getRegistro().size();
				
				LOG.info("    Total titulos procesados SAP: " + lnuTitulosActualizados);
				
				LOG.info(" ");
				LOG.info("        [INI] Detalle respuesta devuelta por SAP [Ajuste VU Activo Fijo]:");
				for(int xTitulos = 0; xTitulos < lnuTitulosActualizados; xTitulos++)
				{
					RespSAPCambiaVUAFijoDTO respAjusteVUAF = new RespSAPCambiaVUAFijoDTO();
					respAjusteVUAF.setCodigoSAP(responseAjusteVU.getRegistro().get(xTitulos).getIDSAP());
					respAjusteVUAF.setStatus(responseAjusteVU.getRegistro().get(xTitulos).getStatus());
					respAjusteVUAF.setSubnumero(responseAjusteVU.getRegistro().get(xTitulos).getSubnumero());
					
					LOG.info("            <CodigoSAP:["+responseAjusteVU.getRegistro().get(xTitulos).getIDSAP()+"], Status:["+responseAjusteVU.getRegistro().get(xTitulos).getStatus()+"], Subnumero:["+responseAjusteVU.getRegistro().get(xTitulos).getSubnumero()+"]>");
					
					afs.add(respAjusteVUAF);
				}
				LOG.info("        [FIN] Detalle respuesta devuelta por SAP [Ajuste VU Activo Fijo]:");
				LOG.info(" ");
				
				
				if(lnuTitulosActualizados == 1)
				{
					resultado.setStatus((responseAjusteVU.getRegistro().get(0).getStatus() != null && responseAjusteVU.getRegistro().get(0).getStatus().length() > 0) ? responseAjusteVU.getRegistro().get(0).getStatus() : "");
				}
				
				resultado.setResultado(true);
				*/
				
				int lnuTitulosProcesados = responseAjusteVU.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Ajuste VU): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPCambiaVUAFijoDTO respSAP = new RespSAPCambiaVUAFijoDTO();
					respSAP.setCodigoSAP(responseAjusteVU.getRegistro().get(0).getIDSAP());
					respSAP.setStatus(responseAjusteVU.getRegistro().get(0).getStatus());
					respSAP.setSubnumero(responseAjusteVU.getRegistro().get(0).getSubnumero());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Ajuste VU]: <CodSAP:["+respSAP.getCodigoSAP()+"], Status:["+respSAP.getStatus()+"], Subnumero:["+respSAP.getSubnumero()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
				}
				else
				{
					tf.setInternalCode("DDA-VU-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("modificaVidaUtilAFijoWS");
					resultado.setResultado(false);
				}
			}
			else
			{
				tf.setInternalCode("DDA-VU-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("modificaVidaUtilAFijoWS");
				resultado.setResultado(false);
			}
			
			return resultado;
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-VU-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("modificaVidaUtilAFijoWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-VU-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("modificaVidaUtilAFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-VU-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("modificaVidaUtilAFijoWS");
			resultado.setResultado(false);
			return resultado;
		}

	}
	
	
	public ResultadoCambiaCostoActivoFijoDTO notificarAumentoCostoAFijoWS(ParamAumentoCostoAFijoDTO dto)
	{
		ResultadoCambiaCostoActivoFijoDTO resultado = new ResultadoCambiaCostoActivoFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPCambioCostoAFijoDTO> afs = resultado.getActivosFijos();
		
		try
		{
			DTCapitalizaContenido params = new DTCapitalizaContenido();
			
			//-- Recorrido de Titulos
			int lnuTotalTitulos = dto.getTitulos().size();
			String lstCodigoSAP = ""; 
			String lstAumento = "";
			String lstFechaContabilizacion = ""; 
			String lstFechaInicio = "";
                        String lstSubnumero = "";
			
			for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
			{
				lstCodigoSAP = (dto.getTitulos().get(xTitulo).getCodigoSAP() != null && dto.getTitulos().get(xTitulo).getCodigoSAP().length() > 0) ? dto.getTitulos().get(xTitulo).getCodigoSAP(): ""; 
				lstAumento = (dto.getTitulos().get(xTitulo).getAumento() != null && dto.getTitulos().get(xTitulo).getAumento().length() > 0) ? dto.getTitulos().get(xTitulo).getAumento(): "";
				lstFechaInicio = (dto.getTitulos().get(xTitulo).getFechaInicio() != null && dto.getTitulos().get(xTitulo).getFechaInicio().length() > 0) ? dto.getTitulos().get(xTitulo).getFechaInicio(): "";
				lstFechaContabilizacion = (dto.getTitulos().get(xTitulo).getFechaContabilizacion() != null && dto.getTitulos().get(xTitulo).getFechaContabilizacion().length() > 0) ? dto.getTitulos().get(xTitulo).getFechaContabilizacion(): "";
				lstSubnumero = (dto.getTitulos().get(xTitulo).getSubnumero()!= null && dto.getTitulos().get(xTitulo).getSubnumero().length() > 0) ? dto.getTitulos().get(xTitulo).getSubnumero(): "0099";
				
				DTCapitalizaContenido.Registro titulo = new DTCapitalizaContenido.Registro();
				titulo.setCodigoSAP(lstCodigoSAP);
                                LOG.info("                Codigo SAP: " + lstCodigoSAP);
				titulo.setAumentoValor(lstAumento);
                                LOG.info("                Aumento: " + lstAumento);
				titulo.setFechaInicio(lstFechaInicio);
                                LOG.info("                Fecha inicio: " + lstFechaInicio);
				titulo.setFechaContabilizacion(lstFechaContabilizacion);
                                LOG.info("                Fecha Contabilizacion: " + lstFechaContabilizacion);
                                titulo.setSUBNUMERO(lstSubnumero);
                                LOG.info("                Subnumero: " + lstSubnumero);
				params.getRegistro().add(titulo);
			}//Ends for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
			
			//-- Llamado al WS de SAP. Interfaz 19
			DTCapitalizaContenidoRes responseCambiaCosto = new DTCapitalizaContenidoRes();
			LOG.debug ( "        Url Srv. Aumento Costo Activo Fijo: " + this.getUrlServicio("19") );
			
			//--REAL CODE
			responseCambiaCosto = (DTCapitalizaContenidoRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("19"), params);
			
			//---[INI] Test -----
			//--1.
			//responseCambiaCosto = null;
			
			//2.
			/*
			DTCapitalizaContenidoRes.Respuesta resp1 = new DTCapitalizaContenidoRes.Respuesta();
			resp1.setCodigoSAP("700000051500");
			resp1.setStatus("OK");
			resp1.setSubno("0001");
			responseCambiaCosto.getRespuesta().add(resp1);
			*/
			
			
			//3.
			/*
			DTCapitalizaContenidoRes.Respuesta resp2 = new DTCapitalizaContenidoRes.Respuesta();
			resp2.setCodigoSAP("700000004146");
			resp2.setStatus("NO_OK");
			resp2.setSubno("0010");
			responseCambiaCosto.getRespuesta().add(resp2);
			*/
			//---[FIN] Test -----
			
			
			if(responseCambiaCosto != null && responseCambiaCosto.getRespuesta() != null && responseCambiaCosto.getRespuesta().size() > 0)
			{
				/*
				 * Codigo multiple original OK, se comenta porque por ahora se ocupara el codigo estandar de los demas metodos donde se supone
				 * que se entregara uno solo
				int lnuTitulosNotificados = responseCambiaCosto.getRespuesta().size();
				LOG.info("    Total titulos procesados SAP: " + lnuTitulosNotificados);
				
				LOG.info(" ");
				LOG.info("        [INI] Detalle respuesta devuelta por SAP [notificarAumentoCostoAFijoWS]:");
				for(int xTitulos = 0; xTitulos < lnuTitulosNotificados; xTitulos++)
				{
					RespSAPCambioCostoAFijoDTO respAC = new RespSAPCambioCostoAFijoDTO(); 
					respAC.setCodigoSAP(responseCambiaCosto.getRespuesta().get(xTitulos).getCodigoSAP());
					respAC.setSubNumero(responseCambiaCosto.getRespuesta().get(xTitulos).getSubno());
					respAC.setStatus(responseCambiaCosto.getRespuesta().get(xTitulos).getStatus());
					LOG.info("            <CodSAP:["+responseCambiaCosto.getRespuesta().get(xTitulos).getCodigoSAP()+"], Subnumero:["+responseCambiaCosto.getRespuesta().get(xTitulos).getSubno()+"], Status:["+responseCambiaCosto.getRespuesta().get(xTitulos).getStatus()+"]>");
					
					afs.add(respAC);
				}
				
				LOG.info("        [FIN] Detalle respuesta devuelta por SAP [notificarAumentoCostoAFijoWS]:");
				LOG.info(" ");
				
				resultado.setResultado(true);
			*/
			
				int lnuTitulosProcesados = responseCambiaCosto.getRespuesta().size();
				LOG.info("                Total titulos procesados SAP(Aumento Costo): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPCambioCostoAFijoDTO respAC = new RespSAPCambioCostoAFijoDTO(); 
					respAC.setCodigoSAP(responseCambiaCosto.getRespuesta().get(0).getCodigoSAP());
					respAC.setSubNumero(responseCambiaCosto.getRespuesta().get(0).getSubno());
					respAC.setStatus(responseCambiaCosto.getRespuesta().get(0).getStatus());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Aumento costo]: <CodSAP:["+respAC.getCodigoSAP()+"], Status:["+respAC.getStatus()+"], Subnumero:["+respAC.getSubNumero()+"]> ");
					
					afs.add(respAC);
					resultado.setResultado(true);
				}
				else
				{
					tf.setInternalCode("DDA-AC-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("notificarAumentoCostoAFijoWS");
					resultado.setResultado(false);
				}
				
			}//Ends if(responseCambiaCosto != null && responseCambiaCosto.getRespuesta() != null && responseCambiaCosto.getRespuesta().size() > 0)
			else
			{
				tf.setInternalCode("DDA-AC-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("notificarAumentoCostoAFijoWS");
				resultado.setResultado(false);
			}
			
			return resultado;
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-AC-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("notificarAumentoCostoAFijoWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-AC-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("notificarAumentoCostoAFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-AC-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("notificarAumentoCostoAFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	
	public ResultadoCambiaCostoActivoFijoDTO notificarDisminucionCostoAFijoWS(ParamDisminucionCostoAFijoDTO dto)
	{
		ResultadoCambiaCostoActivoFijoDTO resultado = new ResultadoCambiaCostoActivoFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPCambioCostoAFijoDTO> afs = resultado.getActivosFijos();
		
		try
		{
			DTDisminucionValor params = new DTDisminucionValor();
			
			//--Titulos
			int lnuTotalTitulos = dto.getTitulos().size();
			String lstCodigoSAP = "";
			String lstSubNumero = "";
			String lstDisminucion = "";
			String lstFechaContabilizacion = "";
			
			for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
			{
				lstCodigoSAP = (dto.getTitulos().get(xTitulo).getCodigoSAP() != null && dto.getTitulos().get(xTitulo).getCodigoSAP().length() > 0) ? dto.getTitulos().get(xTitulo).getCodigoSAP(): "";
				lstSubNumero = (dto.getTitulos().get(xTitulo).getSubNumero() != null && dto.getTitulos().get(xTitulo).getSubNumero().length() > 0) ? dto.getTitulos().get(xTitulo).getSubNumero(): "";
				lstDisminucion = (dto.getTitulos().get(xTitulo).getDisminucion() != null && dto.getTitulos().get(xTitulo).getDisminucion().length() > 0) ? dto.getTitulos().get(xTitulo).getDisminucion(): "";
				lstFechaContabilizacion = (dto.getTitulos().get(xTitulo).getFechaContabilizacion() != null && dto.getTitulos().get(xTitulo).getFechaContabilizacion().length() > 0) ? dto.getTitulos().get(xTitulo).getFechaContabilizacion(): "";
				
				DTDisminucionValor.Registro titulo = new DTDisminucionValor.Registro();
				titulo.setCodigoSAP(lstCodigoSAP);
				titulo.setFechaContab(lstFechaContabilizacion);
				titulo.setFechaInicio(lstFechaContabilizacion);
				titulo.setImporte(lstDisminucion);
				titulo.setSubnumero(lstSubNumero);
				params.getRegistro().add(titulo);
				
			}//Ends for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
			
			//--Llamado al WS de SAP. Interfaz 51
			DTDisminucionValorRes responseDisminuyeCosto = new DTDisminucionValorRes();
			LOG.debug ( "        Url Srv. Disminucion Costo Activo Fijo: " + this.getUrlServicio("51") );
			
			//--REAL CODE
			responseDisminuyeCosto = (DTDisminucionValorRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("51"), params);
			
			//---[INI] Test -----
			//--1.
			//responseDisminuyeCosto = null;
			
			//--2.
			/*
			DTDisminucionValorRes.Registro resp1 = new DTDisminucionValorRes.Registro();
			resp1.setCodigoSAP("700000004148");
			resp1.setStatus("OK");
			resp1.setSubnumero("00010");
			responseDisminuyeCosto.getRegistro().add(resp1);
			*/
			
			//--3.
			/*
			DTDisminucionValorRes.Registro resp1 = new DTDisminucionValorRes.Registro();
			resp1.setCodigoSAP("700000004148");
			resp1.setStatus("NO_OK");
			resp1.setSubnumero("00010");
			responseDisminuyeCosto.getRegistro().add(resp1);
			*/
			//---[FIN] Test -----
			
			if(responseDisminuyeCosto != null && responseDisminuyeCosto.getRegistro() != null && responseDisminuyeCosto.getRegistro().size() > 0)
			{
				/*
				 * Codigo multiple original OK, se comenta porque por ahora se ocupara el codigo estandar de los demas metodos donde se supone
				 * que se entregara uno solo
				int lnuTitulosNotificados = responseDisminuyeCosto.getRegistro().size();
				LOG.info("    Total titulos procesados SAP: " + lnuTitulosNotificados);
				
				LOG.info(" ");
				LOG.info("        [INI] Detalle respuesta devuelta por SAP [notificarDisminucionCostoAFijoWS]:");
				for(int xTitulos = 0; xTitulos < lnuTitulosNotificados; xTitulos++)
				{
					RespSAPCambioCostoAFijoDTO respDC = new RespSAPCambioCostoAFijoDTO(); 
					respDC.setCodigoSAP(responseDisminuyeCosto.getRegistro().get(xTitulos).getCodigoSAP());
					respDC.setStatus(responseDisminuyeCosto.getRegistro().get(xTitulos).getStatus());
					respDC.setSubNumero(responseDisminuyeCosto.getRegistro().get(xTitulos).getSubnumero());
					LOG.info("            <CodSAP:["+responseDisminuyeCosto.getRegistro().get(xTitulos).getCodigoSAP()+"], Status:["+responseDisminuyeCosto.getRegistro().get(xTitulos).getStatus()+"], Subnumero:["+responseDisminuyeCosto.getRegistro().get(xTitulos).getSubnumero()+"]>");
					
					afs.add(respDC);
				}
				
				LOG.info("        [FIN] Detalle respuesta devuelta por SAP [notificarDisminucionCostoAFijoWS]:");
				LOG.info(" ");
				
				resultado.setResultado(true);
				*/
				
				int lnuTitulosProcesados = responseDisminuyeCosto.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Disminucion Costo): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPCambioCostoAFijoDTO respDC = new RespSAPCambioCostoAFijoDTO(); 
					respDC.setCodigoSAP(responseDisminuyeCosto.getRegistro().get(0).getCodigoSAP());
					respDC.setStatus(responseDisminuyeCosto.getRegistro().get(0).getStatus());
					respDC.setSubNumero(responseDisminuyeCosto.getRegistro().get(0).getSubnumero());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Disminucion costo]: <CodSAP:["+respDC.getCodigoSAP()+"], Status:["+respDC.getStatus()+"], Subnumero:["+respDC.getSubNumero()+"]> ");
					
					afs.add(respDC);
					resultado.setResultado(true);
				}
				else
				{
					tf.setInternalCode("DDA-DC-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("notificarDisminucionCostoAFijoWS");
					resultado.setResultado(false);
				}
			}//Ends if(responseCambiaCosto != null && responseCambiaCosto.getRespuesta() != null && responseCambiaCosto.getRespuesta().size() > 0)	
			else
			{
				tf.setInternalCode("DDA-DC-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("notificarDisminucionCostoAFijoWS");
				resultado.setResultado(false);
			}
			
			return resultado;
			
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-DC-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("notificarDisminucionCostoAFijoWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-DC-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("notificarDisminucionCostoAFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-DC-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("notificarDisminucionCostoAFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
	}
	
	public ResultadoCambiaNombreAFijoDTO cambiaNombreActivoFijoWS(ParamCambiaNombreAFijoDTO dto)
	{
		ResultadoCambiaNombreAFijoDTO resultado = new ResultadoCambiaNombreAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPCambiaNombreActivoFijoDTO> afs = resultado.getActivosFijos();
		
		try
		{
			DTNombreActivoFReq params = new DTNombreActivoFReq();
			
			//--Recorrido de titulos
			int lnuTotalTitulos = dto.getTitulos().size();
			String lstIdActivoFijo = "";
			String lstCodigoDDA = "";
			String lstNuevoNombre = "";
			String lstProgramID = "";
			
			for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
			{
				lstIdActivoFijo = (dto.getTitulos().get(xTitulo).getIdActivoFijo() != null && dto.getTitulos().get(xTitulo).getIdActivoFijo().length() > 0) ? dto.getTitulos().get(xTitulo).getIdActivoFijo(): "";
				lstCodigoDDA = (dto.getTitulos().get(xTitulo).getCodigoDDA() != null && dto.getTitulos().get(xTitulo).getCodigoDDA().length() > 0) ? dto.getTitulos().get(xTitulo).getCodigoDDA(): "";
				lstNuevoNombre = (dto.getTitulos().get(xTitulo).getNuevoNombre() != null && dto.getTitulos().get(xTitulo).getNuevoNombre().length() > 0) ? dto.getTitulos().get(xTitulo).getNuevoNombre(): "";
				lstProgramID = (dto.getTitulos().get(xTitulo).getProgramID() != null && dto.getTitulos().get(xTitulo).getProgramID().length() > 0) ? dto.getTitulos().get(xTitulo).getProgramID(): "";
				
				DTNombreActivoFReq.Registro registro = new DTNombreActivoFReq.Registro();
				registro.setIDActivoFSAP(lstIdActivoFijo);
				registro.setIDDDA(lstCodigoDDA);
				registro.setNuevoNombre(strManager.extraerPrimerosCaracteres(lstNuevoNombre, 50));
				registro.setProgramID(lstProgramID);
				params.getRegistro().add(registro);
				
			}//Ends for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
			
			//--Llamado a WS SAP. Interfaz 20
			DTNombreActivoFRes responseCambiaNombreAFijo = new DTNombreActivoFRes();
			LOG.debug ( "                Url Srv. Modificar AF: " + this.getUrlServicio("20") );
			
			//--REAL CODE
			responseCambiaNombreAFijo = (DTNombreActivoFRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("20"), params);
			
			//--TEST
			//1.
			//responseCambiaNombreAFijo = null;
			
			//2.
			/*
			DTNombreActivoFRes.Respuesta resp1 = new DTNombreActivoFRes.Respuesta();
			resp1.setIDSAP("1234567");
			resp1.setStatus("NO_OK");
			responseCambiaNombreAFijo.getRespuesta().add(resp1);
			*/
			
			//3.
			/*
			DTNombreActivoFRes.Respuesta resp1 = new DTNombreActivoFRes.Respuesta();
			resp1.setIDSAP("1234567");
			resp1.setStatus("OK");
			responseCambiaNombreAFijo.getRespuesta().add(resp1);
			*/
			
			if(responseCambiaNombreAFijo != null && responseCambiaNombreAFijo.getRespuesta() != null && responseCambiaNombreAFijo.getRespuesta().size() > 0)
			{
				int lnuTitulosProcesados = responseCambiaNombreAFijo.getRespuesta().size();
				LOG.info("                Total titulos procesados SAP(Modificar AF): " + lnuTitulosProcesados);
				
				
				if(lnuTitulosProcesados == 1)
				{
					/*
					 * Codigo original que traia. No se sabe si estaba validado, ya que esta interfaz se elimino del proceso temporalmente y por lo tanto
					 * no se probo en su totalidad
					DTNombreActivoFRes.Respuesta rSAP = responseCambiaNombreAFijo.getRespuesta().get(0);
					
					LOG.info(" ");
					LOG.info("                [INI] Detalle respuesta devuelta por SAP [Cambia Nombre]:");
					LOG.info("                    <Status:["+rSAP.getStatus()+"]>");
					LOG.info("                    <CodigoSAP:["+rSAP.getIDSAP()+"]>");
					LOG.info("                [FIN] Detalle respuesta devuelta por SAP [Cambia Nombre]:");
					LOG.info(" ");
					
					resultado.setStatus((rSAP.getStatus() != null && rSAP.getStatus().length() > 0) ? rSAP.getStatus() : "");
					resultado.setResultado(true);
					*/
					
					RespSAPCambiaNombreActivoFijoDTO respCN = new RespSAPCambiaNombreActivoFijoDTO();
					respCN.setCodigoSAP(responseCambiaNombreAFijo.getRespuesta().get(0).getIDSAP());
					respCN.setStatus(responseCambiaNombreAFijo.getRespuesta().get(0).getStatus());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Cambio Nombre]: <CodSAP:["+respCN.getCodigoSAP()+"], Status:["+respCN.getStatus()+"]> ");
					
					afs.add(respCN);
					resultado.setResultado(true);
				}
				else
				{
					tf.setInternalCode("DDA-CNAF-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("cambiaNombreActivoFijoWS");
					resultado.setResultado(false);
				}
				
				
			}//Ends if(responseCambiaNombreAFijo != null && responseCambiaNombreAFijo.getRespuesta() != null && responseCambiaNombreAFijo.getRespuesta().size() > 0)
			else
			{
				tf.setInternalCode("DDA-CNAF-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("cambiaNombreActivoFijoWS");
				resultado.setResultado(false);
			}
			
			return resultado;
			
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-CNAF-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("cambiaNombreActivoFijoWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-CNAF-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("cambiaNombreActivoFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-CNAF-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("cambiaNombreActivoFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	private String getUrlServicio(String pNumInterfaz)
	{
		String urlServicio = env.getProperty(AMBIENTE+".clientws.interface.i"+pNumInterfaz).replaceAll("%servidor%", SERVIDOR).replaceAll("%puerto%", PUERTO);
                LOG.info("************************************** getUrl: " + urlServicio);
                LOG.info("************************************** pNumInterfaz: " + pNumInterfaz);
                
	    return urlServicio;
	}
}
