package mx.com.amx.mx.dda.crn.dao;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import mx.com.amx.mx.dda.crn.dto.ContratoSAPSubnumDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.crn.dto.CrnClienteSAPDTO;
import mx.com.amx.mx.dda.crn.dto.TerminosComercialesDTO;
import mx.com.amx.mx.dda.crn.dto.VidaUtilDTO;

@Component
@Qualifier("ddaclienteSAPDAO")
public class DDAClienteSAPDAO implements IDDAClienteSAPDAO {

    private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
    private final String ARCHIVO_PROPIEDADES = "/general.properties";
    Properties env = new Properties();
    private JdbcTemplate jdbcTemplate;

    private String AMBIENTE;
    private String PUEDE_EJECUTAR;
    private String NOTIFICACION_INICIADO;
    private String MODULO;

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public DDAClienteSAPDAO() {
        super();
        try {
            env.load(this.getClass().getResourceAsStream(ARCHIVO_PROPIEDADES));
            AMBIENTE = env.getProperty("ambiente");
            PUEDE_EJECUTAR = env.getProperty("puede.ejecutar");
            NOTIFICACION_INICIADO = env.getProperty("notificacion.iniciado");
            MODULO = env.getProperty("modulo");

        } catch (Exception e) {
            LOG.error(">Constructor[" + this.getClass().getSimpleName() + "] Ocurrio un error : " + e.getMessage());
        }

    }

    @Override
    public boolean verificaEjecutandoseProcesoNotificacion() throws Exception {
        boolean lboEjecutando = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();

        try {
            sb.append("select DECODE(VALOR, 1,'INICIADO', 0,'STANDBY', 'STANDBY') as VALOR_TEXTO ");
            sb.append("from DLA_C_PARAMETRO ");
            sb.append("where CLAVE = ? AND MODULO = ? ");

            LOG.debug(">Sql_D [verificaEjecutandoseProcesoNotificacion]:" + sb.toString());

            final String lstSQL = sb.toString();
            qryParams.add(NOTIFICACION_INICIADO);
            qryParams.add(MODULO);

            String lstValor = (String) jdbcTemplate.queryForObject(lstSQL, qryParams.toArray(), String.class);

            if (lstValor.equalsIgnoreCase("INICIADO")) {
                lboEjecutando = true;
            }

        } catch (EmptyResultDataAccessException er) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::verificaEjecutandoseProcesoNotificacion]: No se encontraron registros coincidentes con la clave especificada. " + er.getMessage());
            throw new Exception("No se encontraron registros coincidentes con la clave especificada");

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::verificaEjecutandoseProcesoNotificacion]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return lboEjecutando;
    }

    @Override
    public boolean puedeIniciarProcesoNotificacion() throws Exception {
        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        
        Integer day = 27;

        try {
            sbD.append("SELECT NVL(MAX(extract(day from fecha)), 27) FROM DDA_T_BLOQUEO_CIERRESAP ");
            sbD.append("WHERE extract(month from sysdate) = extract(month from fecha) ");
            sbD.append("AND extract(year from sysdate) = extract(year from fecha) ");

            day = (Integer) jdbcTemplate.queryForObject(sbD.toString(), qryParams.toArray(), Integer.class);
        } catch (Exception er) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::verificaEjecutandoseProcesoNotificacion]: Error en consulta de fecha de bloqueo. " + er.getMessage());
            throw new Exception("Error en la consulta del dia de bloqueo");
        }

        try {
            Calendar today = Calendar.getInstance();
            if (today.get(Calendar.DAY_OF_MONTH) < day) {
                //--Debug
                sbD.append("select ");
                sbD.append("NVL(VALOR,'0') as VALOR ");
                sbD.append("from ");
                sbD.append("DLA_C_PARAMETRO ");
                sbD.append("where ");
                sbD.append("CLAVE = '" + PUEDE_EJECUTAR + "' ");
                sbD.append("AND MODULO = '" + MODULO + "' ");
                LOG.debug(">Sql_D [puedeIniciarProcesoNotificacion]:" + sbD.toString());

                //--Ejecucion
                sb.append("select ");
                sb.append("NVL(VALOR,'0') as VALOR ");
                sb.append("from ");
                sb.append("DLA_C_PARAMETRO ");
                sb.append("where ");
                sb.append("CLAVE = ? ");
                sb.append("AND MODULO = ? ");

                final String lstSQL = sb.toString();
                qryParams.add(PUEDE_EJECUTAR);
                qryParams.add(MODULO);

                String lstValor = (String) jdbcTemplate.queryForObject(lstSQL, qryParams.toArray(), String.class);

                if (lstValor.equals("1")) {
                    resultado = true;
                }
            } else {
                LOG.info("Fecha de bloqueo a partir del da " + day + " hasta fin de mes.");
            }

        } catch (EmptyResultDataAccessException er) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::puedeIniciarProcesoNotificacion]: No se encontraron registros coincidentes con la clave especificada. " + er.getMessage());
            throw new Exception("No se encontraron registros coincidentes con la clave especificada");

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::puedeIniciarProcesoNotificacion]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    @Override
    public boolean updateEjecutandoseProcesoNotificacion(String pstValor) throws Exception {
        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        int lnuRowsUpdate = 0;

        try {
            String lstValor = (pstValor != null && pstValor.length() > 0) ? pstValor : "";

            //--Debug
            sbD.append("update ");
            sbD.append("DLA_C_PARAMETRO ");
            sbD.append("set VALOR = " + lstValor + " ");
            sbD.append("where ");
            sbD.append("CLAVE = '" + NOTIFICACION_INICIADO + "' ");
            sbD.append("AND MODULO = '" + MODULO + "' ");
            LOG.debug(">Sql_D [updateEjecutandoseProcesoNotificacion]:" + sbD.toString());

            //--Ejecucion
            sb.append("update ");
            sb.append("DLA_C_PARAMETRO ");
            sb.append("set VALOR = ? ");
            sb.append("where ");
            sb.append("CLAVE = ? ");
            sb.append("AND MODULO = ? ");

            final String lstSQL = sb.toString();
            qryParams.add(lstValor);
            qryParams.add(NOTIFICACION_INICIADO);
            qryParams.add(MODULO);

            lnuRowsUpdate = jdbcTemplate.update(lstSQL, qryParams.toArray());

            if (lnuRowsUpdate > 0) {
                resultado = true;
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::updateEjecutandoseProcesoNotificacion]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    @Override
    public List<CrnClienteSAPDTO> obtenerRegistrosCandidatos(String pstInterfaz) throws Exception {
        List<CrnClienteSAPDTO> resultado = new ArrayList<CrnClienteSAPDTO>();
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();

        try {
            //String lstInterfaz = (pstInterfaz != null && pstInterfaz.trim().length() > 0) ? pstInterfaz : "";

            //-- Debug
            sbD.append("select ");
            sbD.append("ID_CRN, ");
            sbD.append("to_char(FECHA_REGISTRO,'dd/mm/yyyy') as FECHA_REGISTRO, ");
            sbD.append("ID_CONTRATO_ORIGINAL, ");
            sbD.append("ID_CONTRATO, ");
            sbD.append("INTERFAZ, ");
            sbD.append("CODIGO_SAP, ");
            sbD.append("AUMENTO, ");
            sbD.append("DISMINUCION, ");
            sbD.append("CODIGO_SAPANT, ");
            sbD.append("DESC_NUEVO, ");
            sbD.append("CODIGO_DDA, ");
            sbD.append("to_char(FECHA_INICIO,'yyyymmdd') as FECHA_INICIO, ");
            sbD.append("PROGRAM_ID, ");
            sbD.append("SUBNUMERO, ");
            sbD.append("VUAA, ");
            sbD.append("VUMM, ");
            sbD.append("to_char(FECHA_CONTABILIZACION,'yyyymmdd') as FECHA_CONTABILIZACION, ");
            sbD.append("ID_TITULO_CNT, ");
            sbD.append("ID_TITULO_CNTORIG, ");
            sbD.append("ID_REGISTRO_SAP, ");
            sbD.append("R_CODIGO_SAP, ");
            sbD.append("R_STATUS, ");
            sbD.append("R_SUBNUMERO, ");
            sbD.append("R_IDDDA, ");
            sbD.append("to_char(FECHA_INTENTO,'dd/mm/yyyy') as FECHA_INTENTO, ");
            sbD.append("to_char(FECHA_ENVIO_OK,'dd/mm/yyyy') as FECHA_ENVIO_OK, ");
            sbD.append("NVL(EJECUTA29,'0') as EJECUTA29, ");
            sbD.append("to_char(FECHA_FIN,'dd/mm/yyyy') as FECHA_FIN ");
            sbD.append("from ");
            sbD.append("DDA_T_CRN_CLIENTESAP ");
            sbD.append("where ");
            sbD.append("INTERFAZ = " + pstInterfaz + " ");
            sbD.append("and to_date(FECHA_CONTABILIZACION,'dd/mm/yyyy') <= to_date(sysdate,'dd/mm/yyyy') ");
            sbD.append("and FECHA_ENVIO_OK is null ");
            LOG.debug("    >Sql_D [obtenerRegistrosCandidatos]:" + sbD.toString());

            //--Ejecucion
            sb.append("select ");
            sb.append("ID_CRN, ");
            sb.append("to_char(FECHA_REGISTRO,'dd/mm/yyyy') as FECHA_REGISTRO, ");
            sb.append("ID_CONTRATO_ORIGINAL, ");
            sb.append("ID_CONTRATO, ");
            sb.append("INTERFAZ, ");
            sb.append("CODIGO_SAP, ");
            sb.append("AUMENTO, ");
            sb.append("DISMINUCION, ");
            sb.append("CODIGO_SAPANT, ");
            sb.append("DESC_NUEVO, ");
            sb.append("CODIGO_DDA, ");
            sb.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO, ");
            sb.append("PROGRAM_ID, ");
            sb.append("SUBNUMERO, ");
            sb.append("VUAA, ");
            sb.append("VUMM, ");
            sb.append("to_char(FECHA_CONTABILIZACION,'dd/mm/yyyy') as FECHA_CONTABILIZACION, ");
            sb.append("ID_TITULO_CNT, ");
            sb.append("ID_TITULO_CNTORIG, ");
            sb.append("ID_REGISTRO_SAP, ");
            sb.append("R_CODIGO_SAP, ");
            sb.append("R_STATUS, ");
            sb.append("R_SUBNUMERO, ");
            sb.append("R_IDDDA, ");
            sb.append("to_char(FECHA_INTENTO,'dd/mm/yyyy') as FECHA_INTENTO, ");
            sb.append("to_char(FECHA_ENVIO_OK,'dd/mm/yyyy') as FECHA_ENVIO_OK, ");
            sb.append("NVL(EJECUTA29,'0') as EJECUTA29, ");
            sb.append("to_char(FECHA_FIN,'dd/mm/yyyy') as FECHA_FIN ");
            sb.append("from ");
            sb.append("DDA_T_CRN_CLIENTESAP ");
            sb.append("where ");
            sb.append("INTERFAZ = ? ");
            sb.append("and to_date(FECHA_CONTABILIZACION,'dd/mm/yyyy') <= to_date(sysdate,'dd/mm/yyyy') ");
            sb.append("and FECHA_ENVIO_OK is null ");

            final String lstSQL = sb.toString();
            qryParams.add(pstInterfaz);

            resultado = (ArrayList<CrnClienteSAPDTO>) getJdbcTemplate().query(lstSQL, qryParams.toArray(), new BeanPropertyRowMapper<CrnClienteSAPDTO>(CrnClienteSAPDTO.class));

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerRegistrosCandidatos]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }

    @Override
    public boolean actualizaCrnClienteSAP(CrnClienteSAPDTO dto) throws Exception {
        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        int lnuRowsUpdate = 0;

        String lstIdCRN = (dto.getID_CRN() != null && dto.getID_CRN().trim().length() > 0) ? dto.getID_CRN() : "VACIO";
        String lstRCodigoSAP = (dto.getR_CODIGO_SAP() != null && dto.getR_CODIGO_SAP().trim().length() > 0) ? dto.getR_CODIGO_SAP() : "VACIO";
        String lstRStatus = (dto.getR_STATUS() != null && dto.getR_STATUS().trim().length() > 0) ? dto.getR_STATUS() : "VACIO";
        String lstRSubnumero = (dto.getR_SUBNUMERO() != null && dto.getR_SUBNUMERO().trim().length() > 0) ? dto.getR_SUBNUMERO() : "VACIO";
        String lstIdDDA = (dto.getR_IDDDA() != null && dto.getR_IDDDA().trim().length() > 0) ? dto.getR_IDDDA() : "VACIO";
        String lstFechaEnvioOK = (dto.getFECHA_ENVIO_OK() != null && dto.getFECHA_ENVIO_OK().trim().length() > 0) ? dto.getFECHA_ENVIO_OK() : "VACIO";

        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());

        try {
            //--Debug
            sbD.append("update DDA_T_CRN_CLIENTESAP ");
            sbD.append("set ");
            sbD.append("FECHA_INTENTO = SYSDATE ");

            if (!lstRCodigoSAP.equalsIgnoreCase("VACIO")) {
                sbD.append(",R_CODIGO_SAP = '" + lstRCodigoSAP + "' ");
            }
            if (!lstRStatus.equalsIgnoreCase("VACIO")) {
                sbD.append(",R_STATUS='" + lstRStatus + "' ");
            }
            if (!lstRSubnumero.equalsIgnoreCase("VACIO")) {
                sbD.append(",R_SUBNUMERO='" + lstRSubnumero + "' ");
            }
            if (!lstIdDDA.equalsIgnoreCase("VACIO")) {
                sbD.append(",R_IDDDA='" + lstIdDDA + "' ");
            }
            if (!lstFechaEnvioOK.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_ENVIO_OK=to_date('" + lstFechaEnvioOK + "','dd/mm/yyyy') ");
            }

            sbD.append("where ");
            sbD.append("ID_CRN = " + lstIdCRN + " ");
            LOG.debug("    >Sql_D [actualizaCrnClienteSAP]:" + sbD.toString());

            //--Ejecucion
            sb.append("update DDA_T_CRN_CLIENTESAP ");
            sb.append("set ");
            sb.append("FECHA_INTENTO = SYSDATE ");

            if (!lstRCodigoSAP.equalsIgnoreCase("VACIO")) {
                sb.append(",R_CODIGO_SAP = ? ");
            }
            if (!lstRStatus.equalsIgnoreCase("VACIO")) {
                sb.append(",R_STATUS=? ");
            }
            if (!lstRSubnumero.equalsIgnoreCase("VACIO")) {
                sb.append(",R_SUBNUMERO=? ");
            }
            if (!lstIdDDA.equalsIgnoreCase("VACIO")) {
                sb.append(",R_IDDDA=? ");
            }
            if (!lstFechaEnvioOK.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_ENVIO_OK=? ");
            }

            sb.append("where ");
            sb.append("ID_CRN = ? ");

            //--Valores query
            if (!lstRCodigoSAP.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstRCodigoSAP);
            }
            if (!lstRStatus.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstRStatus);
            }
            if (!lstRSubnumero.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstRSubnumero);
            }
            if (!lstIdDDA.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdDDA);
            }
            if (!lstFechaEnvioOK.equalsIgnoreCase("VACIO")) {
                lobTSFecha.setTime(df.parse(lstFechaEnvioOK + " 12:00:00").getTime());
                qryParams.add(lobTSFecha);
            }

            qryParams.add(lstIdCRN);

            final String lstSQL = sb.toString();
            lnuRowsUpdate = jdbcTemplate.update(lstSQL, qryParams.toArray());

            if (lnuRowsUpdate > 0) {
                resultado = true;
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::actualizaCrnClienteSAP]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    @Override
    public boolean actualizaContratoTituloFull(ContratoTituloDTO dto) throws Exception {
        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        int lnuRowsUpdate = 0;

        String lstIdTituloCnt = (dto.getID_TITULO_CNT() != null && dto.getID_TITULO_CNT().trim().length() > 0) ? dto.getID_TITULO_CNT() : "VACIO";
        String lstDescTitulo = (dto.getDESC_TITULO() != null && dto.getDESC_TITULO().trim().length() > 0) ? dto.getDESC_TITULO() : "VACIO";
        String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "VACIO";
        String lstIdLista = (dto.getID_LISTA() != null && dto.getID_LISTA().trim().length() > 0) ? dto.getID_LISTA() : "VACIO";
        String lstIdTitulo = (dto.getID_TITULO() != null && dto.getID_TITULO().trim().length() > 0) ? dto.getID_TITULO() : "VACIO";
        String lstIdCategoria = (dto.getID_CATEGORIA() != null && dto.getID_CATEGORIA().trim().length() > 0) ? dto.getID_CATEGORIA() : "VACIO";
        String lstFechaInicio = (dto.getFECHA_INICIO() != null && dto.getFECHA_INICIO().trim().length() > 0) ? dto.getFECHA_INICIO() : "VACIO";
        String lstFechaFin = (dto.getFECHA_FIN() != null && dto.getFECHA_FIN().trim().length() > 0) ? dto.getFECHA_FIN() : "VACIO";
        String lstBriefCase = (dto.getBRIEFCASE() != null && dto.getBRIEFCASE().trim().length() > 0) ? dto.getBRIEFCASE() : "VACIO";
        String lstDto = (dto.getDTO() != null && dto.getDTO().trim().length() > 0) ? dto.getDTO() : "VACIO";
        String lstDtr = (dto.getDTR() != null && dto.getDTR().trim().length() > 0) ? dto.getDTR() : "VACIO";
        String lstIdSap = (dto.getID_SAP() != null && dto.getID_SAP().trim().length() > 0) ? dto.getID_SAP() : "VACIO";
        String lstEstatus = (dto.getESTATUS() != null && dto.getESTATUS().trim().length() > 0) ? dto.getESTATUS() : "VACIO";
        String lstIdTituloCntNvo = (dto.getID_TITULO_CNTNVO() != null && dto.getID_TITULO_CNTNVO().trim().length() > 0) ? dto.getID_TITULO_CNTNVO() : "VACIO";
        String lstHvrd = (dto.getHVRD() != null && dto.getHVRD().trim().length() > 0) ? dto.getHVRD() : "VACIO";
        String lstIdTerritorio = (dto.getID_TERRITORIO() != null && dto.getID_TERRITORIO().trim().length() > 0) ? dto.getID_TERRITORIO() : "VACIO";
        String lstIdRelease = (dto.getID_RELEASE() != null && dto.getID_RELEASE().trim().length() > 0) ? dto.getID_RELEASE() : "VACIO";
        String lstIdTituloCntOrig = (dto.getID_TITULO_CNTORIG() != null && dto.getID_TITULO_CNTORIG().trim().length() > 0) ? dto.getID_TITULO_CNTORIG() : "VACIO";
        String lstFechaNotifSap = (dto.getFECHA_NOTIFSAP() != null && dto.getFECHA_NOTIFSAP().trim().length() > 0) ? dto.getFECHA_NOTIFSAP() : "VACIO";
        String lstCosto = (dto.getCOSTO() != null && dto.getCOSTO().trim().length() > 0) ? dto.getCOSTO() : "VACIO";
        String lstVidaUtil = (dto.getVIDA_UTIL() != null && dto.getVIDA_UTIL().trim().length() > 0) ? dto.getVIDA_UTIL() : "VACIO";
        String lstAjustoTitulo = (dto.getAJUSTO_TITULO() != null && dto.getAJUSTO_TITULO().trim().length() > 0) ? dto.getAJUSTO_TITULO() : "VACIO";
        String lstAjustoValor = (dto.getAJUSTO_VALOR() != null && dto.getAJUSTO_VALOR().trim().length() > 0) ? dto.getAJUSTO_VALOR() : "VACIO";
        String lstAjustoVU = (dto.getAJUSTO_VU() != null && dto.getAJUSTO_VU().trim().length() > 0) ? dto.getAJUSTO_VU() : "VACIO";
        String lstBajaPerdida = (dto.getBAJA_PERDIDA() != null && dto.getBAJA_PERDIDA().trim().length() > 0) ? dto.getBAJA_PERDIDA() : "VACIO";
        String lstFechaAjustoTitulo = (dto.getFECHA_AJUSTOTITULO() != null && dto.getFECHA_AJUSTOTITULO().trim().length() > 0) ? dto.getFECHA_AJUSTOTITULO() : "VACIO";
        String lstFechaAjustoValor = (dto.getFECHA_AJUSTOVALOR() != null && dto.getFECHA_AJUSTOVALOR().trim().length() > 0) ? dto.getFECHA_AJUSTOVALOR() : "VACIO";
        String lstFechaAjustoVU = (dto.getFECHA_AJUSTOVU() != null && dto.getFECHA_AJUSTOVU().trim().length() > 0) ? dto.getFECHA_AJUSTOVU() : "VACIO";
        String lstFechaBaja = (dto.getFECHA_BAJA() != null && dto.getFECHA_BAJA().trim().length() > 0) ? dto.getFECHA_BAJA() : "VACIO";
        String lstIdSapAnt = (dto.getID_SAP_ANT() != null && dto.getID_SAP_ANT().trim().length() > 0) ? dto.getID_SAP_ANT() : "VACIO";
        String lstIdTituloCntAnt = (dto.getID_TITULO_CNTANT() != null && dto.getID_TITULO_CNTANT().trim().length() > 0) ? dto.getID_TITULO_CNTANT() : "VACIO";
        String lstFechaWS = (dto.getFECHA_WS() != null && dto.getFECHA_WS().trim().length() > 0) ? dto.getFECHA_WS() : "VACIO";
        String lstNotaCredito = (dto.getNOTA_CREDITO() != null && dto.getNOTA_CREDITO().trim().length() > 0) ? dto.getNOTA_CREDITO() : "VACIO";
        String lstFacturaCredito = (dto.getFACTURA_CREDITO() != null && dto.getFACTURA_CREDITO().trim().length() > 0) ? dto.getFACTURA_CREDITO() : "VACIO";

        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp lobTSFechaInicio = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSFechaFin = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSFechaNotifSAP = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSFechaAjustoTitulo = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSFechaAjustoValor = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSFechaAjustoVU = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSFechaBaja = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSHVRD = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());

        try {
            //--Debug
            sbD.append("UPDATE DDA_T_CONTRATO_TITULO ");
            sbD.append("SET ");
            sbD.append("FECHA_WS=SYSDATE");

            if (!lstDescTitulo.equalsIgnoreCase("VACIO")) {
                sbD.append(",DESC_TITULO='" + lstDescTitulo + "' ");
            }
            if (!lstIdContrato.equalsIgnoreCase("VACIO")) {
                sbD.append(",ID_CONTRATO=" + lstIdContrato + " ");
            }
            if (!lstIdLista.equalsIgnoreCase("VACIO")) {
                sbD.append(",ID_LISTA=" + lstIdLista + " ");
            }
            if (!lstIdTitulo.equalsIgnoreCase("VACIO")) {
                sbD.append("ID_TITULO=" + lstIdTitulo + " ");
            }
            if (!lstIdCategoria.equalsIgnoreCase("VACIO")) {
                sbD.append(",ID_CATEGORIA=" + lstIdCategoria + " ");
            }
            if (!lstFechaInicio.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_INICIO=to_date('" + lstFechaInicio + "','yyyy-mm-dd')");
            }
            if (!lstFechaFin.equalsIgnoreCase("VACIO")) {
                sbD.append("FECHA_FIN=to_date('" + lstFechaFin + "','yyyy-mm-dd') ");
            }
            if (!lstBriefCase.equalsIgnoreCase("VACIO")) {
                sbD.append(",BRIEFCASE=" + lstBriefCase + " ");
            }
            if (!lstDto.equalsIgnoreCase("VACIO")) {
                sbD.append(",DTO=" + lstDto + " ");
            }
            if (!lstDtr.equalsIgnoreCase("VACIO")) {
                sbD.append(",DTR=" + lstDtr + " ");
            }
            if (!lstIdSap.equalsIgnoreCase("VACIO")) {
                if (lstIdSap.equalsIgnoreCase("NULL")) {
                    sbD.append(",ID_SAP=null ");
                } else {
                    sbD.append(",ID_SAP='" + lstIdSap + "' ");
                }
            }

            if (!lstEstatus.equalsIgnoreCase("VACIO")) {
                sbD.append(",ESTATUS='" + lstEstatus + "' ");
            }
            if (!lstIdTituloCntNvo.equalsIgnoreCase("VACIO")) {
                sbD.append(",ID_TITULO_CNTNVO=" + lstIdTituloCntNvo + " ");
            }
            if (!lstHvrd.equalsIgnoreCase("VACIO")) {
                sbD.append(",HVRD=to_date('" + lstHvrd + "','yyyy-mm-dd') ");
            }
            if (!lstIdTerritorio.equalsIgnoreCase("VACIO")) {
                sbD.append(",ID_TERRITORIO=" + lstIdTerritorio + " ");
            }
            if (!lstIdRelease.equalsIgnoreCase("VACIO")) {
                sbD.append(",ID_RELEASE=" + lstIdRelease + " ");
            }

            if (!lstFechaNotifSap.equalsIgnoreCase("VACIO")) {
                if (lstFechaNotifSap.equalsIgnoreCase("NULL")) {
                    sbD.append(",FECHA_NOTIFSAP=null ");
                } else {
                    sbD.append(",FECHA_NOTIFSAP=to_date('" + lstFechaNotifSap + "','yyyy-mm-dd') ");
                }
            }
            if (!lstCosto.equalsIgnoreCase("VACIO")) {
                sbD.append(",COSTO='" + lstCosto + "' ");
            }
            if (!lstVidaUtil.equalsIgnoreCase("VACIO")) {
                sbD.append(",VIDA_UTIL='" + lstVidaUtil + "' ");
            }
            if (!lstAjustoTitulo.equalsIgnoreCase("VACIO")) {
                sbD.append(",AJUSTO_TITULO=" + lstAjustoTitulo + " ");
            }
            if (!lstAjustoValor.equalsIgnoreCase("VACIO")) {
                sbD.append(",AJUSTO_VALOR=" + lstAjustoValor + " ");
            }
            if (!lstAjustoVU.equalsIgnoreCase("VACIO")) {
                sbD.append(",AJUSTO_VU=" + lstAjustoVU + " ");
            }
            if (!lstBajaPerdida.equalsIgnoreCase("VACIO")) {
                sbD.append(",BAJA_PERDIDA=" + lstBajaPerdida + " ");
            }
            if (!lstFechaAjustoTitulo.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_AJUSTOTITULO=to_date('" + lstFechaAjustoTitulo + "','yyyy-mm-dd') ");
            }
            if (!lstFechaAjustoValor.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_AJUSTOVALOR=to_date('" + lstFechaAjustoValor + "','yyyy-mm-dd') ");
            }
            if (!lstFechaAjustoVU.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_AJUSTOVU=to_date('" + lstFechaAjustoVU + "','yyyy-mm-dd') ");
            }
            if (!lstFechaBaja.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_BAJA=to_date('" + lstFechaBaja + "','yyyy-mm-dd') ");
            }
            if (!lstIdSapAnt.equalsIgnoreCase("VACIO")) {
                sbD.append(",ID_SAP_ANT='" + lstIdSapAnt + "' ");
            }
            if (!lstIdTituloCntAnt.equalsIgnoreCase("VACIO")) {
                sbD.append(",ID_TITULO_CNTANT=" + lstIdTituloCntAnt + " ");
            }
            if (!lstNotaCredito.equalsIgnoreCase("VACIO")) {
                sbD.append(",NOTA_CREDITO=" + lstIdTituloCntAnt + " ");
            }
            if (!lstFacturaCredito.equalsIgnoreCase("VACIO")) {
                sbD.append(",FACTURA_CREDITO='" + lstIdTituloCntAnt + "' ");
            }

            sbD.append("WHERE ");
            if (!lstIdTituloCnt.equalsIgnoreCase("VACIO")) {
                sbD.append("ID_TITULO_CNT=" + lstIdTituloCnt);
            }
            if (!lstIdTituloCntOrig.equalsIgnoreCase("VACIO")) {
                sbD.append("ID_TITULO_CNTORIG=" + lstIdTituloCntOrig + " ");
            }
            LOG.debug("    >Sql_D [actualizaTituloFull]:" + sbD.toString());

            //--Ejecucion
            sb.append("UPDATE DDA_T_CONTRATO_TITULO ");
            sb.append("SET ");
            sb.append("FECHA_WS=SYSDATE ");

            if (!lstDescTitulo.equalsIgnoreCase("VACIO")) {
                sb.append(",DESC_TITULO=? ");
            }
            if (!lstIdContrato.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_CONTRATO=? ");
            }
            if (!lstIdLista.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_LISTA=? ");
            }
            if (!lstIdTitulo.equalsIgnoreCase("VACIO")) {
                sb.append("ID_TITULO=? ");
            }
            if (!lstIdCategoria.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_CATEGORIA=? ");
            }
            if (!lstFechaInicio.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_INICIO=? ");
            }
            if (!lstFechaFin.equalsIgnoreCase("VACIO")) {
                sb.append("FECHA_FIN=? ");
            }
            if (!lstBriefCase.equalsIgnoreCase("VACIO")) {
                sb.append(",BRIEFCASE=? ");
            }
            if (!lstDto.equalsIgnoreCase("VACIO")) {
                sb.append(",DTO=? ");
            }
            if (!lstDtr.equalsIgnoreCase("VACIO")) {
                sb.append(",DTR=? ");
            }

            if (!lstIdSap.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_SAP=? ");
            }
            if (!lstEstatus.equalsIgnoreCase("VACIO")) {
                sb.append(",ESTATUS=? ");
            }
            if (!lstIdTituloCntNvo.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_TITULO_CNTNVO=? ");
            }
            if (!lstHvrd.equalsIgnoreCase("VACIO")) {
                sb.append(",HVRD=?) ");
            }
            if (!lstIdTerritorio.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_TERRITORIO=? ");
            }
            if (!lstIdRelease.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_RELEASE=? ");
            }
            if (!lstFechaNotifSap.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_NOTIFSAP=? ");
            }
            if (!lstCosto.equalsIgnoreCase("VACIO")) {
                sb.append(",COSTO=? ");
            }
            if (!lstVidaUtil.equalsIgnoreCase("VACIO")) {
                sb.append(",VIDA_UTIL=? ");
            }
            if (!lstAjustoTitulo.equalsIgnoreCase("VACIO")) {
                sb.append(",AJUSTO_TITULO=? ");
            }
            if (!lstAjustoValor.equalsIgnoreCase("VACIO")) {
                sb.append(",AJUSTO_VALOR=? ");
            }
            if (!lstAjustoVU.equalsIgnoreCase("VACIO")) {
                sb.append(",AJUSTO_VU=? ");
            }
            if (!lstBajaPerdida.equalsIgnoreCase("VACIO")) {
                sb.append(",BAJA_PERDIDA=? ");
            }
            if (!lstFechaAjustoTitulo.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_AJUSTOTITULO=? ");
            }
            if (!lstFechaAjustoValor.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_AJUSTOVALOR=? ");
            }
            if (!lstFechaAjustoVU.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_AJUSTOVU=? ");
            }
            if (!lstFechaBaja.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_BAJA=? ");
            }
            if (!lstIdSapAnt.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_SAP_ANT=? ");
            }
            if (!lstIdTituloCntAnt.equalsIgnoreCase("VACIO")) {
                sb.append(",ID_TITULO_CNTANT=? ");
            }
            if (!lstNotaCredito.equalsIgnoreCase("VACIO")) {
                sb.append(",NOTA_CREDITO=? ");
            }
            if (!lstFacturaCredito.equalsIgnoreCase("VACIO")) {
                sb.append(",FACTURA_CREDITO=? ");
            }

            sb.append("WHERE ");
            if (!lstIdTituloCnt.equalsIgnoreCase("VACIO")) {
                sb.append("ID_TITULO_CNT=? ");
            }
            if (!lstIdTituloCntOrig.equalsIgnoreCase("VACIO")) {
                sb.append("ID_TITULO_CNTORIG=? ");
            }

            //--Valores Query
            if (!lstDescTitulo.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstDescTitulo);
            }
            if (!lstIdContrato.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdContrato);
            }
            if (!lstIdLista.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdLista);
            }
            if (!lstIdTitulo.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdTitulo);
            }
            if (!lstIdCategoria.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdCategoria);
            }
            if (!lstFechaInicio.equalsIgnoreCase("VACIO")) {
                lobTSFechaInicio.setTime(df.parse(lstFechaInicio + " 12:00:00").getTime());
                qryParams.add(lobTSFechaInicio);
            }
            if (!lstFechaFin.equalsIgnoreCase("VACIO")) {
                lobTSFechaFin.setTime(df.parse(lstFechaFin + " 12:00:00").getTime());
                qryParams.add(lobTSFechaFin);
            }

            if (!lstBriefCase.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstBriefCase);
            }
            if (!lstDto.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstDto);
            }
            if (!lstDtr.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstDtr);
            }
            if (!lstIdSap.equalsIgnoreCase("VACIO")) {
                if (lstIdSap.equalsIgnoreCase("NULL")) {
                    qryParams.add(null);
                } else {
                    qryParams.add(lstIdSap);
                }
            }
            if (!lstEstatus.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstEstatus);
            }
            if (!lstIdTituloCntNvo.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdTituloCntNvo);
            }
            if (!lstHvrd.equalsIgnoreCase("VACIO")) {
                lobTSHVRD.setTime(df.parse(lstHvrd + " 12:00:00").getTime());
                qryParams.add(lobTSHVRD);
            }
            if (!lstIdTerritorio.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdTerritorio);
            }
            if (!lstIdRelease.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdRelease);
            }
            if (!lstFechaNotifSap.equalsIgnoreCase("VACIO")) {
                if (lstFechaNotifSap.equalsIgnoreCase("NULL")) {
                    qryParams.add(null);
                } else {
                    lobTSFechaNotifSAP.setTime(df.parse(lstFechaNotifSap + " 12:00:00").getTime());
                    qryParams.add(lobTSFechaNotifSAP);
                }
            }
            if (!lstCosto.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstCosto);
            }
            if (!lstVidaUtil.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstVidaUtil);
            }
            if (!lstAjustoTitulo.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstAjustoTitulo);
            }
            if (!lstAjustoValor.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstAjustoValor);
            }
            if (!lstAjustoVU.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstAjustoVU);
            }
            if (!lstBajaPerdida.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstBajaPerdida);
            }
            if (!lstFechaAjustoTitulo.equalsIgnoreCase("VACIO")) {
                lobTSFechaAjustoTitulo.setTime(df.parse(lstFechaAjustoTitulo + " 12:00:00").getTime());
                qryParams.add(lobTSFechaAjustoTitulo);
            }
            if (!lstFechaAjustoValor.equalsIgnoreCase("VACIO")) {
                lobTSFechaAjustoValor.setTime(df.parse(lstFechaAjustoValor + " 12:00:00").getTime());
                qryParams.add(lobTSFechaAjustoValor);
            }
            if (!lstFechaAjustoVU.equalsIgnoreCase("VACIO")) {
                lobTSFechaAjustoVU.setTime(df.parse(lstFechaAjustoVU + " 12:00:00").getTime());
                qryParams.add(lobTSFechaAjustoVU);
            }
            if (!lstFechaBaja.equalsIgnoreCase("VACIO")) {
                lobTSFechaBaja.setTime(df.parse(lstFechaBaja + " 12:00:00").getTime());
                qryParams.add(lobTSFechaBaja);
            }
            if (!lstIdSapAnt.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdSapAnt);
            }
            if (!lstIdTituloCntAnt.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdTituloCntAnt);
            }
            if (!lstNotaCredito.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstNotaCredito);
            }
            if (!lstFacturaCredito.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstFacturaCredito);
            }

            if (!lstIdTituloCnt.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdTituloCnt);
            }
            if (!lstIdTituloCntOrig.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstIdTituloCntOrig);
            }

            final String lstSQL = sb.toString();
            lnuRowsUpdate = jdbcTemplate.update(lstSQL, qryParams.toArray());

            if (lnuRowsUpdate > 0) {
                resultado = true;
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::actualizaTituloFull]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    @Override
    public boolean actualizaCntSAPSubnumFull(ContratoSAPSubnumDTO dto) throws Exception {
        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        int lnuRowsUpdate = 0;

        String lstIdRegistroSAP = (dto.getID_REGISTRO_SAP() != null && dto.getID_REGISTRO_SAP().trim().length() > 0) ? dto.getID_REGISTRO_SAP() : "VACIO";
        String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "VACIO";
        String lstIdTituloCnt = (dto.getID_TITULO_CNT() != null && dto.getID_TITULO_CNT().trim().length() > 0) ? dto.getID_TITULO_CNT() : "VACIO";
        String lstIdTituloCntOrig = (dto.getID_TITULO_CNTORIG() != null && dto.getID_TITULO_CNTORIG().trim().length() > 0) ? dto.getID_TITULO_CNTORIG() : "VACIO";
        String lstAumento = (dto.getAUMENTO() != null && dto.getAUMENTO().trim().length() > 0) ? dto.getAUMENTO() : "VACIO";
        String lstDisminucion = (dto.getDISMINUCION() != null && dto.getDISMINUCION().trim().length() > 0) ? dto.getDISMINUCION() : "VACIO";
        String lstFechaSAP = (dto.getFECHA_SAP() != null && dto.getFECHA_SAP().trim().length() > 0) ? dto.getFECHA_SAP() : "VACIO";
        String lstSubnumero = (dto.getSUBNUMERO() != null && dto.getSUBNUMERO().trim().length() > 0) ? dto.getSUBNUMERO() : "VACIO";

        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());

        try {
            //--Debug
            sbD.append("UPDATE DDA_T_CONTRATO_SAP_SUBNUM ");
            sbD.append("SET ");
            sbD.append("FECHA_WS = SYSDATE ");

            if (!lstAumento.equalsIgnoreCase("VACIO")) {
                sbD.append(",AUMENTO='" + lstAumento + "' ");
            }
            if (!lstDisminucion.equalsIgnoreCase("VACIO")) {
                sbD.append(",DISMINUCION='" + lstDisminucion + "' ");
            }
            if (!lstFechaSAP.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_SAP = to_date('" + lstFechaSAP + "','yyyy-mm-dd') ");
            }
            if (!lstSubnumero.equalsIgnoreCase("VACIO")) {
                sbD.append(",SUBNUMERO = '" + lstSubnumero + "' ");
            }

            sbD.append("where ");
            sbD.append("ID_REGISTRO_SAP = " + lstIdRegistroSAP + " ");
            sbD.append("and FECHA_SAP is null ");
            LOG.debug(">Sql_D [actualizaCntSAPSubnumFull]:" + sbD.toString());

            //--Ejecucion
            sb.append("UPDATE DDA_T_CONTRATO_SAP_SUBNUM ");
            sb.append("SET ");
            sb.append("FECHA_WS = SYSDATE ");

            if (!lstAumento.equalsIgnoreCase("VACIO")) {
                sb.append(",AUMENTO=? ");
            }
            if (!lstDisminucion.equalsIgnoreCase("VACIO")) {
                sb.append(",DISMINUCION=? ");
            }
            if (!lstFechaSAP.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_SAP = ? ");
            }
            if (!lstSubnumero.equalsIgnoreCase("VACIO")) {
                sb.append(",SUBNUMERO = ? ");
            }

            sb.append("where ");
            sb.append("ID_REGISTRO_SAP = ? ");
            sb.append("and FECHA_SAP is null ");

            //--Valores query
            if (!lstAumento.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstAumento);
            }
            if (!lstDisminucion.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstDisminucion);
            }
            if (!lstFechaSAP.equalsIgnoreCase("VACIO")) {
                lobTSFecha.setTime(df.parse(lstFechaSAP + " 12:00:00").getTime());
                qryParams.add(lobTSFecha);
            }
            if (!lstSubnumero.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstSubnumero);
            }

            qryParams.add(lstIdRegistroSAP);

            final String lstSQL = sb.toString();
            lnuRowsUpdate = jdbcTemplate.update(lstSQL, qryParams.toArray());

            if (lnuRowsUpdate > 0) {
                resultado = true;
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::actualizaCntSAPSubnumFull]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    @Override
    public VidaUtilDTO calcularVidaUtil(String pstFechaInicio, String pstFechaFin) throws Exception {
        List<VidaUtilDTO> lobVidaUtil = new ArrayList<VidaUtilDTO>();
        VidaUtilDTO resultado = new VidaUtilDTO();
        resultado.setVUAA("");
        resultado.setVUMM("");

        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();

        try {
            String lstFechaInicio = (pstFechaInicio != null && pstFechaInicio.trim().length() > 0) ? pstFechaInicio : "";
            String lstFechaFin = (pstFechaFin != null && pstFechaFin.trim().length() > 0) ? pstFechaFin : "";

            //-- Debug
            sbD.append("select ");
            sbD.append("SUBSTR( DDA_CALCULARVU( to_date('" + lstFechaInicio + "','dd/mm/yyyy'),to_date('" + lstFechaFin + "','dd/mm/yyyy'), 'SAP'), 0, 2 ) as VUAA, ");
            sbD.append("SUBSTR( DDA_CALCULARVU( to_date('" + lstFechaInicio + "','dd/mm/yyyy'),to_date('" + lstFechaFin + "','dd/mm/yyyy'), 'SAP'), 3, 2 ) as VUMM ");
            sbD.append("from ");
            sbD.append("dual ");
            LOG.debug("    >Sql_D [calcularVidaUtil]:" + sbD.toString());

            //--Ejecucion
            sb.append("select ");
            sb.append("SUBSTR( DDA_CALCULARVU( to_date(?,'dd/mm/yyyy'),to_date(?,'dd/mm/yyyy'), 'SAP'), 0, 2 ) as VUAA, ");
            sb.append("SUBSTR( DDA_CALCULARVU( to_date(?,'dd/mm/yyyy'),to_date(?,'dd/mm/yyyy'), 'SAP'), 3, 2 ) as VUMM ");
            sb.append("from ");
            sb.append("dual ");

            final String lstSQL = sb.toString();
            qryParams.add(lstFechaInicio);
            qryParams.add(lstFechaFin);
            qryParams.add(lstFechaInicio);
            qryParams.add(lstFechaFin);

            lobVidaUtil = (ArrayList<VidaUtilDTO>) getJdbcTemplate().query(lstSQL, qryParams.toArray(), new BeanPropertyRowMapper<VidaUtilDTO>(VidaUtilDTO.class));

            if (lobVidaUtil != null && lobVidaUtil.size() == 1) {
                resultado.setVUAA((lobVidaUtil.get(0).getVUAA() != null && lobVidaUtil.get(0).getVUAA().trim().length() > 0) ? lobVidaUtil.get(0).getVUAA() : "");
                resultado.setVUMM((lobVidaUtil.get(0).getVUMM() != null && lobVidaUtil.get(0).getVUMM().trim().length() > 0) ? lobVidaUtil.get(0).getVUMM() : "");
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::calcularVidaUtil]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }

    @Override
    public boolean insertaRegistroCRNClienteSAP(CrnClienteSAPDTO dto) throws Exception {
        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        int lnuRowsUpdate = 0;

        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp lobTSFechaFin = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSFechaInicio = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
        Timestamp lobTSFechaContabilizacion = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());

        try {
            String lstIdCntOriginal = (dto.getID_CONTRATO_ORIGINAL() != null && dto.getID_CONTRATO_ORIGINAL().length() > 0) ? dto.getID_CONTRATO_ORIGINAL() : "";
            String lstIdCnt = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().length() > 0) ? dto.getID_CONTRATO() : "";
            String lstInterfaz = (dto.getINTERFAZ() != null && dto.getINTERFAZ().length() > 0) ? dto.getINTERFAZ() : "";
            String lstCodSAP = (dto.getCODIGO_SAP() != null && dto.getCODIGO_SAP().length() > 0) ? dto.getCODIGO_SAP() : "";
            String lstSubNumero = (dto.getSUBNUMERO() != null && dto.getSUBNUMERO().length() > 0) ? dto.getSUBNUMERO() : "";
            String lstFechaContabilizacion = (dto.getFECHA_CONTABILIZACION() != null && dto.getFECHA_CONTABILIZACION().length() > 0) ? dto.getFECHA_CONTABILIZACION() : "";
            String lstIdTituloCnt = (dto.getID_TITULO_CNT() != null && dto.getID_TITULO_CNT().length() > 0) ? dto.getID_TITULO_CNT() : "";
            String lstIdTituloCntOrig = (dto.getID_TITULO_CNTORIG() != null && dto.getID_TITULO_CNTORIG().length() > 0) ? dto.getID_TITULO_CNTORIG() : "";

            String lstFechaFin = (dto.getFECHA_FIN() != null && dto.getFECHA_FIN().length() > 0) ? dto.getFECHA_FIN() : "VACIO";
            String lstFechaInicio = (dto.getFECHA_INICIO() != null && dto.getFECHA_INICIO().length() > 0) ? dto.getFECHA_INICIO() : "VACIO";
            String lstVUAA = (dto.getVUAA() != null && dto.getVUAA().length() > 0) ? dto.getVUAA() : "VACIO";
            String lstVUMM = (dto.getVUMM() != null && dto.getVUMM().length() > 0) ? dto.getVUMM() : "VACIO";

            //--Debug
            sbD.append("INSERT INTO ");
            sbD.append("DDA_T_CRN_CLIENTESAP ");
            sbD.append("( ");
            sbD.append("ID_CRN, ");
            sbD.append("FECHA_REGISTRO, ");
            sbD.append("ID_CONTRATO_ORIGINAL, ");
            sbD.append("ID_CONTRATO, ");
            sbD.append("INTERFAZ, ");
            sbD.append("CODIGO_SAP, ");
            sbD.append("SUBNUMERO, ");
            sbD.append("FECHA_CONTABILIZACION, ");
            sbD.append("ID_TITULO_CNT, ");
            sbD.append("ID_TITULO_CNTORIG ");

            if (!lstFechaFin.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_FIN ");
            }
            if (!lstFechaInicio.equalsIgnoreCase("VACIO")) {
                sbD.append(",FECHA_INICIO");
            }
            if (!lstVUAA.equalsIgnoreCase("VACIO")) {
                sbD.append(",VUAA");
            }
            if (!lstVUMM.equalsIgnoreCase("VACIO")) {
                sbD.append(",VUMM");
            }

            sbD.append(") ");
            sbD.append("VALUES ");
            sbD.append("( ");
            sbD.append("DDA_SQT_CRN_CLIENTESAP.NEXTVAL, ");
            sbD.append("to_date(SYSDATE,'dd/mm/yyyy'), ");
            sbD.append(lstIdCntOriginal + ", ");
            sbD.append(lstIdCnt + ", ");
            sbD.append(lstInterfaz + ", ");
            sbD.append("'" + lstCodSAP + "', ");
            sbD.append("'" + lstSubNumero + "', ");
            sbD.append("to_date('" + lstFechaContabilizacion + "','dd/mm/yyyy'), ");
            sbD.append(lstIdTituloCnt + ", ");
            sbD.append(lstIdTituloCntOrig + " ");
            if (!lstFechaFin.equalsIgnoreCase("VACIO")) {
                sbD.append(",to_date('" + lstFechaFin + "','dd/mm/yyyy') ");
            }
            if (!lstFechaInicio.equalsIgnoreCase("VACIO")) {
                sbD.append(",to_date('" + lstFechaInicio + "','dd/mm/yyyy') ");
            }
            if (!lstVUAA.equalsIgnoreCase("VACIO")) {
                sbD.append("'" + lstVUAA + "', ");
            }
            if (!lstVUMM.equalsIgnoreCase("VACIO")) {
                sbD.append("'" + lstVUMM + "' ");
            }
            sbD.append(") ");
            LOG.debug(">Sql_D [insertaRegistroCRNClienteSAP]:" + sbD.toString());

            //--Ejecucion
            sb.append("INSERT INTO ");
            sb.append("DDA_T_CRN_CLIENTESAP ");
            sb.append("( ");
            sb.append("ID_CRN, ");
            sb.append("FECHA_REGISTRO, ");
            sb.append("ID_CONTRATO_ORIGINAL, ");
            sb.append("ID_CONTRATO, ");
            sb.append("INTERFAZ, ");
            sb.append("CODIGO_SAP, ");
            sb.append("SUBNUMERO, ");
            sb.append("FECHA_CONTABILIZACION, ");
            sb.append("ID_TITULO_CNT, ");
            sb.append("ID_TITULO_CNTORIG ");
            if (!lstFechaFin.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_FIN ");
            }
            if (!lstFechaInicio.equalsIgnoreCase("VACIO")) {
                sb.append(",FECHA_INICIO");
            }
            if (!lstVUAA.equalsIgnoreCase("VACIO")) {
                sb.append(",VUAA");
            }
            if (!lstVUMM.equalsIgnoreCase("VACIO")) {
                sb.append(",VUMM");
            }

            sb.append(") ");
            sb.append("VALUES ");
            sb.append("( ");
            sb.append("DDA_SQT_CRN_CLIENTESAP.NEXTVAL, ");
            sb.append("SYSDATE, ");
            sb.append("?, ");
            sb.append("?, ");
            sb.append("?, ");
            sb.append("?, ");
            sb.append("?, ");
            sb.append("?, ");
            sb.append("?, ");
            sb.append("? ");
            if (!lstFechaFin.equalsIgnoreCase("VACIO")) {
                sb.append(",? ");
            }
            if (!lstFechaInicio.equalsIgnoreCase("VACIO")) {
                sb.append(",?");
            }
            if (!lstVUAA.equalsIgnoreCase("VACIO")) {
                sb.append(",?");
            }
            if (!lstVUMM.equalsIgnoreCase("VACIO")) {
                sb.append(",?");
            }
            sb.append(") ");

            final String sql = sb.toString();
            qryParams.add(lstIdCntOriginal);
            qryParams.add(lstIdCnt);
            qryParams.add(lstInterfaz);
            qryParams.add(lstCodSAP);
            qryParams.add(lstSubNumero);

            lobTSFechaContabilizacion.setTime(df.parse(lstFechaContabilizacion + " 12:00:00").getTime());
            qryParams.add(lobTSFechaContabilizacion);

            qryParams.add(lstIdTituloCnt);
            qryParams.add(lstIdTituloCntOrig);
            if (!lstFechaFin.equalsIgnoreCase("VACIO")) {
                lobTSFechaFin.setTime(df.parse(lstFechaFin + " 12:00:00").getTime());
                qryParams.add(lobTSFechaFin);
            }
            if (!lstFechaInicio.equalsIgnoreCase("VACIO")) {
                lobTSFechaInicio.setTime(df.parse(lstFechaInicio + " 12:00:00").getTime());
                qryParams.add(lobTSFechaInicio);
            }

            if (!lstVUAA.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstVUAA);
            }

            if (!lstVUMM.equalsIgnoreCase("VACIO")) {
                qryParams.add(lstVUMM);
            }

            int lnumRowsInsertados = jdbcTemplate.update(sql, qryParams.toArray());

            if (lnumRowsInsertados > 0) {
                resultado = true;
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::insertaRegistroCRNClienteSAP]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    @Override
    public boolean ejecutarSPAmortizacionAjustada() throws Exception {
        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        int lnuRowsUpdate = 0;

        try {
            //--Debug
            sbD.append("call DDA_AMORTIZACIONAJUSTADA");
            LOG.debug(">Sql_D [ejecutarSPAmortizacionReal]:" + sbD.toString());

            //--Ejecucion
            sb.append("call DDA_AMORTIZACIONAJUSTADA()");

            final String lstSQL = sb.toString();

            lnuRowsUpdate = jdbcTemplate.update(lstSQL, qryParams.toArray());

            if (lnuRowsUpdate >= 0) {
                resultado = true;
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::ejecutarSPAmortizacionAjustada]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }
    
    @Override
    public List<TerminosComercialesDTO> obtenerContratosCandidatos(String pstInterfaz) throws Exception {
        List<TerminosComercialesDTO> resultado = new ArrayList<>();
        StringBuilder sb = new StringBuilder();
        List<Object> qryParams = new ArrayList<>();

        try {

            //-- Debug
            sb.append("SELECT c.NUMERO_CONTRATO AS numeroContrato, SUM(b.COSTO) AS costo, c.ID_SAP AS ordenCompra, REPLACE(to_char(MIN(c.FECHA_INICIO),'yyyy-mm-dd') ,'-','') AS fechaVencimiento ");
            sb.append("FROM DDA_T_CRN_CLIENTESAP a INNER JOIN DDA_T_CONTRATO_TITULO b ON a.CODIGO_SAP = b.ID_SAP ");
            sb.append("INNER JOIN DDA_T_CONTRATO c ON a.ID_CONTRATO = c.ID_CONTRATO ");
            sb.append("WHERE a.INTERFAZ = ? AND to_date(a.FECHA_CONTABILIZACION,'dd/mm/yyyy') <= to_date(sysdate,'dd/mm/yyyy') ");
            sb.append("GROUP BY c.NUMERO_CONTRATO, c.ID_SAP ");

            final String lstSQL = sb.toString();
            qryParams.add(pstInterfaz);

            resultado = (ArrayList<TerminosComercialesDTO>) jdbcTemplate.query(lstSQL, qryParams.toArray(), new BeanPropertyRowMapper<>(TerminosComercialesDTO.class));

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerRegistrosCandidatos]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }
}
