package mx.com.amx.mx.dda.crn.dto;

import java.io.Serializable;

/**
 * Un objeto de tipo ItemVidaUtilAFijoDTO representa cada uno de los posibles registros para la modificacion de la Vida Util de Activo Fijo (Titulos) a SAP 
 * Este objeto pertenece al mbito DDA.
 */

public class ItemVidaUtilAFijoDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String codigoSAP;
	private String fechaInicio;
	private String subNumero;
	private String vuAA;
	private String vuMM;

	public String getCodigoSAP() {
		return codigoSAP;
	}

	public void setCodigoSAP(String codigoSAP) {
		this.codigoSAP = codigoSAP;
	}

	public String getFechaInicio() {
		return fechaInicio;
	}

	public void setFechaInicio(String fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public String getSubNumero() {
		return subNumero;
	}

	public void setSubNumero(String subNumero) {
		this.subNumero = subNumero;
	}

	public String getVuAA() {
		return vuAA;
	}

	public void setVuAA(String vuAA) {
		this.vuAA = vuAA;
	}

	public String getVuMM() {
		return vuMM;
	}

	public void setVuMM(String vuMM) {
		this.vuMM = vuMM;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" codigoSAP: _" + this.getCodigoSAP() + "_" + NEW_LINE);
		result.append(" fechaInicio: _" + this.getFechaInicio() + "_" + NEW_LINE);
		result.append(" subNumero: _" + this.getSubNumero() + "_" + NEW_LINE);
		result.append(" vuAA: _" + this.getVuAA() + "_" + NEW_LINE);
		result.append(" vuMM: _" + this.getVuMM() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

	
}
