package mx.com.amx.mx.dda.crn.dto;

import java.io.Serializable;
import java.util.List;

/**
 * Representa los parametros de la disminucion de Costo del Titulo enviados desde el front-end, mismos que son 
 * recibidos por este cliente. Esta clase pertenece al ambito de DDA.
 */
public class ParamDisminucionCostoAFijoDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private List<ItemDisminucionCostoActivoFijoDTO> titulos;
	
	public List<ItemDisminucionCostoActivoFijoDTO> getTitulos() {
		return titulos;
	}

	public void setTitulos(List<ItemDisminucionCostoActivoFijoDTO> titulos) {
		this.titulos = titulos;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" items: _" + this.getTitulos().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
}
