package mx.com.amx.mx.dda.crn.dto;

import java.io.Serializable;
import java.util.List;

/**
 * Representa los parametros del Traslado de Activo Fijo.  
 * Esta clase pertenece al ambito de DDA.
 * Los nombres de cada uno de los argumentos fueron tomados del Excel de inventario de interfaces. 
  */
public class ParamTrasladoAFijoDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private List<ItemTrasladoActivoFijoDTO> titulos;
	
	public List<ItemTrasladoActivoFijoDTO> getTitulos() {
		return titulos;
	}

	public void setTitulos(List<ItemTrasladoActivoFijoDTO> titulos) {
		this.titulos = titulos;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" titulos: _" + this.getTitulos().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
