/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.xpath.NodeCallbackHandler;
import org.springframework.xml.xpath.NodeMapper;
import org.springframework.xml.xpath.XPathException;
import org.springframework.xml.xpath.XPathOperations;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractXPathTemplate
extends TransformerObjectSupport
implements XPathOperations {
    private Properties namespaces;

    public Properties getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Properties namespaces) {
        this.namespaces = namespaces;
    }

    public final void evaluate(String expression, Source context, NodeCallbackHandler callbackHandler) throws XPathException {
        this.evaluate(expression, context, new NodeCallbackHandlerNodeMapper(callbackHandler));
    }

    protected Element getRootElement(Source source) throws TransformerException {
        DOMResult domResult = new DOMResult();
        this.transform(source, domResult);
        Document document = (Document)domResult.getNode();
        return document.getDocumentElement();
    }

    private static class NodeCallbackHandlerNodeMapper
    implements NodeMapper {
        private final NodeCallbackHandler callbackHandler;

        public NodeCallbackHandlerNodeMapper(NodeCallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }

        public Object mapNode(Node node, int nodeNum) throws DOMException {
            this.callbackHandler.processNode(node);
            return null;
        }
    }
}

