package mx.com.amx.mx.dda.crn.bo;

import java.util.List;
import java.util.Properties;

import javax.xml.ws.WebServiceException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;

import com.americamovil.dda._1.f.enviaactivofijo.DTActivoFijoRes;
import com.americamovil.dda._1.f.enviaactivofijo.DTTituloMismoValor;
import com.americamovil.dda._1.f.enviadisminucionvalor.DTDisminucionValor;
import com.americamovil.dda._1.f.enviadisminucionvalor.DTDisminucionValorRes;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTBajaConPerdida;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTBajaSinPerdida;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTModificaAFRes;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTTituloPorValor;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTVidaUtil;
import com.americamovil.dda._1.f.enviamodifactivofijo.DTVidaUtilRes;
import com.americamovil.dda._1.f.envianombreactivof.DTNombreActivoFReq;
import com.americamovil.dda._1.f.envianombreactivof.DTNombreActivoFRes;
import com.americamovil.dda._1.f.enviapostcapitalizacontenido.DTCapitalizaContenido;
import com.americamovil.dda._1.f.enviapostcapitalizacontenido.DTCapitalizaContenidoRes;
import com.americamovil.dda._1.f.enviaterminoscomerciales.DTTerminosComerciales;
import com.americamovil.dda._1.f.enviaterminoscomerciales.DTTerminosComerciales.Condicionescomerciales;
import com.americamovil.dda._1.f.enviaterminoscomerciales.DTTerminosComercialesRes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mx.com.amx.mx.dda.crn.dao.DDAClienteSAPDAO;
import mx.com.amx.mx.dda.crn.dto.ItemAumentoCostoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemBajaActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemDisminucionCostoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemTrasladoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ItemVidaUtilAFijoDTO;

import mx.com.amx.mx.dda.crn.dto.ParamAumentoCostoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamBajaActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamCambiaNombreAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamCambiaVUAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamDisminucionCostoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamTrasladoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPBajaActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPBajaPerdidaAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPCambiaNombreActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPCambiaVUAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPCambioCostoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoBajaPerdidaAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaCostoActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaNombreAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCambiaVUAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoEnviaTituloPorValorDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoTrasladoAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.TerminosComercialesDTO;
import mx.com.amx.mx.dda.crn.dto.TransactionFaultDTO;
import mx.com.amx.mx.dda.crn.utils.StringManager;



public class DDACteSAPWSBO 
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	StringManager strManager = new StringManager();
		
	@Autowired
	@Qualifier("wsCRNClienteSAP")
	private WebServiceTemplate wsCRNClienteSAP;
	
	private String AMBIENTE;
	private String SERVIDOR;
	private String PUERTO;
	private String COMPONENTE;
	private String ERROR_COMUNICACION_SAP;
	private String ERROR_INTERNO_SAP;
	private String ERROR_PROCESO;
	private String ERROR_REGISTRO_SAP;
	private String ERROR_RESP_DISTINTA;
	private String FECHA_TEST;
	
	public DDACteSAPWSBO()
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			AMBIENTE = env.getProperty("ambiente");
			SERVIDOR = env.getProperty(AMBIENTE+".servidor.sap.ws");
			PUERTO = env.getProperty(AMBIENTE+".puerto.sap.ws");
			COMPONENTE = "DDA_CRN_ClienteSAP::" + this.getClass().getSimpleName();
			ERROR_COMUNICACION_SAP = env.getProperty("error.comunicacion.sap");
			ERROR_INTERNO_SAP = env.getProperty("error.interno.sap");
			ERROR_PROCESO = env.getProperty("error.proceso");
			ERROR_RESP_DISTINTA = env.getProperty("error.respuesta.distinta.esperada");
			FECHA_TEST = env.getProperty("fecha.test");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
		
	}
	
	public ResultadoEnviaTituloPorValorDTO enviaTituloPorValorWS(ItemBajaActivoFijoDTO dto, DDAClienteSAPDAO dao)
	{
		/*
		 * Debido a que ahora los registros son llamados de multiples contratos ( y no de uno solo como antes) y que 
		 * al no regresar SAP algunos datos que requerimos como Id de Titulo Cnt Original, o Id's especificos para en
		 * nuestras tablas tener la informacion con integridad, se deber hacer uno por uno.
		 */
		ResultadoEnviaTituloPorValorDTO resultado = new ResultadoEnviaTituloPorValorDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPBajaActivoFijoDTO> afs = resultado.getActivosFijos();
                String method = "enviaTituloPorValorWS";
		try
		{
			
			DTTituloPorValor params = new DTTituloPorValor();
                        
                        DTTituloPorValor.Registro titulo = new DTTituloPorValor.Registro();
				
                        titulo.setCodigoSAPAnt(dto.getCodigoSAPAnterior());
                        titulo.setFechaContabilizacion(dto.getFechaContabilizacion());
                        titulo.setFechaInicio(dto.getFechaInicio());

                        params.getRegistro().add(titulo);
			
			
			//--Llamado a WS SAP. Interfaz 27.
			DTModificaAFRes responseTitPorValor = new DTModificaAFRes();
			LOG.info ("                      Url Srv. Titulo por valor: " + this.getUrlServicio("27") );
			
			//--REAL CODE
			responseTitPorValor = (DTModificaAFRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("27"), params);
			
			
			
			//--Version multiple
			if(responseTitPorValor != null && responseTitPorValor.getRegistro() != null && responseTitPorValor.getRegistro().size() > 0)
			{
				int lnuTitulosProcesados = responseTitPorValor.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Tit. x valor): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPBajaActivoFijoDTO respSAP = new RespSAPBajaActivoFijoDTO();
					respSAP.setCodigoSAP(responseTitPorValor.getRegistro().get(0).getIDSAP());
					respSAP.setStatus(responseTitPorValor.getRegistro().get(0).getStatus());
                                        respSAP.setMensaje(responseTitPorValor.getRegistro().get(0).getMENSAJE());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Titulo por valor]: <Status:["+respSAP.getStatus()+"], IdSAP:["+respSAP.getCodigoSAP()+"]> ");
					afs.add(respSAP);
					resultado.setResultado(true);
				}
				else
				{
					writeResponse(tf, "DDA-TAF-005", ERROR_RESP_DISTINTA, "Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.", method, dto.getIdTituloCnt(), dao);
					resultado.setResultado(false);
				}
				
			}
			else
			{
                                writeResponse(tf, "DDA-TAF-004", ERROR_COMUNICACION_SAP, "El servicio web se ejecuto, pero la respuesta es NULL", method, dto.getIdTituloCnt(), dao);
				resultado.setResultado(false);
			}
			
			return resultado;
			
			
		}
		catch(WebServiceException c)
		{
                        writeResponse(tf, "DDA-TAF-001", ERROR_COMUNICACION_SAP, c.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
                        writeResponse(tf, "DDA-TAF-002", ERROR_INTERNO_SAP, se.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
                        writeResponse(tf, "DDA-TAF-003", ERROR_PROCESO, e.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	
	public ResultadoTrasladoAFijoDTO trasladarActivoFijoWS(ItemTrasladoActivoFijoDTO dto, DDAClienteSAPDAO dao)
	{
		/*
		 * Debido a que ahora los registros son llamados de multiples contratos ( y no de uno solo como antes) y que 
		 * al no regresar SAP algunos datos que requerimos como Id de Titulo Cnt Original, o Id's especificos para en
		 * nuestras tablas tener la informacion con integridad, se deber hacer uno por uno.
		 */
		ResultadoTrasladoAFijoDTO resultado = new ResultadoTrasladoAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPActivoFijoDTO> afs = resultado.getActivosFijos();
		String method = "trasladarActivoFijoWS";
		try
		{
			
			String lstCodigoDDANuevo = "";
			String lstCodigoSAPAnterior = "";
			String lstDescActNuevo = "";
			String lstFechaContabilizacion = "";
			String lstFechaInicio = "";
			String lstProgramId = "";
			
			DTTituloMismoValor params = new DTTituloMismoValor();
			
                        DTTituloMismoValor.Registro titulo = new DTTituloMismoValor.Registro();
				
                        lstCodigoDDANuevo = (dto.getCodigoDDANuevo() != null && dto.getCodigoDDANuevo().length() > 0) ? dto.getCodigoDDANuevo(): "";
                        lstCodigoSAPAnterior = (dto.getCodigoSAPAnt() != null && dto.getCodigoSAPAnt().length() > 0) ? dto.getCodigoSAPAnt(): "";
                        lstDescActNuevo = (dto.getDescActNuevo() != null && dto.getDescActNuevo().length() > 0) ? dto.getDescActNuevo(): "";
                        lstFechaContabilizacion = (dto.getFechaContabilizacion() != null && dto.getFechaContabilizacion().length() > 0) ? dto.getFechaContabilizacion(): "";
                        lstFechaInicio = (dto.getFechaInicio() != null && dto.getFechaInicio().length() > 0) ? dto.getFechaInicio(): "";
                        lstProgramId = (dto.getProgramID() != null && dto.getProgramID().length() > 0) ? dto.getProgramID(): "";

                        titulo.setCodigoDDANuevo(lstCodigoDDANuevo);
                        titulo.setCodigoSAPAnt(lstCodigoSAPAnterior);
                        titulo.setDescActNuevo(strManager.extraerPrimerosCaracteres(lstDescActNuevo, 50));
                        titulo.setFechaContabilizacion(lstFechaContabilizacion);
                        titulo.setFechaInicio(lstFechaInicio);
                        titulo.setProgramID(lstProgramId);

                        params.getRegistro().add(titulo);
			
			//--Llamado a WS SAP. Interfaz 25
			DTActivoFijoRes responseTrasladaAFijo = new DTActivoFijoRes();
			LOG.debug ( "                Url Srv. Trasladar Activo Fijo: " + this.getUrlServicio("25") );
			
			//--REAL CODE
			responseTrasladaAFijo = (DTActivoFijoRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("25"), params);
			
			
			if(responseTrasladaAFijo != null && responseTrasladaAFijo.getRespuesta() != null && responseTrasladaAFijo.getRespuesta().size() > 0)
			{
				int lnuTitulosProcesados = responseTrasladaAFijo.getRespuesta().size();
				LOG.info("                Total titulos procesados SAP(traslado): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPActivoFijoDTO respSAP = new RespSAPActivoFijoDTO();
					respSAP.setExcepcion(responseTrasladaAFijo.getRespuesta().get(0).getExcepcion());
					respSAP.setID_DDA(responseTrasladaAFijo.getRespuesta().get(0).getIDDDA());
					respSAP.setID_SAP(responseTrasladaAFijo.getRespuesta().get(0).getIDSAP());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Traslado Titulo mismo valor]: <IdDDA:["+respSAP.getID_DDA()+"], IdSAP:["+respSAP.getID_SAP()+"], Excepcion:["+respSAP.getExcepcion()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
					
				}
				else
				{
					writeResponse(tf, "DDA-TAF-005", ERROR_RESP_DISTINTA, "Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.", method, dto.getIdTituloCnt(), dao);
					resultado.setResultado(false);
				}
				
			}
			else
			{
                                writeResponse(tf, "DDA-TAF-004", ERROR_COMUNICACION_SAP, "El servicio web se ejecuto, pero la respuesta es NULL", method, dto.getIdTituloCnt(), dao);
				resultado.setResultado(false);
			}
			
			return resultado;
			
			
		}
		catch(WebServiceException c)
		{
                        writeResponse(tf, "DDA-TAF-001", ERROR_COMUNICACION_SAP, c.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
                        writeResponse(tf, "DDA-TAF-002", ERROR_INTERNO_SAP, se.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
                        writeResponse(tf, "DDA-TAF-003", ERROR_PROCESO, e.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		
	} 
        
        public void terminosComerciales(List<TerminosComercialesDTO> terminosComerciales, String interfaz) throws Exception{
            try {
                Map<String,List<TerminosComercialesDTO>> contratos = new HashMap<String,List<TerminosComercialesDTO>>();
                for(TerminosComercialesDTO ter : terminosComerciales){
                    if(contratos.get(ter.getNumeroContrato()) == null){
                        contratos.put(ter.getNumeroContrato(), new ArrayList<TerminosComercialesDTO>());
                        contratos.get(ter.getNumeroContrato()).add(ter);
                    } else {
                        contratos.get(ter.getNumeroContrato()).add(ter);
                    }
                }
                LOG.info("************************************** Se crean terminos comerciales para la interfaz: " + interfaz);
                for(Map.Entry<String,List<TerminosComercialesDTO>> contrato : contratos.entrySet()){
                    DTTerminosComerciales params = new DTTerminosComerciales();
                    LOG.info("************************************** Se crean terminos comerciales para contrato: " + contrato.getKey() + " con " + contrato.getValue().size() + " registros enviados");
                    params.setContratoDDA(contrato.getKey());
                    //params.setOrdenCompra("6200000007");
                    params.setOrdenCompra(contrato.getValue().get(0).getOrdenCompra());
                    params.setIdentificadorInt(env.getProperty("identificador.sap" + interfaz));
                    for(TerminosComercialesDTO termino : contrato.getValue()){
                        DTTerminosComerciales.Condicionescomerciales condicion = new DTTerminosComerciales.Condicionescomerciales();
                        condicion.setValorcondicion(termino.getCosto());
                        condicion.setFechavencimiento(termino.getFechaVencimiento());
                        params.getCondicionescomerciales().add(condicion);
                    }
                    DTTerminosComercialesRes response = (DTTerminosComercialesRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("99"), params);
                    if(!response.getESTPROC().equals("OK")){
                        LOG.debug("        Fallo el contrato " + contrato.getValue().get(0).getNumeroContrato() + " al enviarlo a " + this.getUrlServicio("99") 
                                + " mensaje del servicio: " + response.getEstatus());
                    }
                LOG.info("************************************** ESTPROC: " + response.getESTPROC());
                LOG.info("************************************** Estatus: " + response.getEstatus());
                LOG.info("************************************** Response: " + response.toString());
                }
            }catch(Exception e){
                LOG.error("Exception[" + this.getClass().getSimpleName() + "::ejeccuciondeTerminos comerciales]: " + e.getMessage());
                throw new Exception(e.getMessage());
            }
        }
	
	public ResultadoBajaPerdidaAFijoDTO bajaSinPerdidaWS(ItemBajaActivoFijoDTO dto, DDAClienteSAPDAO dao)
	{
		/*
		 * Debido a que ahora los registros son llamados de multiples contratos ( y no de uno solo como antes) y que 
		 * al no regresar SAP algunos datos que requerimos como Id de Titulo Cnt Original, o Id's especificos para en
		 * nuestras tablas tener la informacion con integridad, se deber hacer uno por uno.
		 */
		ResultadoBajaPerdidaAFijoDTO resultado = new ResultadoBajaPerdidaAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPBajaPerdidaAFijoDTO> afs = resultado.getActivosFijos();
		String method = "bajaSinPerdidaWS";
		
		try
		{

			DTBajaSinPerdida params = new DTBajaSinPerdida();
			
                        DTBajaSinPerdida.Registro titulo = new DTBajaSinPerdida.Registro();
				
                        titulo.setCodigoSAP(dto.getCodigoSAPAnterior());
                        titulo.setFechaContab(dto.getFechaContabilizacion());
                        titulo.setFechaInicio(dto.getFechaInicio());
                        titulo.setSubNumero(dto.getSubnumero());
                        params.getRegistro().add(titulo);
			
			//--Llamado a WS SAP. Interfaz 31
			DTModificaAFRes responseBajaSinPerdida = new DTModificaAFRes();
			LOG.debug ( "                Url Srv. Baja sin Perdida Activo Fijo: " + this.getUrlServicio("31") );
			
			//--REAL CODE
			responseBajaSinPerdida = (DTModificaAFRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("31"), params);
			
			if(responseBajaSinPerdida != null && responseBajaSinPerdida.getRegistro() != null && responseBajaSinPerdida.getRegistro().size() > 0)
			{
				int lnuTitulosProcesados = responseBajaSinPerdida.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Baja sin perdida): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPBajaPerdidaAFijoDTO respSAP = new RespSAPBajaPerdidaAFijoDTO();
					respSAP.setCodigoSAP(responseBajaSinPerdida.getRegistro().get(0).getIDSAP());
					respSAP.setStatus(responseBajaSinPerdida.getRegistro().get(0).getStatus());
                                        respSAP.setMensaje(responseBajaSinPerdida.getRegistro().get(0).getMENSAJE());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Baja sin perdida]: <CodSAP:["+respSAP.getCodigoSAP()+"], Status:["+respSAP.getStatus()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
				}
				else
				{
					writeResponse(tf, "DDA-TAF-005", ERROR_RESP_DISTINTA, "Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.", method, dto.getIdTituloCnt(), dao);
					resultado.setResultado(false);
				}
				
			}
			else
			{
                                writeResponse(tf, "DDA-TAF-004", ERROR_COMUNICACION_SAP, "El servicio web se ejecuto, pero la respuesta es NULL", method, dto.getIdTituloCnt(), dao);
				resultado.setResultado(false);
			}
			
			return resultado;
			
			
		}
		catch(WebServiceException c)
		{
                        writeResponse(tf, "DDA-TAF-001", ERROR_COMUNICACION_SAP, c.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
                        writeResponse(tf, "DDA-TAF-002", ERROR_INTERNO_SAP, se.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
                        writeResponse(tf, "DDA-TAF-003", ERROR_PROCESO, e.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	
	public ResultadoBajaPerdidaAFijoDTO bajaConPerdidaWS(ItemBajaActivoFijoDTO dto, DDAClienteSAPDAO dao)
	{
		/*
		 * Debido a que ahora los registros son llamados de multiples contratos ( y no de uno solo como antes) y que 
		 * al no regresar SAP algunos datos que requerimos como Id de Titulo Cnt Original, o Id's especificos para en
		 * nuestras tablas tener la informacion con integridad, se deber hacer uno por uno.
		 */
		ResultadoBajaPerdidaAFijoDTO resultado = new ResultadoBajaPerdidaAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPBajaPerdidaAFijoDTO> afs = resultado.getActivosFijos();
		String method = "bajaConPerdidaWS";
		
		try
		{
			
			DTBajaConPerdida params = new DTBajaConPerdida();
                        
                        DTBajaConPerdida.Registro titulo = new DTBajaConPerdida.Registro();
				
                        titulo.setCodigoSAP(dto.getCodigoSAPAnterior());
                        titulo.setFechaContab(dto.getFechaContabilizacion());
                        titulo.setFechaInicio(dto.getFechaInicio());
                        titulo.setSubNumero(dto.getSubnumero());
                        params.getRegistro().add(titulo);
			
			
			//--Llamado a WS SAP. Interfaz 30
			DTModificaAFRes responseBajaConPerdida = new DTModificaAFRes();
			LOG.debug ( "                Url Srv. Baja con Perdida Activo Fijo: " + this.getUrlServicio("30") );
			
			//--REAL CODE
			responseBajaConPerdida = (DTModificaAFRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("30"), params);
			
			
			if(responseBajaConPerdida != null && responseBajaConPerdida.getRegistro() != null && responseBajaConPerdida.getRegistro().size() > 0)
			{
				int lnuTitulosProcesados = responseBajaConPerdida.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Baja con perdida): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPBajaPerdidaAFijoDTO respSAP = new RespSAPBajaPerdidaAFijoDTO();
					respSAP.setCodigoSAP(responseBajaConPerdida.getRegistro().get(0).getIDSAP());
					respSAP.setStatus(responseBajaConPerdida.getRegistro().get(0).getStatus());
                                        respSAP.setMensaje(responseBajaConPerdida.getRegistro().get(0).getMENSAJE());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Baja con perdida]: <CodSAP:["+respSAP.getCodigoSAP()+"], Status:["+respSAP.getStatus()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
				}
				else
				{
					writeResponse(tf, "DDA-TAF-005", ERROR_RESP_DISTINTA, "Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.", method, dto.getIdTituloCnt(), dao);
					resultado.setResultado(false);
				}
				
			}
			else
			{
                                writeResponse(tf, "DDA-TAF-004", ERROR_COMUNICACION_SAP, "El servicio web se ejecuto, pero la respuesta es NULL", method, dto.getIdTituloCnt(), dao);
				resultado.setResultado(false);
			}
			
			return resultado;
			
			
		}
		catch(WebServiceException c)
		{
                        writeResponse(tf, "DDA-TAF-001", ERROR_COMUNICACION_SAP, c.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
                        writeResponse(tf, "DDA-TAF-002", ERROR_INTERNO_SAP, se.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
                        writeResponse(tf, "DDA-TAF-003", ERROR_PROCESO, e.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	
	public ResultadoCambiaVUAFijoDTO modificaVidaUtilAFijoWS(ItemVidaUtilAFijoDTO dto, DDAClienteSAPDAO dao)
	{
		ResultadoCambiaVUAFijoDTO resultado = new ResultadoCambiaVUAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPCambiaVUAFijoDTO> afs = resultado.getActivosFijos();
                String method = "modificaVidaUtilAFijoWS";

		try
		{
			DTVidaUtil params = new DTVidaUtil();
			
			//--Recorrido de titulos
			DTVidaUtil.Registro titulo = new DTVidaUtil.Registro();
				
                        titulo.setCodigoSAP(dto.getCodigoSAP());
                        titulo.setFechaInicio(dto.getFechaInicio());
                        titulo.setSubnumero(dto.getSubNumero());
                        titulo.setVUAA(dto.getVuAA());
                        titulo.setVUMM(dto.getVuMM());
                        params.getRegistro().add(titulo);
			
			//--Llamado a WS SAP. Interfaz 29.
			DTVidaUtilRes responseAjusteVU = new DTVidaUtilRes();
			LOG.debug ( "                Url Srv. Ajuste VU Activo Fijo: " + this.getUrlServicio("29") );
			
			//--REAL CODE
			responseAjusteVU = (DTVidaUtilRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("29"), params);
			
			
			if(responseAjusteVU != null && responseAjusteVU.getRegistro() != null && responseAjusteVU.getRegistro().size() > 0)
			{
				
				int lnuTitulosProcesados = responseAjusteVU.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Ajuste VU): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPCambiaVUAFijoDTO respSAP = new RespSAPCambiaVUAFijoDTO();
					respSAP.setCodigoSAP(responseAjusteVU.getRegistro().get(0).getIDSAP());
					respSAP.setStatus(responseAjusteVU.getRegistro().get(0).getStatus());
					respSAP.setSubnumero(responseAjusteVU.getRegistro().get(0).getSubnumero());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Ajuste VU]: <CodSAP:["+respSAP.getCodigoSAP()+"], Status:["+respSAP.getStatus()+"], Subnumero:["+respSAP.getSubnumero()+"]> ");
					
					afs.add(respSAP);
					resultado.setResultado(true);
				}
				else
				{
					writeResponse(tf, "DDA-TAF-005", ERROR_RESP_DISTINTA, "Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.", method, dto.getIdTituloCnt(), dao);
					resultado.setResultado(false);
				}
				
			}
			else
			{
                                writeResponse(tf, "DDA-TAF-004", ERROR_COMUNICACION_SAP, "El servicio web se ejecuto, pero la respuesta es NULL", method, dto.getIdTituloCnt(), dao);
				resultado.setResultado(false);
			}
			
			return resultado;
			
			
		}
		catch(WebServiceException c)
		{
                        writeResponse(tf, "DDA-TAF-001", ERROR_COMUNICACION_SAP, c.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
                        writeResponse(tf, "DDA-TAF-002", ERROR_INTERNO_SAP, se.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
                        writeResponse(tf, "DDA-TAF-003", ERROR_PROCESO, e.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}

	}
	
	
	public ResultadoCambiaCostoActivoFijoDTO notificarAumentoCostoAFijoWS(ItemAumentoCostoActivoFijoDTO dto, DDAClienteSAPDAO dao)
	{
		ResultadoCambiaCostoActivoFijoDTO resultado = new ResultadoCambiaCostoActivoFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPCambioCostoAFijoDTO> afs = resultado.getActivosFijos();
                String method = "notificarAumentoCostoAFijoWS";
		
		try
		{
			DTCapitalizaContenido params = new DTCapitalizaContenido();
			
			//-- Recorrido de Titulos
                        String lstCodigoSAP = (dto.getCodigoSAP() != null && dto.getCodigoSAP().length() > 0) ? dto.getCodigoSAP(): ""; 
                        String lstAumento = (dto.getAumento() != null && dto.getAumento().length() > 0) ? dto.getAumento(): "";
                        String lstFechaInicio = (dto.getFechaInicio() != null && dto.getFechaInicio().length() > 0) ? dto.getFechaInicio(): "";
                        String lstFechaContabilizacion = (dto.getFechaContabilizacion() != null && dto.getFechaContabilizacion().length() > 0) ? dto.getFechaContabilizacion(): "";
                        String lstSubnumero = (dto.getSubnumero()!= null && dto.getSubnumero().length() > 0) ? dto.getSubnumero(): "0099";

                        DTCapitalizaContenido.Registro titulo = new DTCapitalizaContenido.Registro();
                        titulo.setCodigoSAP(lstCodigoSAP);
                        LOG.info("                Codigo SAP: " + lstCodigoSAP);
                        titulo.setAumentoValor(lstAumento);
                        LOG.info("                Aumento: " + lstAumento);
                        titulo.setFechaInicio(lstFechaInicio);
                        LOG.info("                Fecha inicio: " + lstFechaInicio);
                        titulo.setFechaContabilizacion(lstFechaContabilizacion);
                        LOG.info("                Fecha Contabilizacion: " + lstFechaContabilizacion);
                        titulo.setSUBNUMERO(lstSubnumero);
                        LOG.info("                Subnumero: " + lstSubnumero);
                        params.getRegistro().add(titulo);

			//-- Llamado al WS de SAP. Interfaz 19
			DTCapitalizaContenidoRes responseCambiaCosto = new DTCapitalizaContenidoRes();
			LOG.debug ( "        Url Srv. Aumento Costo Activo Fijo: " + this.getUrlServicio("19") );
			
			//--REAL CODE
			responseCambiaCosto = (DTCapitalizaContenidoRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("19"), params);
			
			if(responseCambiaCosto != null && responseCambiaCosto.getRespuesta() != null && responseCambiaCosto.getRespuesta().size() > 0)
			{
			
				int lnuTitulosProcesados = responseCambiaCosto.getRespuesta().size();
				LOG.info("                Total titulos procesados SAP(Aumento Costo): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPCambioCostoAFijoDTO respAC = new RespSAPCambioCostoAFijoDTO(); 
					respAC.setCodigoSAP(responseCambiaCosto.getRespuesta().get(0).getCodigoSAP());
					respAC.setSubNumero(responseCambiaCosto.getRespuesta().get(0).getSubno());
					respAC.setStatus(responseCambiaCosto.getRespuesta().get(0).getStatus());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Aumento costo]: <CodSAP:["+respAC.getCodigoSAP()+"], Status:["+respAC.getStatus()+"], Subnumero:["+respAC.getSubNumero()+"]> ");
					
					afs.add(respAC);
					resultado.setResultado(true);
				}
				else
				{
					writeResponse(tf, "DDA-TAF-005", ERROR_RESP_DISTINTA, "Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.", method, dto.getIdTituloCnt(), dao);
					resultado.setResultado(false);
				}
				
			}
			else
			{
                                writeResponse(tf, "DDA-TAF-004", ERROR_COMUNICACION_SAP, "El servicio web se ejecuto, pero la respuesta es NULL", method, dto.getIdTituloCnt(), dao);
				resultado.setResultado(false);
			}
			
			return resultado;
			
			
		}
		catch(WebServiceException c)
		{
                        writeResponse(tf, "DDA-TAF-001", ERROR_COMUNICACION_SAP, c.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
                        writeResponse(tf, "DDA-TAF-002", ERROR_INTERNO_SAP, se.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
                        writeResponse(tf, "DDA-TAF-003", ERROR_PROCESO, e.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		
	}
	
	
	public ResultadoCambiaCostoActivoFijoDTO notificarDisminucionCostoAFijoWS(ItemDisminucionCostoActivoFijoDTO dto, DDAClienteSAPDAO dao)
	{
		ResultadoCambiaCostoActivoFijoDTO resultado = new ResultadoCambiaCostoActivoFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPCambioCostoAFijoDTO> afs = resultado.getActivosFijos();
                String method = "notificarDisminucionCostoAFijoWS";
		
		try
		{
			DTDisminucionValor params = new DTDisminucionValor();
			
			//--Titulos
			String lstCodigoSAP = (dto.getCodigoSAP() != null && dto.getCodigoSAP().length() > 0) ? dto.getCodigoSAP(): "";
                        String lstSubNumero = (dto.getSubNumero() != null && dto.getSubNumero().length() > 0) ? dto.getSubNumero(): "";
                        String lstDisminucion = (dto.getDisminucion() != null && dto.getDisminucion().length() > 0) ? dto.getDisminucion(): "";
                        String lstFechaContabilizacion = (dto.getFechaContabilizacion() != null && dto.getFechaContabilizacion().length() > 0) ? dto.getFechaContabilizacion(): "";

                        DTDisminucionValor.Registro titulo = new DTDisminucionValor.Registro();
                        titulo.setCodigoSAP(lstCodigoSAP);
                        titulo.setFechaContab(lstFechaContabilizacion);
                        titulo.setFechaInicio(lstFechaContabilizacion);
                        titulo.setImporte(lstDisminucion);
                        titulo.setSubnumero(lstSubNumero);
                        params.getRegistro().add(titulo);
			
			//--Llamado al WS de SAP. Interfaz 51
			DTDisminucionValorRes responseDisminuyeCosto = new DTDisminucionValorRes();
			LOG.debug ( "        Url Srv. Disminucion Costo Activo Fijo: " + this.getUrlServicio("51") );
			
			//--REAL CODE
			responseDisminuyeCosto = (DTDisminucionValorRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("51"), params);
			
			if(responseDisminuyeCosto != null && responseDisminuyeCosto.getRegistro() != null && responseDisminuyeCosto.getRegistro().size() > 0)
			{
				
				int lnuTitulosProcesados = responseDisminuyeCosto.getRegistro().size();
				LOG.info("                Total titulos procesados SAP(Disminucion Costo): " + lnuTitulosProcesados);
				
				if(lnuTitulosProcesados == 1)
				{
					RespSAPCambioCostoAFijoDTO respDC = new RespSAPCambioCostoAFijoDTO(); 
					respDC.setCodigoSAP(responseDisminuyeCosto.getRegistro().get(0).getCodigoSAP());
					respDC.setStatus(responseDisminuyeCosto.getRegistro().get(0).getStatus());
					respDC.setSubNumero(responseDisminuyeCosto.getRegistro().get(0).getSubnumero());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Disminucion costo]: <CodSAP:["+respDC.getCodigoSAP()+"], Status:["+respDC.getStatus()+"], Subnumero:["+respDC.getSubNumero()+"]> ");
					
					afs.add(respDC);
					resultado.setResultado(true);
				}
				else
				{
					writeResponse(tf, "DDA-TAF-005", ERROR_RESP_DISTINTA, "Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.", method, dto.getIdTituloCnt(), dao);
					resultado.setResultado(false);
				}
				
			}
			else
			{
                                writeResponse(tf, "DDA-TAF-004", ERROR_COMUNICACION_SAP, "El servicio web se ejecuto, pero la respuesta es NULL", method, dto.getIdTituloCnt(), dao);
				resultado.setResultado(false);
			}
			
			return resultado;
			
			
		}
		catch(WebServiceException c)
		{
                        writeResponse(tf, "DDA-TAF-001", ERROR_COMUNICACION_SAP, c.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
                        writeResponse(tf, "DDA-TAF-002", ERROR_INTERNO_SAP, se.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
                        writeResponse(tf, "DDA-TAF-003", ERROR_PROCESO, e.getMessage(), method, dto.getIdTituloCnt(), dao);
			resultado.setResultado(false);
			return resultado;
		}
	}
	
	/*public ResultadoCambiaNombreAFijoDTO cambiaNombreActivoFijoWS(ParamCambiaNombreAFijoDTO dto)
	{
		ResultadoCambiaNombreAFijoDTO resultado = new ResultadoCambiaNombreAFijoDTO();
		TransactionFaultDTO tf = resultado.getTransFault();
		List<RespSAPCambiaNombreActivoFijoDTO> afs = resultado.getActivosFijos();
		
		try
		{
			DTNombreActivoFReq params = new DTNombreActivoFReq();
			
			//--Recorrido de titulos
			int lnuTotalTitulos = dto.getTitulos().size();
			String lstIdActivoFijo = "";
			String lstCodigoDDA = "";
			String lstNuevoNombre = "";
			String lstProgramID = "";
			
			for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
			{
				lstIdActivoFijo = (dto.getTitulos().get(xTitulo).getIdActivoFijo() != null && dto.getTitulos().get(xTitulo).getIdActivoFijo().length() > 0) ? dto.getTitulos().get(xTitulo).getIdActivoFijo(): "";
				lstCodigoDDA = (dto.getTitulos().get(xTitulo).getCodigoDDA() != null && dto.getTitulos().get(xTitulo).getCodigoDDA().length() > 0) ? dto.getTitulos().get(xTitulo).getCodigoDDA(): "";
				lstNuevoNombre = (dto.getTitulos().get(xTitulo).getNuevoNombre() != null && dto.getTitulos().get(xTitulo).getNuevoNombre().length() > 0) ? dto.getTitulos().get(xTitulo).getNuevoNombre(): "";
				lstProgramID = (dto.getTitulos().get(xTitulo).getProgramID() != null && dto.getTitulos().get(xTitulo).getProgramID().length() > 0) ? dto.getTitulos().get(xTitulo).getProgramID(): "";
				
				DTNombreActivoFReq.Registro registro = new DTNombreActivoFReq.Registro();
				registro.setIDActivoFSAP(lstIdActivoFijo);
				registro.setIDDDA(lstCodigoDDA);
				registro.setNuevoNombre(strManager.extraerPrimerosCaracteres(lstNuevoNombre, 50));
				registro.setProgramID(lstProgramID);
				params.getRegistro().add(registro);
				
			}//Ends for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
			
			//--Llamado a WS SAP. Interfaz 20
			DTNombreActivoFRes responseCambiaNombreAFijo = new DTNombreActivoFRes();
			LOG.debug ( "                Url Srv. Modificar AF: " + this.getUrlServicio("20") );
			
			//--REAL CODE
			responseCambiaNombreAFijo = (DTNombreActivoFRes) wsCRNClienteSAP.marshalSendAndReceive(this.getUrlServicio("20"), params);
			
			
			if(responseCambiaNombreAFijo != null && responseCambiaNombreAFijo.getRespuesta() != null && responseCambiaNombreAFijo.getRespuesta().size() > 0)
			{
				int lnuTitulosProcesados = responseCambiaNombreAFijo.getRespuesta().size();
				LOG.info("                Total titulos procesados SAP(Modificar AF): " + lnuTitulosProcesados);
				
				
				if(lnuTitulosProcesados == 1)
				{
					
					RespSAPCambiaNombreActivoFijoDTO respCN = new RespSAPCambiaNombreActivoFijoDTO();
					respCN.setCodigoSAP(responseCambiaNombreAFijo.getRespuesta().get(0).getIDSAP());
					respCN.setStatus(responseCambiaNombreAFijo.getRespuesta().get(0).getStatus());
					LOG.info("                    [INI/FIN] Detalle respuesta devuelta por SAP [Cambio Nombre]: <CodSAP:["+respCN.getCodigoSAP()+"], Status:["+respCN.getStatus()+"]> ");
					
					afs.add(respCN);
					resultado.setResultado(true);
				}
				else
				{
					tf.setInternalCode("DDA-CNAF-005");
					tf.setComponent(COMPONENTE);
					tf.setFaultDescription(ERROR_RESP_DISTINTA);
					tf.setFaultMessage("Se esperaba 1 y solo 1 registro y la respuesta fue distinta de 1.");
					tf.setMethod("cambiaNombreActivoFijoWS");
					resultado.setResultado(false);
				}
				
				
			}//Ends if(responseCambiaNombreAFijo != null && responseCambiaNombreAFijo.getRespuesta() != null && responseCambiaNombreAFijo.getRespuesta().size() > 0)
			else
			{
				tf.setInternalCode("DDA-CNAF-004");
				tf.setComponent(COMPONENTE);
				tf.setFaultDescription(ERROR_COMUNICACION_SAP);
				tf.setFaultMessage("El servicio web se ejecuto, pero la respuesta es NULL");
				tf.setMethod("cambiaNombreActivoFijoWS");
				resultado.setResultado(false);
			}
			
			return resultado;
			
		}
		catch(WebServiceException c)
		{
			tf.setInternalCode("DDA-CNAF-001");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_COMUNICACION_SAP);
			tf.setFaultMessage(c.getMessage());
			tf.setMethod("cambiaNombreActivoFijoWS");
			resultado.setResultado(false);
	    	return resultado;
		}	
		catch(SoapFaultClientException se)
		{	
			tf.setInternalCode("DDA-CNAF-002");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_INTERNO_SAP);
			tf.setFaultMessage(se.getMessage());
			tf.setMethod("cambiaNombreActivoFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		catch(Exception e)
		{
			tf.setInternalCode("DDA-CNAF-003");
			tf.setComponent(COMPONENTE);
			tf.setFaultDescription(ERROR_PROCESO);
			tf.setFaultMessage(e.getMessage());
			tf.setMethod("cambiaNombreActivoFijoWS");
			resultado.setResultado(false);
			return resultado;
		}
		
	}*/
	
	private String getUrlServicio(String pNumInterfaz)
	{
		String urlServicio = env.getProperty(AMBIENTE+".clientws.interface.i"+pNumInterfaz).replaceAll("%servidor%", SERVIDOR).replaceAll("%puerto%", PUERTO);
                LOG.info("************************************** getUrl: " + urlServicio);
                LOG.info("************************************** pNumInterfaz: " + pNumInterfaz);
                
	    return urlServicio;
	}
        
        private void writeResponse(TransactionFaultDTO tf, String intCode, String faultDesc, String message, String method, String idtituloCnt, DDAClienteSAPDAO dao){
            tf.setInternalCode(intCode);
            tf.setComponent(COMPONENTE);
            tf.setFaultDescription(faultDesc);
            tf.setFaultMessage(message);
            tf.setMethod(method);
            dao.actualizarEstatusSapTitulosByTitulo(faultDesc, idtituloCnt);
        }
}
