package mx.com.amx.mx.dda.crn.dao;

import java.util.List;
import mx.com.amx.mx.dda.crn.dto.ContratoDTO;

import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.crn.dto.DatosCntTituloExhibicionDTO;
import mx.com.amx.mx.dda.crn.dto.ItemActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParametroDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoPagoDTO;

public interface IDDAExhibicionDAO 
{
	public List<ParametroDTO> getValorDiaNotificacion() throws Exception;
	public boolean puedeIniciarProcesoNotificacion() throws Exception;
	public boolean verificaEjecutandoseProcesoNotificacion() throws Exception;
	public boolean updateEjecutandoseProcesoNotificacion(String pstValor) throws Exception;
	public List<DatosCntTituloExhibicionDTO> obtenerTitulosRecienExhibidos(String pstFechaReferencia) throws Exception;
	public boolean actualizaFechaNotificacion(ContratoTituloDTO dto) throws Exception;
	public boolean insertarRegistroSubnum(String pstIdTituloCnt) throws Exception;
	public List<ItemActivoFijoDTO> obtenerTitulosSinIdSAP_RecienExhibidos(String pstFechaReferencia) throws Exception;
        public List<ItemActivoFijoDTO> obtenerContratosConTitulosSinIdSAP_RecienExhibidos(String pstFechaReferencia) throws Exception;
	public boolean actualizaIdSAPCntTitulo(RespSAPActivoFijoDTO dto) throws Exception;
	public boolean ejecutarSPAmortizacionReal() throws Exception;
        public List<ContratoDTO> obtenerContratos() throws Exception;
        public List<ContratoDTO> obtenerContratosCandidatos() throws Exception;
        public boolean eliminarIdSAPCntTitulo(String idcontrato) throws Exception;
        public List<ContratoPagoDTO> obtenerCondicionesComerciales(String idContrato) throws Exception;
        public List<ContratoPagoDTO> obtenerAnticipo(String idContrato) throws Exception;
        public void actualizarEstatusSapTitulosByContrato(String mensaje, String idContrato);
        public void actualizarEstatusSapTitulosByTitulo(String mensaje, String idContrato);
}
