/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.poibrowser;

import java.io.IOException;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;

public class DocumentDescriptor {
    String name;
    POIFSDocumentPath path;
    DocumentInputStream stream;
    int size;
    byte[] bytes;

    public DocumentDescriptor(String name, POIFSDocumentPath path, DocumentInputStream stream, int nrOfBytes) {
        this.name = name;
        this.path = path;
        this.stream = stream;
        try {
            this.size = stream.available();
            if (stream.markSupported()) {
                stream.mark(nrOfBytes);
                byte[] b = new byte[nrOfBytes];
                int read = stream.read(b, 0, Math.min(this.size, b.length));
                this.bytes = new byte[read];
                System.arraycopy(b, 0, this.bytes, 0, read);
                stream.reset();
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }
}

