/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsJobException;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public class SendQueueMessageJob
implements Job {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        QueueConnectionFactory qcf = null;
        QueueConnection conn = null;
        QueueSession session = null;
        Queue queue = null;
        QueueSender sender = null;
        InitialContext ctx = null;
        JobDetail detail = context.getJobDetail();
        JobDataMap jobDataMap = detail.getJobDataMap();
        try {
            ctx = JmsHelper.getInitialContext(jobDataMap);
            qcf = (QueueConnectionFactory)ctx.lookup(jobDataMap.getString("jms.connection.factory"));
            if (JmsHelper.isDestinationSecure(jobDataMap)) {
                String user = jobDataMap.getString("jms.user");
                String pw = jobDataMap.getString("jms.password");
                conn = qcf.createQueueConnection(user, pw);
            } else {
                conn = qcf.createQueueConnection();
            }
            boolean useTransactions = JmsHelper.useTransaction(jobDataMap);
            int ackMode = jobDataMap.getInt("jms.acknowledge");
            session = conn.createQueueSession(useTransactions, ackMode);
            String queueName = jobDataMap.getString("jms.destination");
            queue = (Queue)ctx.lookup(queueName);
            sender = session.createSender(queue);
            String factoryClass = jobDataMap.getString("jms.message.factory.class.name");
            JmsMessageFactory factory = JmsHelper.getMessageFactory(factoryClass);
            Message m = factory.createMessage(jobDataMap, (Session)session);
            sender.send(m);
        }
        catch (NamingException e) {
            try {
                throw new JobExecutionException(e.getMessage());
                catch (JMSException e2) {
                    throw new JobExecutionException(e2.getMessage());
                }
                catch (JmsJobException e3) {
                    throw new JobExecutionException(e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(sender);
                JmsHelper.closeResource(session);
                JmsHelper.closeResource(conn);
                throw throwable;
            }
        }
        JmsHelper.closeResource(sender);
        JmsHelper.closeResource(session);
        JmsHelper.closeResource(conn);
    }
}

