/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.groovy;

import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;

public class JsonSlurper
extends GroovyObjectSupport {
    private JsonConfig jsonConfig;

    public JsonSlurper() {
        this(new JsonConfig());
    }

    public JsonSlurper(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig != null ? jsonConfig : new JsonConfig();
    }

    public JSON parse(File file) throws IOException {
        return this.parse(new FileReader(file));
    }

    public JSON parse(URL url) throws IOException {
        return this.parse(url.openConnection().getInputStream());
    }

    public JSON parse(InputStream input) throws IOException {
        return this.parse(new InputStreamReader(input));
    }

    public JSON parse(String uri) throws IOException {
        return this.parse(new URL(uri));
    }

    public JSON parse(Reader reader) throws IOException {
        char[] chunk = new char[1024];
        StringBuffer buffer = new StringBuffer();
        while (reader.read(chunk) != -1) {
            buffer.append(chunk);
        }
        return this.parseText(buffer.toString());
    }

    public JSON parseText(String text) {
        return JSONSerializer.toJSON((Object)text, this.jsonConfig);
    }
}

