package mx.com.amx.mx.dda.crn.dto;

import java.io.Serializable;
import java.util.List;

/**
 * Representa la respuesta que sera enviada al Front-End por parte de este cliente en la creacion de una orden de Compra (Contrato)
 * Incluye un mensaje y resultado de la transaccion.
 *
 */
public class ResponseOrdenCompraDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String mensaje;
	private boolean resultado;
	private int lnuTotalRegOCSAP_Envio;
	private int lnuTotalRegOCSAP_Regreso;
	private int lnuTotalRegOCSAP_OK;
	private int lnuTotalRegOCSAP_NOOK;
	private int lnuTotalUpdIdSAP_OK;
	private int lnuTotalUpdIdSAP_NOOK;
        private List<ItemActivoFijoDTO> titulos;
	
	public String getMensaje() {
		return this.mensaje;
	}
	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}
	public boolean getResultado() {
		return resultado;
	}
	public void setResultado(boolean resultado) {
		this.resultado = resultado;
	}
	
	public int getLnuTotalRegOCSAP_Envio() {
		return lnuTotalRegOCSAP_Envio;
	}
	public void setLnuTotalRegOCSAP_Envio(int lnuTotalRegOCSAP_Envio) {
		this.lnuTotalRegOCSAP_Envio = lnuTotalRegOCSAP_Envio;
	}
	public int getLnuTotalRegOCSAP_Regreso() {
		return lnuTotalRegOCSAP_Regreso;
	}
	public void setLnuTotalRegOCSAP_Regreso(int lnuTotalRegOCSAP_Regreso) {
		this.lnuTotalRegOCSAP_Regreso = lnuTotalRegOCSAP_Regreso;
	}
	public int getLnuTotalRegOCSAP_OK() {
		return lnuTotalRegOCSAP_OK;
	}
	public void setLnuTotalRegOCSAP_OK(int lnuTotalRegOCSAP_OK) {
		this.lnuTotalRegOCSAP_OK = lnuTotalRegOCSAP_OK;
	}
	public int getLnuTotalRegOCSAP_NOOK() {
		return lnuTotalRegOCSAP_NOOK;
	}
	public void setLnuTotalRegOCSAP_NOOK(int lnuTotalRegOCSAP_NOOK) {
		this.lnuTotalRegOCSAP_NOOK = lnuTotalRegOCSAP_NOOK;
	}
	public int getLnuTotalUpdIdSAP_OK() {
		return lnuTotalUpdIdSAP_OK;
	}
	public void setLnuTotalUpdIdSAP_OK(int lnuTotalUpdIdSAP_OK) {
		this.lnuTotalUpdIdSAP_OK = lnuTotalUpdIdSAP_OK;
	}
	public int getLnuTotalUpdIdSAP_NOOK() {
		return lnuTotalUpdIdSAP_NOOK;
	}
	public void setLnuTotalUpdIdSAP_NOOK(int lnuTotalUpdIdSAP_NOOK) {
		this.lnuTotalUpdIdSAP_NOOK = lnuTotalUpdIdSAP_NOOK;
	}

        public List<ItemActivoFijoDTO> getTitulos() {
            return titulos;
        }

        public void setTitulos(List<ItemActivoFijoDTO> titulos) {
            this.titulos = titulos;
        }
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" mensaje: _" + this.getMensaje() + "_" + NEW_LINE);
		result.append(" resultado: _" + this.getResultado() + "_" + NEW_LINE);
		result.append(" lnuTotalRegOCSAP_Envio: _" + this.getLnuTotalRegOCSAP_Envio() + "_" + NEW_LINE);
		result.append(" lnuTotalRegOCSAP_Regreso: _" + this.getLnuTotalRegOCSAP_Regreso() + "_" + NEW_LINE);
		result.append(" lnuTotalRegOCSAP_OK: _" + this.getLnuTotalRegOCSAP_OK() + "_" + NEW_LINE);
		result.append(" lnuTotalRegOCSAP_NOOK: _" + this.getLnuTotalRegOCSAP_NOOK() + "_" + NEW_LINE);
		result.append(" lnuTotalUpdIdSAP_OK: _" + this.getLnuTotalUpdIdSAP_OK() + "_" + NEW_LINE);
		result.append(" lnuTotalUpdIdSAP_NOOK: _" + this.getLnuTotalUpdIdSAP_NOOK() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
}
