package mx.com.amx.mx.dda.crn.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Representa el manejo interno que se le dara al llamado del WS a SAP para
 * Notificar Activos Fijos (Titulos recien exhibidos). considerando los posibles
 * escenarios de exito y error. Si el objeto TransactionFaultDTO tiene valores,
 * entonces ocurrio alguna excepcion en el llamado. Si la lista de
 * RespSAPNotificaAFijoDTO tiene valores entonces la conexion al servicio se
 * realizo satisfactoriamente. En resumen, ambos objetos deben ser mutuamente
 * excluyentes, indicando el exito o el error segun haya sucedido.
 */
public class ResultadoNotificacionDTO implements Serializable {

    private static final long serialVersionUID = 1L;
    private List<RespSAPNotificaAFijoDTO> notificaciones = new ArrayList<RespSAPNotificaAFijoDTO>();
    private TransactionFaultDTO transFault = new TransactionFaultDTO();
    private Integer titulosEnviados;
    private boolean resultado;

    public Integer getTitulosEnviados() {
        return titulosEnviados;
    }

    public void setTitulosEnviados(Integer titulosEnviados) {
        this.titulosEnviados = titulosEnviados;
    }

    public List<RespSAPNotificaAFijoDTO> getNotificaciones() {
        return notificaciones;
    }

    public void setNotificaciones(List<RespSAPNotificaAFijoDTO> notificaciones) {
        this.notificaciones = notificaciones;
    }

    public TransactionFaultDTO getTransFault() {
        return transFault;
    }

    public void setTransFault(TransactionFaultDTO transFault) {
        this.transFault = transFault;
    }

    public boolean getResultado() {
        return resultado;
    }

    public void setResultado(boolean resultado) {
        this.resultado = resultado;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        result.append(" [Begin of Class] " + NEW_LINE);
        result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
        result.append(" notificaciones: _" + this.getNotificaciones().size() + "_" + NEW_LINE);
        result.append(" tFault: _" + this.getTransFault().toString() + "_" + NEW_LINE);
        result.append(" resultado: _" + this.getResultado() + "_" + NEW_LINE);
        result.append(" titulosEnviados: _" + this.getTitulosEnviados() + "_" + NEW_LINE);
        result.append(" [End of Class] " + NEW_LINE);
        result.append("}");
        NEW_LINE = null;

        return result.toString();
    }
}
