/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class RSAKeyValueResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)RSAKeyValueResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName()));
        }
        if (element == null) {
            return null;
        }
        boolean bl = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        Element element2 = null;
        if (bl) {
            element2 = XMLUtils.selectDsNode(element.getFirstChild(), "RSAKeyValue", 0);
        } else if (XMLUtils.elementIsInSignatureSpace(element, "RSAKeyValue")) {
            element2 = element;
        }
        if (element2 == null) {
            return null;
        }
        try {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(element2, string);
            return rSAKeyValue.getPublicKey();
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
            return null;
        }
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

