package mx.com.amx.mx.dda.crn.dto;

import java.io.Serializable;
import java.util.List;

/**
 * Representa los parametros del Activo Fijo (Titulos) enviados desde el front-end, mismos que son 
 * recibidos por este cliente. Esta clase pertenece al ambito de DDA.
 */
public class ParamActivoFijoDTO implements Serializable 
{
    private static final long serialVersionUID = 1L;
    private List<ItemActivoFijoDTO> titulos;
    private List<ItemActivoFijoDTO> contratos;

    public List<ItemActivoFijoDTO> getTitulos() {
        return titulos;
    }
    public void setTitulos(List<ItemActivoFijoDTO> titulos) {
        this.titulos = titulos;
    }

    public List<ItemActivoFijoDTO> getContratos() {
        return contratos;
    }

    public void setContratos(List<ItemActivoFijoDTO> contratos) {
        this.contratos = contratos;
    }
    
    public String toString() 
    {
            StringBuilder result = new StringBuilder();
            String NEW_LINE = System.getProperty("line.separator");
            result.append(" [Begin of Class] " + NEW_LINE);
            result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
            result.append(" items: _" + this.getTitulos().size() + "_" + NEW_LINE);
            result.append(" [End of Class] " + NEW_LINE);
            result.append("}");
            NEW_LINE = null;

            return result.toString();
    }
}
