package mx.com.amx.mx.dda.crn.dto;

import java.io.Serializable;

/**
 * Representa el manejo de errores.
 * Es utilizado con fines de tracking en el momento de ocurrir algun error o excepcion.
 * Los campos que usa son:
 * <br>
 * InternalCode : Es el codigo interno de error que se ha generado. Ejemplo: DDA-CNT-001. Mismo que significa que es un error del sistema DDA 
 * perteneciente a operaciones de contratos (CNT) y que es el error con identificador 001.
 * <br>
 * Component: Es el nombre del componente donde se gener el error. Ejemplo: DDA_ClienteSAP :: ClienteBO. Donde indica que el proyecto es DDA_ClienteSAP y esta en la
 * clase ClienteBO.
 * <br>
 * Method : Es el nombre del metodo donde se genera el error. Ejemplo: crearActivoFijoWS.
 * <br>
 * FaultDescription: Es la descripcion del error generado. Ejemplo: Error al comunicarse con el web service de SAP.
 * <br>
 * FaultMessage: Es la descripcin tecnica del error presentado o el mensaje devuelto por la excepcion misma. Ejemplo: e.getMessage(). (Donde e es una variable de tipo Exception)
 *  
 */
public class TransactionFaultDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String InternalCode;
	private String Component;
	private String Method;
	private String FaultDescription;
	private String FaultMessage;
	
	
	public String getInternalCode() {
		return this.InternalCode;
	}
	public void setInternalCode(String internalCode) {
		this.InternalCode = internalCode;
	}
	public String getComponent() {
		return this.Component;
	}
	public void setComponent(String component) {
		this.Component = component;
	}
	public String getMethod() {
		return this.Method;
	}
	public void setMethod(String method) {
		this.Method = method;
	}
	public String getFaultDescription() {
		return this.FaultDescription;
	}
	public void setFaultDescription(String faultDescription) {
		this.FaultDescription = faultDescription;
	}
	public String getFaultMessage() {
		return this.FaultMessage;
	}
	public void setFaultMessage(String faultMessage) {
		this.FaultMessage = faultMessage;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" InternalCode: _" + this.getInternalCode() + "_" + NEW_LINE);
		result.append(" Component: _" + this.getComponent() + "_" + NEW_LINE);
		result.append(" Method: _" + this.getMethod() + "_" + NEW_LINE);
		result.append(" FaultDescription: _" + this.getFaultDescription() + "_" + NEW_LINE);
		result.append(" FaultMessage: _" + this.getFaultMessage() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
}
