/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package mx.com.mx.dda.msjb;

/**
 *
 * @author albarranoi
 */
import java.io.*;
import java.util.List;
import javax.servlet.*;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.*;
import mx.com.amx.mx.dda.crn.DDAExhibicion;
import mx.com.amx.mx.dda.crn.bo.DDAExhibicionBO;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;


@WebServlet(name="service", urlPatterns={"/servicio"})
public class service extends HttpServlet {

    private DDAExhibicion ex;
    private DDAExhibicionBO bo;
    private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws IOException, ServletException {
        String jsonList = request.getParameter("lista");
        ObjectMapper objMapper = new ObjectMapper();
        List<String> contratos = objMapper.readValue(jsonList, new TypeReference<List<String>>() {});
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        String msg = ejec(contratos,jsonList);
        out.write("{\"rows\":\"" + msg + "\"}");
    }

    public String ejec( List<String> contratos, String jsonList) {

        ApplicationContext context = new ClassPathXmlApplicationContext("ApplicationContext.xml");
        setEx((DDAExhibicion) context.getBean("exhibicion_DDA"));
        LOG.info("    Ejecutando proceso por solicitud para los contratos: " + jsonList);
        String cntrts = "";
        boolean primero = true;
        for (String elemento : contratos) {
            if (!primero) {
                cntrts += ",";
            }
            cntrts += elemento;
            primero = false;
        }
        getEx().ejecutaProceso(cntrts);
        return "OK";
    }

    /**
     * @return the ex
     */
    public DDAExhibicion getEx() {
        return ex;
    }

    /**
     * @param ex the ex to set
     */
    public void setEx(DDAExhibicion ex) {
        this.ex = ex;
    }

}
