/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;
import org.w3c.dom.Element;

public abstract class SaajUtils {
    public static final int SAAJ_11 = 0;
    public static final int SAAJ_12 = 1;
    public static final int SAAJ_13 = 2;
    private static final String SAAJ_13_CLASS_NAME = "javax.xml.soap.SAAJMetaFactory";
    private static int saajVersion = 1;

    private static boolean isSaaj13() {
        try {
            ClassUtils.forName((String)SAAJ_13_CLASS_NAME);
            MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
        catch (SOAPException ex) {
            return false;
        }
    }

    private static boolean isSaaj12() {
        if (Element.class.isAssignableFrom(SOAPElement.class)) {
            try {
                MessageFactory messageFactory = MessageFactory.newInstance();
                SOAPMessage message = messageFactory.createMessage();
                try {
                    message.getSOAPBody();
                    return true;
                }
                catch (UnsupportedOperationException ex) {
                    return false;
                }
            }
            catch (SOAPException e) {
                return false;
            }
        }
        return false;
    }

    public static int getSaajVersion() {
        return saajVersion;
    }

    public static String getSaajVersionString() {
        if (saajVersion >= 2) {
            return "SAAJ 1.3";
        }
        if (saajVersion == 1) {
            return "SAAJ 1.2";
        }
        if (saajVersion == 0) {
            return "SAAJ 1.1";
        }
        return "";
    }

    public static Name toName(QName qName, SOAPElement resolveElement) throws SOAPException {
        String qNamePrefix = QNameUtils.getPrefix(qName);
        SOAPEnvelope envelope = SaajUtils.getEnvelope(resolveElement);
        if (StringUtils.hasLength((String)qName.getNamespaceURI()) && StringUtils.hasLength((String)qNamePrefix)) {
            return envelope.createName(qName.getLocalPart(), qNamePrefix, qName.getNamespaceURI());
        }
        if (StringUtils.hasLength((String)qName.getNamespaceURI())) {
            Iterator prefixes = SaajUtils.getSaajVersion() == 0 ? resolveElement.getNamespacePrefixes() : resolveElement.getVisibleNamespacePrefixes();
            while (prefixes.hasNext()) {
                String prefix = (String)prefixes.next();
                if (!qName.getNamespaceURI().equals(resolveElement.getNamespaceURI(prefix))) continue;
                return envelope.createName(qName.getLocalPart(), prefix, qName.getNamespaceURI());
            }
            return envelope.createName(qName.getLocalPart(), "", qName.getNamespaceURI());
        }
        return envelope.createName(qName.getLocalPart());
    }

    public static QName toQName(Name name) {
        if (StringUtils.hasLength((String)name.getURI()) && StringUtils.hasLength((String)name.getPrefix())) {
            return QNameUtils.createQName(name.getURI(), name.getLocalName(), name.getPrefix());
        }
        if (StringUtils.hasLength((String)name.getURI())) {
            return new QName(name.getURI(), name.getLocalName());
        }
        return new QName(name.getLocalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPMessage loadMessage(Resource resource, MessageFactory messageFactory) throws SOAPException, IOException {
        InputStream is = resource.getInputStream();
        try {
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            mimeHeaders.addHeader("Content-Length", Long.toString(resource.getFile().length()));
            SOAPMessage sOAPMessage = messageFactory.createMessage(mimeHeaders, is);
            return sOAPMessage;
        }
        finally {
            is.close();
        }
    }

    public static SOAPEnvelope getEnvelope(SOAPElement element) {
        Assert.notNull((Object)element, (String)"Element should not be null");
        do {
            if (!(element instanceof SOAPEnvelope)) continue;
            return (SOAPEnvelope)element;
        } while ((element = element.getParentElement()) != null);
        return null;
    }

    static {
        saajVersion = SaajUtils.isSaaj13() ? 2 : (SaajUtils.isSaaj12() ? 1 : 0);
    }
}

