/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback.acegi;

import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.UserCache;
import org.acegisecurity.providers.dao.cache.NullUserCache;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.xwss.callback.DefaultTimestampValidator;

public class AcegiDigestPasswordValidationCallbackHandler
extends AbstractCallbackHandler
implements InitializingBean {
    private UserCache userCache = new NullUserCache();
    private UserDetailsService userDetailsService;

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"userDetailsService is required");
    }

    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof PasswordValidationCallback) {
            PasswordValidationCallback passwordCallback = (PasswordValidationCallback)callback;
            if (passwordCallback.getRequest() instanceof PasswordValidationCallback.DigestPasswordRequest) {
                PasswordValidationCallback.DigestPasswordRequest request = (PasswordValidationCallback.DigestPasswordRequest)passwordCallback.getRequest();
                String username = request.getUsername();
                UserDetails user = this.loadUserDetails(username);
                if (user != null) {
                    request.setPassword(user.getPassword());
                }
                AcegiDigestPasswordValidator validator = new AcegiDigestPasswordValidator(user);
                passwordCallback.setValidator((PasswordValidationCallback.PasswordValidator)validator);
                return;
            }
        } else if (callback instanceof TimestampValidationCallback) {
            TimestampValidationCallback timestampCallback = (TimestampValidationCallback)callback;
            timestampCallback.setValidator((TimestampValidationCallback.TimestampValidator)new DefaultTimestampValidator());
        } else if (callback instanceof CleanupCallback) {
            SecurityContextHolder.clearContext();
            return;
        }
        throw new UnsupportedCallbackException(callback);
    }

    private UserDetails loadUserDetails(String username) throws DataAccessException {
        UserDetails user = this.userCache.getUserFromCache(username);
        if (user == null) {
            try {
                user = this.userDetailsService.loadUserByUsername(username);
            }
            catch (UsernameNotFoundException notFound) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Username '" + username + "' not found"));
                }
                return null;
            }
            this.userCache.putUserInCache(user);
        }
        return user;
    }

    private class AcegiDigestPasswordValidator
    extends PasswordValidationCallback.DigestPasswordValidator {
        private UserDetails user;

        private AcegiDigestPasswordValidator(UserDetails user) {
            this.user = user;
        }

        public boolean validate(PasswordValidationCallback.Request request) throws PasswordValidationCallback.PasswordValidationException {
            if (super.validate(request)) {
                UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)this.user, (Object)this.user.getPassword());
                if (AcegiDigestPasswordValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    AcegiDigestPasswordValidationCallbackHandler.this.logger.debug((Object)("Authentication success: " + authRequest.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
                return true;
            }
            return false;
        }
    }
}

