/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.DecryptionKeyCallback;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import org.apache.xml.security.utils.RFC2253Parser;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ws.soap.security.support.KeyStoreUtils;
import org.springframework.ws.soap.security.xwss.callback.CryptographyCallbackHandler;

public class KeyStoreCallbackHandler
extends CryptographyCallbackHandler
implements InitializingBean {
    private static final String X_509_CERTIFICATE_TYPE = "X.509";
    private static final String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";
    private KeyStore keyStore;
    private KeyStore symmetricStore;
    private KeyStore trustStore;
    private String defaultAlias;
    private char[] privateKeyPassword;
    private char[] symmetricKeyPassword;

    private static X509Certificate getCertificate(String alias, KeyStore store) throws IOException {
        try {
            return (X509Certificate)store.getCertificate(alias);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static X509Certificate getCertificate(PublicKey pk, KeyStore store) throws IOException {
        try {
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                String alias = aliases.nextElement();
                Certificate cert = store.getCertificate(alias);
                if (cert == null || !X_509_CERTIFICATE_TYPE.equals(cert.getType()) || !(x509Cert = (X509Certificate)cert).getPublicKey().equals(pk)) continue;
                return x509Cert;
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public void setDefaultAlias(String defaultAlias) {
        this.defaultAlias = defaultAlias;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        if (privateKeyPassword != null) {
            this.privateKeyPassword = privateKeyPassword.toCharArray();
        }
    }

    public void setSymmetricKeyPassword(String symmetricKeyPassword) {
        if (symmetricKeyPassword != null) {
            this.symmetricKeyPassword = symmetricKeyPassword.toCharArray();
        }
    }

    public void setSymmetricStore(KeyStore symmetricStore) {
        this.symmetricStore = symmetricStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.keyStore == null) {
            this.loadDefaultKeyStore();
        }
        if (this.trustStore == null) {
            this.loadDefaultTrustStore();
        }
        if (this.symmetricStore == null) {
            this.symmetricStore = this.keyStore;
        }
        if (this.symmetricKeyPassword == null) {
            this.symmetricKeyPassword = this.privateKeyPassword;
        }
    }

    protected final void handleAliasPrivKeyCertRequest(SignatureKeyCallback callback, SignatureKeyCallback.AliasPrivKeyCertRequest request) throws IOException {
        PrivateKey privateKey = this.getPrivateKey(request.getAlias());
        X509Certificate certificate = this.getCertificate(request.getAlias());
        request.setPrivateKey(privateKey);
        request.setX509Certificate(certificate);
    }

    protected final void handleAliasSymmetricKeyRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.AliasSymmetricKeyRequest request) throws IOException {
        SecretKey secretKey = this.getSymmetricKey(request.getAlias());
        request.setSymmetricKey(secretKey);
    }

    protected final void handleAliasSymmetricKeyRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.AliasSymmetricKeyRequest request) throws IOException {
        SecretKey secretKey = this.getSymmetricKey(request.getAlias());
        request.setSymmetricKey(secretKey);
    }

    protected final void handleAliasX509CertificateRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.AliasX509CertificateRequest request) throws IOException {
        X509Certificate certificate = this.getCertificateFromTrustStore(request.getAlias());
        request.setX509Certificate(certificate);
    }

    protected final void handleCertificateValidationCallback(CertificateValidationCallback callback) {
        callback.setValidator((CertificateValidationCallback.CertificateValidator)new KeyStoreCertificateValidator());
    }

    protected final void handleDefaultPrivKeyCertRequest(SignatureKeyCallback callback, SignatureKeyCallback.DefaultPrivKeyCertRequest request) throws IOException {
        PrivateKey privateKey = this.getPrivateKey(this.defaultAlias);
        X509Certificate certificate = this.getCertificate(this.defaultAlias);
        request.setPrivateKey(privateKey);
        request.setX509Certificate(certificate);
    }

    protected final void handleDefaultX509CertificateRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.DefaultX509CertificateRequest request) throws IOException {
        X509Certificate certificate = this.getCertificateFromTrustStore(this.defaultAlias);
        request.setX509Certificate(certificate);
    }

    protected final void handlePublicKeyBasedPrivKeyCertRequest(SignatureKeyCallback callback, SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest request) throws IOException {
        PrivateKey privateKey = this.getPrivateKey(request.getPublicKey());
        X509Certificate certificate = this.getCertificate(request.getPublicKey());
        request.setPrivateKey(privateKey);
        request.setX509Certificate(certificate);
    }

    protected final void handlePublicKeyBasedPrivKeyRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest request) throws IOException {
        PrivateKey key = this.getPrivateKey(request.getPublicKey());
        request.setPrivateKey(key);
    }

    protected final void handlePublicKeyBasedRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.PublicKeyBasedRequest request) throws IOException {
        X509Certificate certificate = this.getCertificateFromTrustStore(request.getPublicKey());
        request.setX509Certificate(certificate);
    }

    protected final void handlePublicKeyBasedRequest(SignatureVerificationKeyCallback callback, SignatureVerificationKeyCallback.PublicKeyBasedRequest request) throws IOException {
        X509Certificate certificate = this.getCertificateFromTrustStore(request.getPublicKey());
        request.setX509Certificate(certificate);
    }

    protected final void handleX509CertificateBasedRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.X509CertificateBasedRequest request) throws IOException {
        PrivateKey privKey = this.getPrivateKey(request.getX509Certificate());
        request.setPrivateKey(privKey);
    }

    protected final void handleX509IssuerSerialBasedRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.X509IssuerSerialBasedRequest request) throws IOException {
        PrivateKey key = this.getPrivateKey(request.getIssuerName(), request.getSerialNumber());
        request.setPrivateKey(key);
    }

    protected final void handleX509IssuerSerialBasedRequest(SignatureVerificationKeyCallback callback, SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest request) throws IOException {
        X509Certificate certificate = this.getCertificateFromTrustStore(request.getIssuerName(), request.getSerialNumber());
        request.setX509Certificate(certificate);
    }

    protected final void handleX509SubjectKeyIdentifierBasedRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest request) throws IOException {
        PrivateKey key = this.getPrivateKey(request.getSubjectKeyIdentifier());
        request.setPrivateKey(key);
    }

    protected final void handleX509SubjectKeyIdentifierBasedRequest(SignatureVerificationKeyCallback callback, SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest request) throws IOException {
        X509Certificate certificate = this.getCertificateFromTrustStore(request.getSubjectKeyIdentifier());
        request.setX509Certificate(certificate);
    }

    protected X509Certificate getCertificate(String alias) throws IOException {
        return KeyStoreCallbackHandler.getCertificate(alias, this.keyStore);
    }

    protected X509Certificate getCertificate(PublicKey pk) throws IOException {
        return KeyStoreCallbackHandler.getCertificate(pk, this.keyStore);
    }

    protected X509Certificate getCertificateFromTrustStore(String alias) throws IOException {
        return KeyStoreCallbackHandler.getCertificate(alias, this.trustStore);
    }

    protected X509Certificate getCertificateFromTrustStore(byte[] subjectKeyIdentifier) throws IOException {
        try {
            Enumeration<String> aliases = this.trustStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = aliases.nextElement();
                Certificate cert = this.trustStore.getCertificate(alias);
                if (cert == null || !X_509_CERTIFICATE_TYPE.equals(cert.getType()) || (keyId = this.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(subjectKeyIdentifier, keyId)) continue;
                return x509Cert;
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    protected X509Certificate getCertificateFromTrustStore(PublicKey pk) throws IOException {
        return KeyStoreCallbackHandler.getCertificate(pk, this.trustStore);
    }

    protected X509Certificate getCertificateFromTrustStore(String issuerName, BigInteger serialNumber) throws IOException {
        try {
            Enumeration<String> aliases = this.trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = this.trustStore.getCertificate(alias);
                if (cert == null || !X_509_CERTIFICATE_TYPE.equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize((String)x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return x509Cert;
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    protected PrivateKey getPrivateKey(String alias) throws IOException {
        try {
            return (PrivateKey)this.keyStore.getKey(alias, this.privateKeyPassword);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected PrivateKey getPrivateKey(PublicKey publicKey) throws IOException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.privateKeyPassword);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    protected PrivateKey getPrivateKey(X509Certificate certificate) throws IOException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !cert.equals(certificate)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.privateKeyPassword);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    protected PrivateKey getPrivateKey(byte[] keyIdentifier) throws IOException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !X_509_CERTIFICATE_TYPE.equals(cert.getType()) || (keyId = this.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(keyIdentifier, keyId)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.privateKeyPassword);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    protected PrivateKey getPrivateKey(String issuerName, BigInteger serialNumber) throws IOException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !X_509_CERTIFICATE_TYPE.equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize((String)x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.privateKeyPassword);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    protected final byte[] getSubjectKeyIdentifier(X509Certificate cert) {
        byte[] subjectKeyIdentifier = cert.getExtensionValue(SUBJECT_KEY_IDENTIFIER_OID);
        if (subjectKeyIdentifier == null) {
            return null;
        }
        byte[] dest = new byte[subjectKeyIdentifier.length - 4];
        System.arraycopy(subjectKeyIdentifier, 4, dest, 0, subjectKeyIdentifier.length - 4);
        return dest;
    }

    protected SecretKey getSymmetricKey(String alias) throws IOException {
        try {
            return (SecretKey)this.symmetricStore.getKey(alias, this.symmetricKeyPassword);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void loadDefaultKeyStore() {
        try {
            this.keyStore = KeyStoreUtils.loadDefaultKeyStore();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Loaded default key store");
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Could not open default key store", (Throwable)ex);
        }
    }

    protected void loadDefaultTrustStore() {
        try {
            this.trustStore = KeyStoreUtils.loadDefaultTrustStore();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Loaded default trust store");
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Could not open default trust store", (Throwable)ex);
        }
    }

    private class KeyStoreCertificateValidator
    implements CertificateValidationCallback.CertificateValidator {
        private KeyStoreCertificateValidator() {
        }

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            CertPathBuilder builder;
            PKIXBuilderParameters parameters;
            if (this.isOwnedCert(certificate)) {
                if (KeyStoreCallbackHandler.this.logger.isDebugEnabled()) {
                    KeyStoreCallbackHandler.this.logger.debug((Object)("Certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] is in private keystore"));
                }
                return true;
            }
            if (KeyStoreCallbackHandler.this.trustStore == null) {
                return false;
            }
            try {
                certificate.checkValidity();
            }
            catch (CertificateExpiredException e) {
                if (KeyStoreCallbackHandler.this.logger.isDebugEnabled()) {
                    KeyStoreCallbackHandler.this.logger.debug((Object)("Certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] has expired"));
                }
                return false;
            }
            catch (CertificateNotYetValidException e) {
                if (KeyStoreCallbackHandler.this.logger.isDebugEnabled()) {
                    KeyStoreCallbackHandler.this.logger.debug((Object)("Certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] is not yet valid"));
                }
                return false;
            }
            X509CertSelector certSelector = new X509CertSelector();
            certSelector.setCertificate(certificate);
            try {
                parameters = new PKIXBuilderParameters(KeyStoreCallbackHandler.this.trustStore, (CertSelector)certSelector);
                parameters.setRevocationEnabled(false);
                builder = CertPathBuilder.getInstance("PKIX");
            }
            catch (GeneralSecurityException ex) {
                throw new CertificateValidationCallback.CertificateValidationException("Could not create PKIX CertPathBuilder", (Throwable)ex);
            }
            try {
                builder.build(parameters);
            }
            catch (CertPathBuilderException e) {
                if (KeyStoreCallbackHandler.this.logger.isDebugEnabled()) {
                    KeyStoreCallbackHandler.this.logger.debug((Object)("Certification path of certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] could not be validated"));
                }
                return false;
            }
            catch (InvalidAlgorithmParameterException e) {
                if (KeyStoreCallbackHandler.this.logger.isDebugEnabled()) {
                    KeyStoreCallbackHandler.this.logger.debug((Object)("Algorithm of certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] could not be validated"));
                }
                return false;
            }
            if (KeyStoreCallbackHandler.this.logger.isDebugEnabled()) {
                KeyStoreCallbackHandler.this.logger.debug((Object)("Certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] validated"));
            }
            return true;
        }

        private boolean isOwnedCert(X509Certificate cert) throws CertificateValidationCallback.CertificateValidationException {
            if (KeyStoreCallbackHandler.this.keyStore == null) {
                return false;
            }
            try {
                Enumeration<String> aliases = KeyStoreCallbackHandler.this.keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509Cert;
                    String alias = aliases.nextElement();
                    if (!KeyStoreCallbackHandler.this.keyStore.isKeyEntry(alias) || (x509Cert = (X509Certificate)KeyStoreCallbackHandler.this.keyStore.getCertificate(alias)) == null || !x509Cert.equals(cert)) continue;
                    return true;
                }
                return false;
            }
            catch (GeneralSecurityException e) {
                throw new CertificateValidationCallback.CertificateValidationException("Could not determine whether certificate is contained in main key store", (Throwable)e);
            }
        }
    }
}

