/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method.dom;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.core.MethodParameter;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadSourceMethodProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomPayloadMethodProcessor
extends AbstractPayloadSourceMethodProcessor {
    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        return this.supports(parameter);
    }

    protected Node resolveRequestPayloadArgument(MethodParameter parameter, Source requestPayload) throws Exception {
        if (requestPayload instanceof DOMSource) {
            return this.resolveArgumentDomSource(parameter, (DOMSource)requestPayload);
        }
        DOMResult domResult = new DOMResult();
        this.transform(requestPayload, domResult);
        DOMSource domSource = new DOMSource(domResult.getNode());
        return this.resolveArgumentDomSource(parameter, domSource);
    }

    private Node resolveArgumentDomSource(MethodParameter parameter, DOMSource requestSource) {
        Node requestNode;
        Class parameterType = parameter.getParameterType();
        if (parameterType.isAssignableFrom((requestNode = requestSource.getNode()).getClass())) {
            return requestNode;
        }
        if (Element.class.equals((Object)parameterType) && requestNode instanceof Document) {
            Document document = (Document)requestNode;
            return document.getDocumentElement();
        }
        throw new UnsupportedOperationException();
    }

    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        return this.supports(returnType);
    }

    protected DOMSource createResponsePayload(MethodParameter returnType, Object returnValue) {
        Element returnedElement = (Element)returnValue;
        return new DOMSource(returnedElement);
    }

    private boolean supports(MethodParameter parameter) {
        return Element.class.equals((Object)parameter.getParameterType());
    }
}

