package mx.com.amx.mx.dda.crn;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import mx.com.amx.mx.dda.crn.bo.DDATerminacionBO;
import mx.com.amx.mx.dda.crn.dto.ContratoDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoEstatusDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.crn.utils.DateManager;

import org.apache.log4j.Logger;


public class DDATerminacion implements ApplicationContextAware
{
	private ApplicationContext context;
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	Properties env 	= 	new Properties();
	DateManager dateManager = new DateManager();
	private DDATerminacionBO bo;
	
	private String ESTATUS_TERMINADO;
	
	public DDATerminacion()
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			ESTATUS_TERMINADO = env.getProperty("estatus.terminado");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	public void ejecutaProceso()
	{
		
		LOG.info("  ");
		LOG.info("<< :::::::::::::::: Inicia Proceso Terminacion DDA :::::::::::::::: >>");
		try
		{
			
			//-- 1. Verifica que no se este ejecutando ya un proceso de Terminacion
			LOG.info("    [INI]. Paso 1.- Verifica bandera de ejecucion de proceso de Terminacion.");
			boolean boEjecutandoseProceso = bo.existeProcesoEjecutandose();
			LOG.info("    [INI]. Paso 1.- Verifica bandera de ejecucion de proceso de Terminacion. Esta ejecutando?: _" + boEjecutandoseProceso+"_");
			
			if(!boEjecutandoseProceso)
			{
				//-- 2. Verificar si se puede iniciar el proceso
				LOG.info("    [INI]. Paso 2.- Verifica si se puede iniciar el proceso de Terminacion.");
				boolean boIniciar = bo.verificaPuedeIniciar();
				LOG.info("    [FIN]. Paso 2.- Verifica si se puede iniciar el proceso de Terminacion. Resultado: _" + boIniciar+"_");
				
				if(boIniciar)
				{
					//-- 3. Actualiza bandera indicando que inicia el proceso general de Terminacion
					LOG.info("    [INI]. Paso 3.- Prendiendo Bandera Inicio Proceso General Costo de Renta.");
					boolean boActualizarBanderaIniciaProceso = bo.actualizarEjecutandoProceso("1"); 
					LOG.info("    [FIN]. Paso 3.- Prendiendo Bandera Inicio Proceso General Costo de Renta. Resultado: _"+boActualizarBanderaIniciaProceso+"_");
					
					if(boActualizarBanderaIniciaProceso)
					{
						//--4. Obtener fecha actual del sistema
						LOG.info("    [INI]. Paso 4.- Obtener fecha actual.");
						String lstFechaActual = dateManager.getFechaActual("dd/mm/yyyy");
						LOG.info("    [INI]. Paso 4.- Obtener fecha actual. Resultado:_"+lstFechaActual+"_");
						
						if(lstFechaActual != null && lstFechaActual.trim().length() > 0)
						{
							//------5. Busqueda de contratos vigentes tipo Suscripcion
							LOG.info("    [INI]. Paso 5.- Buscando contratos vigentes tipo Suscripcion.");
							List<ContratoDTO> lobContratos = bo.consultaContratosVigentes();
							LOG.info("    [FIN]. Paso 5.- Buscando contratos vigentes tipo Suscripcion. Resultado:_" + lobContratos.size()+"_");
							
							if(lobContratos != null && lobContratos.size() > 0)
							{
								//------6. Recorrido de los contratos obtenidos
								LOG.info("    [INI]. Paso 6.- Recorrido de los contratos obtenidos.");
								int lnuTotalContratos = lobContratos.size();
								int lnuTotalContratosTerminados = 0;
								
								for(int xContrato = 0; xContrato < lnuTotalContratos; xContrato++ )
								{
									ContratoDTO contrato = (ContratoDTO)lobContratos.get(xContrato);
									String lstIdContrato = (contrato.getID_CONTRATO() != null && contrato.getID_CONTRATO().trim().length() > 0) ? contrato.getID_CONTRATO() : "";
									
									LOG.info("     ");
									LOG.info("        CONTRATO: <Registro:["+xContrato+"],IdContrato:["+lstIdContrato+"]>");
									
									//----7. Consulta la maxima fecha de los titulos asociados al contrato
									LOG.info("			[INI]. Paso 7.- Buscando maxima fecha de los Titulos asociados a contrato ["+lstIdContrato+"].");
									String lstMaximaFechaTitulos = bo.obtenerMaxFechaTitulosPorContrato(lstIdContrato);
									LOG.info("			[FIN]. Paso 7.- Buscando maxima fecha de los Titulos asociados a contrato ["+lstIdContrato+"]. Resultado:_"+lstMaximaFechaTitulos+"_");
									
									if(lstMaximaFechaTitulos != null && lstMaximaFechaTitulos.trim().length() > 0)
									{
										
										//--8. Validacion de fecha de fin del titulo vs fecha actual
										int lnuResFecha = dateManager.compararFechas(lstMaximaFechaTitulos, lstFechaActual);
										LOG.info("				[INI/FIN]. Paso 8.- Validacion fecha fin - fecha actual. Resultado:_"+lnuResFecha+"_");
										
										
										if(lnuResFecha == -1)
										{
											//--9. Actualizacion de estatus al contrato en cuestion
											LOG.info("				[INI]. Paso 9.- Actualizacion de estatus al contrato ["+lstIdContrato+"].");
											ContratoDTO cntUpd = new ContratoDTO();
											cntUpd.setID_CONTRATO(lstIdContrato);
											cntUpd.setID_ESTATUS(ESTATUS_TERMINADO);
											boolean lboActualizacion = bo.actualizarContrato(cntUpd);
											LOG.info("				[FIN]. Paso 9.- Actualizacion de estatus al contrato ["+lstIdContrato+"]. Resultado:_"+lboActualizacion+"_");
											
											if(lboActualizacion)
											{
												lnuTotalContratosTerminados++;
												
												//--11. Historico de estatus
												LOG.info("				[INI]. Paso 10.- Registro en bitacora de historico de estatus contrato ["+lstIdContrato+"].");
												ContratoEstatusDTO cntEstatus = new ContratoEstatusDTO();
												cntEstatus.setEXPEDIENTE(null);
												cntEstatus.setID_CONTRATO(lstIdContrato);
												cntEstatus.setID_ESTATUS(ESTATUS_TERMINADO);
												boolean lboBitacoraEstatus = bo.registrarBitacoraEstatus(cntEstatus);
												LOG.info("				[FIN]. Paso 10.- Registro en bitacora de historico de estatus contrato ["+lstIdContrato+"]. Resultado:_"+lboBitacoraEstatus+"_");
												
											}
											else
											{
												LOG.error("DDA-TER-007: Ocurrio un error al actualizar el estatus a Terminado del Contrato ["+lstIdContrato+"].");
											}
										}//Ends if(lnuResFecha == -1)
										
									}
									else
									{
										LOG.error("DDA-TER-006: No se pubo obtener la fecha maxima de los titulos asociados al contrato ["+lstIdContrato+"].");
									}
									
								}//Ends for(int xContrato = 0; xContrato < lnuTotalContratos; xContrato++ )
								LOG.info("    [FIN]. Paso 6.- Recorrido de los contratos obtenidos.");
								
								LOG.info("------------------------------------------------------------------------- ");
								LOG.info("- Resumen de proceso: ");
								LOG.info("------------------------------------------------------------------------- ");
								LOG.info("Total de Contratos encontrados: ["+ lnuTotalContratos+"]");
								LOG.info("Total de Contratos Terminados: [" + lnuTotalContratosTerminados+"]");
								LOG.info("  ");
								LOG.info("------------------------------------------------------------------------- ");
								
								//--Finalizacion de proceso
								bo.actualizarEjecutandoProceso("0");
								LOG.info("Apaga bandera de proceso Terminacion.[Finalizacion proceso. ]");
								
							}//Termina if(lobContratos != null && lobContratos.size() > 0)
							else
							{
								LOG.error("DDA-TER-005: No se encontraron contratos vigentes tipo Suscripcion.");
								
								bo.actualizarEjecutandoProceso("0");
								LOG.info("Apaga bandera de proceso Terminacion.[Else_lobContratos_null]");
							}
							
						} // Ends if(lstFechaActual != null && lstFechaActual.trim().length() > 0)
						else
						{
							LOG.error("DDA-TER-004: No se pudo obtener la fecha actual del sistema.");
							
							bo.actualizarEjecutandoProceso("0");
							LOG.info("Apaga bandera de proceso Terminacion.[Else_obtenerFechaActualSistema]");
						}
						
					}//Ends if(boActualizarBanderaIniciaProceso)
					else
					{
						LOG.error("DDA-TER-003: No se pudo actualizar la bandera de inicio de proceso.");
						
						bo.actualizarEjecutandoProceso("0");
						LOG.info("Apaga bandera de proceso Terminacion.[Else_boActualizarBanderaIniciaProceso]");
						
					}
				}//Ends if(boIniciar)
				else
				{
					LOG.error("DDA-TER-002: No se han otorgado los permisos para poder iniciar el proceso.");
				}
			}//Ends if(!boEjecutandoseProceso)
			else
			{
				LOG.error("DDA-TER-001: Es probable que se haya iniciado este proceso previamente.");
			}

		}
		catch (Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutaProceso]: "+e.getMessage() );
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
		}
		
		LOG.info("<< :::::::::::::::: Finaliza Proceso Terminacion DDA :::::::::::::::: >>");
		LOG.info("  ");
	}
	
	
	
	@Override
	public void setApplicationContext(ApplicationContext arg0) 	throws BeansException 
	{
		LOG.info("Entering to the application Context...");
		this.context = context;
	}

	public DDATerminacionBO getBo() {
		return bo;
	}

	public void setBo(DDATerminacionBO bo) {
		this.bo = bo;
	}
	

}


