package mx.com.amx.mx.dda.crn.dao;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import mx.com.amx.mx.dda.crn.dto.ContratoDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoEstatusDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;



@Component
@Qualifier("ddaTerminacionDAO")
public class DDATerminacionDAO implements IDDATerminacionDAO
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	private JdbcTemplate jdbcTemplate;
	
	
	private String PUEDE_EJECUTAR;
	private String INICIADO;
	private String MODULO;
	private String ESTATUS_VIGENTE;
	private String TIPO_CONTRATO_SUSCRIPCION;
	private String ESTATUS_TITULO_ACTIVO;
	
	
	public JdbcTemplate getJdbcTemplate() {
		return jdbcTemplate;
	}

	public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
		this.jdbcTemplate = jdbcTemplate;
	} 
	
	public DDATerminacionDAO() 
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			PUEDE_EJECUTAR=env.getProperty("puede.ejecutar");
			INICIADO=env.getProperty("iniciado");
			MODULO=env.getProperty("modulo");
			ESTATUS_VIGENTE = env.getProperty("estatus.vigente");
			TIPO_CONTRATO_SUSCRIPCION = env.getProperty("tipo.contrato.suscripcion");
			ESTATUS_TITULO_ACTIVO = env.getProperty("estatus.titulo.activo");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	
	}
	

	@Override
	public boolean verificaEjecutandoseProceso() throws Exception 
	{
		boolean lboEjecutando = false;
		StringBuffer sb = new StringBuffer();
		StringBuffer sbD = new StringBuffer();
		List qryParams = new ArrayList();
		
		try
		{
			//--Debug
			sbD.append("select ");
			sbD.append("DECODE(VALOR, 1,'INICIADO', ");
			sbD.append("              0,'STANDBY', ");
			sbD.append("      'STANDBY') as VALOR_TEXTO ");
			sbD.append("from ");
			sbD.append("DLA_C_PARAMETRO ");
			sbD.append("where ");
			sbD.append("CLAVE = '"+INICIADO+"' ");
			sbD.append("AND MODULO = '"+MODULO+"' ");
			LOG.debug(">Sql_D [verificaEjecutandoseProceso]:" + sbD.toString());
			
			//--Ejecucion
			sb.append("select ");
			sb.append("DECODE(VALOR, 1,'INICIADO', ");
			sb.append("              0,'STANDBY', ");
			sb.append("      'STANDBY') as VALOR_TEXTO ");
			sb.append("from ");
			sb.append("DLA_C_PARAMETRO ");
			sb.append("where ");
			sb.append("CLAVE = ? ");
			sb.append("AND MODULO = ? ");
			
			final String lstSQL = sb.toString();
			qryParams.add(INICIADO);
			qryParams.add(MODULO);
			
			String lstValor  = (String) jdbcTemplate.queryForObject(lstSQL,qryParams.toArray(),String.class);
			
			if(lstValor.equalsIgnoreCase("INICIADO"))
				lboEjecutando = true;
			
		}
		catch(EmptyResultDataAccessException er)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::verificaEjecutandoseProceso]: No se encontraron registros coincidentes con la clave especificada. " + er.getMessage() );
			throw new Exception("No se encontraron registros coincidentes con la clave especificada");
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::verificaEjecutandoseProceso]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return lboEjecutando;
	}
	
	@Override
	public boolean puedeIniciarProceso() throws Exception 
	{
		boolean resultado = false;
		StringBuffer sb = new StringBuffer();
		StringBuffer sbD = new StringBuffer();
		List qryParams = new ArrayList();
		
		try
		{
			//--Debug
			sbD.append("select ");
			sbD.append("NVL(VALOR,'0') as VALOR ");
			sbD.append("from ");
			sbD.append("DLA_C_PARAMETRO ");
			sbD.append("where ");
			sbD.append("CLAVE = '"+PUEDE_EJECUTAR+"' ");
			sbD.append("AND MODULO = '"+MODULO+"' ");
			LOG.debug(">Sql_D [puedeIniciarProceso]:" + sbD.toString());
			
			//--Ejecucion
			sb.append("select ");
			sb.append("NVL(VALOR,'0') as VALOR ");
			sb.append("from ");
			sb.append("DLA_C_PARAMETRO ");
			sb.append("where ");
			sb.append("CLAVE = ? ");
			sb.append("AND MODULO = ? ");
			
			final String lstSQL = sb.toString();
			qryParams.add(PUEDE_EJECUTAR);
			qryParams.add(MODULO);
			
			String lstValor  = (String) jdbcTemplate.queryForObject(lstSQL,qryParams.toArray(),String.class);
			
			if(lstValor.equals("1"))
				resultado = true;
				
		}
		catch(EmptyResultDataAccessException er)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::puedeIniciarProceso]: No se encontraron registros coincidentes con la clave especificada. " + er.getMessage() );
			throw new Exception("No se encontraron registros coincidentes con la clave especificada");
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::puedeIniciarProceso]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	@Override
	public boolean updateEjecutandoseProceso(String pstValor) throws Exception 
	{
		boolean resultado = false;
		StringBuffer sb = new StringBuffer();
		StringBuffer sbD = new StringBuffer();
		List qryParams = new ArrayList();
		int lnuRowsUpdate = 0;
		
		try
		{
			String lstValor = (pstValor != null && pstValor.length() > 0) ? pstValor: "";
			
			//--Debug
			sbD.append("update ");
			sbD.append("DLA_C_PARAMETRO ");
			sbD.append("set VALOR = "+lstValor+" ");
			sbD.append("where ");
			sbD.append("CLAVE = '"+INICIADO+"' ");
			sbD.append("AND MODULO = '"+MODULO+"' ");
			LOG.debug(">Sql_D [updateEjecutandoseProceso]:" + sbD.toString());
			
			//--Ejecucion
			sb.append("update ");
			sb.append("DLA_C_PARAMETRO ");
			sb.append("set VALOR = ? ");
			sb.append("where ");
			sb.append("CLAVE = ? ");
			sb.append("AND MODULO = ? ");
			
			final String lstSQL = sb.toString();
			qryParams.add(lstValor);
			qryParams.add(INICIADO);
			qryParams.add(MODULO);
			
			lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
			
			if(lnuRowsUpdate > 0)
				resultado = true;
				
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::updateEjecutandoseProceso]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}

	@Override
	public List<ContratoDTO> obtenerContratosVigentes() throws Exception 
	{
		List<ContratoDTO> lobResultado = new ArrayList<ContratoDTO>();
		StringBuffer sb = new StringBuffer();
		StringBuffer sbD = new StringBuffer();
		List qryParams = new ArrayList();
		
		try
		{
			//--Debug
			sbD.append("select ");
			sbD.append("ID_CONTRATO ");
			sbD.append("from ");
			sbD.append("DDA_T_CONTRATO ");
			sbD.append("where ");			
			sbD.append("ID_ESTATUS = "+ESTATUS_VIGENTE+" ");
			sbD.append("order by ID_CONTRATO ");
			LOG.debug(">Sql_D [obtenerContratosVigentes]:" + sbD.toString());
			
			//--Ejecucion
			sb.append("select ");
			sb.append("ID_CONTRATO ");
			sb.append("from ");
			sb.append("DDA_T_CONTRATO ");	
			sb.append("where ");
			sb.append("ID_ESTATUS = ? ");
			sb.append("order by ID_CONTRATO ");
			
			final String lstSQL = sb.toString();			
			qryParams.add(ESTATUS_VIGENTE);
			
			lobResultado = (ArrayList<ContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoDTO>(ContratoDTO.class));
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerContratosVigentes]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		
		return lobResultado;
	}
	
	@Override
	public boolean actualizaContratoFull(ContratoDTO dto) throws Exception 
	{
		boolean resultado = false;
		StringBuffer sb = new StringBuffer();
		StringBuffer sbD = new StringBuffer();
		List qryParams = new ArrayList();
		int lnuRowsUpdate = 0;
		
		String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "VACIO";
		String lstIdEstudio = (dto.getID_ESTUDIO() != null && dto.getID_ESTUDIO().trim().length() > 0) ? dto.getID_ESTUDIO() : "VACIO";
		String lstIdEstatus = (dto.getID_ESTATUS() != null && dto.getID_ESTATUS().trim().length() > 0) ? dto.getID_ESTATUS() : "VACIO";
		String lstIdTipoMovimiento = (dto.getID_TIPO_MOVIMIENTO() != null && dto.getID_TIPO_MOVIMIENTO().trim().length() > 0) ? dto.getID_TIPO_MOVIMIENTO() : "VACIO";
		String lstIdTipoContrato = (dto.getID_TIPO_CONTRATO() != null && dto.getID_TIPO_CONTRATO().trim().length() > 0) ? dto.getID_TIPO_CONTRATO() : "VACIO";
		String lstIdApartado = (dto.getID_APARTADO() != null && dto.getID_APARTADO().trim().length() > 0) ? dto.getID_APARTADO() : "VACIO";
		String lstNumContrato = (dto.getNUMERO_CONTRATO() != null && dto.getNUMERO_CONTRATO().trim().length() > 0) ? dto.getNUMERO_CONTRATO() : "VACIO";
		String lstFechaInicio = (dto.getFECHA_INICIO() != null && dto.getFECHA_INICIO().trim().length() > 0) ? dto.getFECHA_INICIO() : "VACIO";
		String lstFechaFin = (dto.getFECHA_FIN() != null && dto.getFECHA_FIN().trim().length() > 0) ? dto.getFECHA_FIN() : "VACIO";
		String lstIdCntOriginal = (dto.getID_CONTRATO_ORIGINAL() != null && dto.getID_CONTRATO_ORIGINAL().trim().length() > 0) ? dto.getID_CONTRATO_ORIGINAL() : "VACIO";
		String lstFechaAlta = (dto.getFECHA_ALTA() != null && dto.getFECHA_ALTA().trim().length() > 0) ? dto.getFECHA_ALTA() : "VACIO";
		String lstIdSap = (dto.getID_SAP() != null && dto.getID_SAP().trim().length() > 0) ? dto.getID_SAP() : "VACIO";
		String lstAmortizable = (dto.getAMORTIZABLE() != null && dto.getAMORTIZABLE().trim().length() > 0) ? dto.getAMORTIZABLE() : "VACIO";
		String lstFechaWS = (dto.getFECHA_WS() != null && dto.getFECHA_WS().trim().length() > 0) ? dto.getFECHA_WS() : "VACIO";
		String lstFechaModifSAP = (dto.getFECHA_MODIFSAP() != null && dto.getFECHA_MODIFSAP().trim().length() > 0) ? dto.getFECHA_MODIFSAP() : "VACIO";
		
		DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
		Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
		
		try
		{
			//--Debug
				sbD.append("UPDATE DDA_T_CONTRATO "); 
				sbD.append("SET ");
				sbD.append("FECHA_WS=SYSDATE ");
			
			if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
				sbD.append(",ID_ESTUDIO="+lstIdEstudio+" ");
			if(!lstIdEstatus.equalsIgnoreCase("VACIO"))
				sbD.append(",ID_ESTATUS="+lstIdEstatus+" ");
			if(!lstIdTipoMovimiento.equalsIgnoreCase("VACIO"))
				sbD.append(",ID_TIPO_MOVIMIENTO="+lstIdTipoMovimiento+" ");
			if(!lstIdTipoContrato.equalsIgnoreCase("VACIO"))
				sbD.append(",ID_TIPO_CONTRATO="+lstIdTipoContrato+" "); 
			if(!lstIdApartado.equalsIgnoreCase("VACIO"))
				sbD.append(",ID_APARTADO="+lstIdApartado+" ");
			if(!lstNumContrato.equalsIgnoreCase("VACIO"))
				sbD.append(",NUMERO_CONTRATO='"+lstNumContrato+"' ");
			if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
				sbD.append(",FECHA_INICIO=to_date('"+lstFechaInicio+"','yyyy-mm-dd') ");
			if(!lstFechaFin.equalsIgnoreCase("VACIO"))
				sbD.append(",FECHA_FIN=to_date('"+lstFechaFin+"','yyyy-mm-dd') ");
			if(!lstIdCntOriginal.equalsIgnoreCase("VACIO"))
				sbD.append(",ID_CONTRATO_ORIGINAL="+lstIdCntOriginal+" ");
			if(!lstFechaAlta.equalsIgnoreCase("VACIO"))
				sbD.append(",FECHA_ALTA=to_date('"+lstFechaAlta+"','yyyy-mm-dd') ");
			if(!lstIdSap.equalsIgnoreCase("VACIO"))
				sbD.append(",ID_SAP='"+lstIdSap+"' ");
			if(!lstAmortizable.equalsIgnoreCase("VACIO"))
				sbD.append(",AMORTIZABLE='"+lstAmortizable+"' ");
			if(!lstFechaModifSAP.equalsIgnoreCase("VACIO"))
				sbD.append(",FECHA_MODIFSAP=to_date('"+lstFechaModifSAP+"','yyyy-mm-dd') ");
			
			
				sbD.append("WHERE ");
				sbD.append("ID_CONTRATO="+lstIdContrato+" ");
				
			LOG.debug(">Sql_D [actualizaContratoFull]:" + sbD.toString());
				
			
			//--Ejecucion
				sb.append("UPDATE DDA_T_CONTRATO "); 
				sb.append("SET ");
				sb.append("FECHA_WS=SYSDATE ");
			
			if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
				sb.append(",ID_ESTUDIO=? ");
			if(!lstIdEstatus.equalsIgnoreCase("VACIO"))
				sb.append(",ID_ESTATUS=? ");
			if(!lstIdTipoMovimiento.equalsIgnoreCase("VACIO"))
				sb.append(",ID_TIPO_MOVIMIENTO=? ");
			if(!lstIdTipoContrato.equalsIgnoreCase("VACIO"))
				sb.append(",ID_TIPO_CONTRATO=? "); 
			if(!lstIdApartado.equalsIgnoreCase("VACIO"))
				sb.append(",ID_APARTADO=? ");
			if(!lstNumContrato.equalsIgnoreCase("VACIO"))
				sb.append(",NUMERO_CONTRATO=? ");
			if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
				sb.append(",FECHA_INICIO=? ");
			if(!lstFechaFin.equalsIgnoreCase("VACIO"))
				sb.append(",FECHA_FIN=? ");
			if(!lstIdCntOriginal.equalsIgnoreCase("VACIO"))
				sb.append(",ID_CONTRATO_ORIGINAL=? ");
			if(!lstFechaAlta.equalsIgnoreCase("VACIO"))
				sb.append(",FECHA_ALTA=? ");
			if(!lstIdSap.equalsIgnoreCase("VACIO"))
				sb.append(",ID_SAP=? ");
			if(!lstAmortizable.equalsIgnoreCase("VACIO"))
				sb.append(",AMORTIZABLE=? ");
			if(!lstFechaModifSAP.equalsIgnoreCase("VACIO"))
				sb.append(",FECHA_MODIFSAP=? ");
			
				sb.append("WHERE ");
				sb.append("ID_CONTRATO=? ");
				
			//--Valores Query
			if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
				qryParams.add(lstIdEstudio);
			if(!lstIdEstatus.equalsIgnoreCase("VACIO"))
				qryParams.add(lstIdEstatus);
			if(!lstIdTipoMovimiento.equalsIgnoreCase("VACIO"))
				qryParams.add(lstIdTipoMovimiento);
			if(!lstIdTipoContrato.equalsIgnoreCase("VACIO"))
				qryParams.add(lstIdTipoContrato); 
			if(!lstIdApartado.equalsIgnoreCase("VACIO"))
				qryParams.add(lstIdApartado);
			if(!lstNumContrato.equalsIgnoreCase("VACIO"))
				qryParams.add(lstNumContrato);
			if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
			{
				lobTSFecha.setTime(df.parse(lstFechaInicio+" 12:00:00").getTime());
				qryParams.add(lobTSFecha);
			}
			if(!lstFechaFin.equalsIgnoreCase("VACIO"))
			{
				lobTSFecha.setTime(df.parse(lstFechaFin+" 12:00:00").getTime());
				qryParams.add(lobTSFecha);
			}
			if(!lstIdCntOriginal.equalsIgnoreCase("VACIO"))
				qryParams.add(lstIdCntOriginal);
			if(!lstFechaAlta.equalsIgnoreCase("VACIO"))
			{
				lobTSFecha.setTime(df.parse(lstFechaAlta+" 12:00:00").getTime());
				qryParams.add(lobTSFecha);
			}
			if(!lstIdSap.equalsIgnoreCase("VACIO"))
				qryParams.add(lstIdSap);
			if(!lstAmortizable.equalsIgnoreCase("VACIO"))
				qryParams.add(lstAmortizable);
			if(!lstFechaModifSAP.equalsIgnoreCase("VACIO"))
			{
				lobTSFecha.setTime(df.parse(lstFechaModifSAP+" 12:00:00").getTime());
				qryParams.add(lobTSFecha);
			}
			
			qryParams.add(lstIdContrato);
			
			
			final String lstSQL = sb.toString();
			lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
			
			if(lnuRowsUpdate > 0)
				resultado = true;

			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizaTituloFull]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}

	@Override
	public boolean registraBitacoraEstatus(ContratoEstatusDTO dto) throws Exception 
	{
		boolean resultado = false;
		List qryParams = new ArrayList();
		StringBuffer sb = new StringBuffer();
		StringBuffer sbD = new StringBuffer();
		
		try
		{
			//--Debug
			sbD.append("INSERT INTO DDA_T_CONTRATO_ESTATUS ");
			sbD.append("( ");
			sbD.append("ID_CONTRATO_ESTATUS, ");
			sbD.append("ID_CONTRATO, "); 
			sbD.append("ID_ESTATUS, "); 
			sbD.append("EXPEDIENTE, "); 
			sbD.append("FECHA_ESTATUS ");
			sbD.append(") "); 
			sbD.append("VALUES(DDA_SQT_CONTRATO_ESTATUS.NEXTVAL,"+dto.getID_CONTRATO()+", "+dto.getID_ESTATUS()+", '"+dto.getEXPEDIENTE()+"', SYSDATE) ");
			LOG.debug(">Sql_D [registraBitacoraEstatus]:" + sbD.toString());
			
			//--Ejecucion
			sb.append("INSERT INTO DDA_T_CONTRATO_ESTATUS ");
			sb.append("( ");
			sb.append("ID_CONTRATO_ESTATUS, ");
			sb.append("ID_CONTRATO, "); 
			sb.append("ID_ESTATUS, "); 
			sb.append("EXPEDIENTE, "); 
			sb.append("FECHA_ESTATUS ");
			sb.append(") "); 
			sb.append("VALUES(DDA_SQT_CONTRATO_ESTATUS.NEXTVAL,?,?,?,SYSDATE) ");
			
			final String sql = sb.toString();
			qryParams.add(dto.getID_CONTRATO());
			qryParams.add(dto.getID_ESTATUS());
			qryParams.add(dto.getEXPEDIENTE());
			
		
			int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
		 
			if(lnumRowsInsertados > 0)
				resultado = true;
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::registraBitacoraEstatus]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}

	@Override
	public String obtenerMaximaFechaTitulosPorContrato(String pstIdContrato) throws Exception 
	{
		List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
		String resultado = "";
		StringBuffer sb = new StringBuffer();
		StringBuffer sbD = new StringBuffer();
		List qryParams = new ArrayList();
		
		try
		{
			//--Debug
			sbD.append("SELECT ");
			sbD.append("TO_CHAR( MAX( FECHA_FIN ),'dd/mm/yyyy') as FECHA_FIN ");
			sbD.append("FROM ");
			sbD.append("( ");
			sbD.append("SELECT FECHA_FIN "); 
			sbD.append("FROM DDA_T_CONTRATO_TITULO "); 
			sbD.append("WHERE ID_CONTRATO = "+pstIdContrato+" ");
			sbD.append("AND ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
			sbD.append("UNION ALL ");
			sbD.append("SELECT FECHA_FIN "); 
			sbD.append("FROM DDA_T_CNT_TITULO "); 
			sbD.append("WHERE ID_CONTRATO = "+pstIdContrato+" ");
			sbD.append(") ");
			LOG.debug(">Sql_D [obtenerMaximaFechaTitulosPorContrato]:" + sbD.toString());
			
			//--Ejecucion
			sb.append("SELECT ");
			sb.append("TO_CHAR( MAX( FECHA_FIN ),'dd/mm/yyyy') as FECHA_FIN ");
			sb.append("FROM ");
			sb.append("( ");
			sb.append("SELECT FECHA_FIN "); 
			sb.append("FROM DDA_T_CONTRATO_TITULO "); 
			sb.append("WHERE ID_CONTRATO = ? ");
			sb.append("AND ESTATUS = ? ");
			sb.append("UNION ALL ");
			sb.append("SELECT FECHA_FIN "); 
			sb.append("FROM DDA_T_CNT_TITULO "); 
			sb.append("WHERE ID_CONTRATO = ? ");
			sb.append(") ");
			
			final String lstSQL = sb.toString();			
			qryParams.add(pstIdContrato);
			qryParams.add(ESTATUS_TITULO_ACTIVO);
			qryParams.add(pstIdContrato);
			
			lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
			if(lobResultado.size() == 1)
				resultado = lobResultado.get(0).getFECHA_FIN();
			
			return resultado;
			
		}
		catch(EmptyResultDataAccessException er)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMaximaFechaTitulosPorContrato]: No se encontraron registros coincidentes. " + er.getMessage() );
			throw new Exception("No se encontraron registros coincidentes.");
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMaximaFechaTitulosPorContrato]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
	}


}
