/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.provider;

import org.springframework.util.Assert;
import org.springframework.ws.wsdl.wsdl11.provider.DefaultMessagesProvider;
import org.w3c.dom.Element;

public class SuffixBasedMessagesProvider
extends DefaultMessagesProvider {
    public static final String DEFAULT_REQUEST_SUFFIX = "Request";
    public static final String DEFAULT_RESPONSE_SUFFIX = "Response";
    public static final String DEFAULT_FAULT_SUFFIX = "Fault";
    private String requestSuffix = "Request";
    private String responseSuffix = "Response";
    private String faultSuffix = "Fault";

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public void setRequestSuffix(String requestSuffix) {
        Assert.hasText((String)requestSuffix, (String)"'requestSuffix' must not be empty");
        this.requestSuffix = requestSuffix;
    }

    public String getResponseSuffix() {
        return this.responseSuffix;
    }

    public void setResponseSuffix(String responseSuffix) {
        Assert.hasText((String)responseSuffix, (String)"'responseSuffix' must not be empty");
        this.responseSuffix = responseSuffix;
    }

    public String getFaultSuffix() {
        return this.faultSuffix;
    }

    public void setFaultSuffix(String faultSuffix) {
        Assert.hasText((String)faultSuffix, (String)"'faultSuffix' must not be empty");
        this.faultSuffix = faultSuffix;
    }

    protected boolean isMessageElement(Element element) {
        if (super.isMessageElement(element)) {
            String elementName = this.getElementName(element);
            Assert.hasText((String)elementName, (String)"Element has no name");
            return elementName.endsWith(this.getRequestSuffix()) || elementName.endsWith(this.getResponseSuffix()) || elementName.endsWith(this.getFaultSuffix());
        }
        return false;
    }
}

