package mx.com.amx.mx.dda.crn.bo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;

import javax.xml.ws.WebServiceException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;

import mx.com.amx.mx.dda.crn.dao.DDATerminacionDAO;
import mx.com.amx.mx.dda.crn.dto.ContratoDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoEstatusDTO;
import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;



public class DDATerminacionBO 
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	
	private DDATerminacionDAO dao;
	private String COMPONENTE;
	
	public DDATerminacionBO() 
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			COMPONENTE = "DDA_CRN_Terminacion::" + this.getClass().getSimpleName();
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	public boolean existeProcesoEjecutandose() throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::existeProcesoEjecutandose]");
		boolean resultado = false;
		try
		{
			resultado = dao.verificaEjecutandoseProceso();
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::existeProcesoEjecutandose]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public boolean verificaPuedeIniciar() throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::verificaPuedeIniciar]");
		
		boolean resultado = false;
		try
		{
			resultado = dao.puedeIniciarProceso();
			
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::verificaPuedeIniciar]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public boolean actualizarEjecutandoProceso(String pstValor) throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::actualizarEjecutandoProceso]");
		LOG.debug("    - Parametros: _" + pstValor+"_");
		
		boolean resultado = false;
		try
		{
			resultado = dao.updateEjecutandoseProceso(pstValor);
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizarEjecutandoProceso]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public List<ContratoDTO> consultaContratosVigentes() throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::consultaContratosVigentes]");
		List<ContratoDTO> lobResultado = new ArrayList<ContratoDTO>();
		
		try
		{
			lobResultado = dao.obtenerContratosVigentes();
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::consultaContratosVigentes]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		return lobResultado;
	}
	
	public DDATerminacionDAO getDao() {
		return dao;
	}

	public void setDao(DDATerminacionDAO dao) {
		this.dao = dao;
	}
	
	public String getFechaActual(String pstFormato)
	{
		String lstFechaActual = "";
		Calendar lobTiempoActual = Calendar.getInstance();
		
		//--
		int lnuDiaActual = lobTiempoActual.get(Calendar.DAY_OF_MONTH);
		int lnuMesActual = lobTiempoActual.get(Calendar.MONTH) + 1;
		int lnuAnnioActual = lobTiempoActual.get(Calendar.YEAR);

		//--
		String lstTmpDia 	= (lobTiempoActual.get(Calendar.DAY_OF_MONTH) < 10) ? "0" +Integer.toString(lobTiempoActual.get(Calendar.DAY_OF_MONTH)) : 	Integer.toString(lobTiempoActual.get(Calendar.DAY_OF_MONTH));
		String lstTmpMes 	= (lnuMesActual < 10 ) ? "0" + Integer.toString(lnuMesActual) : Integer.toString(lnuMesActual);
		String lstTmpAnnio  = Integer.toString(lnuAnnioActual);
		String lstHora		= (lobTiempoActual.get(Calendar.HOUR_OF_DAY) < 10) ? "0" +Integer.toString(lobTiempoActual.get(Calendar.HOUR_OF_DAY)) : 	Integer.toString(lobTiempoActual.get(Calendar.HOUR_OF_DAY));
		String lstMinutos   = (lobTiempoActual.get(Calendar.MINUTE) < 10) ? "0" +Integer.toString(lobTiempoActual.get(Calendar.MINUTE)) : 	Integer.toString(lobTiempoActual.get(Calendar.MINUTE));
		String lstSegundos  = (lobTiempoActual.get(Calendar.SECOND) < 10) ? "0" +Integer.toString(lobTiempoActual.get(Calendar.SECOND)) : 	Integer.toString(lobTiempoActual.get(Calendar.SECOND));
		
		
		if(pstFormato.equalsIgnoreCase("dd/mm/yyyy"))
			lstFechaActual = lstTmpDia + "/" + lstTmpMes + "/" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("mm/dd/yyyy"))
			lstFechaActual = lstTmpMes + "/" + lstTmpDia + "/" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("yyyy/mm/dd"))
			lstFechaActual = lstTmpAnnio + "/" + lstTmpMes + "/" + lstTmpDia;
		else if(pstFormato.equalsIgnoreCase("dd/mm/yyyy hh:mi:ss"))
			lstFechaActual = lstTmpDia + "/" + lstTmpMes + "/" + lstTmpAnnio + lstHora + ":" + lstMinutos + ":" + lstSegundos;
		else if(pstFormato.equalsIgnoreCase("mm/dd/yyyy hh:mi:ss"))
			lstFechaActual = lstTmpMes + "/" + lstTmpDia + "/" + lstTmpAnnio + lstHora + ":" + lstMinutos + ":" + lstSegundos;
		else if(pstFormato.equalsIgnoreCase("yyyy/mm/dd hh:mi:ss"))
			lstFechaActual = lstTmpAnnio + "/" + lstTmpMes + "/" + lstTmpDia + lstHora + ":" + lstMinutos + ":" + lstSegundos;
		if(pstFormato.equalsIgnoreCase("dd-mm-yyyy"))
			lstFechaActual = lstTmpDia + "-" + lstTmpMes + "-" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("mm-dd-yyyy"))
			lstFechaActual = lstTmpMes + "-" + lstTmpDia + "-" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("yyyy-mm-dd"))
			lstFechaActual = lstTmpAnnio + "-" + lstTmpMes + "-" + lstTmpDia;
		else if(pstFormato.equalsIgnoreCase("dd.mm.yyyy"))
			lstFechaActual = lstTmpDia + "." + lstTmpMes + "." + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("mm/yyyy"))
			lstFechaActual = lstTmpMes + "/" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("yyyy/mm"))
			lstFechaActual =  lstTmpAnnio + "/" + lstTmpMes;
		else if(pstFormato.equalsIgnoreCase("yyyy-mm"))
			lstFechaActual =  lstTmpAnnio + "-" + lstTmpMes;
		return lstFechaActual;
	}
	
	public boolean actualizarContrato(ContratoDTO dto) throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::actualizarContrato]");
		LOG.debug("    - Parametros: _" + dto.toString()+"_");
		
		boolean resultado = false;
		try
		{
			resultado = dao.actualizaContratoFull(dto);
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizarContrato]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public boolean registrarBitacoraEstatus(ContratoEstatusDTO dto) throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::registrarBitacoraEstatus]");
		LOG.debug("    - Parametros: _" + dto.toString()+"_");
		
		boolean resultado = false;
		try
		{
			resultado = dao.registraBitacoraEstatus(dto);
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarBitacoraEstatus]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	public String obtenerMaxFechaTitulosPorContrato(String pstIdContrato) throws Exception
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::obtenerMaxFechaTitulosPorContrato]");
		LOG.debug("    - Parametros: _" + pstIdContrato+"_");
		
		String resultado = "";
		try
		{
			resultado = dao.obtenerMaximaFechaTitulosPorContrato(pstIdContrato);
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMaxFechaTitulosPorContrato]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
		
	}
	
}
