package mx.com.amx.mx.dda.ws.dao;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;



import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import mx.com.amx.mx.dda.ws.dto.ContratoDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoEstatusDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoSAPDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoSAPSubnumDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.ws.dto.DatosFacturaDTO;
import mx.com.amx.mx.dda.ws.dto.FacturaDTO;
import mx.com.amx.mx.dda.ws.dto.ItemActivoFijoDTO;
import mx.com.amx.mx.dda.ws.dto.MaterialDTO;
import mx.com.amx.mx.dda.ws.dto.QryMontosAnualesCntDTO;
import mx.com.amx.mx.dda.ws.dto.TitulosAsocContratoDTO;

@Component
@Qualifier("contratoDAO")
public class ContratoDAO implements IContratoDAO
{
                private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
                private final String ARCHIVO_PROPIEDADES       = "/general.properties";
                Properties env =             new Properties();
                private JdbcTemplate jdbcTemplate;
                
                private String CENTRO_COSTO;
                private String ESTATUS_VIGENTE;
                private String ESTATUS_TITULO_ACTIVO;
                private String AMBIENTE;
                
                public ContratoDAO()
                {
                               super();
                               try
                               {
                                               env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
                                               AMBIENTE = env.getProperty("ambiente");
                                               CENTRO_COSTO = env.getProperty(AMBIENTE+".centro.costo");
                                               ESTATUS_VIGENTE = env.getProperty("estatus.vigente");
                                               ESTATUS_TITULO_ACTIVO = env.getProperty("estatus.titulo.activo");
                               }
                               catch(Exception e)
                               {
                                               LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
                               }
                }
                
                public JdbcTemplate getJdbcTemplate() 
                {
                               return jdbcTemplate;
                }
                
                @Autowired
                public void setJdbcTemplate(JdbcTemplate jdbcTemplate) 
                {
                               this.jdbcTemplate = jdbcTemplate;
                }
                
                @Override
                public boolean actualizaContratoFull(ContratoDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "VACIO";
                               String lstIdEstudio = (dto.getID_ESTUDIO() != null && dto.getID_ESTUDIO().trim().length() > 0) ? dto.getID_ESTUDIO() : "VACIO";
                               String lstIdEstatus = (dto.getID_ESTATUS() != null && dto.getID_ESTATUS().trim().length() > 0) ? dto.getID_ESTATUS() : "VACIO";
                               String lstIdTipoMovimiento = (dto.getID_TIPO_MOVIMIENTO() != null && dto.getID_TIPO_MOVIMIENTO().trim().length() > 0) ? dto.getID_TIPO_MOVIMIENTO() : "VACIO";
                               String lstIdTipoContrato = (dto.getID_TIPO_CONTRATO() != null && dto.getID_TIPO_CONTRATO().trim().length() > 0) ? dto.getID_TIPO_CONTRATO() : "VACIO";
                               String lstIdApartado = (dto.getID_APARTADO() != null && dto.getID_APARTADO().trim().length() > 0) ? dto.getID_APARTADO() : "VACIO";
                               String lstNumContrato = (dto.getNUMERO_CONTRATO() != null && dto.getNUMERO_CONTRATO().trim().length() > 0) ? dto.getNUMERO_CONTRATO() : "VACIO";
                               String lstFechaInicio = (dto.getFECHA_INICIO() != null && dto.getFECHA_INICIO().trim().length() > 0) ? dto.getFECHA_INICIO() : "VACIO";
                               String lstFechaFin = (dto.getFECHA_FIN() != null && dto.getFECHA_FIN().trim().length() > 0) ? dto.getFECHA_FIN() : "VACIO";
                               String lstIdCntOriginal = (dto.getID_CONTRATO_ORIGINAL() != null && dto.getID_CONTRATO_ORIGINAL().trim().length() > 0) ? dto.getID_CONTRATO_ORIGINAL() : "VACIO";
                               String lstFechaAlta = (dto.getFECHA_ALTA() != null && dto.getFECHA_ALTA().trim().length() > 0) ? dto.getFECHA_ALTA() : "VACIO";
                               String lstIdSap = (dto.getID_SAP() != null && dto.getID_SAP().trim().length() > 0) ? dto.getID_SAP() : "VACIO";
                               String lstAmortizable = (dto.getAMORTIZABLE() != null && dto.getAMORTIZABLE().trim().length() > 0) ? dto.getAMORTIZABLE() : "VACIO";
                               String lstFechaWS = (dto.getFECHA_WS() != null && dto.getFECHA_WS().trim().length() > 0) ? dto.getFECHA_WS() : "VACIO";
                               String lstFechaModifSAP = (dto.getFECHA_MODIFSAP() != null && dto.getFECHA_MODIFSAP().trim().length() > 0) ? dto.getFECHA_MODIFSAP() : "VACIO";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                                               sbD.append("UPDATE DDA_T_CONTRATO "); 
                                                               sbD.append("SET ");
                                                               sbD.append("FECHA_WS=SYSDATE ");
                                               
                                               if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_ESTUDIO="+lstIdEstudio+" ");
                                               if(!lstIdEstatus.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_ESTATUS="+lstIdEstatus+" ");
                                               if(!lstIdTipoMovimiento.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_TIPO_MOVIMIENTO="+lstIdTipoMovimiento+" ");
                                               if(!lstIdTipoContrato.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_TIPO_CONTRATO="+lstIdTipoContrato+" "); 
                                               if(!lstIdApartado.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_APARTADO="+lstIdApartado+" ");
                                               if(!lstNumContrato.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",NUMERO_CONTRATO='"+lstNumContrato+"' ");
                                               if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_INICIO=to_date('"+lstFechaInicio+"','yyyy-mm-dd') ");
                                               if(!lstFechaFin.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_FIN=to_date('"+lstFechaFin+"','yyyy-mm-dd') ");
                                               if(!lstIdCntOriginal.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_CONTRATO_ORIGINAL="+lstIdCntOriginal+" ");
                                               if(!lstFechaAlta.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_ALTA=to_date('"+lstFechaAlta+"','yyyy-mm-dd') ");
                                               if(!lstIdSap.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_SAP='"+lstIdSap+"' ");
                                               if(!lstAmortizable.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",AMORTIZABLE='"+lstAmortizable+"' ");
                                               if(!lstFechaModifSAP.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_MODIFSAP=to_date('"+lstFechaModifSAP+"','yyyy-mm-dd') ");
                                               
                                               
                                                               sbD.append("WHERE ");
                                                               sbD.append("ID_CONTRATO="+lstIdContrato+" ");
                                                               
                                               LOG.debug(">Sql_D [actualizaContratoFull]:" + sbD.toString());
                                                               
                                               
                                               //--Ejecucion
                                                               sb.append("UPDATE DDA_T_CONTRATO "); 
                                                               sb.append("SET ");
                                                               sb.append("FECHA_WS=SYSDATE ");
                                               
                                               if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_ESTUDIO=? ");
                                               if(!lstIdEstatus.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_ESTATUS=? ");
                                               if(!lstIdTipoMovimiento.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_TIPO_MOVIMIENTO=? ");
                                               if(!lstIdTipoContrato.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_TIPO_CONTRATO=? "); 
                                               if(!lstIdApartado.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_APARTADO=? ");
                                               if(!lstNumContrato.equalsIgnoreCase("VACIO"))
                                                               sb.append(",NUMERO_CONTRATO=? ");
                                               if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_INICIO=? ");
                                               if(!lstFechaFin.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_FIN=? ");
                                               if(!lstIdCntOriginal.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_CONTRATO_ORIGINAL=? ");
                                               if(!lstFechaAlta.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_ALTA=? ");
                                               if(!lstIdSap.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_SAP=? ");
                                               if(!lstAmortizable.equalsIgnoreCase("VACIO"))
                                                               sb.append(",AMORTIZABLE=? ");
                                               if(!lstFechaModifSAP.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_MODIFSAP=? ");
                                               
                                                               sb.append("WHERE ");
                                                               sb.append("ID_CONTRATO=? ");
                                                               
                                               //--Valores Query
                                               if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdEstudio);
                                               if(!lstIdEstatus.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdEstatus);
                                               if(!lstIdTipoMovimiento.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdTipoMovimiento);
                                               if(!lstIdTipoContrato.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdTipoContrato); 
                                               if(!lstIdApartado.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdApartado);
                                               if(!lstNumContrato.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstNumContrato);
                                               if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaInicio+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstFechaFin.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaFin+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstIdCntOriginal.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdCntOriginal);
                                               if(!lstFechaAlta.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaAlta+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstIdSap.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdSap);
                                               if(!lstAmortizable.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstAmortizable);
                                               if(!lstFechaModifSAP.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaModifSAP+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               
                                               qryParams.add(lstIdContrato);
                                               
                                               
                                               final String lstSQL = sb.toString();
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;

                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizaTituloFull]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                               
                }
                
                
                @Override
                public boolean registraBitacoraEstatus(ContratoEstatusDTO dto) throws Exception
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_CONTRATO_ESTATUS ");
                                               sbD.append("( ");
                                               sbD.append("ID_CONTRATO_ESTATUS, ");
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("ID_ESTATUS, "); 
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("FECHA_ESTATUS ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES(DDA_SQT_CONTRATO_ESTATUS.NEXTVAL,"+dto.getID_CONTRATO()+", "+dto.getID_ESTATUS()+", '"+dto.getEXPEDIENTE()+"', SYSDATE) ");
                                               LOG.debug(">Sql_D [registraBitacoraEstatus]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_CONTRATO_ESTATUS ");
                                               sb.append("( ");
                                               sb.append("ID_CONTRATO_ESTATUS, ");
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("ID_ESTATUS, "); 
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("FECHA_ESTATUS ");
                                               sb.append(") "); 
                                               sb.append("VALUES(DDA_SQT_CONTRATO_ESTATUS.NEXTVAL,?,?,?,SYSDATE) ");
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(dto.getID_CONTRATO());
                                               qryParams.add(dto.getID_ESTATUS());
                                               qryParams.add(dto.getEXPEDIENTE());
                                               
                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::registraBitacoraEstatus]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                               
                }
                
                
                @Override
                public int cuantosTitulosNoIDSAP(String pstIdContrato) throws Exception 
                {
                               int resultado = 0;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdContrato =    ( pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                                               
                                               //-- Debug
                                               sbD.append("SELECT ");
                                               sbD.append("count(ID_TITULO_CNT) as CUANTOS ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_TITULO ");
                                               sbD.append("where ");
                                               sbD.append("ID_SAP IS NULL ");
                                               sbD.append("and ID_CONTRATO = "+ pstIdContrato);
                                               LOG.debug(">Sql_D [cuantosTitulosNoIDSAP]:" + sbD.toString());
                                               
                                               //-- Ejecucion
                                               sb.append("SELECT ");
                                               sb.append("count(ID_TITULO_CNT) as CUANTOS ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_TITULO ");
                                               sb.append("where ");
                                               sb.append("ID_SAP IS NULL ");
                                               sb.append("and ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               resultado = (int)getJdbcTemplate().queryForInt(lstSQL,qryParams.toArray());
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::cuantosTitulosNoIDSAP]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               return resultado;
                }
                
                @Override
                public List<ItemActivoFijoDTO> obtenerTitulosContratoNoIDSAP(String pstIdContrato) throws Exception 
                {
                               List<ItemActivoFijoDTO> lobResultado = new ArrayList<ItemActivoFijoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               
                                               String lstIdContrato =    ( pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                                               //-- 29/Jul/2016: Se hace un cambio al query por las modificaciones relativas a los cambios realizados por parte de SAP y que para mantener coherencia entre sus interfaces y 
                                               //-- nuestra integracion. Adicionalmente se elimina del query original el tener que llamar la descripcion del Titulo de la tabla DDA_C_TITULO. Ahora se traer� de la tabla
                                               //-- DDA_T_CONTRATO_TITULO.
                                               
                                               
                                               
                                               //-- Debug
                                               sbD.append("select ");
                                               sbD.append("contrato.ID_SAP as ordenCompra, ");
                                               sbD.append("estudio.ID_SAP as proveedor, ");
                                               sbD.append("cnttit.DESC_TITULO as descripcion, ");
                                               sbD.append("cnttit.ID_TITULO_CNT as codigoDDA, ");
                                               sbD.append("'"+CENTRO_COSTO+"' as centroCosto, ");
                                               sbD.append("cnttit.ID_BV as programID ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_TITULO cnttit, ");
                                               sbD.append("DDA_T_CONTRATO contrato, ");
                                               sbD.append("DDA_C_ESTUDIO estudio ");
                                               sbD.append("where ");
                                               sbD.append("cnttit.ID_CONTRATO = contrato.ID_CONTRATO ");
                                               sbD.append("and contrato.ID_ESTUDIO = estudio.ID_ESTUDIO ");
                                               sbD.append("and cnttit.ID_SAP is null ");
                                               sbD.append("and cnttit.ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerTitulosContratoNoIDSAP]:" + sbD.toString());
                                               
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("contrato.ID_SAP as ordenCompra, ");
                                               sb.append("estudio.ID_SAP as proveedor, ");
                                               sb.append("cnttit.DESC_TITULO as descripcion, ");
                                               sb.append("cnttit.ID_TITULO_CNT as codigoDDA, ");
                                               sb.append("'"+CENTRO_COSTO+"' as centroCosto, ");
                                               sb.append("cnttit.ID_BV as programID ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_TITULO cnttit, ");
                                               sb.append("DDA_T_CONTRATO contrato, ");
                                               sb.append("DDA_C_ESTUDIO estudio ");
                                               sb.append("where ");
                                               sb.append("cnttit.ID_CONTRATO = contrato.ID_CONTRATO ");
                                               sb.append("and contrato.ID_ESTUDIO = estudio.ID_ESTUDIO ");
                                               sb.append("and cnttit.ID_SAP is null ");
                                               sb.append("and cnttit.ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<ItemActivoFijoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ItemActivoFijoDTO>(ItemActivoFijoDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTitulosContratoNoIDSAP]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }
                
                
                @Override
                public String obtenerIDSAPContrato(String pstIdContrato) throws Exception 
                {
                               String lstResultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(ID_SAP,'-1') as ID_SAP ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CONTRATO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+pstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerIDSAPContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(ID_SAP,'-1') as ID_SAP ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CONTRATO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(pstIdContrato);
                                               
                                               lstResultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return lstResultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerIDSAPContrato]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerIDSAPContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                }
                
                
                @Override
                public boolean actualizaContratoTituloFull(ContratoTituloDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstIdTituloCnt = (dto.getID_TITULO_CNT() != null && dto.getID_TITULO_CNT().trim().length() > 0) ? dto.getID_TITULO_CNT() : "VACIO";
                               String lstDescTitulo = (dto.getDESC_TITULO() != null && dto.getDESC_TITULO().trim().length() > 0) ? dto.getDESC_TITULO() : "VACIO";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "VACIO";
                               String lstIdLista = (dto.getID_LISTA() != null && dto.getID_LISTA().trim().length() > 0) ? dto.getID_LISTA() : "VACIO";
                               String lstIdTitulo = (dto.getID_TITULO() != null && dto.getID_TITULO().trim().length() > 0) ? dto.getID_TITULO() : "VACIO";
                               String lstIdCategoria = (dto.getID_CATEGORIA() != null && dto.getID_CATEGORIA().trim().length() > 0) ? dto.getID_CATEGORIA() : "VACIO";
                               String lstFechaInicio = (dto.getFECHA_INICIO() != null && dto.getFECHA_INICIO().trim().length() > 0) ? dto.getFECHA_INICIO() : "VACIO";
                               String lstFechaFin = (dto.getFECHA_FIN() != null && dto.getFECHA_FIN().trim().length() > 0) ? dto.getFECHA_FIN() : "VACIO";
                               String lstBriefCase = (dto.getBRIEFCASE() != null && dto.getBRIEFCASE().trim().length() > 0) ? dto.getBRIEFCASE() : "VACIO";
                               String lstDto = (dto.getDTO() != null && dto.getDTO().trim().length() > 0) ? dto.getDTO() : "VACIO";
                               String lstDtr = (dto.getDTR() != null && dto.getDTR().trim().length() > 0) ? dto.getDTR() : "VACIO";
                               String lstIdSap = (dto.getID_SAP() != null && dto.getID_SAP().trim().length() > 0) ? dto.getID_SAP() : "VACIO";
                               String lstEstatus = (dto.getESTATUS() != null && dto.getESTATUS().trim().length() > 0) ? dto.getESTATUS() : "VACIO";
                               String lstIdTituloCntNvo = (dto.getID_TITULO_CNTNVO() != null && dto.getID_TITULO_CNTNVO().trim().length() > 0) ? dto.getID_TITULO_CNTNVO() : "VACIO";
                               String lstHvrd = (dto.getHVRD() != null && dto.getHVRD().trim().length() > 0) ? dto.getHVRD() : "VACIO";
                               String lstIdTerritorio = (dto.getID_TERRITORIO() != null && dto.getID_TERRITORIO().trim().length() > 0) ? dto.getID_TERRITORIO() : "VACIO";
                               String lstIdRelease = (dto.getID_RELEASE() != null && dto.getID_RELEASE().trim().length() > 0) ? dto.getID_RELEASE() : "VACIO";
                               String lstIdTituloCntOrig = (dto.getID_TITULO_CNTORIG() != null && dto.getID_TITULO_CNTORIG().trim().length() > 0) ? dto.getID_TITULO_CNTORIG() : "VACIO";
                               String lstFechaNotifSap = (dto.getFECHA_NOTIFSAP() != null && dto.getFECHA_NOTIFSAP().trim().length() > 0) ? dto.getFECHA_NOTIFSAP() : "VACIO";
                               String lstCosto = (dto.getCOSTO() != null && dto.getCOSTO().trim().length() > 0) ? dto.getCOSTO() : "VACIO";
                               String lstVidaUtil = (dto.getVIDA_UTIL() != null && dto.getVIDA_UTIL().trim().length() > 0) ? dto.getVIDA_UTIL() : "VACIO";
                               String lstAjustoTitulo = (dto.getAJUSTO_TITULO() != null && dto.getAJUSTO_TITULO().trim().length() > 0) ? dto.getAJUSTO_TITULO() : "VACIO";
                               String lstAjustoValor = (dto.getAJUSTO_VALOR() != null && dto.getAJUSTO_VALOR().trim().length() > 0) ? dto.getAJUSTO_VALOR() : "VACIO";
                                String lstAjustoVU = (dto.getAJUSTO_VU() != null && dto.getAJUSTO_VU().trim().length() > 0) ? dto.getAJUSTO_VU() : "VACIO";
                               String lstBajaPerdida = (dto.getBAJA_PERDIDA() != null && dto.getBAJA_PERDIDA().trim().length() > 0) ? dto.getBAJA_PERDIDA() : "VACIO";
                               String lstFechaAjustoTitulo = (dto.getFECHA_AJUSTOTITULO() != null && dto.getFECHA_AJUSTOTITULO().trim().length() > 0) ? dto.getFECHA_AJUSTOTITULO() : "VACIO";
                               String lstFechaAjustoValor = (dto.getFECHA_AJUSTOVALOR() != null && dto.getFECHA_AJUSTOVALOR().trim().length() > 0) ? dto.getFECHA_AJUSTOVALOR() : "VACIO";
                               String lstFechaAjustoVU = (dto.getFECHA_AJUSTOVU() != null && dto.getFECHA_AJUSTOVU().trim().length() > 0) ? dto.getFECHA_AJUSTOVU() : "VACIO";
                               String lstFechaBaja = (dto.getFECHA_BAJA() != null && dto.getFECHA_BAJA().trim().length() > 0) ? dto.getFECHA_BAJA() : "VACIO";
                               String lstIdSapAnt = (dto.getID_SAP_ANT() != null && dto.getID_SAP_ANT().trim().length() > 0) ? dto.getID_SAP_ANT() : "VACIO";
                               String lstIdTituloCntAnt = (dto.getID_TITULO_CNTANT() != null && dto.getID_TITULO_CNTANT().trim().length() > 0) ? dto.getID_TITULO_CNTANT() : "VACIO";
                               String lstFechaWS = (dto.getFECHA_WS() != null && dto.getFECHA_WS().trim().length() > 0) ? dto.getFECHA_WS() : "VACIO";
                               String lstNotaCredito = (dto.getNOTA_CREDITO() != null && dto.getNOTA_CREDITO().trim().length() > 0) ? dto.getNOTA_CREDITO() : "VACIO";
                               String lstFacturaCredito = (dto.getFACTURA_CREDITO() != null && dto.getFACTURA_CREDITO().trim().length() > 0) ? dto.getFACTURA_CREDITO() : "VACIO";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                                               //--Debug
                                                               sbD.append("UPDATE DDA_T_CONTRATO_TITULO "); 
                                                               sbD.append("SET ");
                                                               sbD.append("FECHA_WS=SYSDATE");
                                               
                                               if(!lstDescTitulo.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",DESC_TITULO='"+lstDescTitulo+"' ");
                                               if(!lstIdContrato.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_CONTRATO="+lstIdContrato+" ");
                                               if(!lstIdLista.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_LISTA="+lstIdLista+" ");
                                               if(!lstIdTitulo.equalsIgnoreCase("VACIO"))
                                                               sbD.append("ID_TITULO="+lstIdTitulo+" ");
                                               if(!lstIdCategoria.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_CATEGORIA="+lstIdCategoria+" ");
                                               if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_INICIO=to_date('"+lstFechaInicio+"','yyyy-mm-dd')");
                                               if(!lstFechaFin.equalsIgnoreCase("VACIO"))
                                                               sbD.append("FECHA_FIN=to_date('"+lstFechaFin+"','yyyy-mm-dd') ");
                                               if(!lstBriefCase.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",BRIEFCASE="+lstBriefCase+" ");
                                               if(!lstDto.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",DTO="+lstDto+" ");
                                               if(!lstDtr.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",DTR="+lstDtr+" ");
                                               if(!lstIdSap.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_SAP='"+lstIdSap+"' ");
                                               if(!lstEstatus.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ESTATUS='"+lstEstatus+"' ");
                                               if(!lstIdTituloCntNvo.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_TITULO_CNTNVO="+lstIdTituloCntNvo+" ");
                                               if(!lstHvrd.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",HVRD=to_date('"+lstHvrd+"','yyyy-mm-dd') ");
                                               if(!lstIdTerritorio.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_TERRITORIO="+lstIdTerritorio+" "); 
                                               if(!lstIdRelease.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_RELEASE="+lstIdRelease+" ");
                                               if(!lstIdTituloCntOrig.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_TITULO_CNTORIG="+lstIdTituloCntOrig+" ");
                                               if(!lstFechaNotifSap.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_NOTIFSAP=to_date('"+lstFechaNotifSap+"','yyyy-mm-dd') ");
                                               if(!lstCosto.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",COSTO='"+lstCosto+"' ");
                                               if(!lstVidaUtil.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",VIDA_UTIL='"+lstVidaUtil+"' ");
                                               if(!lstAjustoTitulo.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",AJUSTO_TITULO="+lstAjustoTitulo+" "); 
                                               if(!lstAjustoValor.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",AJUSTO_VALOR="+lstAjustoValor+" ");
                                               if(!lstAjustoVU.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",AJUSTO_VU="+lstAjustoVU+" ");
                                               if(!lstBajaPerdida.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",BAJA_PERDIDA="+lstBajaPerdida+" ");
                                               if(!lstFechaAjustoTitulo.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_AJUSTOTITULO=to_date('"+lstFechaAjustoTitulo+"','yyyy-mm-dd') ");
                                               if(!lstFechaAjustoValor.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_AJUSTOVALOR=to_date('"+lstFechaAjustoValor+"','yyyy-mm-dd') "); 
                                               if(!lstFechaAjustoVU.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_AJUSTOVU=to_date('"+lstFechaAjustoVU+"','yyyy-mm-dd') ");
                                               if(!lstFechaBaja.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_BAJA=to_date('"+lstFechaBaja+"','yyyy-mm-dd') ");
                                               if(!lstIdSapAnt.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_SAP_ANT='"+lstIdSapAnt+"' ");
                                               if(!lstIdTituloCntAnt.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_TITULO_CNTANT="+lstIdTituloCntAnt+" ");
                                               if(!lstNotaCredito.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",NOTA_CREDITO="+lstIdTituloCntAnt+" ");
                                               if(!lstFacturaCredito.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FACTURA_CREDITO='"+lstIdTituloCntAnt+"' ");
                                               
                                                               sbD.append("WHERE ");
                                                               sbD.append("ID_TITULO_CNT="+lstIdTituloCnt);
                                               LOG.debug(">Sql_D [actualizaTituloFull]:" + sbD.toString());
                                               
                                               
                                               
                                               //--Ejecucion
                                                               sb.append("UPDATE DDA_T_CONTRATO_TITULO "); 
                                                               sb.append("SET ");
                                                               sb.append("FECHA_WS=SYSDATE ");
                                               
                                               if(!lstDescTitulo.equalsIgnoreCase("VACIO"))
                                                               sb.append(",DESC_TITULO=? ");
                                               if(!lstIdContrato.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_CONTRATO=? ");
                                               if(!lstIdLista.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_LISTA=? ");
                                               if(!lstIdTitulo.equalsIgnoreCase("VACIO"))
                                                               sb.append("ID_TITULO=? ");
                                               if(!lstIdCategoria.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_CATEGORIA=? ");
                                               if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_INICIO=? ");
                                               if(!lstFechaFin.equalsIgnoreCase("VACIO"))
                                                               sb.append("FECHA_FIN=? ");
                                               if(!lstBriefCase.equalsIgnoreCase("VACIO"))
                                                               sb.append(",BRIEFCASE=? ");
                                               if(!lstDto.equalsIgnoreCase("VACIO"))
                                                               sb.append(",DTO=? ");
                                               if(!lstDtr.equalsIgnoreCase("VACIO"))
                                                               sb.append(",DTR=? ");
                                               if(!lstIdSap.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_SAP=? ");
                                               if(!lstEstatus.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ESTATUS=? ");
                                               if(!lstIdTituloCntNvo.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_TITULO_CNTNVO=? ");
                                               if(!lstHvrd.equalsIgnoreCase("VACIO"))
                                                               sb.append(",HVRD=?) ");
                                               if(!lstIdTerritorio.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_TERRITORIO=? "); 
                                               if(!lstIdRelease.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_RELEASE=? ");
                                               if(!lstIdTituloCntOrig.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_TITULO_CNTORIG=? ");
                                               if(!lstFechaNotifSap.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_NOTIFSAP=? ");
                                               if(!lstCosto.equalsIgnoreCase("VACIO"))
                                                               sb.append(",COSTO=? ");
                                               if(!lstVidaUtil.equalsIgnoreCase("VACIO"))
                                                               sb.append(",VIDA_UTIL=? ");
                                               if(!lstAjustoTitulo.equalsIgnoreCase("VACIO"))
                                                               sb.append(",AJUSTO_TITULO=? "); 
                                               if(!lstAjustoValor.equalsIgnoreCase("VACIO"))
                                                               sb.append(",AJUSTO_VALOR=? ");
                                               if(!lstAjustoVU.equalsIgnoreCase("VACIO"))
                                                               sb.append(",AJUSTO_VU=? ");
                                               if(!lstBajaPerdida.equalsIgnoreCase("VACIO"))
                                                               sb.append(",BAJA_PERDIDA=? ");
                                               if(!lstFechaAjustoTitulo.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_AJUSTOTITULO=? ");
                                               if(!lstFechaAjustoValor.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_AJUSTOVALOR=? "); 
                                               if(!lstFechaAjustoVU.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_AJUSTOVU=? ");
                                               if(!lstFechaBaja.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_BAJA=? ");
                                               if(!lstIdSapAnt.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_SAP_ANT=? ");
                                               if(!lstIdTituloCntAnt.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_TITULO_CNTANT=? ");
                                               if(!lstNotaCredito.equalsIgnoreCase("VACIO"))
                                                               sb.append(",NOTA_CREDITO=? ");
                                               if(!lstFacturaCredito.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FACTURA_CREDITO=? ");
                                               
                                                               sb.append("WHERE ");
                                                               sb.append("ID_TITULO_CNT=? ");
                                               
                                               
                                               //--Valores Query
                                               if(!lstDescTitulo.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstDescTitulo);
                                               if(!lstIdContrato.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdContrato);
                                               if(!lstIdLista.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdLista);
                                               if(!lstIdTitulo.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdTitulo);
                                               if(!lstIdCategoria.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdCategoria);
                                               if(!lstFechaInicio.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaInicio+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstFechaFin.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaFin+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                                               
                                               if(!lstBriefCase.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstBriefCase);
                                               if(!lstDto.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstDto);
                                               if(!lstDtr.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstDtr);
                                               if(!lstIdSap.equalsIgnoreCase("VACIO"))
                                               {
                                                               if(lstIdSap.equalsIgnoreCase("NULL"))
                                                                               qryParams.add(null);
                                                               else
                                                                               qryParams.add(lstIdSap);
                                               }
                                               if(!lstEstatus.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstEstatus);
                                               if(!lstIdTituloCntNvo.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdTituloCntNvo);
                                               if(!lstHvrd.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstHvrd+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstIdTerritorio.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdTerritorio); 
                                               if(!lstIdRelease.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdRelease);
                                               if(!lstIdTituloCntOrig.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdTituloCntOrig);
                                               if(!lstFechaNotifSap.equalsIgnoreCase("VACIO"))
                                               {
                                                               if(lstFechaNotifSap.equalsIgnoreCase("NULL"))
                                                               {
                                                                               qryParams.add(null);
                                                               }
                                                               else
                                                               {
                                                                               lobTSFecha.setTime(df.parse(lstFechaNotifSap+" 12:00:00").getTime());
                                                                               qryParams.add(lobTSFecha);
                                                               }
                                               }
                                               if(!lstCosto.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstCosto);
                                               if(!lstVidaUtil.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstVidaUtil);
                                               if(!lstAjustoTitulo.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstAjustoTitulo); 
                                               if(!lstAjustoValor.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstAjustoValor);
                                               if(!lstAjustoVU.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstAjustoVU);
                                               if(!lstBajaPerdida.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstBajaPerdida);
                                               if(!lstFechaAjustoTitulo.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaAjustoTitulo+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstFechaAjustoValor.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaAjustoValor+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstFechaAjustoVU.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaAjustoVU+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstFechaBaja.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaBaja+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstIdSapAnt.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdSapAnt);
                                               if(!lstIdTituloCntAnt.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdTituloCntAnt);
                                               if(!lstNotaCredito.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstNotaCredito);
                                               if(!lstFacturaCredito.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstFacturaCredito);
                                               
                                               qryParams.add(lstIdTituloCnt);
                                               
                                               
                                               final String lstSQL = sb.toString();
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizaTituloFull]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                
                @Override
                public String obtenerFechaModifSAPContrato(String pstIdContrato) throws Exception 
                {
                               String lstResultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(TO_CHAR(FECHA_MODIFSAP,'dd/mm/yyyy'),'-1') as FECHA_MODIFSAP ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CONTRATO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+pstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerFechaModifSAPContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(TO_CHAR(FECHA_MODIFSAP,'dd/mm/yyyy'),'-1') as FECHA_MODIFSAP ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CONTRATO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(pstIdContrato);
                                               
                                               lstResultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return lstResultado;
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerFechaModifSAPContrato]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerFechaModifSAPContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                }
                
                
                @Override
                public String obtenerUltimoCntVigenteRelacionado(String pstIdContratoAdendumEnmienda) throws Exception 
                {
                               String lstResultado = "-1";
                               List<ContratoDTO> lobResultado = new ArrayList<ContratoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdContrato =    ( pstIdContratoAdendumEnmienda != null && pstIdContratoAdendumEnmienda.trim().length() > 0) ? pstIdContratoAdendumEnmienda : "";
                                               
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(cntotros.ID_CONTRATO,'-1') as ID_CONTRATO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO cntotros, ");
                                               sbD.append("DDA_T_CONTRATO cnt ");
                                               sbD.append("where ");
                                               sbD.append("cnt.ID_CONTRATO_ORIGINAL = cntotros.ID_CONTRATO_ORIGINAL ");
                                               sbD.append("and cnt.ID_ESTUDIO = cntotros.ID_ESTUDIO ");
                                               sbD.append("and cntotros.ID_ESTATUS = "+ESTATUS_VIGENTE+" ");
                                               sbD.append("and cnt.ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerUltimoCntVigenteRelacionado]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(cntotros.ID_CONTRATO,'-1') as ID_CONTRATO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO cntotros, ");
                                               sb.append("DDA_T_CONTRATO cnt ");
                                               sb.append("where ");
                                               sb.append("cnt.ID_CONTRATO_ORIGINAL = cntotros.ID_CONTRATO_ORIGINAL ");
                                               sb.append("and cnt.ID_ESTUDIO = cntotros.ID_ESTUDIO ");
                                               sb.append("and cntotros.ID_ESTATUS = ? ");
                                               sb.append("and cnt.ID_CONTRATO = ? ");
                                               
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(ESTATUS_VIGENTE);
                                               qryParams.add(lstIdContrato);
                                               
                                               
                                               
                                               lobResultado = (ArrayList<ContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoDTO>(ContratoDTO.class));
                                               if(lobResultado.size() == 1)
                                                               lstResultado = lobResultado.get(0).getID_CONTRATO();


                                               return lstResultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerUltimoCntVigenteRelacionado]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerUltimoCntVigenteRelacionado]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }
                
                @Override
                public List<TitulosAsocContratoDTO> obtenerTitulosAsociadosContrato(String pstIdContrato) throws Exception 
                {
                               List<TitulosAsocContratoDTO> lobResultado = new ArrayList<TitulosAsocContratoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdContrato =    ( pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                                               
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("cntit.ID_TITULO_CNT, ");
                                               sbD.append("cntit.ID_TITULO_CNTORIG, ");
                                               sbD.append("cntit.DESC_TITULO, ");
                                               sbD.append("est.ID_SAP as ID_SAP_ESTUDIO, ");
                                               sbD.append("cntit.ID_BV, ");
                                               sbD.append("to_char(cntit.FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_TITULO cntit, ");
                                               sbD.append("DDA_T_CONTRATO cnt, ");
                                               sbD.append("DDA_C_ESTUDIO est ");
                                               sbD.append("where ");
                                               sbD.append("cnt.ID_CONTRATO = cntit.ID_CONTRATO ");
                                               sbD.append("and est.ID_ESTUDIO = cnt.ID_ESTUDIO ");
                                               sbD.append("and cntit.ID_CONTRATO = "+lstIdContrato+" ");
                                               sbD.append("and cntit.ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               LOG.debug(">Sql_D [obtenerTitulosAsociadosContrato]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("cntit.ID_TITULO_CNT, ");
                                               sb.append("cntit.ID_TITULO_CNTORIG, ");
                                               sb.append("cntit.DESC_TITULO, ");
                                               sb.append("est.ID_SAP as ID_SAP_ESTUDIO, ");
                                               sb.append("cntit.ID_BV, ");
                                               sb.append("to_char(cntit.FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_TITULO cntit, ");
                                               sb.append("DDA_T_CONTRATO cnt, ");
                                               sb.append("DDA_C_ESTUDIO est ");
                                               sb.append("where ");
                                               sb.append("cnt.ID_CONTRATO = cntit.ID_CONTRATO ");
                                               sb.append("and est.ID_ESTUDIO = cnt.ID_ESTUDIO ");
                                               sb.append("and cntit.ID_CONTRATO = ? ");
                                               sb.append("and cntit.ESTATUS = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(ESTATUS_TITULO_ACTIVO);
                                               
                                               lobResultado = (ArrayList<TitulosAsocContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<TitulosAsocContratoDTO>(TitulosAsocContratoDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTitulosAsociadosContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }
                
                
                @Override
                public List<TitulosAsocContratoDTO> obtenerTitulosTransaccionalesAsociadosContrato(String pstIdContrato) throws Exception 
                {
                               List<TitulosAsocContratoDTO> lobResultado = new ArrayList<TitulosAsocContratoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdContrato =    ( pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                                               
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("cntit.ID_TITULO_CNT, ");
                                               sbD.append("cntit.ID_TITULO_CNTORIG, ");
                                               sbD.append("cntit.NOMBRE_ESTANDAR as DESC_TITULO, ");
                                               sbD.append("est.ID_SAP as ID_SAP_ESTUDIO, ");
                                               sbD.append("cntit.ID_BV, ");
                                               sbD.append("to_char(cntit.FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CNT_TITULO cntit, ");
                                               sbD.append("DDA_T_CONTRATO cnt, ");
                                               sbD.append("DDA_C_ESTUDIO est ");
                                               sbD.append("where ");
                                               sbD.append("cnt.ID_CONTRATO = cntit.ID_CONTRATO ");
                                               sbD.append("and est.ID_ESTUDIO = cnt.ID_ESTUDIO ");
                                               sbD.append("and cntit.ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerTitulosTransaccionalesAsociadosContrato]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("cntit.ID_TITULO_CNT, ");
                                               sb.append("cntit.ID_TITULO_CNTORIG, ");
                                               sb.append("cntit.NOMBRE_ESTANDAR as DESC_TITULO, ");
                                               sb.append("est.ID_SAP as ID_SAP_ESTUDIO, ");
                                               sb.append("cntit.ID_BV, ");
                                               sb.append("to_char(cntit.FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CNT_TITULO cntit, ");
                                               sb.append("DDA_T_CONTRATO cnt, ");
                                               sb.append("DDA_C_ESTUDIO est ");
                                               sb.append("where ");
                                               sb.append("cnt.ID_CONTRATO = cntit.ID_CONTRATO ");
                                               sb.append("and est.ID_ESTUDIO = cnt.ID_ESTUDIO ");
                                               sb.append("and cntit.ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<TitulosAsocContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<TitulosAsocContratoDTO>(TitulosAsocContratoDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                             LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTitulosTransaccionalesAsociadosContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                
                
                @Override
                public String obtenerFechaAutorizacion(String pstIdContrato) throws Exception 
                {
                               String lstResultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                                {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(TO_CHAR(FECHA_AUTORIZACION,'dd/mm/yyyy'),'-1') as FECHA_AUTORIZACION ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CONTRATO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+pstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerFechaModifSAPContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(TO_CHAR(FECHA_AUTORIZACION,'dd/mm/yyyy'),'-1') as FECHA_AUTORIZACION ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CONTRATO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(pstIdContrato);
                                               
                                               lstResultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return lstResultado;
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerFechaAutorizacion]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerFechaAutorizacion]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }


                @Override
                public boolean actualizaCntSAPSubnumFull(ContratoSAPSubnumDTO dto, String pstIdSAP, String pstSubnum) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstIdRegistroSAP = (dto.getID_REGISTRO_SAP() != null && dto.getID_REGISTRO_SAP().trim().length() > 0) ? dto.getID_REGISTRO_SAP() : "VACIO";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "VACIO";
                               String lstIdTituloCnt = (dto.getID_TITULO_CNT() != null && dto.getID_TITULO_CNT().trim().length() > 0) ? dto.getID_TITULO_CNT() : "VACIO";
                               String lstIdTituloCntOrig = (dto.getID_TITULO_CNTORIG() != null && dto.getID_TITULO_CNTORIG().trim().length() > 0) ? dto.getID_TITULO_CNTORIG() : "VACIO";
                               String lstAumento = (dto.getAUMENTO() != null && dto.getAUMENTO().trim().length() > 0) ? dto.getAUMENTO() : "VACIO";
                               String lstDisminucion = (dto.getDISMINUCION() != null && dto.getDISMINUCION().trim().length() > 0) ? dto.getDISMINUCION() : "VACIO";
                               String lstFechaSAP = (dto.getFECHA_SAP() != null && dto.getFECHA_SAP().trim().length() > 0) ? dto.getFECHA_SAP() : "VACIO";
                               String lstSubnumero = (dto.getSUBNUMERO() != null && dto.getSUBNUMERO().trim().length() > 0) ? dto.getSUBNUMERO() : "VACIO";
                               String lstFlg19    = (dto.getFLG19() != null && dto.getFLG19().trim().length() > 0) ? dto.getFLG19() : "VACIO";
                               String lstSubNumCond = (pstSubnum != null && pstSubnum.trim().length() > 0) ? pstSubnum : "VACIO";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                                               sbD.append("UPDATE DDA_T_CONTRATO_SAP_SUBNUM ");
                                                               sbD.append("SET "); 
                                                               sbD.append("FECHA_WS = SYSDATE ");
                                               
                                               if(!lstAumento.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",AUMENTO='"+lstAumento+"' ");
                                               if(!lstDisminucion.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",DISMINUCION='"+lstDisminucion+"' ");
                                               if(!lstFechaSAP.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_SAP = to_date('"+lstFechaSAP+"','yyyy-mm-dd') ");
                                               if(!lstSubnumero.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",SUBNUMERO = '"+lstSubnumero+"' ");
                                               if(!lstFlg19.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FLG19 = '"+lstFlg19+"' ");
                                               
                                                               sbD.append("where ");
                                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                                               sbD.append("and FECHA_SAP is null ");
                                               if(!lstSubNumCond.equalsIgnoreCase("VACIO"))
                                                               sbD.append("and SUBNUMERO = '"+lstSubNumCond+"' ");
                                                               
                                                               sbD.append("and ID_TITULO_CNT in "); 
                                                               sbD.append("( ");
                                                               sbD.append("select ");
                                                               sbD.append("ID_TITULO_CNT ");
                                                               sbD.append("from ");
                                                               sbD.append("DDA_T_CONTRATO_TITULO cnt ");
                                                               sbD.append("where ");
                                                               sbD.append("cnt.ID_CONTRATO = "+lstIdContrato+" ");
                                                               sbD.append("and ID_SAP = '"+pstIdSAP+"' ");
                                                               sbD.append("and cnt.ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                                               sbD.append(") ");
                                                               LOG.debug(">Sql_D [actualizaCntSAPSubnumFull]:" + sbD.toString());
                                                               
                                               //--Ejecucion
                                               sb.append("UPDATE DDA_T_CONTRATO_SAP_SUBNUM ");
                                               sb.append("SET "); 
                                               sb.append("FECHA_WS = SYSDATE ");
                               
                               if(!lstAumento.equalsIgnoreCase("VACIO"))
                                               sb.append(",AUMENTO=? ");
                               if(!lstDisminucion.equalsIgnoreCase("VACIO"))
                                               sb.append(",DISMINUCION=? ");
                               if(!lstFechaSAP.equalsIgnoreCase("VACIO"))
                                               sb.append(",FECHA_SAP = ? ");
                               if(!lstSubnumero.equalsIgnoreCase("VACIO"))
                                               sb.append(",SUBNUMERO = ? ");
                               if(!lstFlg19.equalsIgnoreCase("VACIO"))
                                               sb.append(",FLG19 = ? ");
                               
                                               sb.append("where ");
                                                sb.append("ID_CONTRATO = ? ");
                                               sb.append("and FECHA_SAP is null ");
                               if(!lstSubNumCond.equalsIgnoreCase("VACIO"))
                                               sb.append("and SUBNUMERO = ? ");
                               
                                               sb.append("and ID_TITULO_CNT in "); 
                                               sb.append("( ");
                                               sb.append("select ");
                                               sb.append("ID_TITULO_CNT ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_TITULO cnt ");
                                               sb.append("where ");
                                               sb.append("cnt.ID_CONTRATO = ? ");
                                               sb.append("and ID_SAP = ? ");
                                               sb.append("and cnt.ESTATUS = ? ");
                                               sb.append(") ");
                                               
                                               //--Valores query
                                               if(!lstAumento.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstAumento);
                                               if(!lstDisminucion.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstDisminucion);
                                               if(!lstFechaSAP.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaSAP+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstSubnumero.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstSubnumero);
                                               if(!lstFlg19.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstFlg19);
                                               
                                                               qryParams.add(lstIdContrato);

                                               if(!lstSubNumCond.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstSubNumCond);
                                               
                                                               qryParams.add(lstIdContrato);
                                                               qryParams.add(pstIdSAP);
                                                               qryParams.add(ESTATUS_TITULO_ACTIVO);
                                               
                                               
                                               final String lstSQL = sb.toString();
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizaCntSAPSubnumFull]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                
                @Override
                public String obtenerMontoContrato(String pstIdContrato) throws Exception 
                {
                               String lstResultado = "0";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.length() > 0) ? pstIdContrato: "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("TRUNC(NVL(SUM(COSTO),0),2) as MONTO_CONTRATO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_TITULO ");
                                               sbD.append("where ");
                                               sbD.append("ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               sbD.append("and ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerMontoContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("TRUNC(NVL(SUM(COSTO),0),2) as MONTO_CONTRATO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_TITULO ");
                                               sb.append("where ");
                                               sb.append("ESTATUS = ? ");
                                               sb.append("and ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(ESTATUS_TITULO_ACTIVO);
                                               qryParams.add(lstIdContrato);
                                               
                                               lstResultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return lstResultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontoContrato]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontoContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }

                @Override
                public String obtenerMontoReportadoSAP(String pstIdContrato, String posicionExcluir) throws Exception 
                {
                               String lstResultado = "0";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.length() > 0) ? pstIdContrato: "";
                               String lstPosExcluir = (posicionExcluir != null && posicionExcluir.length() > 0) ? posicionExcluir: "";
                               try
                               {
                                               //--Debug
                                                               sbD.append("select ");
                                                               sbD.append("TRUNC(NVL(SUM(MONTO),0),2) as MONTO_SAP ");
                                                               sbD.append("from "); 
                                                               sbD.append("DDA_T_CONTRATO_SAP ");
                                                               sbD.append("where ");
                                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                                               
                                               if(!lstPosExcluir.equals(""))
                                                               sbD.append("and POSICION <> '"+lstPosExcluir+"' ");

                                               LOG.debug(">Sql_D [obtenerMontoReportadoSAP]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                                               sb.append("select ");
                                                               sb.append("TRUNC(NVL(SUM(MONTO),0),2) as MONTO_SAP ");
                                                               sb.append("from "); 
                                                               sb.append("DDA_T_CONTRATO_SAP ");
                                                               sb.append("where ");
                                                               sb.append("ID_CONTRATO = ? ");
                                                               
                                               if(!lstPosExcluir.equals(""))
                                                               sb.append("and POSICION <> ? ");
                                               
                                               
                                               //--Params
                                                               final String lstSQL = sb.toString();
                                                               qryParams.add(lstIdContrato);
                                               
                                               if(!lstPosExcluir.equals(""))
                                                               qryParams.add(lstPosExcluir);
                                               
                                               lstResultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return lstResultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontoReportadoSAP]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontoReportadoSAP]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }

                @Override
                public String obtenerPosicionAumento(String pstIdContrato) throws Exception 
                {
                               String lstResultado = "";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.length() > 0) ? pstIdContrato: "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("LPAD(NVL(MAX(posicion),0)+10,5,'0') as POSICION ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_SAP ");
                                               sbD.append("WHERE ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerPosicionAumento]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("LPAD(NVL(MAX(posicion),0)+10,5,'0') as POSICION ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_SAP ");
                                               sb.append("WHERE ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lstResultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return lstResultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerPosicionAumento]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerPosicionAumento]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }

                @Override
                public boolean insertarRegistroPosicion(ContratoSAPDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().length() > 0) ? dto.getID_CONTRATO(): "";
                                               String lstPosicion = (dto.getPOSICION() != null && dto.getPOSICION().length() > 0) ? dto.getPOSICION(): "";
                                               String lstMonto = (dto.getMONTO() != null && dto.getMONTO().length() > 0) ? dto.getMONTO(): "";
                                               String lstDocMaterial = (dto.getDOC_MATERIAL() != null && dto.getDOC_MATERIAL().length() > 0) ? dto.getDOC_MATERIAL(): "";
                                               
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_CONTRATO_SAP ");
                                               sbD.append("( ");
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("POSICION, "); 
                                               sbD.append("MONTO, "); 
                                                sbD.append("DOC_MATERIAL, ");
                                               sbD.append("FECHA_SAP ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append(lstIdContrato+", "); 
                                               sbD.append("'"+lstPosicion+"', "); 
                                               sbD.append("'"+lstMonto+"', "); 
                                               sbD.append("'"+lstDocMaterial+"', ");
                                               sbD.append("SYSDATE ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [insertarRegistroPosicion]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_CONTRATO_SAP ");
                                               sb.append("( ");
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("POSICION, "); 
                                               sb.append("MONTO, "); 
                                               sb.append("DOC_MATERIAL, ");
                                               sb.append("FECHA_SAP ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("(?, ?, ?, ?, SYSDATE ) ");
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstPosicion);
                                               qryParams.add(lstMonto);
                                               qryParams.add(lstDocMaterial);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::insertarRegistroPosicion]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean actualizaRegistroPosicion(ContratoSAPDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "VACIO";
                                String lstMonto = (dto.getMONTO() != null && dto.getMONTO().trim().length() > 0) ? dto.getMONTO() : "VACIO";
                               String lstPosicion = (dto.getPOSICION() != null && dto.getPOSICION().trim().length() > 0) ? dto.getPOSICION() : "VACIO";
                               String lstDocMaterial = (dto.getDOC_MATERIAL() != null && dto.getDOC_MATERIAL().trim().length() > 0) ? dto.getDOC_MATERIAL() : "VACIO";
                               
                               try
                               {
                                               //--Debug
                                                               sbD.append("UPDATE DDA_T_CONTRATO_SAP "); 
                                                               sbD.append("SET "); 
                                                               sbD.append("FECHA_SAP=SYSDATE ");
                                               
                                                if(!lstMonto.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",MONTO='"+lstMonto+"' ");
                                               if(!lstDocMaterial.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",DOC_MATERIAL='"+lstDocMaterial+"' ");
                                               
                                                               sbD.append("WHERE "); 
                                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                                               sbD.append("AND POSICION = '"+lstPosicion+"' ");
                                               LOG.debug(">Sql_D [actualizaRegistroPosicion]:" + sbD.toString());
                                                               
                                               //--Ejecucion
                                                               sb.append("UPDATE DDA_T_CONTRATO_SAP "); 
                                                               sb.append("SET "); 
                                                               sb.append("FECHA_SAP=SYSDATE ");
                               
                                               if(!lstMonto.equalsIgnoreCase("VACIO"))
                                                               sb.append(",MONTO=? ");
                                               if(!lstDocMaterial.equalsIgnoreCase("VACIO"))
                                                               sb.append(",DOC_MATERIAL=? ");
                                               
                                                               sb.append("WHERE "); 
                                                               sb.append("ID_CONTRATO = ? ");
                                                               sb.append("AND POSICION = ? ");
                                               
                                               //--Valores query
                                               if(!lstMonto.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstMonto);
                                               if(!lstDocMaterial.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstDocMaterial);
                                                               
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstPosicion);
                                               
                                               final String lstSQL = sb.toString();
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizaRegistroPosicion]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPDDA_CrnClienteSAP(String pstIdContrato) throws Exception 
                {
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_CRNCLIENTESAP");
                                               LOG.debug(">Sql_D [ejecutarSPDDA_CrnClienteSAP]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_CRNCLIENTESAP(?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPDDA_CrnClienteSAP]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public List<DatosFacturaDTO> obtenerDatosFactura(String pstIdFactura) throws Exception 
                {
                               List<DatosFacturaDTO> lobResultado = new ArrayList<DatosFacturaDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdFactura =       ( pstIdFactura != null && pstIdFactura.trim().length() > 0) ? pstIdFactura : "";
                                               
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("fac.ID_FACTURA, ");
                                               sbD.append("fac.NO_FACTURA, ");
                                               sbD.append("to_char(fac.FECHA,'dd.mm.yyyy') as FECHA_FACTURA, ");
                                               sbD.append("fac.IVA, ");
                                               sbD.append("SUBSTR(fac.COMENTARIO,0,50) as COMENTARIO, ");
                                               sbD.append("CASE "); 
                                               sbD.append("WHEN fac.FECHA_SAP_I17 is null then LPAD(posiciones.POS_MAX + 10,5,'0') ");
                                               sbD.append("ELSE LPAD(posiciones.POS_MAX,5,'0') ");
                                               sbD.append("END as POSICION_ENVIAR, ");                                      
                                               sbD.append("fac.TIPO_PAGO, ");
                                               sbD.append("to_char(fac.FECHA_SAP_I17,'dd/mm/yyyy') as FECHA_SAP_I17, ");
                                               sbD.append("to_char(fac.FECHA_SAP_I32,'dd/mm/yyyy') as FECHA_SAP_I32, ");
                                               sbD.append("to_char(fac.FECHA_SAP_I14,'dd/mm/yyyy') as FECHA_SAP_I14, ");
                                               sbD.append("est.MONEDA, ");
                                               sbD.append("facdet.ID_CONTRATO_ORIGINAL, ");
                                               sbD.append("facdet.MONTO_PAGAR, ");
                                               sbD.append("cnt.ID_SAP as ID_SAP_CONTRATO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_FACTURA fac, ");
                                               sbD.append("DDA_C_ESTUDIO est, ");
                                               sbD.append("DDA_T_FACTURA_DETALLE facdet, ");
                                               sbD.append("DDA_T_CONTRATO cnt, ");
                                               sbD.append("( ");
                                               sbD.append("   select ");
                                               sbD.append("    fd.ID_CONTRATO_ORIGINAL, ");
                                               sbD.append("   NVL(MAX(f.POSICION),10) as POS_MAX ");
                                               sbD.append("    from ");
                                               sbD.append("   DDA_T_FACTURA f, ");
                                               sbD.append("    DDA_T_FACTURA_DETALLE fd ");
                                               sbD.append("   where ");
                                               sbD.append("   f.ID_FACTURA = fd.ID_FACTURA ");
                                               sbD.append("   group by fd.ID_CONTRATO_ORIGINAL ");
                                               sbD.append(") posiciones ");
                                               sbD.append("where ");
                                               sbD.append("fac.ID_ESTUDIO = est.ID_ESTUDIO ");
                                               sbD.append("and fac.ID_FACTURA = facdet.ID_FACTURA ");
                                               sbD.append("and facdet.ID_CONTRATO_ORIGINAL = cnt.ID_CONTRATO ");
                                               sbD.append("and facdet.ID_CONTRATO_ORIGINAL = posiciones.ID_CONTRATO_ORIGINAL ");
                                               sbD.append("and cnt.ID_SAP is not null ");
                                               sbD.append("and fac.ID_FACTURA = "+lstIdFactura+" ");
                                               LOG.debug(">Sql_D [obtenerDatosFactura]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("fac.ID_FACTURA, ");
                                               sb.append("fac.NO_FACTURA, ");
                                               sb.append("to_char(fac.FECHA,'dd.mm.yyyy') as FECHA_FACTURA, ");
                                               sb.append("fac.IVA, ");
                                               sb.append("SUBSTR(fac.COMENTARIO,0,50) as COMENTARIO, ");
                                               sb.append("CASE "); 
                                               sb.append("WHEN fac.FECHA_SAP_I17 is null then LPAD(posiciones.POS_MAX + 10,5,'0') ");
                                               sb.append("ELSE LPAD(posiciones.POS_MAX,5,'0') ");
                                               sb.append("END as POSICION_ENVIAR, ");
                                               sb.append("fac.TIPO_PAGO, ");
                                               sb.append("to_char(fac.FECHA_SAP_I17,'dd/mm/yyyy') as FECHA_SAP_I17, ");
                                               sb.append("to_char(fac.FECHA_SAP_I32,'dd/mm/yyyy') as FECHA_SAP_I32, ");
                                               sb.append("to_char(fac.FECHA_SAP_I14,'dd/mm/yyyy') as FECHA_SAP_I14, ");
                                               sb.append("est.MONEDA, ");
                                               sb.append("facdet.ID_CONTRATO_ORIGINAL, ");
                                               sb.append("facdet.MONTO_PAGAR, ");
                                               sb.append("cnt.ID_SAP as ID_SAP_CONTRATO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_FACTURA fac, ");
                                               sb.append("DDA_C_ESTUDIO est, ");
                                               sb.append("DDA_T_FACTURA_DETALLE facdet, ");
                                               sb.append("DDA_T_CONTRATO cnt, ");
                                               sb.append("( ");
                                               sb.append("                      select ");
                                               sb.append("       fd.ID_CONTRATO_ORIGINAL, ");
                                               sb.append("                      NVL(MAX(f.POSICION),10) as POS_MAX ");
                                               sb.append("       from ");
                                               sb.append("                      DDA_T_FACTURA f, ");
                                               sb.append("       DDA_T_FACTURA_DETALLE fd ");
                                               sb.append("                      where ");
                                               sb.append("                      f.ID_FACTURA = fd.ID_FACTURA ");
                                               sb.append("                      group by fd.ID_CONTRATO_ORIGINAL ");
                                               sb.append(") posiciones ");
                                               sb.append("where ");
                                               sb.append("fac.ID_ESTUDIO = est.ID_ESTUDIO ");
                                               sb.append("and fac.ID_FACTURA = facdet.ID_FACTURA ");
                                               sb.append("and facdet.ID_CONTRATO_ORIGINAL = cnt.ID_CONTRATO ");
                                               sb.append("and facdet.ID_CONTRATO_ORIGINAL = posiciones.ID_CONTRATO_ORIGINAL ");
                                               sb.append("and cnt.ID_SAP is not null ");
                                               sb.append("and fac.ID_FACTURA = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdFactura);
                                               
                                               lobResultado = (ArrayList<DatosFacturaDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<DatosFacturaDTO>(DatosFacturaDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerDatosFactura]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                @Override
                public boolean actualizaFacturaFull(FacturaDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstIdFactura = (dto.getID_FACTURA() != null && dto.getID_FACTURA().trim().length() > 0) ? dto.getID_FACTURA() : "VACIO";
                               String lstNoFactura = (dto.getNO_FACTURA() != null && dto.getNO_FACTURA().trim().length() > 0) ? dto.getNO_FACTURA() : "VACIO";
                               String lstFecha = (dto.getFECHA() != null && dto.getFECHA().trim().length() > 0) ? dto.getFECHA() : "VACIO";
                               String lstMonto = (dto.getMONTO() != null && dto.getMONTO().trim().length() > 0) ? dto.getMONTO() : "VACIO";
                               String lstSharepoint = (dto.getSHAREPOINT() != null && dto.getSHAREPOINT().trim().length() > 0) ? dto.getSHAREPOINT() : "VACIO";
                               String lstApproved = (dto.getAPPROVED() != null && dto.getAPPROVED().trim().length() > 0) ? dto.getAPPROVED() : "VACIO";
                               String lstSAP = (dto.getSAP() != null && dto.getSAP().trim().length() > 0) ? dto.getSAP() : "VACIO";
                               String lstPaid = (dto.getPAID() != null && dto.getPAID().trim().length() > 0) ? dto.getPAID() : "VACIO";
                               String lstDUE = (dto.getDUE() != null && dto.getDUE().trim().length() > 0) ? dto.getDUE() : "VACIO";
                               String lstComentario = (dto.getCOMENTARIO() != null && dto.getCOMENTARIO().trim().length() > 0) ? dto.getCOMENTARIO() : "VACIO";
                               String lstIdEstudio = (dto.getID_ESTUDIO() != null && dto.getID_ESTUDIO().trim().length() > 0) ? dto.getID_ESTUDIO() : "VACIO";
                               String lstIVA = (dto.getIVA() != null && dto.getIVA().trim().length() > 0) ? dto.getIVA() : "VACIO";
                               String lstPosicion = (dto.getPOSICION() != null && dto.getPOSICION().trim().length() > 0) ? dto.getPOSICION() : "VACIO";
                               String lstFechaSapI17 = (dto.getFECHA_SAP_I17() != null && dto.getFECHA_SAP_I17().trim().length() > 0) ? dto.getFECHA_SAP_I17() : "VACIO";
                               String lstFechaSapI32 = (dto.getFECHA_SAP_I32() != null && dto.getFECHA_SAP_I32().trim().length() > 0) ? dto.getFECHA_SAP_I32() : "VACIO";
                               String lstDocMaterial = (dto.getDOC_MATERIAL() != null && dto.getDOC_MATERIAL().trim().length() > 0) ? dto.getDOC_MATERIAL() : "VACIO";
                               String lstFechaSapI14 = (dto.getFECHA_SAP_I14() != null && dto.getFECHA_SAP_I14().trim().length() > 0) ? dto.getFECHA_SAP_I14() : "VACIO";
                               String lstFacturaI14 = (dto.getFACTURA_I14() != null && dto.getFACTURA_I14().trim().length() > 0) ? dto.getFACTURA_I14() : "VACIO";
                               String lstFechaSapI16 = (dto.getFECHA_SAP_I16() != null && dto.getFECHA_SAP_I16().trim().length() > 0) ? dto.getFECHA_SAP_I16() : "VACIO";
                               String lstDoctoSapI16 = (dto.getDOCTO_SAP_I16() != null && dto.getDOCTO_SAP_I16().trim().length() > 0) ? dto.getDOCTO_SAP_I16() : "VACIO";
                               String lstTipoPago = (dto.getTIPO_PAGO() != null && dto.getTIPO_PAGO().trim().length() > 0) ? dto.getTIPO_PAGO() : "VACIO";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               Timestamp lobTSFechaSapI17 = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               Timestamp lobTSFechaSapI32 = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               Timestamp lobTSFechaSapI14 = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               Timestamp lobTSFechaSapI16 = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                                               sbD.append("UPDATE DDA_T_FACTURA ");
                                                               sbD.append("SET ");
                                                               sbD.append("FECHA_WS = SYSDATE ");
                                               
                                               if(!lstNoFactura.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",NO_FACTURA='"+lstNoFactura+"' ");
                                               if(!lstFecha.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA=to_date('"+lstFecha+"','yyyy-mm-dd') ");
                                               if(!lstMonto.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",MONTO='"+lstMonto+"' ");
                                               if(!lstSharepoint.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",SHAREPOINT="+lstSharepoint+" ");
                                               if(!lstApproved.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",APPROVED="+lstApproved+" ");
                                               if(!lstSAP.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",SAP="+lstSAP+" ");
                                               if(!lstPaid.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",PAID='"+lstPaid+"' ");
                                               if(!lstDUE.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",DUE='"+lstDUE+"' ");
                                               if(!lstComentario.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",COMENTARIO='"+lstComentario+"' ");
                                               if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",ID_ESTUDIO="+lstIdEstudio+" ");
                                               if(!lstIVA.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",IVA='"+lstIVA+"' ");
                                               if(!lstPosicion.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",POSICION='"+lstPosicion+"' ");
                                               if(!lstFechaSapI17.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_SAP_I17=to_date('"+lstFechaSapI17+"','yyyy-mm-dd') ");
                                               if(!lstFechaSapI32.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_SAP_I32=to_date('"+lstFechaSapI32+"','yyyy-mm-dd') ");
                                               if(!lstDocMaterial.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",DOC_MATERIAL='"+lstDocMaterial+"' ");
                                               if(!lstFechaSapI14.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_SAP_I14=to_date('"+lstFechaSapI14+"','yyyy-mm-dd') ");
                                               if(!lstFacturaI14.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FACTURA_I14='"+lstFacturaI14+"' ");
                                               if(!lstFechaSapI16.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",FECHA_SAP_I16=to_date('"+lstFechaSapI16+"','yyyy-mm-dd') ");
                                               if(!lstDoctoSapI16.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",DOCTO_SAP_I16='"+lstDoctoSapI16+"' ");
                                               if(!lstTipoPago.equalsIgnoreCase("VACIO"))
                                                               sbD.append(",TIPO_PAGO='"+lstTipoPago+"' ");
                                               
                                                               sbD.append("where ");
                                                               sbD.append("ID_FACTURA = "+lstIdFactura+" ");
                                               LOG.debug(">Sql_D [actualizaFacturaFull]:" + sbD.toString());
                                               

                                               //--Ejecucion
                                                               sb.append("UPDATE DDA_T_FACTURA ");
                                                               sb.append("SET ");
                                                               sb.append("FECHA_WS = SYSDATE ");
                               
                                               if(!lstNoFactura.equalsIgnoreCase("VACIO"))
                                                               sb.append(",NO_FACTURA=? ");
                                               if(!lstFecha.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA=? ");
                                                if(!lstMonto.equalsIgnoreCase("VACIO"))
                                                               sb.append(",MONTO=? ");
                                               if(!lstSharepoint.equalsIgnoreCase("VACIO"))
                                                               sb.append(",SHAREPOINT=? ");
                                               if(!lstApproved.equalsIgnoreCase("VACIO"))
                                                               sb.append(",APPROVED=? ");
                                               if(!lstSAP.equalsIgnoreCase("VACIO"))
                                                               sb.append(",SAP=? ");
                                               if(!lstPaid.equalsIgnoreCase("VACIO"))
                                                               sb.append(",PAID=? ");
                                               if(!lstDUE.equalsIgnoreCase("VACIO"))
                                                               sb.append(",DUE=? ");
                                               if(!lstComentario.equalsIgnoreCase("VACIO"))
                                                               sb.append(",COMENTARIO=? ");
                                               if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
                                                               sb.append(",ID_ESTUDIO=? ");
                                               if(!lstIVA.equalsIgnoreCase("VACIO"))
                                                               sb.append(",IVA=? ");
                                               if(!lstPosicion.equalsIgnoreCase("VACIO"))
                                                               sb.append(",POSICION=? ");
                                               if(!lstFechaSapI17.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_SAP_I17=? ");
                                               if(!lstFechaSapI32.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_SAP_I32=? ");
                                               if(!lstDocMaterial.equalsIgnoreCase("VACIO"))
                                                               sb.append(",DOC_MATERIAL=? ");
                                               if(!lstFechaSapI14.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_SAP_I14=? ");
                                               if(!lstFacturaI14.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FACTURA_I14=? ");
                                               if(!lstFechaSapI16.equalsIgnoreCase("VACIO"))
                                                               sb.append(",FECHA_SAP_I16=? ");
                                               if(!lstDoctoSapI16.equalsIgnoreCase("VACIO"))
                                                               sb.append(",DOCTO_SAP_I16=? ");
                                               if(!lstTipoPago.equalsIgnoreCase("VACIO"))
                                                               sb.append(",TIPO_PAGO=? ");
                                               
                                                               sb.append("where ");
                                                               sb.append("ID_FACTURA = ? ");
                                               
                               
                                               //--Valores query
                                               if(!lstNoFactura.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstNoFactura);
                                               if(!lstFecha.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFecha+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }
                                               if(!lstMonto.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstMonto);
                                               if(!lstSharepoint.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstSharepoint);
                                               if(!lstApproved.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstApproved);
                                               if(!lstSAP.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstSAP);
                                               if(!lstPaid.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstPaid);
                                               if(!lstDUE.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstDUE);
                                               if(!lstComentario.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstComentario);
                                               if(!lstIdEstudio.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIdEstudio);
                                               if(!lstIVA.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstIVA);
                                               if(!lstPosicion.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstPosicion);
                                               if(!lstFechaSapI17.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFechaSapI17.setTime(df.parse(lstFechaSapI17+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFechaSapI17);
                                               }
                                               if(!lstFechaSapI32.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFechaSapI32.setTime(df.parse(lstFechaSapI32+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFechaSapI32);
                                               }
                                               if(!lstDocMaterial.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstDocMaterial);
                                               if(!lstFechaSapI14.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFechaSapI14.setTime(df.parse(lstFechaSapI14+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFechaSapI14);
                                               }
                                               if(!lstFacturaI14.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstFacturaI14);
                                               if(!lstFechaSapI16.equalsIgnoreCase("VACIO"))
                                               {
                                                               lobTSFechaSapI16.setTime(df.parse(lstFechaSapI16+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFechaSapI16);
                                               }
                                               if(!lstDoctoSapI16.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstDoctoSapI16);
                                               if(!lstTipoPago.equalsIgnoreCase("VACIO"))
                                                               qryParams.add(lstTipoPago);
                                               
                                               qryParams.add(lstIdFactura);
                                               
                                               final String lstSQL = sb.toString();
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizaFacturaFull]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public List<MaterialDTO> obtenerCodigoISOMedida(String pstIdMaterial) throws Exception 
                {
                               List<MaterialDTO> lobResultado = new ArrayList<MaterialDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdSAPMaterial =             ( pstIdMaterial != null && pstIdMaterial.trim().length() > 0) ? pstIdMaterial : "";
                                               
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("CODIGO_ISO_MEDIDA ");
                                               sbD.append("from ");
                                               sbD.append("DDA_C_MATERIAL ");
                                               sbD.append("where ");
                                               sbD.append("to_number(CODIGO_SAP) = to_number('"+lstIdSAPMaterial+"') ");
                                               LOG.debug(">Sql_D [obtenerCodigoISOMedida]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("CODIGO_ISO_MEDIDA ");
                                               sb.append("from ");
                                               sb.append("DDA_C_MATERIAL ");
                                               sb.append("where ");
                                               sb.append("to_number(CODIGO_SAP) = to_number(?) ");

                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdSAPMaterial);
                                               
                                               lobResultado = (ArrayList<MaterialDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<MaterialDTO>(MaterialDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerCodigoISOMedida]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                public String obtenerIndicadorIVACnt(String pstIdContrato) throws Exception 
                {
                               String lstResultado = "";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                                                
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("CLAVE_IVA ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CONTRATO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerIndicadorIVACnt]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("CLAVE_IVA ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CONTRATO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");

                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lstResultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerIndicadorIVACnt]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerIndicadorIVACnt]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lstResultado;
                }

                @Override
                public String obtenerUltimaPosicionRegSinDocMaterial(String pstIdContrato) throws Exception 
                {
                               String lstResultado = "";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.length() > 0) ? pstIdContrato: "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("LPAD(NVL(MAX(POSICION),0),5,'0') as POSICION ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CONTRATO_SAP ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               sbD.append("and DOC_MATERIAL is null ");
                                               LOG.debug(">Sql_D [obtenerUltimaPosicionRegSinDocMaterial]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("LPAD(NVL(MAX(POSICION),0),5,'0') as POSICION ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CONTRATO_SAP ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               sb.append("and DOC_MATERIAL is null ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lstResultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return lstResultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerUltimaPosicionRegSinDocMaterial]: No se encontraron registros coincidentes con el ID especificado. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con el ID especificado");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerUltimaPosicionRegSinDocMaterial]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }

                @Override
                public List<QryMontosAnualesCntDTO> obtenerMontosAnualesPorContrato(String pstIdContrato) throws Exception 
                {
                               List<QryMontosAnualesCntDTO> lobResultado = new ArrayList<QryMontosAnualesCntDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdContrato =    ( pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                                               
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ROUND(SUM(COSTO),2) as MONTO, to_char(FECHA_INICIO,'yyyy') AS ANNIO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_TITULO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               sbD.append("and ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               sbD.append("and to_number(to_char(FECHA_INICIO,'yyyy')) >= (to_number(to_char(SYSDATE,'yyyy'))) ");
                                               sbD.append("group by to_char(FECHA_INICIO,'yyyy') ");
                                               LOG.debug(">Sql_D [obtenerMontosAnualesPorContrato]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ROUND(SUM(COSTO),2) as MONTO, to_char(FECHA_INICIO,'yyyy') AS ANNIO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_TITULO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               sb.append("and ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               sb.append("and to_number(to_char(FECHA_INICIO,'yyyy')) >= (to_number(to_char(SYSDATE,'yyyy'))) ");
                                               sb.append("group by to_char(FECHA_INICIO,'yyyy') ");

                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<QryMontosAnualesCntDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryMontosAnualesCntDTO>(QryMontosAnualesCntDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontosAnualesPorContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                @Override
                public List<ContratoSAPDTO> obtenerMontoAnualReportadoSAP(String pstIdContrato, String pstAnnio) throws Exception 
                {
                               List<ContratoSAPDTO> lobResultado = new ArrayList<ContratoSAPDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               String lstIdContrato =    ( pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                                               String lstAnnio = ( pstAnnio != null && pstAnnio.trim().length() > 0) ? pstAnnio : "";
                                               
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("POSICION, ROUND(MONTO,2) as MONTO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_SAP ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               sbD.append("and ANNIO = '"+lstAnnio+"' ");
                                               LOG.debug(">Sql_D [obtenerMontoAnualReportadoSAP]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("POSICION, ROUND(MONTO,2) as MONTO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_SAP ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               sb.append("and ANNIO = ? ");

                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstAnnio);
                                               
                                               lobResultado = (ArrayList<ContratoSAPDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoSAPDTO>(ContratoSAPDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontoAnualReportadoSAP]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                @Override
                public boolean insertarRegistroPosicionAnnio(ContratoSAPDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().length() > 0) ? dto.getID_CONTRATO(): "";
                                               String lstPosicion = (dto.getPOSICION() != null && dto.getPOSICION().length() > 0) ? dto.getPOSICION(): "";
                                               String lstMonto = (dto.getMONTO() != null && dto.getMONTO().length() > 0) ? dto.getMONTO(): "";
                                               String lstDocMaterial = (dto.getDOC_MATERIAL() != null && dto.getDOC_MATERIAL().length() > 0) ? dto.getDOC_MATERIAL(): "";
                                               String lstAnnio = (dto.getANNIO() != null && dto.getANNIO().length() > 0) ? dto.getANNIO(): "";
                                               
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_CONTRATO_SAP ");
                                               sbD.append("( ");
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("POSICION, "); 
                                               sbD.append("MONTO, "); 
                                               sbD.append("DOC_MATERIAL, ");
                                               sbD.append("ANNIO, ");
                                               sbD.append("FECHA_SAP ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append(lstIdContrato+", "); 
                                               sbD.append("'"+lstPosicion+"', "); 
                                               sbD.append("'"+lstMonto+"', "); 
                                               sbD.append("'"+lstDocMaterial+"', ");
                                               sbD.append("'"+lstAnnio+"' ");
                                               sbD.append("SYSDATE ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [insertarRegistroPosicionAnnio]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_CONTRATO_SAP ");
                                               sb.append("( ");
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("POSICION, "); 
                                               sb.append("MONTO, "); 
                                               sb.append("DOC_MATERIAL, ");
                                               sb.append("ANNIO, ");
                                               sb.append("FECHA_SAP ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("(?, ?, ?, ?, ?, SYSDATE ) ");
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstPosicion);
                                               qryParams.add(lstMonto);
                                               qryParams.add(lstDocMaterial);
                                               qryParams.add(lstAnnio);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::insertarRegistroPosicionAnnio]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }


}
