package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.List;


/**
 * Representa los parametros para agregar una posicion a un contrato enviados desde el front-end, mismos que son 
 * recibidos por este cliente. Esta clase pertenece al ambito de DDA.
 * Los nombres de cada uno de los argumentos fueron tomados del Excel de inventario de interfaces. 
 *
 */
public class ParamAgregaPosicionDTO implements Serializable
{
	private static final long serialVersionUID = 1L;
	private String idDocumento;
	private List<ItemAgregaPosicionDTO> items;
	
	public String getIdDocumento() {
		return idDocumento;
	}

	public void setIdDocumento(String idDocumento) {
		this.idDocumento = idDocumento;
	}

	public List<ItemAgregaPosicionDTO> getItems() {
		return items;
	}

	public void setItems(List<ItemAgregaPosicionDTO> items) {
		this.items = items;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" idDocumento: _" + this.getIdDocumento() + "_" + NEW_LINE);
		result.append(" items: _" + this.getItems().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
