package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.List;


/**
 * Representa los parametros para la modificacin de posicion de un titulo enviados desde el front-end, mismos que son 
 * recibidos por este cliente. Esta clase pertenece al ambito de DDA.
 * Los nombres de cada uno de los argumentos fueron tomados del Excel de inventario de interfaces. 
 *
 */
public class ParamModificaPosicionDTO implements Serializable
{
	private static final long serialVersionUID = 1L;
	private String documento;
	private List<ItemModificaPosicionDTO> items;
	
	public String getDocumento() {
		return documento;
	}

	public void setDocumento(String documento) {
		this.documento = documento;
	}

	public List<ItemModificaPosicionDTO> getItems() {
		return items;
	}

	public void setItems(List<ItemModificaPosicionDTO> items) {
		this.items = items;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" documento: _" + this.getDocumento() + "_" + NEW_LINE);
		result.append(" items: _" + this.getItems().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
