package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

/**
 * Representa los parametros que se deben pasar al proceso de Actualizar Contrato.
 * Los campos que usa son:
 * <br>
 * caso: Es una descripcion que se usa para saber el contexto de cuando se actualiza el contrato. Ej. CASO_NOTIFICACION_SAP, CASO_VIGENTE,etc
 * <br>
 * estatus: Es el valor del estatus a actualizar. Ej. 7 = Notificacion SAP, 5 = Vigente,etc.
 * <br>
 * idContrato: Es el id (interno) del Contrato al cual se hara la actualizacion del estatus.
 * <br>
 * expediente: Es el expediente del usuario que desencadeno el proceso.
 * <br>
 */
public class ParamActualizaContratoDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String caso;
	private String estatus;
	private String idContrato;
	private String expediente;
	
	public String getCaso() {
		return caso;
	}
	public void setCaso(String caso) {
		this.caso = caso;
	}
	public String getEstatus() {
		return estatus;
	}
	public void setEstatus(String estatus) {
		this.estatus = estatus;
	}
	public String getIdContrato() {
		return idContrato;
	}
	public void setIdContrato(String idContrato) {
		this.idContrato = idContrato;
	}
	public String getExpediente() {
		return expediente;
	}
	public void setExpediente(String expediente) {
		this.expediente = expediente;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" caso: _" + this.getCaso() + "_" + NEW_LINE);
		result.append(" estatus: _" + this.getEstatus() + "_" + NEW_LINE);
		result.append(" idContrato: _" + this.getIdContrato() + "_" + NEW_LINE);
		result.append(" expediente: _" + this.getExpediente() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
}
