package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.List;


/**
 * Representa los parametros de la Orden de Compra (Contrato) enviados desde el front-end, mismos que son 
 * recibidos por este cliente. Esta clase pertenece al ambito de DDA.
 * Los nombres de cada uno de los argumentos fueron tomados del Excel de inventario de interfaces. 
 *
 */
public class ParamOrdenCompraDTO implements Serializable
{
	private static final long serialVersionUID = 1L;
	private String sociedad;
	private String claseDoc;
	private String idProveedor;
	private String orgCompras;
	private String grupoCompras;
	private String fechaDoc;
	private String referencia;
	private String idContrato;
	private String expediente;
	private List<ItemOrdenCompraDTO> items;
	
	public String getSociedad() {
		return this.sociedad;
	}
	public void setSociedad(String sociedad) {
		this.sociedad = sociedad;
	}
	public String getClaseDoc() {
		return this.claseDoc;
	}
	public void setClaseDoc(String claseDoc) {
		this.claseDoc = claseDoc;
	}
	public String getIdProveedor() {
		return this.idProveedor;
	}
	public void setIdProveedor(String idProveedor) {
		this.idProveedor = idProveedor;
	}
	public String getOrgCompras() {
		return this.orgCompras;
	}
	public void setOrgCompras(String orgCompras) {
		this.orgCompras = orgCompras;
	}
	public String getGrupoCompras() {
		return this.grupoCompras;
	}
	public void setGrupoCompras(String grupoCompras) {
		this.grupoCompras = grupoCompras;
	}
	public String getFechaDoc() {
		return this.fechaDoc;
	}
	public void setFechaDoc(String fechaDoc) {
		this.fechaDoc = fechaDoc;
	}
	public String getReferencia() {
		return this.referencia;
	}
	public void setReferencia(String referencia) {
		this.referencia = referencia;
	}
	public List<ItemOrdenCompraDTO> getItems() {
		return this.items;
	}
	public void setItems(List<ItemOrdenCompraDTO> items) {
		this.items = items;
	}
	public String getIdContrato() {
		return this.idContrato;
	}
	public void setIdContrato(String idContrato) {
		this.idContrato = idContrato;
	}
	public String getExpediente() {
		return expediente;
	}
	public void setExpediente(String expediente) {
		this.expediente = expediente;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" sociedad: _" + this.getSociedad() + "_" + NEW_LINE);
		result.append(" claseDoc: _" + this.getClaseDoc() + "_" + NEW_LINE);
		result.append(" idProveedor: _" + this.getIdProveedor() + "_" + NEW_LINE);
		result.append(" orgCompras: _" + this.getOrgCompras() + "_" + NEW_LINE);
		result.append(" grupoCompras: _" + this.getGrupoCompras() + "_" + NEW_LINE);
		result.append(" fechaDoc: _" + this.getFechaDoc() + "_" + NEW_LINE);
		result.append(" referencia: _" + this.getReferencia() + "_" + NEW_LINE);
		result.append(" idContrato: _" + this.getIdContrato() + "_" + NEW_LINE);
		result.append(" expediente: _" + this.getExpediente() + "_" + NEW_LINE);
		result.append(" items: _" + this.getItems().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
