/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.base;

import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.context.FacesContext;

public abstract class AbstractBehavior
extends ClientBehaviorBase {
    protected Map<String, Object> literals;
    protected Map<String, ValueExpression> bindings;

    public AbstractBehavior() {
        int propertiesCount = this.getAllProperties().length;
        this.literals = new HashMap<String, Object>(propertiesCount);
        this.bindings = new HashMap<String, ValueExpression>(propertiesCount);
    }

    public void setLiteral(String attr, Object val) {
        if (val == null && this.literals.containsKey(attr)) {
            this.literals.remove(attr);
        } else {
            this.literals.put(attr, val);
        }
    }

    public void setLiteral(Enum<?> property, Object val) {
        String attr = property.name();
        this.setLiteral(attr, val);
    }

    public void setValueExpression(String attr, ValueExpression ve) {
        if (ve == null && this.bindings.containsKey(attr)) {
            this.bindings.remove(attr);
        } else {
            this.bindings.put(attr, ve);
        }
    }

    public void setValueExpression(Enum<?> property, ValueExpression ve) {
        String attr = property.name();
        this.setValueExpression(attr, ve);
    }

    public <T> T eval(String attr, T unspecifiedValue) {
        if (this.literals.containsKey(attr)) {
            Object val = this.literals.get(attr);
            if (val == null) {
                return unspecifiedValue;
            }
            return (T)val;
        }
        ValueExpression ve = this.bindings.get(attr);
        if (ve != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            return (T)ve.getValue(elContext);
        }
        return unspecifiedValue;
    }

    protected <T> T eval(Enum<?> property, T unspecifiedValue) {
        return this.eval(property.name(), unspecifiedValue);
    }

    public void put(String name, Object value) {
        this.setLiteral(name, value);
    }

    public void put(Enum<?> property, Object value) {
        this.setLiteral(property.name(), value);
    }

    protected boolean isAttributeSet(String attr) {
        return this.literals.containsKey(attr) || this.bindings.containsKey(attr);
    }

    protected boolean isAttributeSet(Enum<?> property) {
        String attr = property.name();
        return this.isAttributeSet(attr);
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object superState = super.saveState(context);
        Object values = this.initialStateMarked() ? (superState == null ? null : new Object[]{superState}) : new Object[]{superState, this.savePropertyMap(context, this.literals, false), this.savePropertyMap(context, this.bindings, true)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            super.restoreState(context, values[0]);
            if (values.length != 1) {
                this.literals = this.restorePropertyMap(context, (Object[])values[1], false);
                this.bindings = this.restorePropertyMap(context, (Object[])values[2], true);
                this.clearInitialState();
            }
        }
    }

    protected Object[] savePropertyMap(FacesContext context, Map map, boolean saveValuesAsAttachedState) {
        if (map == null) {
            return null;
        }
        Enum<?>[] allProperties = this.getAllProperties();
        Object[] values = new Object[allProperties.length];
        for (int i = 0; i < allProperties.length; ++i) {
            Object val = map.get(allProperties[i].name());
            if (saveValuesAsAttachedState) {
                val = UIComponentBase.saveAttachedState((FacesContext)context, val);
            }
            if (val == null) continue;
            values[i] = val;
        }
        return values;
    }

    protected Map restorePropertyMap(FacesContext context, Object[] values, boolean restoreValuesFromAttachedState) {
        if (values == null) {
            return null;
        }
        Enum<?>[] allProperties = this.getAllProperties();
        HashMap<String, Object> map = new HashMap<String, Object>(allProperties.length);
        for (int i = 0; i < allProperties.length; ++i) {
            Object val = values[i];
            if (restoreValuesFromAttachedState) {
                val = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)val);
            }
            if (val == null) continue;
            map.put(allProperties[i].name(), val);
        }
        return map;
    }

    protected abstract Enum<?>[] getAllProperties();
}

