/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.io.Serializable;
import javax.faces.component.EditableValueHolder;

public class SavedState
implements Serializable {
    public static final SavedState NULL_STATE = new SavedState();
    private static final long serialVersionUID = 4325654657465654768L;
    private Object submittedValue;
    private boolean submitted;
    private boolean valid = true;
    private Object value;
    private boolean localValueSet = false;

    public SavedState() {
    }

    public SavedState(EditableValueHolder evh) {
        this.populate(evh);
    }

    public void populate(EditableValueHolder evh) {
        this.value = evh.getLocalValue();
        this.valid = evh.isValid();
        this.submittedValue = evh.getSubmittedValue();
        this.localValueSet = evh.isLocalValueSet();
    }

    public void restoreState(EditableValueHolder evh) {
        evh.setValue(this.value);
        evh.setValid(this.valid);
        evh.setSubmittedValue(this.submittedValue);
        evh.setLocalValueSet(this.localValueSet);
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isLocalValueSet() {
        return this.localValueSet;
    }

    public void setLocalValueSet(boolean localValueSet) {
        this.localValueSet = localValueSet;
    }

    public boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public String toString() {
        return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localValueSet ? 1231 : 1237);
        result = 31 * result + (this.submitted ? 1231 : 1237);
        result = 31 * result + (this.submittedValue == null ? 0 : this.submittedValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SavedState other = (SavedState)obj;
        if (this.localValueSet != other.localValueSet) {
            return false;
        }
        if (this.submitted != other.submitted) {
            return false;
        }
        return !(this.submittedValue == null ? other.submittedValue != null : !this.submittedValue.equals(other.submittedValue));
    }
}

