/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.convert.DateTimeConverter;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.LocaleUtils;

public abstract class UICalendar
extends HtmlInputText {
    public static final String CONTAINER_CLASS = "ui-calendar";
    public static final String INPUT_STYLE_CLASS = "ui-inputfield ui-widget ui-state-default ui-corner-all";
    public static final String DATE_OUT_OF_RANGE_MESSAGE_ID = "primefaces.calendar.OUT_OF_RANGE";
    public static final String DATE_INVALID_MESSAGE_ID = "primefaces.calendar.INVALID";
    public static final String DATE_INVALID_RANGE_MESSAGE_ID = "primefaces.calendar.DATE_INVALID_RANGE_MESSAGE_ID";
    private String timeOnlyPattern = null;
    private boolean conversionFailed = false;

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public Object getTimeZone() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeZone), null);
    }

    public void setTimeZone(Object timeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeZone), timeZone);
    }

    public String getPattern() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pattern), null);
    }

    public void setPattern(String pattern) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pattern), (Object)pattern);
    }

    public Object getMindate() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mindate), null);
    }

    public void setMindate(Object mindate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mindate), mindate);
    }

    public Object getMaxdate() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxdate), null);
    }

    public void setMaxdate(Object maxdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxdate), maxdate);
    }

    public boolean isTimeOnly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeOnly), (Object)false);
    }

    public void setTimeOnly(boolean timeOnly) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeOnly), (Object)timeOnly);
    }

    public boolean isReadonlyInput() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonlyInput), (Object)false);
    }

    public void setReadonlyInput(boolean readonlyInput) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonlyInput), (Object)readonlyInput);
    }

    public String getInputStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputStyle), null);
    }

    public void setInputStyle(String inputStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inputStyle), (Object)inputStyle);
    }

    public String getInputStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputStyleClass), null);
    }

    public void setInputStyleClass(String inputStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inputStyleClass), (Object)inputStyleClass);
    }

    public String getType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.type), (Object)"text");
    }

    public void setType(String type) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.type), (Object)type);
    }

    public String getSelectionMode() {
        return null;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return LocaleUtils.resolveLocale(this.getLocale(), this.getClientId(facesContext));
    }

    public boolean hasTime() {
        String pattern = this.getPattern();
        return pattern != null && (pattern.contains("HH") || pattern.contains("mm") || pattern.contains("ss"));
    }

    public String calculatePattern() {
        String pattern = this.getPattern();
        Locale locale = this.calculateLocale(this.getFacesContext());
        return pattern == null ? ((SimpleDateFormat)DateFormat.getDateInstance(3, locale)).toPattern() : pattern;
    }

    public String calculateTimeOnlyPattern() {
        if (this.timeOnlyPattern == null) {
            String localePattern = ((SimpleDateFormat)DateFormat.getDateInstance(3, this.calculateLocale(this.getFacesContext()))).toPattern();
            String userTimePattern = this.getPattern();
            this.timeOnlyPattern = localePattern + " " + userTimePattern;
        }
        return this.timeOnlyPattern;
    }

    public String convertPattern(String patternTemplate) {
        String pattern = patternTemplate.replaceAll("MMM", "###");
        int patternLen = pattern.length();
        int countM = patternLen - pattern.replaceAll("M", "").length();
        int countD = patternLen - pattern.replaceAll("d", "").length();
        if (countM == 1) {
            pattern = pattern.replaceAll("M", "mm");
        }
        if (countD == 1) {
            pattern = pattern.replaceAll("d", "dd");
        }
        pattern = pattern.replaceAll("[a-zA-Z]", "9");
        pattern = pattern.replaceAll("###", "aaa");
        return pattern;
    }

    public boolean isConversionFailed() {
        return this.conversionFailed;
    }

    public void setConversionFailed(boolean value) {
        this.conversionFailed = value;
    }

    public String getInputClientId() {
        return this.getClientId(this.getFacesContext()) + "_input";
    }

    public String getValidatableInputClientId() {
        return this.getClientId(this.getFacesContext()) + "_input";
    }

    public String getLabelledBy() {
        return (String)this.getStateHelper().get((Serializable)((Object)"labelledby"));
    }

    public void setLabelledBy(String labelledBy) {
        this.getStateHelper().put((Serializable)((Object)"labelledby"), (Object)labelledBy);
    }

    public Converter getConverter() {
        Converter converter = super.getConverter();
        if (converter == null && PrimeApplicationContext.getCurrentInstance(this.getFacesContext()).getConfig().isClientSideValidationEnabled()) {
            DateTimeConverter con = new DateTimeConverter();
            con.setPattern(this.calculatePattern());
            con.setTimeZone(CalendarUtils.calculateTimeZone(this.getTimeZone()));
            con.setLocale(this.calculateLocale(this.getFacesContext()));
            return con;
        }
        return converter;
    }

    public static enum PropertyKeys {
        locale,
        timeZone,
        pattern,
        mindate,
        maxdate,
        timeOnly,
        readonlyInput,
        inputStyle,
        inputStyleClass,
        type;

    }
}

