/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autoupdate;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderComponentEvent;

public class AutoUpdateListener
implements ComponentSystemEventListener {
    private static final String COMPONENT_CLIENT_IDS = AutoUpdateListener.class.getName() + ".COMPONENT_CLIENT_IDS";
    private static final AutoUpdateListener INSTANCE_ENABLED = new AutoUpdateListener(false);
    private static final AutoUpdateListener INSTANCE_DISABLED = new AutoUpdateListener(true);
    private final boolean disabled;

    public AutoUpdateListener() {
        this.disabled = false;
    }

    public AutoUpdateListener(boolean disabled) {
        this.disabled = disabled;
    }

    public void processEvent(ComponentSystemEvent cse) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = ((UIComponent)cse.getSource()).getClientId(context);
        List<String> clientIds = AutoUpdateListener.getOrCreateAutoUpdateComponentClientIds(context);
        if (this.disabled) {
            clientIds.remove(clientId);
        } else if (!clientIds.contains(clientId)) {
            clientIds.add(clientId);
        }
    }

    public static List<String> getOrCreateAutoUpdateComponentClientIds(FacesContext context) {
        List<String> clientIds = AutoUpdateListener.getAutoUpdateComponentClientIds(context);
        if (clientIds == null) {
            clientIds = new ArrayList<String>();
            context.getViewRoot().getAttributes().put(COMPONENT_CLIENT_IDS, clientIds);
        }
        return clientIds;
    }

    public static List<String> getAutoUpdateComponentClientIds(FacesContext context) {
        return (List)context.getViewRoot().getAttributes().get(COMPONENT_CLIENT_IDS);
    }

    public static void subscribe(UIComponent component, boolean disabled) {
        component.subscribeToEvent(PostAddToViewEvent.class, (ComponentSystemEventListener)(disabled ? INSTANCE_DISABLED : INSTANCE_ENABLED));
        component.subscribeToEvent(PreRenderComponentEvent.class, (ComponentSystemEventListener)(disabled ? INSTANCE_DISABLED : INSTANCE_ENABLED));
    }
}

