/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.clock;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.PrimeFaces;
import org.primefaces.component.clock.Clock;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.WidgetBuilder;

public class ClockRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Clock clock = (Clock)component;
        if (clock.isSyncRequest()) {
            PrimeFaces.current().ajax().addCallbackParam("datetime", System.currentTimeMillis());
            context.renderResponse();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Clock clock = (Clock)component;
        this.encodeMarkup(context, clock);
        this.encodeScript(context, clock);
    }

    protected void encodeMarkup(FacesContext context, Clock clock) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = clock.getClientId(context);
        if (clock.getDisplayMode().equals("analog")) {
            writer.startElement("div", (UIComponent)clock);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("class", (Object)"ui-analog-clock ui-widget", null);
            writer.endElement("div");
        } else {
            writer.startElement("span", (UIComponent)clock);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("class", (Object)"ui-clock ui-widget ui-widget-header ui-corner-all", null);
            writer.endElement("span");
        }
    }

    protected void encodeScript(FacesContext context, Clock clock) throws IOException {
        String clientId = clock.getClientId(context);
        String mode = clock.getMode();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Clock", clock.resolveWidgetVar(), clientId);
        wb.attr("mode", mode).attr("pattern", clock.getPattern(), null).attr("displayMode", clock.getDisplayMode()).attr("locale", context.getViewRoot().getLocale().toString());
        if (mode.equals("server")) {
            wb.attr("value", this.getValueWithTimeZone(context, clock));
            if (clock.isAutoSync()) {
                wb.attr("autoSync", true).attr("syncInterval", clock.getSyncInterval());
            }
        }
        wb.finish();
    }

    protected String getValueWithTimeZone(FacesContext context, Clock clock) {
        Locale locale = context.getViewRoot().getLocale();
        String value = "";
        if (locale != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", locale);
            dateFormat.setTimeZone(CalendarUtils.calculateTimeZone(clock.getTimeZone()));
            value = dateFormat.format(new Date());
        }
        return value;
    }
}

