/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.contentflow;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.contentflow.ContentFlow;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ContentFlowRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ContentFlow cf = (ContentFlow)component;
        this.encodeMarkup(context, cf);
        this.encodeScript(context, cf);
    }

    protected void encodeMarkup(FacesContext context, ContentFlow cf) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = cf.getStyle();
        String styleClass = cf.getStyleClass();
        String containerClass = styleClass == null ? "ui-contentflow ui-widget ui-widget-content ui-corner-all" : "ui-contentflow ui-widget ui-widget-content ui-corner-all " + styleClass;
        writer.startElement("div", (UIComponent)cf);
        writer.writeAttribute("id", (Object)cf.getClientId(context), null);
        writer.writeAttribute("class", (Object)containerClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"loadindicator", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"indicator", null);
        writer.endElement("div");
        writer.endElement("div");
        this.encodeContent(context, cf);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"globalCaption", null);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, ContentFlow cf) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = cf.getVar();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"flow", null);
        if (var == null) {
            for (UIComponent child : cf.getChildren()) {
                if (!child.isRendered()) continue;
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"item", null);
                child.encodeAll(context);
                writer.endElement("div");
            }
        } else {
            Map requestMap = context.getExternalContext().getRequestMap();
            Collection value = (Collection)cf.getValue();
            if (value != null) {
                Iterator it = value.iterator();
                while (it.hasNext()) {
                    requestMap.put(var, it.next());
                    writer.startElement("div", null);
                    writer.writeAttribute("class", (Object)"item", null);
                    this.renderChildren(context, (UIComponent)cf);
                    writer.endElement("div");
                }
            }
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ContentFlow cf) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        if (context.isPostback()) {
            wb.init("ContentFlow", cf.resolveWidgetVar(), cf.getClientId(context));
        } else {
            wb.initWithWindowLoad("ContentFlow", cf.resolveWidgetVar(), cf.getClientId(context));
        }
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

