/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.TableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.event.data.PostPageEvent;

public class PageFeature
implements DataTableFeature {
    @Override
    public void decode(FacesContext context, DataTable table) {
        throw new RuntimeException("PageFeature should not encode.");
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        table.updatePaginationData(context, table);
        boolean isPageState = table.isPageStateRequest(context);
        if (table.isLazy() && !isPageState) {
            table.loadLazyData();
        }
        if (!isPageState) {
            renderer.encodeTbody(context, table, true);
        }
        context.getApplication().publishEvent(context, PostPageEvent.class, (Object)table);
        if (table.isMultiViewState()) {
            TableState ts = table.getTableState(true);
            ts.setFirst(table.getFirst());
            ts.setRows(table.getRows());
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return table.isPaginationRequest(context);
    }
}

