/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.PDFExportVisitCallback;
import org.primefaces.util.ComponentUtils;

public class PDFExporter
extends Exporter {
    private Font cellFont;
    private Font facetFont;
    private Color facetBgColor;
    private ExporterOptions expOptions;
    private MethodExpression onTableRender;

    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, ExporterOptions options, MethodExpression onTableRender) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            this.onTableRender = onTableRender;
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            if (!document.isOpen()) {
                document.open();
            }
            if (options != null) {
                this.expOptions = options;
            }
            document.add((Element)this.exportPDFTable(context, table, pageOnly, selectionOnly, encodingType));
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, filename);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void export(FacesContext context, List<String> clientIds, String outputFileName, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, ExporterOptions options, MethodExpression onTableRender) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            this.onTableRender = onTableRender;
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            if (!document.isOpen()) {
                document.open();
            }
            if (options != null) {
                this.expOptions = options;
            }
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, clientIds, null);
            PDFExportVisitCallback visitCallback = new PDFExportVisitCallback(this, document, pageOnly, selectionOnly, encodingType);
            context.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, outputFileName);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void export(FacesContext context, String outputFileName, List<DataTable> tables, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, ExporterOptions options, MethodExpression onTableRender) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            this.onTableRender = onTableRender;
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            if (!document.isOpen()) {
                document.open();
            }
            if (options != null) {
                this.expOptions = options;
            }
            for (DataTable table : tables) {
                document.add((Element)this.exportPDFTable(context, table, pageOnly, selectionOnly, encodingType));
                Paragraph preface = new Paragraph();
                this.addEmptyLine(preface, 3);
                document.add((Element)preface);
            }
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, outputFileName);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected PdfPTable exportPDFTable(FacesContext context, DataTable table, boolean pageOnly, boolean selectionOnly, String encoding) {
        int columnsCount = this.getColumnsCount(table);
        PdfPTable pdfTable = new PdfPTable(columnsCount);
        this.cellFont = FontFactory.getFont((String)"Times", (String)encoding);
        this.facetFont = FontFactory.getFont((String)"Times", (String)encoding, (float)12.0f, (int)1);
        if (this.onTableRender != null) {
            this.onTableRender.invoke(context.getELContext(), new Object[]{pdfTable, table});
        }
        if (this.expOptions != null) {
            this.applyFacetOptions(this.expOptions);
            this.applyCellOptions(this.expOptions);
        }
        this.addTableFacets(context, table, pdfTable, "header");
        this.addColumnFacets(table, pdfTable, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, pdfTable);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, pdfTable);
        } else {
            this.exportAll(context, table, pdfTable);
        }
        if (table.hasFooterColumn()) {
            this.addColumnFacets(table, pdfTable, Exporter.ColumnType.FOOTER);
        }
        this.addTableFacets(context, table, pdfTable, "footer");
        table.setRowIndex(-1);
        return pdfTable;
    }

    protected void addTableFacets(FacesContext context, DataTable table, PdfPTable pdfTable, String facetType) {
        String facetText = null;
        UIComponent facet = table.getFacet(facetType);
        if (facet != null) {
            if (facet instanceof UIPanel) {
                for (UIComponent child : facet.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    facetText = value;
                    break;
                }
            } else {
                facetText = ComponentUtils.getValueToRender(context, facet);
            }
        }
        if (facetText != null) {
            int colspan = 0;
            for (UIColumn col : table.getColumns()) {
                if (!col.isRendered() || !col.isExportable()) continue;
                ++colspan;
            }
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(facetText, this.facetFont));
            if (this.facetBgColor != null) {
                cell.setBackgroundColor(this.facetBgColor);
            }
            cell.setHorizontalAlignment(1);
            cell.setColspan(colspan);
            pdfTable.addCell(cell);
        }
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        PdfPTable pdfTable = (PdfPTable)document;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(pdfTable, col.getChildren(), this.cellFont, col);
        }
    }

    protected void addColumnFacets(DataTable table, PdfPTable pdfTable, Exporter.ColumnType columnType) {
        for (UIColumn col : table.getColumns()) {
            String textValue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            UIComponent facet = col.getFacet(columnType.facet());
            switch (columnType) {
                case HEADER: {
                    textValue = col.getExportHeaderValue() != null ? col.getExportHeaderValue() : col.getHeaderText();
                    break;
                }
                case FOOTER: {
                    textValue = col.getExportFooterValue() != null ? col.getExportFooterValue() : col.getFooterText();
                    break;
                }
                default: {
                    textValue = null;
                }
            }
            if (textValue != null) {
                this.addColumnValue(pdfTable, textValue);
                continue;
            }
            if (facet != null) {
                this.addColumnValue(pdfTable, facet);
                continue;
            }
            this.addColumnValue(pdfTable, "");
        }
    }

    protected void addColumnValue(PdfPTable pdfTable, UIComponent component) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        this.addColumnValue(pdfTable, value);
    }

    protected void addColumnValue(PdfPTable pdfTable, String value) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, this.facetFont));
        if (this.facetBgColor != null) {
            cell.setBackgroundColor(this.facetBgColor);
        }
        pdfTable.addCell(cell);
    }

    protected void addColumnValue(PdfPTable pdfTable, List<UIComponent> components, Font font, UIColumn column) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (column.getExportFunction() != null) {
            pdfTable.addCell((Phrase)new Paragraph(this.exportColumnByFunction(context, column), font));
        } else {
            StringBuilder builder = new StringBuilder();
            for (UIComponent component : components) {
                String value;
                if (!component.isRendered() || (value = this.exportValue(context, component)) == null) continue;
                builder.append(value);
            }
            pdfTable.addCell((Phrase)new Paragraph(builder.toString(), font));
        }
    }

    protected void writePDFToResponse(ExternalContext externalContext, ByteArrayOutputStream baos, String fileName) throws IOException, DocumentException {
        externalContext.setResponseContentType("application/pdf");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", ComponentUtils.createContentDisposition("attachment", fileName + ".pdf"));
        externalContext.setResponseContentLength(baos.size());
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
        OutputStream out = externalContext.getResponseOutputStream();
        baos.writeTo(out);
        externalContext.responseFlushBuffer();
    }

    protected int getColumnsCount(DataTable table) {
        int count = 0;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            ++count;
        }
        return count;
    }

    protected void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Object)new Paragraph(" "));
        }
    }

    protected void applyFacetOptions(ExporterOptions options) {
        String facetFontStyle;
        String facetFontSize;
        String facetFontColor;
        String facetBackground = options.getFacetBgColor();
        if (facetBackground != null) {
            this.facetBgColor = Color.decode(facetBackground);
        }
        if ((facetFontColor = options.getFacetFontColor()) != null) {
            this.facetFont.setColor(Color.decode(facetFontColor));
        }
        if ((facetFontSize = options.getFacetFontSize()) != null) {
            this.facetFont.setSize((float)Integer.valueOf(facetFontSize).intValue());
        }
        if ((facetFontStyle = options.getFacetFontStyle()) != null) {
            if (facetFontStyle.equalsIgnoreCase("NORMAL")) {
                facetFontStyle = "0";
            }
            if (facetFontStyle.equalsIgnoreCase("BOLD")) {
                facetFontStyle = "1";
            }
            if (facetFontStyle.equalsIgnoreCase("ITALIC")) {
                facetFontStyle = "2";
            }
            this.facetFont.setStyle(facetFontStyle);
        }
    }

    protected void applyCellOptions(ExporterOptions options) {
        String cellFontStyle;
        String cellFontSize;
        String cellFontColor = options.getCellFontColor();
        if (cellFontColor != null) {
            this.cellFont.setColor(Color.decode(cellFontColor));
        }
        if ((cellFontSize = options.getCellFontSize()) != null) {
            this.cellFont.setSize((float)Integer.valueOf(cellFontSize).intValue());
        }
        if ((cellFontStyle = options.getCellFontStyle()) != null) {
            if (cellFontStyle.equalsIgnoreCase("NORMAL")) {
                cellFontStyle = "0";
            }
            if (cellFontStyle.equalsIgnoreCase("BOLD")) {
                cellFontStyle = "1";
            }
            if (cellFontStyle.equalsIgnoreCase("ITALIC")) {
                cellFontStyle = "2";
            }
            this.cellFont.setStyle(cellFontStyle);
        }
    }
}

