/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.organigram;

import org.primefaces.model.OrganigramNode;

public final class OrganigramHelper {
    private OrganigramHelper() {
    }

    public static OrganigramNode findTreeNode(OrganigramNode searchRoot, String rowKey) {
        if (rowKey == null || searchRoot == null) {
            return null;
        }
        if (searchRoot.getRowKey().equals(rowKey)) {
            return searchRoot;
        }
        if (searchRoot.getChildren() != null) {
            for (OrganigramNode child : searchRoot.getChildren()) {
                OrganigramNode childResult = OrganigramHelper.findTreeNode(child, rowKey);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    public static OrganigramNode findTreeNode(OrganigramNode searchRoot, OrganigramNode selection) {
        if (selection == null || searchRoot == null) {
            return null;
        }
        if (searchRoot.equals(selection)) {
            return searchRoot;
        }
        if (searchRoot.getChildren() != null) {
            for (OrganigramNode child : searchRoot.getChildren()) {
                OrganigramNode childResult = OrganigramHelper.findTreeNode(child, selection);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    public static void buildRowKeys(OrganigramNode node) {
        if (node.getChildren() != null && !node.getChildren().isEmpty()) {
            for (int i = 0; i < node.getChildren().size(); ++i) {
                OrganigramNode childNode = node.getChildren().get(i);
                String childRowKey = node.getParent() == null ? String.valueOf(i) : node.getRowKey() + "_" + i;
                childNode.setRowKey(childRowKey);
                OrganigramHelper.buildRowKeys(childNode);
            }
        }
    }
}

