/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.splitbutton;

import java.io.Serializable;
import java.util.List;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.splitbutton.SplitButtonBase;
import org.primefaces.event.MenuActionEvent;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuGroup;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class SplitButton
extends SplitButtonBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.SplitButton";
    public static final String STYLE_CLASS = "ui-splitbutton ui-buttonset ui-widget";
    public static final String BUTTON_TEXT_ICON_LEFT_BUTTON_CLASS = "ui-button ui-widget ui-state-default ui-corner-left ui-button-text-icon-left";
    public static final String BUTTON_TEXT_ICON_RIGHT_BUTTON_CLASS = "ui-button ui-widget ui-state-default ui-corner-left ui-button-text-icon-right";
    public static final String MENU_ICON_BUTTON_CLASS = "ui-splitbutton-menubutton  ui-button ui-widget ui-state-default ui-corner-right ui-button-icon-only";
    public static final String BUTTON_TEXT_ONLY_BUTTON_CLASS = "ui-button ui-widget ui-state-default ui-corner-left ui-button-text-only";
    public static final String BUTTON_ICON_ONLY_BUTTON_CLASS = "ui-button ui-widget ui-state-default ui-corner-left ui-button-icon-only";
    public static final String SPLITBUTTON_CONTAINER_CLASS = "ui-menu ui-splitbuttonmenu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow";
    public static final String LIST_WRAPPER_CLASS = "ui-splitbuttonmenu-list-wrapper";

    public String resolveStyleClass() {
        boolean iconBlank = LangUtils.isValueBlank(this.getIcon());
        boolean valueBlank = this.getValue() == null;
        boolean modelBlank = this.getModel() == null;
        String styleClass = "";
        if (modelBlank && !ComponentUtils.shouldRenderChildren((UIComponent)this)) {
            if (!valueBlank && iconBlank) {
                styleClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only";
            } else if (!valueBlank && !iconBlank) {
                styleClass = this.getIconPos().equals("left") ? "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left" : "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-right";
            } else if (valueBlank && !iconBlank) {
                styleClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only";
            }
        } else if (!valueBlank && iconBlank) {
            styleClass = BUTTON_TEXT_ONLY_BUTTON_CLASS;
        } else if (!valueBlank && !iconBlank) {
            styleClass = this.getIconPos().equals("left") ? BUTTON_TEXT_ICON_LEFT_BUTTON_CLASS : BUTTON_TEXT_ICON_RIGHT_BUTTON_CLASS;
        } else if (valueBlank && !iconBlank) {
            styleClass = BUTTON_ICON_ONLY_BUTTON_CLASS;
        }
        if (this.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        return styleClass;
    }

    @Override
    public boolean isPartialSubmitSet() {
        return this.getStateHelper().get((Serializable)((Object)SplitButtonBase.PropertyKeys.partialSubmit)) != null || this.getValueExpression(SplitButtonBase.PropertyKeys.partialSubmit.toString()) != null;
    }

    @Override
    public boolean isResetValuesSet() {
        return this.getStateHelper().get((Serializable)((Object)SplitButtonBase.PropertyKeys.resetValues)) != null || this.getValueExpression(SplitButtonBase.PropertyKeys.resetValues.toString()) != null;
    }

    @Override
    public boolean isAjaxified() {
        return this.isAjax();
    }

    public List getElements() {
        MenuModel model = this.getModel();
        if (model != null) {
            return model.getElements();
        }
        return this.getChildren();
    }

    public int getElementsCount() {
        List elements = this.getElements();
        return elements == null ? 0 : elements.size();
    }

    protected MenuItem findMenuitem(List<MenuElement> elements, String id) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        String[] paths = id.split("_");
        if (paths.length == 0) {
            return null;
        }
        int childIndex = Integer.parseInt(paths[0]);
        if (childIndex >= elements.size()) {
            return null;
        }
        MenuElement childElement = elements.get(childIndex);
        if (paths.length == 1) {
            return (MenuItem)childElement;
        }
        String relativeIndex = id.substring(id.indexOf("_") + 1);
        return this.findMenuitem(((MenuGroup)childElement).getElements(), relativeIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        block6: {
            block7: {
                String outcome;
                if (!(event instanceof MenuActionEvent)) break block7;
                FacesContext facesContext = this.getFacesContext();
                ELContext eLContext = facesContext.getELContext();
                MenuActionEvent menuActionEvent = (MenuActionEvent)event;
                MenuItem menuItem = menuActionEvent.getMenuItem();
                String command = menuItem.getCommand();
                if (command == null) break block6;
                String actionExpressionString = menuItem.getCommand();
                MethodExpression noArgExpr = facesContext.getApplication().getExpressionFactory().createMethodExpression(eLContext, actionExpressionString, String.class, new Class[0]);
                Object invokeResult = null;
                try {
                    invokeResult = noArgExpr.invoke(eLContext, null);
                    outcome = invokeResult != null ? invokeResult.toString() : null;
                }
                catch (MethodNotFoundException methodNotFoundException) {
                    String outcome2;
                    try {
                        try {
                            MethodExpression argExpr = facesContext.getApplication().getExpressionFactory().createMethodExpression(eLContext, actionExpressionString, String.class, new Class[]{ActionEvent.class});
                            invokeResult = argExpr.invoke(eLContext, new Object[]{event});
                        }
                        catch (MethodNotFoundException methodNotFoundException2) {
                            MethodExpression argExpr = facesContext.getApplication().getExpressionFactory().createMethodExpression(eLContext, actionExpressionString, String.class, new Class[]{MenuActionEvent.class});
                            invokeResult = argExpr.invoke(eLContext, new Object[]{event});
                        }
                        outcome2 = invokeResult != null ? invokeResult.toString() : null;
                    }
                    catch (Throwable throwable) {
                        String outcome3 = invokeResult != null ? invokeResult.toString() : null;
                        facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, actionExpressionString, outcome3);
                        throw throwable;
                    }
                    facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, actionExpressionString, outcome2);
                    break block6;
                }
                facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, actionExpressionString, outcome);
                break block6;
            }
            super.broadcast(event);
        }
    }
}

