/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.splitbutton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.behavior.confirm.ConfirmBehavior;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.component.splitbutton.SplitButton;
import org.primefaces.event.MenuActionEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class SplitButtonRenderer
extends OutcomeTargetRenderer {
    private static final String SB_BUILD_ONCLICK = SplitButtonRenderer.class.getName() + "#buildOnclick";
    private static final String SB_BUILD_NON_AJAX_REQUEST = SplitButtonRenderer.class.getName() + "#buildNonAjaxRequest";

    public void decode(FacesContext context, UIComponent component) {
        SplitButton button = (SplitButton)component;
        if (button.isDisabled()) {
            return;
        }
        String clientId = button.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String param = button.isAjax() ? clientId : clientId + "_button";
        String itemParam = clientId + "_menuid";
        if (params.containsKey(itemParam)) {
            String menuid = (String)params.get(clientId + "_menuid");
            MenuItem menuitem = button.findMenuitem(button.getElements(), menuid);
            MenuActionEvent event = new MenuActionEvent((UIComponent)button, menuitem);
            if (menuitem.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            component.queueEvent((FacesEvent)event);
        } else if (params.containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SplitButton button = (SplitButton)component;
        MenuModel model = button.getModel();
        if (model != null && button.getElementsCount() > 0) {
            model.generateUniqueIds();
        }
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SplitButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String menuId = clientId + "_menu";
        String menuButtonId = clientId + "_menuButton";
        String buttonId = clientId + "_button";
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-splitbutton ui-buttonset ui-widget" : "ui-splitbutton ui-buttonset ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "id");
        }
        this.encodeDefaultButton(context, button, buttonId);
        if (button.getElementsCount() > 0) {
            this.encodeMenuIcon(context, button, menuButtonId);
            this.encodeMenu(context, button, menuId);
        }
        writer.endElement("div");
    }

    protected void encodeDefaultButton(FacesContext context, SplitButton button, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String value = (String)button.getValue();
        String icon = button.getIcon();
        String onclick = this.buildOnclick(context, button);
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("name", (Object)id, "name");
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        if (onclick.length() > 0) {
            writer.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (!this.isValueBlank(icon)) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (value == null) {
            writer.write("ui-button");
        } else {
            writer.writeText((Object)value, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeMenuIcon(FacesContext context, SplitButton button, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String buttonClass = "ui-splitbutton-menubutton  ui-button ui-widget ui-state-default ui-corner-right ui-button-icon-only";
        if (button.isDisabled()) {
            buttonClass = buttonClass + " ui-state-disabled";
        }
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)buttonClass, null);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext context, SplitButton button) throws IOException {
        String clientId = button.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SplitButton", button.resolveWidgetVar(), clientId);
        wb.attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)button, button.getAppendTo()), null);
        if (button.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", button.getFilterMatchMode(), null).nativeAttr("filterFunction", button.getFilterFunction(), null);
        }
        wb.finish();
    }

    protected String buildOnclick(FacesContext context, SplitButton button) throws IOException {
        StringBuilder onclick = SharedStringBuilder.get(context, SB_BUILD_ONCLICK);
        if (button.getOnclick() != null) {
            onclick.append(button.getOnclick()).append(";");
        }
        if (button.isAjax()) {
            onclick.append(this.buildAjaxRequest(context, button));
        } else {
            UIForm form = ComponentTraversalUtils.closestForm(context, (UIComponent)button);
            if (form == null) {
                throw new FacesException("SplitButton : \"" + button.getClientId(context) + "\" must be inside a form element");
            }
            onclick.append(this.buildNonAjaxRequest(context, (UIComponent)button, (UIComponent)form, null, false));
        }
        String onclickBehaviors = this.getEventBehaviors(context, (ClientBehaviorHolder)button, "click", null);
        if (onclickBehaviors != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        return onclick.toString();
    }

    protected void encodeMenu(FacesContext context, SplitButton button, String menuId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String menuStyleClass = button.getMenuStyleClass();
        menuStyleClass = menuStyleClass == null ? "ui-menu ui-splitbuttonmenu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow" : "ui-menu ui-splitbuttonmenu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow " + menuStyleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)menuId, null);
        writer.writeAttribute("class", (Object)menuStyleClass, "styleClass");
        writer.writeAttribute("role", (Object)"menu", null);
        if (button.isFilter()) {
            this.encodeFilter(context, button);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-splitbuttonmenu-list-wrapper", "styleClass");
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", "styleClass");
        this.encodeElements(context, button, button.getElements(), false);
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeElements(FacesContext context, SplitButton button, List<Object> elements, boolean isSubmenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (Object element : elements) {
            if (element instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)element;
                if (!menuItem.isRendered()) continue;
                String containerStyle = menuItem.getContainerStyle();
                String containerStyleClass = menuItem.getContainerStyleClass();
                String string = containerStyleClass = containerStyleClass == null ? "ui-menuitem ui-widget ui-corner-all" : "ui-menuitem ui-widget ui-corner-all " + containerStyleClass;
                if (isSubmenu) {
                    containerStyleClass = containerStyleClass + " " + "ui-submenu-child";
                }
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)containerStyleClass, null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                if (containerStyle != null) {
                    writer.writeAttribute("style", (Object)containerStyle, null);
                }
                this.encodeMenuItem(context, button, menuItem);
                writer.endElement("li");
                continue;
            }
            if (element instanceof Submenu) {
                this.encodeSubmenu(context, button, (Submenu)element);
                continue;
            }
            if (!(element instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)element);
        }
    }

    protected void encodeMenuItem(FacesContext context, SplitButton button, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuitem.getIcon();
        String title = menuitem.getTitle();
        if (menuitem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuitem);
        } else {
            String styleClass;
            boolean disabled = menuitem.isDisabled();
            writer.startElement("a", null);
            writer.writeAttribute("id", (Object)menuitem.getClientId(), null);
            if (title != null) {
                writer.writeAttribute("title", (Object)title, null);
            }
            styleClass = (styleClass = menuitem.getStyleClass()) == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
            styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
            writer.writeAttribute("class", (Object)styleClass, null);
            if (menuitem.getStyle() != null) {
                writer.writeAttribute("style", (Object)menuitem.getStyle(), null);
            }
            if (disabled) {
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)"return false;", null);
            } else {
                this.setConfirmationScript(context, menuitem);
                String onclick = menuitem.getOnclick();
                if (menuitem.getUrl() != null || menuitem.getOutcome() != null) {
                    String targetURL = this.getTargetURL(context, (UIOutcomeTarget)((Object)menuitem));
                    writer.writeAttribute("href", (Object)targetURL, null);
                    if (menuitem.getTarget() != null) {
                        writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
                    }
                } else {
                    String command;
                    writer.writeAttribute("href", (Object)"#", null);
                    UIForm form = ComponentTraversalUtils.closestForm(context, (UIComponent)button);
                    if (form == null) {
                        throw new FacesException("MenuItem must be inside a form element");
                    }
                    if (menuitem.isDynamic()) {
                        String buttonClientId = button.getClientId(context);
                        Map<String, List<String>> params = menuitem.getParams();
                        if (params == null) {
                            params = new LinkedHashMap<String, List<String>>();
                        }
                        ArrayList<String> idParams = new ArrayList<String>();
                        idParams.add(menuitem.getId());
                        params.put(buttonClientId + "_menuid", idParams);
                        command = menuitem.isAjax() ? this.buildAjaxRequest(context, (UIComponent)button, (AjaxSource)((Object)menuitem), form, params) : this.buildNonAjaxRequest(context, (UIComponent)button, (UIComponent)form, buttonClientId, params, true);
                    } else {
                        command = menuitem.isAjax() ? this.buildAjaxRequest(context, (AjaxSource)((Object)menuitem), form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, (UIComponent)form, ((UIComponent)menuitem).getClientId(context), true);
                    }
                    String string = onclick = onclick == null ? command : onclick + ";" + command;
                }
                if (onclick != null) {
                    if (menuitem.requiresConfirmation()) {
                        writer.writeAttribute("data-pfconfirmcommand", (Object)onclick, null);
                        writer.writeAttribute("onclick", (Object)menuitem.getConfirmationScript(), "onclick");
                    } else {
                        writer.writeAttribute("onclick", (Object)onclick, null);
                    }
                }
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
                writer.endElement("span");
            }
            if (menuitem.getValue() != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
                writer.writeText(menuitem.getValue(), "value");
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    protected void encodeSubmenu(FacesContext context, SplitButton button, Submenu submenu) throws IOException {
        if (!submenu.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        String styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget-header ui-corner-all" : "ui-widget-header ui-corner-all " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("h3", null);
        if (label != null) {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("h3");
        writer.endElement("li");
        this.encodeElements(context, button, submenu.getElements(), true);
    }

    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        if (!separator.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator ui-state-default" : "ui-separator ui-state-default " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    protected void encodeFilter(FacesContext context, SplitButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = button.getClientId(context) + "_filter";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-splitbuttonmenu-filter-container", null);
        writer.startElement("input", null);
        writer.writeAttribute("class", (Object)"ui-splitbuttonmenu-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (button.getFilterPlaceholder() != null) {
            writer.writeAttribute("placeholder", (Object)button.getFilterPlaceholder(), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", id);
        writer.endElement("span");
        writer.endElement("input");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void setConfirmationScript(FacesContext context, MenuItem item) {
        if (item instanceof ClientBehaviorHolder) {
            List clickBehaviors;
            Map behaviors = ((ClientBehaviorHolder)item).getClientBehaviors();
            List list = clickBehaviors = behaviors == null ? null : (List)behaviors.get("click");
            if (clickBehaviors != null && !clickBehaviors.isEmpty()) {
                for (int i = 0; i < clickBehaviors.size(); ++i) {
                    ClientBehavior clientBehavior = (ClientBehavior)clickBehaviors.get(i);
                    if (!(clientBehavior instanceof ConfirmBehavior)) continue;
                    ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)item), (String)"click", (String)item.getClientId(), (Collection)Collections.EMPTY_LIST);
                    clientBehavior.getScript(cbc);
                    break;
                }
            }
        }
    }

    protected String buildNonAjaxRequest(FacesContext context, UIComponent component, UIComponent form, String decodeParam, Map<String, List<String>> parameters, boolean submit) {
        StringBuilder request = SharedStringBuilder.get(context, SB_BUILD_NON_AJAX_REQUEST);
        String formId = form.getClientId(context);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (decodeParam != null) {
            params.put(decodeParam, decodeParam);
        }
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter) || !child.isRendered()) continue;
            UIParameter param = (UIParameter)child;
            params.put(param.getName(), param.getValue());
        }
        if (parameters != null && !parameters.isEmpty()) {
            for (String paramName : parameters.keySet()) {
                params.put(paramName, parameters.get(paramName).get(0));
            }
        }
        if (!params.isEmpty()) {
            request.append("PrimeFaces.addSubmitParam('").append(formId).append("',{");
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                Object value = params.get(key);
                request.append("'").append(key).append("':'").append(value).append("'");
                if (!it.hasNext()) continue;
                request.append(",");
            }
            request.append("})");
        }
        if (submit) {
            request.append(".submit('").append(formId).append("');return false;");
        }
        return request.toString();
    }
}

